/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.pqc.crypto.cmce.GF;

class GF13
extends GF {
    public GF13(int gfbits) {
        super(gfbits);
    }

    protected short gf_mul(short in0, short in1) {
        long t0 = in0;
        long t1 = in1;
        long tmp = t0 * (t1 & 1L);
        for (int i = 1; i < this.GFBITS; ++i) {
            tmp ^= t0 * (t1 & (long)(1 << i));
        }
        long t = tmp & 0x1FF0000L;
        tmp ^= t >> 9 ^ t >> 10 ^ t >> 12 ^ t >> 13;
        t = tmp & 0xE000L;
        return (short)((tmp ^= t >> 9 ^ t >> 10 ^ t >> 12 ^ t >> 13) & (long)this.GFMASK);
    }

    protected short gf_sq2(short in) {
        long[] B = new long[]{0x1111111111111111L, 0x303030303030303L, 0xF000F000F000FL, 0xFF000000FFL};
        long[] M = new long[]{0x1FF0000000000L, 0xFF80000000L, 2143289344L, 4186112L};
        long x = in;
        x = (x | x << 24) & B[3];
        x = (x | x << 12) & B[2];
        x = (x | x << 6) & B[1];
        x = (x | x << 3) & B[0];
        for (int i = 0; i < 4; ++i) {
            long t = x & M[i];
            x ^= t >> 9 ^ t >> 10 ^ t >> 12 ^ t >> 13;
        }
        return (short)(x & (long)this.GFMASK);
    }

    private short gf_sqmul(short in, short m) {
        long[] M = new long[]{0x1FF0000000L, 0xFF80000L, 516096L};
        long t0 = in;
        long t1 = m;
        long x = (t1 << 6) * (t0 & 0x40L);
        t0 ^= t0 << 7;
        x ^= t1 * (t0 & 0x4001L);
        x ^= t1 * (t0 & 0x8002L) << 1;
        x ^= t1 * (t0 & 0x10004L) << 2;
        x ^= t1 * (t0 & 0x20008L) << 3;
        x ^= t1 * (t0 & 0x40010L) << 4;
        x ^= t1 * (t0 & 0x80020L) << 5;
        for (int i = 0; i < 3; ++i) {
            long t = x & M[i];
            x ^= t >> 9 ^ t >> 10 ^ t >> 12 ^ t >> 13;
        }
        return (short)(x & (long)this.GFMASK);
    }

    private short gf_sq2mul(short in, short m) {
        long[] M = new long[]{0x1FF0000000000000L, 0xFF80000000000L, 8778913153024L, 17146314752L, 33423360L, 122880L};
        long t0 = in;
        long t1 = m;
        long x = (t1 << 18) * (t0 & 0x40L);
        t0 ^= t0 << 21;
        x ^= t1 * (t0 & 0x10000001L);
        x ^= t1 * (t0 & 0x20000002L) << 3;
        x ^= t1 * (t0 & 0x40000004L) << 6;
        x ^= t1 * (t0 & 0x80000008L) << 9;
        x ^= t1 * (t0 & 0x100000010L) << 12;
        x ^= t1 * (t0 & 0x200000020L) << 15;
        for (int i = 0; i < 6; ++i) {
            long t = x & M[i];
            x ^= t >> 9 ^ t >> 10 ^ t >> 12 ^ t >> 13;
        }
        return (short)(x & (long)this.GFMASK);
    }

    protected short gf_frac(short den, short num) {
        short tmp_11 = this.gf_sqmul(den, den);
        short tmp_1111 = this.gf_sq2mul(tmp_11, tmp_11);
        short out = this.gf_sq2(tmp_1111);
        out = this.gf_sq2mul(out, tmp_1111);
        out = this.gf_sq2(out);
        out = this.gf_sq2mul(out, tmp_1111);
        return this.gf_sqmul(out, num);
    }

    protected short gf_inv(short den) {
        return this.gf_frac(den, (short)1);
    }
}

