/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static Map nameToHashId = new HashMap(){
        {
            this.put("sha1", Integers.valueOf((int)2));
            this.put("sha224", Integers.valueOf((int)11));
            this.put("sha256", Integers.valueOf((int)8));
            this.put("sha384", Integers.valueOf((int)9));
            this.put("sha512", Integers.valueOf((int)10));
            this.put("sha3-224", Integers.valueOf((int)312));
            this.put("sha3-256", Integers.valueOf((int)313));
            this.put("sha3-384", Integers.valueOf((int)314));
            this.put("sha3-512", Integers.valueOf((int)315));
            this.put("ripemd160", Integers.valueOf((int)3));
            this.put("rmd160", Integers.valueOf((int)3));
            this.put("md2", Integers.valueOf((int)5));
            this.put("md4", Integers.valueOf((int)301));
            this.put("tiger", Integers.valueOf((int)6));
            this.put("haval", Integers.valueOf((int)7));
            this.put("sm3", Integers.valueOf((int)326));
            this.put("md5", Integers.valueOf((int)1));
        }
    };
    private static Map oidToName = new HashMap(){
        {
            this.put(CryptlibObjectIdentifiers.curvey25519, "Curve25519");
            this.put(EdECObjectIdentifiers.id_X25519, "Curve25519");
            this.put(EdECObjectIdentifiers.id_Ed25519, "Ed25519");
            this.put(SECObjectIdentifiers.secp256r1, "NIST P-256");
            this.put(SECObjectIdentifiers.secp384r1, "NIST P-384");
            this.put(SECObjectIdentifiers.secp521r1, "NIST P-521");
        }
    };
    private static final int READ_AHEAD = 60;

    public static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    public static int getDigestIDForName(String string) {
        if (nameToHashId.containsKey(string = Strings.toLowerCase((String)string))) {
            return (Integer)nameToHashId.get(string);
        }
        throw new IllegalArgumentException("unable to map " + string + " to a hash id");
    }

    public static String getCurveName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = (String)oidToName.get(aSN1ObjectIdentifier);
        if (string != null) {
            return string;
        }
        return ECNamedCurveTable.getName((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
    }

    public static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return PGPUtil.getDigestName(n2) + "with" + string;
    }

    public static String getSymmetricCipherName(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 11: {
                return "Camellia";
            }
            case 12: {
                return "Camellia";
            }
            case 13: {
                return "Camellia";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + n);
    }

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String string) {
        defProvider = string;
    }

    static MPInteger[] dsaSigToMpi(byte[] byArray) throws PGPException {
        ASN1Integer aSN1Integer;
        ASN1Integer aSN1Integer2;
        try {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)byArray);
            aSN1Integer2 = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0));
            aSN1Integer = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(1));
        }
        catch (RuntimeException runtimeException) {
            throw new PGPException("exception decoding signature", runtimeException);
        }
        return new MPInteger[]{new MPInteger(aSN1Integer2.getValue()), new MPInteger(aSN1Integer.getValue())};
    }

    public static boolean isKeyRing(byte[] byArray) throws IOException {
        BCPGInputStream bCPGInputStream = new BCPGInputStream(new ByteArrayInputStream(byArray));
        int n = bCPGInputStream.nextPacketTag();
        return n == 6 || n == 14 || n == 5 || n == 7;
    }

    public static boolean isKeyBox(byte[] byArray) throws IOException {
        if (byArray.length < 12) {
            return false;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        for (int i = 0; i != 8; ++i) {
            ((InputStream)byteArrayInputStream).read();
        }
        return ((InputStream)byteArrayInputStream).read() == 75 && ((InputStream)byteArrayInputStream).read() == 66 && ((InputStream)byteArrayInputStream).read() == 88 && ((InputStream)byteArrayInputStream).read() == 102;
    }

    public static byte[] makeRandomKey(int n, SecureRandom secureRandom) throws PGPException {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                break;
            }
            case 1: {
                n2 = 128;
                break;
            }
            case 3: {
                n2 = 128;
                break;
            }
            case 4: {
                n2 = 128;
                break;
            }
            case 5: {
                n2 = 128;
                break;
            }
            case 6: {
                n2 = 64;
                break;
            }
            case 7: {
                n2 = 128;
                break;
            }
            case 8: {
                n2 = 192;
                break;
            }
            case 9: {
                n2 = 256;
                break;
            }
            case 11: {
                n2 = 128;
                break;
            }
            case 12: {
                n2 = 192;
                break;
            }
            case 13: {
                n2 = 256;
                break;
            }
            case 10: {
                n2 = 256;
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[(n2 + 7) / 8];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file);
        PGPUtil.pipeFileContents(file, outputStream2, 32768);
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file, byte[] byArray) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file.getName(), new Date(file.lastModified()), byArray);
        PGPUtil.pipeFileContents(file, outputStream2, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pipeFileContents(File file, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n2;
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
            }
            outputStream.close();
        }
        finally {
            Arrays.fill((byte[])byArray, (byte)0);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isPossiblyBase64(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 43 || n == 47 || n == 13 || n == 10;
    }

    public static InputStream getDecoderStream(InputStream inputStream) throws IOException {
        int n;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStreamExt(inputStream);
        }
        inputStream.mark(60);
        int n2 = inputStream.read();
        if ((n2 & 0x80) != 0) {
            inputStream.reset();
            return inputStream;
        }
        if (!PGPUtil.isPossiblyBase64(n2)) {
            inputStream.reset();
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray = new byte[60];
        int n3 = 1;
        byArray[0] = (byte)n2;
        for (n = 1; n != 60 && (n2 = inputStream.read()) >= 0; ++n) {
            if (!PGPUtil.isPossiblyBase64(n2)) {
                inputStream.reset();
                return new ArmoredInputStream(inputStream);
            }
            if (n2 == 10 || n2 == 13) continue;
            byArray[n3++] = (byte)n2;
        }
        inputStream.reset();
        if (n < 4) {
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        try {
            byte[] byArray3 = Base64.decode((byte[])byArray2);
            if ((byArray3[0] & 0x80) != 0) {
                return new ArmoredInputStream(inputStream, false);
            }
            return new ArmoredInputStream(inputStream);
        }
        catch (DecoderException decoderException) {
            throw new IOException(decoderException.getMessage());
        }
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream inputStream) {
            super(inputStream);
        }

        public synchronized int available() throws IOException {
            int n = super.available();
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
    }
}

