/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.util.test.SimpleTest;

public class GeneralizedTimeTest
extends SimpleTest {
    String[] input = new String[]{"20020122122220", "20020122122220Z", "20020122122220-1000", "20020122122220+00", "20020122122220.1", "20020122122220.1Z", "20020122122220.1-1000", "20020122122220.1+00", "20020122122220.01", "20020122122220.01Z", "20020122122220.01-1000", "20020122122220.01+00", "20020122122220.001", "20020122122220.001Z", "20020122122220.001-1000", "20020122122220.001+00", "20020122122220.0001", "20020122122220.0001Z", "20020122122220.0001-1000", "20020122122220.0001+00", "20020122122220.0001+1000"};
    String[] output = new String[]{"20020122122220", "20020122122220GMT+00:00", "20020122122220GMT-10:00", "20020122122220GMT+00:00", "20020122122220.1", "20020122122220.1GMT+00:00", "20020122122220.1GMT-10:00", "20020122122220.1GMT+00:00", "20020122122220.01", "20020122122220.01GMT+00:00", "20020122122220.01GMT-10:00", "20020122122220.01GMT+00:00", "20020122122220.001", "20020122122220.001GMT+00:00", "20020122122220.001GMT-10:00", "20020122122220.001GMT+00:00", "20020122122220.0001", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT-10:00", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT+10:00"};
    String[] zOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};
    String[] mzOutput = new String[]{"20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122122220.100Z", "20020122122220.100Z", "20020122222220.100Z", "20020122122220.100Z", "20020122122220.010Z", "20020122122220.010Z", "20020122222220.010Z", "20020122122220.010Z", "20020122122220.001Z", "20020122122220.001Z", "20020122222220.001Z", "20020122122220.001Z", "20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122022220.000Z"};
    String[] derMzOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220.1Z", "20020122122220.1Z", "20020122222220.1Z", "20020122122220.1Z", "20020122122220.01Z", "20020122122220.01Z", "20020122222220.01Z", "20020122122220.01Z", "20020122122220.001Z", "20020122122220.001Z", "20020122222220.001Z", "20020122122220.001Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};
    String[] truncOutput = new String[]{"200201221222Z", "2002012212Z"};
    String[] derTruncOutput = new String[]{"20020122122200Z", "20020122120000Z"};

    private String calculateGMTOffset(Date date) {
        String string = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (n < 0) {
            string = "-";
            n = -n;
        }
        int n2 = n / 3600000;
        int n3 = (n - n2 * 60 * 60 * 1000) / 60000;
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(date)) {
            n2 += string.equals("+") ? 1 : -1;
        }
        return "GMT" + string + this.convert(n2) + ":" + this.convert(n3);
    }

    private String convert(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return Integer.toString(n);
    }

    public String getName() {
        return "GeneralizedTime";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new GeneralizedTimeTest());
    }

    public void performTest() throws Exception {
        ASN1GeneralizedTime aSN1GeneralizedTime;
        Object object;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        int n = 0;
        while (n != this.input.length) {
            ASN1GeneralizedTime aSN1GeneralizedTime2 = new ASN1GeneralizedTime(this.input[n]);
            if (this.output[n].indexOf(71) > 0) {
                if (!aSN1GeneralizedTime2.getTime().equals(this.output[n])) {
                    this.fail("failed GMT conversion test got " + aSN1GeneralizedTime2.getTime() + " expected " + this.output[n]);
                }
                if (!simpleDateFormat.format(aSN1GeneralizedTime2.getDate()).equals(this.zOutput[n])) {
                    this.fail("failed date conversion test");
                }
            } else {
                object = this.calculateGMTOffset(aSN1GeneralizedTime2.getDate());
                if (!aSN1GeneralizedTime2.getTime().equals(String.valueOf(this.output[n]) + (String)object)) {
                    this.fail("failed conversion test got " + aSN1GeneralizedTime2.getTime() + " expected " + this.output[n] + (String)object);
                }
            }
            ++n;
        }
        simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        int n2 = 0;
        while (n2 != this.input.length) {
            object = new ASN1GeneralizedTime(this.input[n2]);
            if (!simpleDateFormat.format(((ASN1GeneralizedTime)object).getDate()).equals(this.mzOutput[n2])) {
                this.fail("failed long date conversion test");
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 != this.mzOutput.length) {
            DERGeneralizedTime dERGeneralizedTime = new DERGeneralizedTime(this.mzOutput[n3]);
            if (!this.areEqual(dERGeneralizedTime.getEncoded(), new ASN1GeneralizedTime(this.derMzOutput[n3]).getEncoded())) {
                this.fail("der encoding wrong");
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 != this.truncOutput.length) {
            aSN1GeneralizedTime = new DERGeneralizedTime(this.truncOutput[n4]);
            if (!this.areEqual(aSN1GeneralizedTime.getEncoded(), new ASN1GeneralizedTime(this.derTruncOutput[n4]).getEncoded())) {
                this.fail("trunc der encoding wrong");
            }
            ++n4;
        }
        aSN1GeneralizedTime = new ASN1GeneralizedTime("20190704031318GMT+00:00");
        this.isTrue("20190704031318GMT+00:00".equals(aSN1GeneralizedTime.getTime()));
        try {
            new DERGeneralizedTime(new byte[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTrue(illegalArgumentException.getMessage().equals("GeneralizedTime string too short"));
        }
    }
}

