/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.util.test.SimpleTest;

public class IssuingDistributionPointUnitTest
extends SimpleTest {
    private void checkPoint(int n, DistributionPointName distributionPointName, boolean bl, boolean bl2, ReasonFlags reasonFlags, boolean bl3, boolean bl4) throws IOException {
        IssuingDistributionPoint issuingDistributionPoint = new IssuingDistributionPoint(distributionPointName, bl, bl2, reasonFlags, bl3, bl4);
        this.checkValues(issuingDistributionPoint, distributionPointName, bl, bl2, reasonFlags, bl3, bl4);
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(issuingDistributionPoint.getEncoded()));
        if (aSN1Sequence.size() != n) {
            this.fail("size mismatch");
        }
        issuingDistributionPoint = IssuingDistributionPoint.getInstance(aSN1Sequence);
        this.checkValues(issuingDistributionPoint, distributionPointName, bl, bl2, reasonFlags, bl3, bl4);
    }

    private void checkValues(IssuingDistributionPoint issuingDistributionPoint, DistributionPointName distributionPointName, boolean bl, boolean bl2, ReasonFlags reasonFlags, boolean bl3, boolean bl4) {
        if (issuingDistributionPoint.onlyContainsUserCerts() != bl) {
            this.fail("mismatch on onlyContainsUserCerts");
        }
        if (issuingDistributionPoint.onlyContainsCACerts() != bl2) {
            this.fail("mismatch on onlyContainsCACerts");
        }
        if (issuingDistributionPoint.isIndirectCRL() != bl3) {
            this.fail("mismatch on indirectCRL");
        }
        if (issuingDistributionPoint.onlyContainsAttributeCerts() != bl4) {
            this.fail("mismatch on onlyContainsAttributeCerts");
        }
        if (!this.isEquiv(reasonFlags, issuingDistributionPoint.getOnlySomeReasons())) {
            this.fail("mismatch on onlySomeReasons");
        }
        if (!this.isEquiv(distributionPointName, issuingDistributionPoint.getDistributionPoint())) {
            this.fail("mismatch on distributionPoint");
        }
    }

    public String getName() {
        return "IssuingDistributionPoint";
    }

    private boolean isEquiv(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new IssuingDistributionPointUnitTest());
    }

    public void performTest() throws Exception {
        DistributionPointName distributionPointName = new DistributionPointName(new GeneralNames(new GeneralName(new X500Name("cn=test"))));
        ReasonFlags reasonFlags = new ReasonFlags(32);
        this.checkPoint(6, distributionPointName, true, true, reasonFlags, true, true);
        this.checkPoint(2, distributionPointName, false, false, reasonFlags, false, false);
        this.checkPoint(0, null, false, false, null, false, false);
        try {
            IssuingDistributionPoint.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

