/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class StringTest
extends SimpleTest {
    private void checkString(ASN1String aSN1String, ASN1String aSN1String2) throws IOException {
        ASN1String aSN1String3 = (ASN1String)((Object)ASN1Primitive.fromByteArray(((ASN1Primitive)((Object)aSN1String)).getEncoded()));
        if (!aSN1String.toString().equals(aSN1String3.toString())) {
            this.fail(String.valueOf(aSN1String3.getClass().getName()) + " shortBytes result incorrect");
        }
        ASN1String aSN1String4 = (ASN1String)((Object)ASN1Primitive.fromByteArray(((ASN1Primitive)((Object)aSN1String2)).getEncoded()));
        if (!aSN1String2.toString().equals(aSN1String4.toString())) {
            this.fail(String.valueOf(aSN1String4.getClass().getName()) + " longBytes result incorrect");
        }
    }

    public String getName() {
        return "String";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new StringTest());
    }

    public void performTest() throws IOException {
        DERUniversalString dERUniversalString;
        DERBitString dERBitString = new DERBitString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17});
        if (!dERBitString.getString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!dERBitString.toString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(dERBitString = new DERBitString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!dERBitString.toString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(dERUniversalString = new DERUniversalString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17})).getString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!dERUniversalString.toString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        if (!(dERUniversalString = new DERUniversalString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!dERUniversalString.toString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        byte[] byArray = new byte[]{-1, -2, -3, -4, -5, -6, -7, -8};
        String string = new String(byArray, "iso-8859-1");
        DERT61String dERT61String = new DERT61String(Strings.fromByteArray(byArray));
        if (!dERT61String.getString().equals(string)) {
            this.fail("DERT61String.getString() result incorrect");
        }
        if (!dERT61String.toString().equals(string)) {
            this.fail("DERT61String.toString() result incorrect");
        }
        char[] cArray = new char[]{'a', 'b', 'c', 'd', 'e'};
        char[] cArray2 = new char[1000];
        int n = 0;
        while (n != cArray2.length) {
            cArray2[n] = 88;
            ++n;
        }
        this.checkString(new DERBMPString(new String(cArray)), new DERBMPString(new String(cArray2)));
        this.checkString(new DERUTF8String(new String(cArray)), new DERUTF8String(new String(cArray2)));
        this.checkString(new DERIA5String(new String(cArray)), new DERIA5String(new String(cArray2)));
        this.checkString(new DERPrintableString(new String(cArray)), new DERPrintableString(new String(cArray2)));
        this.checkString(new DERVisibleString(new String(cArray)), new DERVisibleString(new String(cArray2)));
        this.checkString(new DERGeneralString(new String(cArray)), new DERGeneralString(new String(cArray2)));
        this.checkString(new DERT61String(new String(cArray)), new DERT61String(new String(cArray2)));
        cArray = new char[]{'1', '2', '3', '4', '5'};
        cArray2 = new char[1000];
        int n2 = 0;
        while (n2 != cArray2.length) {
            cArray2[n2] = 49;
            ++n2;
        }
        this.checkString(new DERNumericString(new String(cArray)), new DERNumericString(new String(cArray2)));
        byte[] byArray2 = new byte[]{97, 98, 99, 100, 101};
        byte[] byArray3 = new byte[1000];
        int n3 = 0;
        while (n3 != cArray2.length) {
            byArray3[n3] = 88;
            ++n3;
        }
        this.checkString(new DERUniversalString(byArray2), new DERUniversalString(byArray3));
    }
}

