/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import org.bouncycastle.util.test.SimpleTest;

public class TypeOfBiometricDataUnitTest
extends SimpleTest {
    private void checkNonPredefined(TypeOfBiometricData typeOfBiometricData, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (typeOfBiometricData.isPredefined()) {
            this.fail("predefined type found when not expected.");
        }
        if (!typeOfBiometricData.getBiometricDataOid().equals(aSN1ObjectIdentifier)) {
            this.fail("data oid does not match.");
        }
    }

    private void checkPredefined(TypeOfBiometricData typeOfBiometricData, int n) {
        if (!typeOfBiometricData.isPredefined()) {
            this.fail("predefined type expected but not found.");
        }
        if (typeOfBiometricData.getPredefinedBiometricType() != n) {
            this.fail("predefined type does not match.");
        }
    }

    private void checkPredefinedType(int n) throws IOException {
        TypeOfBiometricData typeOfBiometricData = new TypeOfBiometricData(n);
        this.checkPredefined(typeOfBiometricData, n);
        typeOfBiometricData = TypeOfBiometricData.getInstance(typeOfBiometricData);
        this.checkPredefined(typeOfBiometricData, n);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(typeOfBiometricData.toASN1Primitive().getEncoded());
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        typeOfBiometricData = TypeOfBiometricData.getInstance(aSN1Primitive);
        this.checkPredefined(typeOfBiometricData, n);
    }

    public String getName() {
        return "TypeOfBiometricData";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new TypeOfBiometricDataUnitTest());
    }

    public void performTest() throws Exception {
        this.checkPredefinedType(0);
        this.checkPredefinedType(1);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier("1.1");
        TypeOfBiometricData typeOfBiometricData = new TypeOfBiometricData(aSN1ObjectIdentifier);
        this.checkNonPredefined(typeOfBiometricData, aSN1ObjectIdentifier);
        typeOfBiometricData = TypeOfBiometricData.getInstance(typeOfBiometricData);
        this.checkNonPredefined(typeOfBiometricData, aSN1ObjectIdentifier);
        ASN1Primitive aSN1Primitive = typeOfBiometricData.toASN1Primitive();
        typeOfBiometricData = TypeOfBiometricData.getInstance(aSN1Primitive);
        this.checkNonPredefined(typeOfBiometricData, aSN1ObjectIdentifier);
        typeOfBiometricData = TypeOfBiometricData.getInstance(null);
        if (typeOfBiometricData != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            TypeOfBiometricData.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            new TypeOfBiometricData(100);
            this.fail("constructor failed to detect bad predefined type.");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

