/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStrictStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class X500NameTest
extends SimpleTest {
    String[] subjects = new String[]{"C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Webserver Team,CN=www2.connect4.com.au,E=webmaster@connect4.com.au", "C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Certificate Authority,CN=Connect 4 CA,E=webmaster@connect4.com.au", "C=AU,ST=QLD,CN=SSLeay/rsa test cert", "C=US,O=National Aeronautics and Space Administration,SERIALNUMBER=16+CN=Steve Schoch", "E=cooke@issl.atl.hp.com,C=US,OU=Hewlett Packard Company (ISSL),CN=Paul A. Cooke", "O=Sun Microsystems Inc,CN=store.sun.com", "unstructuredAddress=192.168.1.33,unstructuredName=pixfirewall.ciscopix.com,CN=pixfirewall.ciscopix.com", "CN=*.canal-plus.com,OU=Provided by TBS INTERNET https://www.tbs-certificats.com/,OU=\\ CANAL \\+,O=CANAL\\+DISTRIBUTION,L=issy les moulineaux,ST=Hauts de Seine,C=FR", "O=Bouncy Castle,CN=www.bouncycastle.org\\ ", "O=Bouncy Castle,CN=c:\\\\fred\\\\bob", "C=0,O=1,OU=2,T=3,CN=4,SERIALNUMBER=5,STREET=6,SERIALNUMBER=7,L=8,ST=9,SURNAME=10,GIVENNAME=11,INITIALS=12,GENERATION=13,UniqueIdentifier=14,BusinessCategory=15,PostalCode=16,DN=17,Pseudonym=18,PlaceOfBirth=19,Gender=20,CountryOfCitizenship=21,CountryOfResidence=22,NameAtBirth=23,PostalAddress=24,2.5.4.54=25,TelephoneNumber=26,Name=27,E=28,unstructuredName=29,unstructuredAddress=30,E=31,DC=32,UID=33"};
    String[] hexSubjects = new String[]{"CN=\\20Test\\20X,O=\\20Test,C=GB", "CN=\\ Test X,O=\\ Test,C=GB", "CN=\\20Test\\20X\\20,O=\\20Test,C=GB", "CN=\\ Test X\\ ,O=\\ Test,C=GB"};
    private static final String dnqSubject = "DNQ=Legion of the Bouncy Castle Inc.";

    private ASN1Encodable createEntryValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(aSN1ObjectIdentifier, string);
        X500Name x500Name = x500NameBuilder.build();
        ASN1Sequence aSN1Sequence = (ASN1Sequence)x500Name.toASN1Primitive();
        ASN1Set aSN1Set = ASN1Set.getInstance(aSN1Sequence.getObjectAt(0).toASN1Primitive());
        aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(0);
        return aSN1Sequence.getObjectAt(1);
    }

    private ASN1Encodable createEntryValueFromString(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(aSN1ObjectIdentifier, string);
        X500Name x500Name = new X500Name(x500NameBuilder.build().toString());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)x500Name.toASN1Primitive();
        ASN1Set aSN1Set = ASN1Set.getInstance(aSN1Sequence.getObjectAt(0).toASN1Primitive());
        aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(0);
        return aSN1Sequence.getObjectAt(1);
    }

    private void equalityTest(X500Name x500Name, X500Name x500Name2) {
        if (!x500Name.equals(x500Name2)) {
            this.fail("equality test failed for " + x500Name + " : " + x500Name2);
        }
        if (x500Name.hashCode() != x500Name2.hashCode()) {
            this.fail("hashCodeTest test failed for " + x500Name + " : " + x500Name2);
        }
    }

    private static X500Name fromBytes(byte[] byArray) throws IOException {
        return X500Name.getInstance(ASN1Primitive.fromByteArray(byArray));
    }

    public String getName() {
        return "X500Name";
    }

    private String getValue(RDN rDN) {
        return ((ASN1String)((Object)rDN.getFirst().getValue())).getString();
    }

    private void ietfUtilsTest() throws Exception {
        IETFUtils.valueToString(new DERUTF8String(" "));
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new X500NameTest());
    }

    public void performTest() throws Exception {
        String[] stringArray;
        RDN[] rDNArray;
        X500Name x500Name;
        DERUTF8String dERUTF8String;
        byte[] byArray;
        byte[] byArray2;
        String string;
        ASN1UTF8String aSN1UTF8String;
        X500Name x500Name2;
        DERTaggedObject dERTaggedObject;
        X500Name x500Name3;
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray;
        X500Name x500Name4;
        this.ietfUtilsTest();
        this.testEncodingPrintableString(BCStyle.C, "AU");
        this.testEncodingPrintableString(BCStyle.SERIALNUMBER, "123456");
        this.testEncodingPrintableString(BCStyle.DN_QUALIFIER, "123456");
        this.testEncodingIA5String(BCStyle.EmailAddress, "test@test.com");
        this.testEncodingIA5String(BCStyle.DC, "test");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "#180F32303032303132323132323232305A");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "20020122122220Z");
        this.testEncodingUTF8String(BCStyle.CN, "M\u00c3\u00b6rsky");
        this.testEncodingUTF8String(BCStyle.ORGANIZATION_IDENTIFIER, "M\u00c3\u00b6rsky");
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name x500Name5 = x500NameBuilder.build();
        if (!x500Name5.equals(x500Name5)) {
            this.fail("Failed same object test");
        }
        X500Name x500Name6 = new X500Name((X500NameStyle)DNQStyle.INSTANCE, dnqSubject);
        this.isEquals(x500Name6.toString(), dnqSubject);
        x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name x500Name7 = x500NameBuilder.build();
        if (!x500Name5.equals(x500Name7)) {
            this.fail("Failed same name test");
        }
        if (x500Name5.hashCode() != x500Name7.hashCode()) {
            this.fail("Failed same name test - in Order");
        }
        X500NameBuilder x500NameBuilder2 = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500NameBuilder x500NameBuilder3 = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        x500NameBuilder.addRDN(BCStyle.C, "AU");
        x500NameBuilder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        x500NameBuilder.addRDN(BCStyle.L, "Melbourne");
        x500NameBuilder.addRDN(BCStyle.ST, "Victoria");
        x500Name5 = x500NameBuilder2.build();
        x500Name7 = x500NameBuilder3.build();
        if (!x500Name5.equals(x500Name7)) {
            this.fail("Failed reverse name test");
        }
        if (x500Name5.hashCode() != x500Name7.hashCode()) {
            this.fail("Failed reverse name test hashCode");
        }
        int n = 0;
        while (n != this.subjects.length) {
            X500Name x500Name8 = new X500Name(this.subjects[n]);
            if (!(x500Name8 = X500Name.getInstance(ASN1Primitive.fromByteArray(x500Name8.getEncoded()))).toString().equals(this.subjects[n])) {
                this.fail("failed regeneration test " + n + " got: " + x500Name8.toString() + " expected " + this.subjects[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.hexSubjects.length) {
            x500Name4 = new X500Name(this.hexSubjects[n2]);
            if (!(x500Name4 = X500Name.getInstance(ASN1Primitive.fromByteArray(x500Name4.getEncoded()))).toString().equals(this.hexSubjects[n2 + 1])) {
                this.fail("failed hex regeneration test " + n2 + " got: " + x500Name4.toString() + " expected " + this.subjects[n2]);
            }
            n2 += 2;
        }
        x500Name4 = new X500Name("SERIALNUMBER=BBB + CN=AA");
        if (!X500NameTest.fromBytes(x500Name4.getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 1");
        }
        if (!X500NameTest.fromBytes((x500Name4 = new X500Name("CN=AA + SERIALNUMBER=BBB")).getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 2");
        }
        if (!X500NameTest.fromBytes((x500Name4 = new X500Name("SERIALNUMBER=B + CN=AA")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 3");
        }
        if (!X500NameTest.fromBytes((x500Name4 = new X500Name("CN=AA + SERIALNUMBER=B")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 4");
        }
        this.equalityTest(new X500Name("CN=The     Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=   The Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=The Legion   "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  The     Legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion+C=AU, O=Legion "), new X500Name("CN=The Legion+C=AU, O=Legion"));
        X500Name x500Name9 = new X500Name("SERIALNUMBER=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name x500Name10 = new X500Name("2.5.4.5=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name x500Name11 = new X500Name("2.5.4.5=#130138,O=ABC,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(x500Name9, x500Name10);
        this.equalityTest(x500Name10, x500Name11);
        this.equalityTest(x500Name11, x500Name9);
        x500Name9 = new X500Name("2.5.4.5=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        x500Name10 = new X500Name("SERIALNUMBER=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        x500Name11 = X500Name.getInstance(ASN1Primitive.fromByteArray(Hex.decode("3063310b3009060355040613024c54312f302d060355040a132655414220536b6169746d656e696e696f20736572746966696b6176696d6f2063656e74726173311730150603550403130e53534320436c6173732033204341310a30080603550405130138")));
        this.equalityTest(x500Name9, x500Name10);
        this.equalityTest(x500Name10, x500Name11);
        this.equalityTest(x500Name11, x500Name9);
        x500Name9 = new X500Name("SERIALNUMBER=8,O=XX,CN=ABC Class 3 CA,C=LT");
        x500Name10 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        x500Name9 = new X500Name("SERIALNUMBER=8,O=,CN=ABC Class 3 CA,C=LT");
        x500Name10 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(x500Name9, x500Name10);
        this.equalityTest(X500Name.getInstance(BCStrictStyle.INSTANCE, x500Name9), X500Name.getInstance(BCStrictStyle.INSTANCE, x500Name10));
        x500Name10 = new X500Name("C=LT,2.5.4.5=8,O=,CN=ABC Class 3 CA");
        this.equalityTest(x500Name9, x500Name10);
        if (X500Name.getInstance(BCStrictStyle.INSTANCE, x500Name9).equals(X500Name.getInstance(BCStrictStyle.INSTANCE, x500Name10))) {
            this.fail("strict comparison failed");
        }
        if ((x500Name5 = new X500Name("CN=The Legion")).equals(new DERSequence())) {
            this.fail("inequality test with sequence");
        }
        if (x500Name5.equals(new DERSequence(new DERSet()))) {
            this.fail("inequality test with sequence and set");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        if (x500Name5.equals(new DERSequence(new DERSet(new DERSet(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (x500Name5.equals(new DERSequence(new DERSet(new DERSet(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (x500Name5.equals(new DERSequence(new DERSet(new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        if (x500Name5.equals(new DERSequence(new DERSet(new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("1.1"));
        aSN1EncodableVector.add(new DERSequence());
        if (x500Name5.equals(new DERSequence(new DERSet(new DERSequence(aSN1EncodableVector))))) {
            this.fail("inequality test with sequence and bad sequence");
        }
        if (x500Name5.equals(null)) {
            this.fail("inequality test with null");
        }
        if (!((aSN1ObjectIdentifierArray = (x500Name4 = new X500Name("CN=AA + CN=AA + CN=AA")).getAttributeTypes()).length == 3 && aSN1ObjectIdentifierArray[0].equals(BCStyle.CN) && aSN1ObjectIdentifierArray[1].equals(BCStyle.CN) && aSN1ObjectIdentifierArray[2].equals(BCStyle.CN))) {
            this.fail("types not matched correctly");
        }
        if (!((aSN1ObjectIdentifierArray = (x500Name3 = new X500Name("CN=AA + CN=AA, C=AU")).getAttributeTypes()).length == 3 && aSN1ObjectIdentifierArray[0].equals(BCStyle.CN) && aSN1ObjectIdentifierArray[1].equals(BCStyle.CN) && aSN1ObjectIdentifierArray[2].equals(BCStyle.C))) {
            this.fail("nested types not matched correctly");
        }
        if (!(dERTaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)new X500Name("CN=AA"))).isExplicit()) {
            this.fail("failed to explicitly tag CHOICE object");
        }
        if (!(x500Name2 = X500Name.getInstance(dERTaggedObject, false)).equals(new X500Name("CN=AA"))) {
            this.fail("failed to recover tagged name");
        }
        if (!(aSN1UTF8String = (ASN1UTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, string = "#" + new String(byArray2 = Hex.encode(byArray = (dERUTF8String = new DERUTF8String("The Legion of the Bouncy Castle")).getEncoded())))).equals(dERUTF8String)) {
            this.fail("failed X509DefaultEntryConverter test");
        }
        if (!(aSN1UTF8String = (ASN1UTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, "\\" + string)).equals(new DERUTF8String(string))) {
            this.fail("failed X509DefaultEntryConverter test got " + aSN1UTF8String + " expected: " + string);
        }
        if (!(x500Name = new X500Name("CN=\\#nothex#string")).toString().equals("CN=\\#nothex#string")) {
            this.fail("# string not properly escaped.");
        }
        if ((rDNArray = x500Name.getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("#nothex#string")) {
            this.fail("escaped # not reduced properly");
        }
        if ((aSN1ObjectIdentifierArray = x500Name.getAttributeTypes()).length != 1 || !aSN1ObjectIdentifierArray[0].equals(BCStyle.CN)) {
            this.fail("type not matched correctly");
        }
        if ((rDNArray = (x500Name = new X500Name("CN=\"a+b\"")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if ((rDNArray = (x500Name = new X500Name("CN=a\\+b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if (!x500Name.toString().equals("CN=a\\+b")) {
            this.fail("+ in string not properly escaped.");
        }
        if ((rDNArray = (x500Name = new X500Name("CN=a\\=b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(rDNArray[0]).equals("a=b")) {
            this.fail("escaped = not reduced properly");
        }
        if (!x500Name.toString().equals("CN=a\\=b")) {
            this.fail("= in string not properly escaped.");
        }
        if ((rDNArray = (x500Name = new X500Name("TELEPHONENUMBER=\"+61999999999\"")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(rDNArray[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if ((rDNArray = (x500Name = new X500Name("TELEPHONENUMBER=\\+61999999999")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(rDNArray[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if (!"E".equals(BCStyle.INSTANCE.oidToDisplayName(BCStyle.EmailAddress))) {
            this.fail("display name for E incorrect");
        }
        if ((stringArray = BCStyle.INSTANCE.oidToAttrNames(BCStyle.EmailAddress)).length != 2) {
            this.fail("no aliases found");
        }
        if (!"e".equals(stringArray[0]) && !"e".equals(stringArray[1])) {
            this.fail("first alias name for E incorrect");
        }
        if (!"emailaddress".equals(stringArray[0]) && !"emailaddress".equals(stringArray[1])) {
            this.fail("second alias name for E incorrect");
        }
        if (BCStyle.INSTANCE.oidToDisplayName(new ASN1ObjectIdentifier("1.2.1")) != null) {
            this.fail("unknown oid matched!");
        }
        if (BCStyle.INSTANCE.oidToAttrNames(new ASN1ObjectIdentifier("1.2.1")).length != 0) {
            this.fail("unknown oid matched aliases!");
        }
        if (!new X500Name("CN=\"  CA1 -   CP.04.03\", OU=Testing, OU=Dod, O=U.S. Government, C=US").equals(new X500Name("CN=\"ca1 - CP.04.03  \", OU=Testing, OU=Dod, O=U.S. Government, C=US"))) {
            this.fail("padded equality test failed");
        }
    }

    private void testEncodingGeneralizedTime(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not GeneralizedTime");
        }
        if (!((aSN1Encodable = this.createEntryValueFromString(aSN1ObjectIdentifier, string)) instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not GeneralizedTime");
        }
    }

    private void testEncodingIA5String(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1IA5String)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not IA5String");
        }
    }

    private void testEncodingPrintableString(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1PrintableString)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not printable string");
        }
    }

    private void testEncodingUTF8String(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) throws IOException {
        ASN1Encodable aSN1Encodable = this.createEntryValue(aSN1ObjectIdentifier, string);
        if (!(aSN1Encodable instanceof ASN1UTF8String)) {
            this.fail("encoding for " + aSN1ObjectIdentifier + " not UTF8String");
        }
        if (!string.equals(ASN1UTF8String.getInstance(aSN1Encodable.toASN1Primitive().getEncoded()).getString())) {
            this.fail("decoding not correct");
        }
    }

    public static class DNQStyle
    extends BCStyle {
        public static final DNQStyle INSTANCE = new DNQStyle();

        private DNQStyle() {
            this.defaultLookUp.put("dnq", BCStyle.DN_QUALIFIER);
            this.defaultSymbols.put(BCStyle.DN_QUALIFIER, "DNQ");
        }
    }
}

