/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.HarakaBase;
import org.bouncycastle.util.Arrays;

public class Haraka512Digest
extends HarakaBase {
    private static byte[][] RC;
    private final byte[] buffer;
    private int off;

    static {
        byte[][] byArrayArray = new byte[40][];
        byArrayArray[0] = new byte[]{6, -124, 112, 76, -26, 32, -64, 10, -78, -59, -2, -16, 117, -127, 123, -99};
        byArrayArray[1] = new byte[]{-117, 102, -76, -31, -120, -13, -96, 107, 100, 15, 107, -92, 47, 8, -9, 23};
        byArrayArray[2] = new byte[]{52, 2, -34, 45, 83, -14, -124, -104, -49, 2, -99, 96, -97, 2, -111, 20};
        byArrayArray[3] = new byte[]{14, -42, -22, -26, 46, 123, 79, 8, -69, -13, -68, -81, -3, 91, 79, 121};
        byArrayArray[4] = new byte[]{-53, -49, -80, -53, 72, 114, 68, -117, 121, -18, -51, 28, -66, 57, 112, 68};
        byArrayArray[5] = new byte[]{126, -22, -51, -18, 110, -112, 50, -73, -115, 83, 53, -19, 43, -118, 5, 123};
        byArrayArray[6] = new byte[]{103, -62, -113, 67, 94, 46, 124, -48, -30, 65, 39, 97, -38, 79, -17, 27};
        byArrayArray[7] = new byte[]{41, 36, -39, -80, -81, -54, -52, 7, 103, 95, -3, -30, 31, -57, 11, 59};
        byArrayArray[8] = new byte[]{-85, 77, 99, -15, -26, -122, 127, -23, -20, -37, -113, -54, -71, -44, 101, -18};
        byArrayArray[9] = new byte[]{28, 48, -65, -124, -44, -73, -51, 100, 91, 42, 64, 79, -83, 3, 126, 51};
        byte[] byArray = new byte[16];
        byArray[0] = -78;
        byArray[1] = -52;
        byArray[2] = 11;
        byArray[3] = -71;
        byArray[4] = -108;
        byArray[5] = 23;
        byArray[6] = 35;
        byArray[7] = -65;
        byArray[8] = 105;
        byArray[9] = 2;
        byArray[10] = -117;
        byArray[11] = 46;
        byArray[12] = -115;
        byArray[13] = -10;
        byArray[14] = -104;
        byArrayArray[10] = byArray;
        byArrayArray[11] = new byte[]{-6, 4, 120, -90, -34, 111, 85, 114, 74, -86, -98, -56, 92, -99, 45, -118};
        byArrayArray[12] = new byte[]{-33, -76, -97, 43, 107, 119, 42, 18, 14, -6, 79, 46, 41, 18, -97, -44};
        byArrayArray[13] = new byte[]{30, -95, 3, 68, -12, 73, -94, 54, 50, -42, 17, -82, -69, 106, 18, -18};
        byte[] byArray2 = new byte[16];
        byArray2[0] = -81;
        byArray2[1] = 4;
        byArray2[2] = 73;
        byArray2[3] = -120;
        byArray2[4] = 75;
        byArray2[5] = 5;
        byArray2[7] = -124;
        byArray2[8] = 95;
        byArray2[9] = -106;
        byArray2[11] = -55;
        byArray2[12] = -100;
        byArray2[13] = -88;
        byArray2[14] = -20;
        byArray2[15] = -90;
        byArrayArray[14] = byArray2;
        byArrayArray[15] = new byte[]{33, 2, 94, -40, -99, 25, -100, 79, 120, -94, -57, -29, 39, -27, -109, -20};
        byArrayArray[16] = new byte[]{-65, 58, -86, -8, -89, 89, -55, -73, -71, 40, 46, -51, -126, -44, 1, 115};
        byArrayArray[17] = new byte[]{98, 96, 112, 13, 97, -122, -80, 23, 55, -14, -17, -39, 16, 48, 125, 107};
        byArrayArray[18] = new byte[]{90, -54, 69, -62, 33, 48, 4, 67, -127, -62, -111, 83, -10, -4, -102, -58};
        byArrayArray[19] = new byte[]{-110, 35, -105, 60, 34, 107, 104, -69, 44, -81, -110, -24, 54, -47, -108, 58};
        byArrayArray[20] = new byte[]{-45, -65, -110, 56, 34, 88, -122, -21, 108, -70, -71, 88, -27, 16, 113, -76};
        byArrayArray[21] = new byte[]{-37, -122, 60, -27, -82, -16, -58, 119, -109, 61, -3, -35, 36, -31, 18, -115};
        byArrayArray[22] = new byte[]{-69, 96, 98, 104, -1, -21, -96, -100, -125, -28, -115, -29, -53, 34, 18, -79};
        byArrayArray[23] = new byte[]{115, 75, -45, -36, -30, -28, -47, -100, 45, -71, 26, 78, -57, 43, -9, 125};
        byArrayArray[24] = new byte[]{67, -69, 71, -61, 97, 48, 27, 67, 75, 20, 21, -60, 44, -77, -110, 78};
        byArrayArray[25] = new byte[]{-37, -89, 117, -88, -25, 7, -17, -10, 3, -78, 49, -35, 22, -21, 104, -103};
        byArrayArray[26] = new byte[]{109, -13, 97, 75, 60, 117, 89, 119, -114, 94, 35, 2, 126, -54, 71, 44};
        byArrayArray[27] = new byte[]{-51, -89, 90, 23, -42, -34, 125, 119, 109, 27, -27, -71, -72, -122, 23, -7};
        byArrayArray[28] = new byte[]{-20, 107, 67, -16, 107, -88, -23, -86, -99, 108, 6, -99, -87, 70, -18, 93};
        byArrayArray[29] = new byte[]{-53, 30, 105, 80, -7, 87, 51, 43, -94, 83, 17, 89, 59, -13, 39, -63};
        byte[] byArray3 = new byte[16];
        byArray3[0] = 44;
        byArray3[1] = -18;
        byArray3[2] = 12;
        byArray3[3] = 117;
        byArray3[5] = -38;
        byArray3[6] = 97;
        byArray3[7] = -100;
        byArray3[8] = -28;
        byArray3[9] = -19;
        byArray3[10] = 3;
        byArray3[11] = 83;
        byArray3[12] = 96;
        byArray3[13] = 14;
        byArray3[14] = -48;
        byArray3[15] = -39;
        byArrayArray[30] = byArray3;
        byArrayArray[31] = new byte[]{-16, -79, -91, -95, -106, -23, 12, -85, -128, -69, -70, -68, 99, -92, -93, 80};
        byArrayArray[32] = new byte[]{-82, 61, -79, 2, 94, -106, 41, -120, -85, 13, -34, 48, -109, -115, -54, 57};
        byArrayArray[33] = new byte[]{23, -69, -113, 56, -43, 84, -92, 11, -120, 20, -13, -88, 46, 117, -76, 66};
        byArrayArray[34] = new byte[]{52, -69, -118, 91, 95, 66, 127, -41, -82, -74, -73, 121, 54, 10, 22, -10};
        byArrayArray[35] = new byte[]{38, -10, 82, 65, -53, -27, 84, 56, 67, -50, 89, 24, -1, -70, -81, -34};
        byArrayArray[36] = new byte[]{76, -23, -102, 84, -71, -13, 2, 106, -94, -54, -100, -9, -125, -98, -55, 120};
        byArrayArray[37] = new byte[]{-82, 81, -91, 26, 27, -33, -9, -66, 64, -64, 110, 40, 34, -112, 18, 53};
        byArrayArray[38] = new byte[]{-96, -63, 97, 60, -70, 126, -46, 43, -63, 115, -68, 15, 72, -90, 89, -49};
        byArrayArray[39] = new byte[]{117, 106, -52, 3, 2, 40, -126, -120, 74, -42, -67, -3, -23, -59, -99, -95};
        RC = byArrayArray;
    }

    public Haraka512Digest() {
        this.buffer = new byte[64];
    }

    public Haraka512Digest(Haraka512Digest haraka512Digest) {
        this.buffer = Arrays.clone(haraka512Digest.buffer);
        this.off = haraka512Digest.off;
    }

    public int doFinal(byte[] byArray, int n) {
        if (this.off != 64) {
            throw new IllegalStateException("input must be exactly 64 bytes");
        }
        if (byArray.length - n < 32) {
            throw new IllegalArgumentException("output too short to receive digest");
        }
        int n2 = this.haraka512256(this.buffer, byArray, n);
        this.reset();
        return n2;
    }

    public String getAlgorithmName() {
        return "Haraka-512";
    }

    private int haraka512256(byte[] byArray, byte[] byArray2, int n) {
        byte[][] byArray3 = new byte[4][16];
        byte[][] byArray4 = new byte[4][16];
        System.arraycopy(byArray, 0, byArray3[0], 0, 16);
        System.arraycopy(byArray, 16, byArray3[1], 0, 16);
        System.arraycopy(byArray, 32, byArray3[2], 0, 16);
        System.arraycopy(byArray, 48, byArray3[3], 0, 16);
        byArray3[0] = HarakaBase.aesEnc(byArray3[0], RC[0]);
        byArray3[1] = HarakaBase.aesEnc(byArray3[1], RC[1]);
        byArray3[2] = HarakaBase.aesEnc(byArray3[2], RC[2]);
        byArray3[3] = HarakaBase.aesEnc(byArray3[3], RC[3]);
        byArray3[0] = HarakaBase.aesEnc(byArray3[0], RC[4]);
        byArray3[1] = HarakaBase.aesEnc(byArray3[1], RC[5]);
        byArray3[2] = HarakaBase.aesEnc(byArray3[2], RC[6]);
        byArray3[3] = HarakaBase.aesEnc(byArray3[3], RC[7]);
        this.mix512(byArray3, byArray4);
        byArray3[0] = HarakaBase.aesEnc(byArray4[0], RC[8]);
        byArray3[1] = HarakaBase.aesEnc(byArray4[1], RC[9]);
        byArray3[2] = HarakaBase.aesEnc(byArray4[2], RC[10]);
        byArray3[3] = HarakaBase.aesEnc(byArray4[3], RC[11]);
        byArray3[0] = HarakaBase.aesEnc(byArray3[0], RC[12]);
        byArray3[1] = HarakaBase.aesEnc(byArray3[1], RC[13]);
        byArray3[2] = HarakaBase.aesEnc(byArray3[2], RC[14]);
        byArray3[3] = HarakaBase.aesEnc(byArray3[3], RC[15]);
        this.mix512(byArray3, byArray4);
        byArray3[0] = HarakaBase.aesEnc(byArray4[0], RC[16]);
        byArray3[1] = HarakaBase.aesEnc(byArray4[1], RC[17]);
        byArray3[2] = HarakaBase.aesEnc(byArray4[2], RC[18]);
        byArray3[3] = HarakaBase.aesEnc(byArray4[3], RC[19]);
        byArray3[0] = HarakaBase.aesEnc(byArray3[0], RC[20]);
        byArray3[1] = HarakaBase.aesEnc(byArray3[1], RC[21]);
        byArray3[2] = HarakaBase.aesEnc(byArray3[2], RC[22]);
        byArray3[3] = HarakaBase.aesEnc(byArray3[3], RC[23]);
        this.mix512(byArray3, byArray4);
        byArray3[0] = HarakaBase.aesEnc(byArray4[0], RC[24]);
        byArray3[1] = HarakaBase.aesEnc(byArray4[1], RC[25]);
        byArray3[2] = HarakaBase.aesEnc(byArray4[2], RC[26]);
        byArray3[3] = HarakaBase.aesEnc(byArray4[3], RC[27]);
        byArray3[0] = HarakaBase.aesEnc(byArray3[0], RC[28]);
        byArray3[1] = HarakaBase.aesEnc(byArray3[1], RC[29]);
        byArray3[2] = HarakaBase.aesEnc(byArray3[2], RC[30]);
        byArray3[3] = HarakaBase.aesEnc(byArray3[3], RC[31]);
        this.mix512(byArray3, byArray4);
        byArray3[0] = HarakaBase.aesEnc(byArray4[0], RC[32]);
        byArray3[1] = HarakaBase.aesEnc(byArray4[1], RC[33]);
        byArray3[2] = HarakaBase.aesEnc(byArray4[2], RC[34]);
        byArray3[3] = HarakaBase.aesEnc(byArray4[3], RC[35]);
        byArray3[0] = HarakaBase.aesEnc(byArray3[0], RC[36]);
        byArray3[1] = HarakaBase.aesEnc(byArray3[1], RC[37]);
        byArray3[2] = HarakaBase.aesEnc(byArray3[2], RC[38]);
        byArray3[3] = HarakaBase.aesEnc(byArray3[3], RC[39]);
        this.mix512(byArray3, byArray4);
        byArray3[0] = HarakaBase.xor(byArray4[0], byArray, 0);
        byArray3[1] = HarakaBase.xor(byArray4[1], byArray, 16);
        byArray3[2] = HarakaBase.xor(byArray4[2], byArray, 32);
        byArray3[3] = HarakaBase.xor(byArray4[3], byArray, 48);
        System.arraycopy(byArray3[0], 8, byArray2, n, 8);
        System.arraycopy(byArray3[1], 8, byArray2, n + 8, 8);
        System.arraycopy(byArray3[2], 0, byArray2, n + 16, 8);
        System.arraycopy(byArray3[3], 0, byArray2, n + 24, 8);
        return 32;
    }

    private void mix512(byte[][] byArray, byte[][] byArray2) {
        System.arraycopy(byArray[0], 12, byArray2[0], 0, 4);
        System.arraycopy(byArray[2], 12, byArray2[0], 4, 4);
        System.arraycopy(byArray[1], 12, byArray2[0], 8, 4);
        System.arraycopy(byArray[3], 12, byArray2[0], 12, 4);
        System.arraycopy(byArray[2], 0, byArray2[1], 0, 4);
        System.arraycopy(byArray[0], 0, byArray2[1], 4, 4);
        System.arraycopy(byArray[3], 0, byArray2[1], 8, 4);
        System.arraycopy(byArray[1], 0, byArray2[1], 12, 4);
        System.arraycopy(byArray[2], 4, byArray2[2], 0, 4);
        System.arraycopy(byArray[0], 4, byArray2[2], 4, 4);
        System.arraycopy(byArray[3], 4, byArray2[2], 8, 4);
        System.arraycopy(byArray[1], 4, byArray2[2], 12, 4);
        System.arraycopy(byArray[0], 8, byArray2[3], 0, 4);
        System.arraycopy(byArray[2], 8, byArray2[3], 4, 4);
        System.arraycopy(byArray[1], 8, byArray2[3], 8, 4);
        System.arraycopy(byArray[3], 8, byArray2[3], 12, 4);
    }

    public void reset() {
        this.off = 0;
        Arrays.clear(this.buffer);
    }

    public void update(byte by) {
        if (this.off + 1 > 64) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        this.buffer[this.off++] = by;
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.off + n2 > 64) {
            throw new IllegalArgumentException("total input cannot be more than 64 bytes");
        }
        System.arraycopy(byArray, n, this.buffer, this.off, n2);
        this.off += n2;
    }
}

