/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StatelessProcessing;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AESEngine
implements BlockCipher,
StatelessProcessing {
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] rcon;
    private static final int[] T0;
    private static final int[] Tinv0;
    private static final int m1 = -2139062144;
    private static final int m2 = 0x7F7F7F7F;
    private static final int m3 = 27;
    private static final int m4 = -1061109568;
    private static final int m5 = 0x3F3F3F3F;
    private int ROUNDS;
    private int[][] WorkingKey = null;
    private boolean forEncryption;
    private byte[] s;
    private static final int BLOCK_SIZE = 16;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = 99;
        byArray[1] = 124;
        byArray[2] = 119;
        byArray[3] = 123;
        byArray[4] = -14;
        byArray[5] = 107;
        byArray[6] = 111;
        byArray[7] = -59;
        byArray[8] = 48;
        byArray[9] = 1;
        byArray[10] = 103;
        byArray[11] = 43;
        byArray[12] = -2;
        byArray[13] = -41;
        byArray[14] = -85;
        byArray[15] = 118;
        byArray[16] = -54;
        byArray[17] = -126;
        byArray[18] = -55;
        byArray[19] = 125;
        byArray[20] = -6;
        byArray[21] = 89;
        byArray[22] = 71;
        byArray[23] = -16;
        byArray[24] = -83;
        byArray[25] = -44;
        byArray[26] = -94;
        byArray[27] = -81;
        byArray[28] = -100;
        byArray[29] = -92;
        byArray[30] = 114;
        byArray[31] = -64;
        byArray[32] = -73;
        byArray[33] = -3;
        byArray[34] = -109;
        byArray[35] = 38;
        byArray[36] = 54;
        byArray[37] = 63;
        byArray[38] = -9;
        byArray[39] = -52;
        byArray[40] = 52;
        byArray[41] = -91;
        byArray[42] = -27;
        byArray[43] = -15;
        byArray[44] = 113;
        byArray[45] = -40;
        byArray[46] = 49;
        byArray[47] = 21;
        byArray[48] = 4;
        byArray[49] = -57;
        byArray[50] = 35;
        byArray[51] = -61;
        byArray[52] = 24;
        byArray[53] = -106;
        byArray[54] = 5;
        byArray[55] = -102;
        byArray[56] = 7;
        byArray[57] = 18;
        byArray[58] = -128;
        byArray[59] = -30;
        byArray[60] = -21;
        byArray[61] = 39;
        byArray[62] = -78;
        byArray[63] = 117;
        byArray[64] = 9;
        byArray[65] = -125;
        byArray[66] = 44;
        byArray[67] = 26;
        byArray[68] = 27;
        byArray[69] = 110;
        byArray[70] = 90;
        byArray[71] = -96;
        byArray[72] = 82;
        byArray[73] = 59;
        byArray[74] = -42;
        byArray[75] = -77;
        byArray[76] = 41;
        byArray[77] = -29;
        byArray[78] = 47;
        byArray[79] = -124;
        byArray[80] = 83;
        byArray[81] = -47;
        byArray[83] = -19;
        byArray[84] = 32;
        byArray[85] = -4;
        byArray[86] = -79;
        byArray[87] = 91;
        byArray[88] = 106;
        byArray[89] = -53;
        byArray[90] = -66;
        byArray[91] = 57;
        byArray[92] = 74;
        byArray[93] = 76;
        byArray[94] = 88;
        byArray[95] = -49;
        byArray[96] = -48;
        byArray[97] = -17;
        byArray[98] = -86;
        byArray[99] = -5;
        byArray[100] = 67;
        byArray[101] = 77;
        byArray[102] = 51;
        byArray[103] = -123;
        byArray[104] = 69;
        byArray[105] = -7;
        byArray[106] = 2;
        byArray[107] = 127;
        byArray[108] = 80;
        byArray[109] = 60;
        byArray[110] = -97;
        byArray[111] = -88;
        byArray[112] = 81;
        byArray[113] = -93;
        byArray[114] = 64;
        byArray[115] = -113;
        byArray[116] = -110;
        byArray[117] = -99;
        byArray[118] = 56;
        byArray[119] = -11;
        byArray[120] = -68;
        byArray[121] = -74;
        byArray[122] = -38;
        byArray[123] = 33;
        byArray[124] = 16;
        byArray[125] = -1;
        byArray[126] = -13;
        byArray[127] = -46;
        byArray[128] = -51;
        byArray[129] = 12;
        byArray[130] = 19;
        byArray[131] = -20;
        byArray[132] = 95;
        byArray[133] = -105;
        byArray[134] = 68;
        byArray[135] = 23;
        byArray[136] = -60;
        byArray[137] = -89;
        byArray[138] = 126;
        byArray[139] = 61;
        byArray[140] = 100;
        byArray[141] = 93;
        byArray[142] = 25;
        byArray[143] = 115;
        byArray[144] = 96;
        byArray[145] = -127;
        byArray[146] = 79;
        byArray[147] = -36;
        byArray[148] = 34;
        byArray[149] = 42;
        byArray[150] = -112;
        byArray[151] = -120;
        byArray[152] = 70;
        byArray[153] = -18;
        byArray[154] = -72;
        byArray[155] = 20;
        byArray[156] = -34;
        byArray[157] = 94;
        byArray[158] = 11;
        byArray[159] = -37;
        byArray[160] = -32;
        byArray[161] = 50;
        byArray[162] = 58;
        byArray[163] = 10;
        byArray[164] = 73;
        byArray[165] = 6;
        byArray[166] = 36;
        byArray[167] = 92;
        byArray[168] = -62;
        byArray[169] = -45;
        byArray[170] = -84;
        byArray[171] = 98;
        byArray[172] = -111;
        byArray[173] = -107;
        byArray[174] = -28;
        byArray[175] = 121;
        byArray[176] = -25;
        byArray[177] = -56;
        byArray[178] = 55;
        byArray[179] = 109;
        byArray[180] = -115;
        byArray[181] = -43;
        byArray[182] = 78;
        byArray[183] = -87;
        byArray[184] = 108;
        byArray[185] = 86;
        byArray[186] = -12;
        byArray[187] = -22;
        byArray[188] = 101;
        byArray[189] = 122;
        byArray[190] = -82;
        byArray[191] = 8;
        byArray[192] = -70;
        byArray[193] = 120;
        byArray[194] = 37;
        byArray[195] = 46;
        byArray[196] = 28;
        byArray[197] = -90;
        byArray[198] = -76;
        byArray[199] = -58;
        byArray[200] = -24;
        byArray[201] = -35;
        byArray[202] = 116;
        byArray[203] = 31;
        byArray[204] = 75;
        byArray[205] = -67;
        byArray[206] = -117;
        byArray[207] = -118;
        byArray[208] = 112;
        byArray[209] = 62;
        byArray[210] = -75;
        byArray[211] = 102;
        byArray[212] = 72;
        byArray[213] = 3;
        byArray[214] = -10;
        byArray[215] = 14;
        byArray[216] = 97;
        byArray[217] = 53;
        byArray[218] = 87;
        byArray[219] = -71;
        byArray[220] = -122;
        byArray[221] = -63;
        byArray[222] = 29;
        byArray[223] = -98;
        byArray[224] = -31;
        byArray[225] = -8;
        byArray[226] = -104;
        byArray[227] = 17;
        byArray[228] = 105;
        byArray[229] = -39;
        byArray[230] = -114;
        byArray[231] = -108;
        byArray[232] = -101;
        byArray[233] = 30;
        byArray[234] = -121;
        byArray[235] = -23;
        byArray[236] = -50;
        byArray[237] = 85;
        byArray[238] = 40;
        byArray[239] = -33;
        byArray[240] = -116;
        byArray[241] = -95;
        byArray[242] = -119;
        byArray[243] = 13;
        byArray[244] = -65;
        byArray[245] = -26;
        byArray[246] = 66;
        byArray[247] = 104;
        byArray[248] = 65;
        byArray[249] = -103;
        byArray[250] = 45;
        byArray[251] = 15;
        byArray[252] = -80;
        byArray[253] = 84;
        byArray[254] = -69;
        byArray[255] = 22;
        S = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = 82;
        byArray2[1] = 9;
        byArray2[2] = 106;
        byArray2[3] = -43;
        byArray2[4] = 48;
        byArray2[5] = 54;
        byArray2[6] = -91;
        byArray2[7] = 56;
        byArray2[8] = -65;
        byArray2[9] = 64;
        byArray2[10] = -93;
        byArray2[11] = -98;
        byArray2[12] = -127;
        byArray2[13] = -13;
        byArray2[14] = -41;
        byArray2[15] = -5;
        byArray2[16] = 124;
        byArray2[17] = -29;
        byArray2[18] = 57;
        byArray2[19] = -126;
        byArray2[20] = -101;
        byArray2[21] = 47;
        byArray2[22] = -1;
        byArray2[23] = -121;
        byArray2[24] = 52;
        byArray2[25] = -114;
        byArray2[26] = 67;
        byArray2[27] = 68;
        byArray2[28] = -60;
        byArray2[29] = -34;
        byArray2[30] = -23;
        byArray2[31] = -53;
        byArray2[32] = 84;
        byArray2[33] = 123;
        byArray2[34] = -108;
        byArray2[35] = 50;
        byArray2[36] = -90;
        byArray2[37] = -62;
        byArray2[38] = 35;
        byArray2[39] = 61;
        byArray2[40] = -18;
        byArray2[41] = 76;
        byArray2[42] = -107;
        byArray2[43] = 11;
        byArray2[44] = 66;
        byArray2[45] = -6;
        byArray2[46] = -61;
        byArray2[47] = 78;
        byArray2[48] = 8;
        byArray2[49] = 46;
        byArray2[50] = -95;
        byArray2[51] = 102;
        byArray2[52] = 40;
        byArray2[53] = -39;
        byArray2[54] = 36;
        byArray2[55] = -78;
        byArray2[56] = 118;
        byArray2[57] = 91;
        byArray2[58] = -94;
        byArray2[59] = 73;
        byArray2[60] = 109;
        byArray2[61] = -117;
        byArray2[62] = -47;
        byArray2[63] = 37;
        byArray2[64] = 114;
        byArray2[65] = -8;
        byArray2[66] = -10;
        byArray2[67] = 100;
        byArray2[68] = -122;
        byArray2[69] = 104;
        byArray2[70] = -104;
        byArray2[71] = 22;
        byArray2[72] = -44;
        byArray2[73] = -92;
        byArray2[74] = 92;
        byArray2[75] = -52;
        byArray2[76] = 93;
        byArray2[77] = 101;
        byArray2[78] = -74;
        byArray2[79] = -110;
        byArray2[80] = 108;
        byArray2[81] = 112;
        byArray2[82] = 72;
        byArray2[83] = 80;
        byArray2[84] = -3;
        byArray2[85] = -19;
        byArray2[86] = -71;
        byArray2[87] = -38;
        byArray2[88] = 94;
        byArray2[89] = 21;
        byArray2[90] = 70;
        byArray2[91] = 87;
        byArray2[92] = -89;
        byArray2[93] = -115;
        byArray2[94] = -99;
        byArray2[95] = -124;
        byArray2[96] = -112;
        byArray2[97] = -40;
        byArray2[98] = -85;
        byArray2[100] = -116;
        byArray2[101] = -68;
        byArray2[102] = -45;
        byArray2[103] = 10;
        byArray2[104] = -9;
        byArray2[105] = -28;
        byArray2[106] = 88;
        byArray2[107] = 5;
        byArray2[108] = -72;
        byArray2[109] = -77;
        byArray2[110] = 69;
        byArray2[111] = 6;
        byArray2[112] = -48;
        byArray2[113] = 44;
        byArray2[114] = 30;
        byArray2[115] = -113;
        byArray2[116] = -54;
        byArray2[117] = 63;
        byArray2[118] = 15;
        byArray2[119] = 2;
        byArray2[120] = -63;
        byArray2[121] = -81;
        byArray2[122] = -67;
        byArray2[123] = 3;
        byArray2[124] = 1;
        byArray2[125] = 19;
        byArray2[126] = -118;
        byArray2[127] = 107;
        byArray2[128] = 58;
        byArray2[129] = -111;
        byArray2[130] = 17;
        byArray2[131] = 65;
        byArray2[132] = 79;
        byArray2[133] = 103;
        byArray2[134] = -36;
        byArray2[135] = -22;
        byArray2[136] = -105;
        byArray2[137] = -14;
        byArray2[138] = -49;
        byArray2[139] = -50;
        byArray2[140] = -16;
        byArray2[141] = -76;
        byArray2[142] = -26;
        byArray2[143] = 115;
        byArray2[144] = -106;
        byArray2[145] = -84;
        byArray2[146] = 116;
        byArray2[147] = 34;
        byArray2[148] = -25;
        byArray2[149] = -83;
        byArray2[150] = 53;
        byArray2[151] = -123;
        byArray2[152] = -30;
        byArray2[153] = -7;
        byArray2[154] = 55;
        byArray2[155] = -24;
        byArray2[156] = 28;
        byArray2[157] = 117;
        byArray2[158] = -33;
        byArray2[159] = 110;
        byArray2[160] = 71;
        byArray2[161] = -15;
        byArray2[162] = 26;
        byArray2[163] = 113;
        byArray2[164] = 29;
        byArray2[165] = 41;
        byArray2[166] = -59;
        byArray2[167] = -119;
        byArray2[168] = 111;
        byArray2[169] = -73;
        byArray2[170] = 98;
        byArray2[171] = 14;
        byArray2[172] = -86;
        byArray2[173] = 24;
        byArray2[174] = -66;
        byArray2[175] = 27;
        byArray2[176] = -4;
        byArray2[177] = 86;
        byArray2[178] = 62;
        byArray2[179] = 75;
        byArray2[180] = -58;
        byArray2[181] = -46;
        byArray2[182] = 121;
        byArray2[183] = 32;
        byArray2[184] = -102;
        byArray2[185] = -37;
        byArray2[186] = -64;
        byArray2[187] = -2;
        byArray2[188] = 120;
        byArray2[189] = -51;
        byArray2[190] = 90;
        byArray2[191] = -12;
        byArray2[192] = 31;
        byArray2[193] = -35;
        byArray2[194] = -88;
        byArray2[195] = 51;
        byArray2[196] = -120;
        byArray2[197] = 7;
        byArray2[198] = -57;
        byArray2[199] = 49;
        byArray2[200] = -79;
        byArray2[201] = 18;
        byArray2[202] = 16;
        byArray2[203] = 89;
        byArray2[204] = 39;
        byArray2[205] = -128;
        byArray2[206] = -20;
        byArray2[207] = 95;
        byArray2[208] = 96;
        byArray2[209] = 81;
        byArray2[210] = 127;
        byArray2[211] = -87;
        byArray2[212] = 25;
        byArray2[213] = -75;
        byArray2[214] = 74;
        byArray2[215] = 13;
        byArray2[216] = 45;
        byArray2[217] = -27;
        byArray2[218] = 122;
        byArray2[219] = -97;
        byArray2[220] = -109;
        byArray2[221] = -55;
        byArray2[222] = -100;
        byArray2[223] = -17;
        byArray2[224] = -96;
        byArray2[225] = -32;
        byArray2[226] = 59;
        byArray2[227] = 77;
        byArray2[228] = -82;
        byArray2[229] = 42;
        byArray2[230] = -11;
        byArray2[231] = -80;
        byArray2[232] = -56;
        byArray2[233] = -21;
        byArray2[234] = -69;
        byArray2[235] = 60;
        byArray2[236] = -125;
        byArray2[237] = 83;
        byArray2[238] = -103;
        byArray2[239] = 97;
        byArray2[240] = 23;
        byArray2[241] = 43;
        byArray2[242] = 4;
        byArray2[243] = 126;
        byArray2[244] = -70;
        byArray2[245] = 119;
        byArray2[246] = -42;
        byArray2[247] = 38;
        byArray2[248] = -31;
        byArray2[249] = 105;
        byArray2[250] = 20;
        byArray2[251] = 99;
        byArray2[252] = 85;
        byArray2[253] = 33;
        byArray2[254] = 12;
        byArray2[255] = 125;
        Si = byArray2;
        rcon = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212, 179, 125, 250, 239, 197, 145};
        int[] nArray = new int[256];
        nArray[0] = -1520213050;
        nArray[1] = -2072216328;
        nArray[2] = -1720223762;
        nArray[3] = -1921287178;
        nArray[4] = 0xDF2F2FF;
        nArray[5] = -1117033514;
        nArray[6] = -1318096930;
        nArray[7] = 1422247313;
        nArray[8] = 1345335392;
        nArray[9] = 50397442;
        nArray[10] = -1452841010;
        nArray[11] = 2099981142;
        nArray[12] = 436141799;
        nArray[13] = 1658312629;
        nArray[14] = -424957107;
        nArray[15] = -1703512340;
        nArray[16] = 1170918031;
        nArray[17] = -1652391393;
        nArray[18] = 1086966153;
        nArray[19] = -2021818886;
        nArray[20] = 368769775;
        nArray[21] = -346465870;
        nArray[22] = -918075506;
        nArray[23] = 0xBF0F0FB;
        nArray[24] = -324162239;
        nArray[25] = 1742001331;
        nArray[26] = -39673249;
        nArray[27] = -357585083;
        nArray[28] = -1080255453;
        nArray[29] = -140204973;
        nArray[30] = -1770884380;
        nArray[31] = 1539358875;
        nArray[32] = -1028147339;
        nArray[33] = 486407649;
        nArray[34] = -1366060227;
        nArray[35] = 1780885068;
        nArray[36] = 1513502316;
        nArray[37] = 1094664062;
        nArray[38] = 49805301;
        nArray[39] = 1338821763;
        nArray[40] = 1546925160;
        nArray[41] = -190470831;
        nArray[42] = 887481809;
        nArray[43] = 150073849;
        nArray[44] = -1821281822;
        nArray[45] = 1943591083;
        nArray[46] = 1395732834;
        nArray[47] = 1058346282;
        nArray[48] = 201589768;
        nArray[49] = 1388824469;
        nArray[50] = 1696801606;
        nArray[51] = 1589887901;
        nArray[52] = 672667696;
        nArray[53] = -1583966665;
        nArray[54] = 251987210;
        nArray[55] = -1248159185;
        nArray[56] = 151455502;
        nArray[57] = 907153956;
        nArray[58] = -1686077413;
        nArray[59] = 1038279391;
        nArray[60] = 652995533;
        nArray[61] = 1764173646;
        nArray[62] = -843926913;
        nArray[63] = -1619692054;
        nArray[64] = 453576978;
        nArray[65] = -1635548387;
        nArray[66] = 1949051992;
        nArray[67] = 773462580;
        nArray[68] = 756751158;
        nArray[69] = -1301385508;
        nArray[70] = -296068428;
        nArray[71] = -73359269;
        nArray[72] = -162377052;
        nArray[73] = 1295727478;
        nArray[74] = 1641469623;
        nArray[75] = -827083907;
        nArray[76] = 2066295122;
        nArray[77] = 0x3EE3E3DD;
        nArray[78] = 1898917726;
        nArray[79] = -1752923117;
        nArray[80] = -179088474;
        nArray[81] = 1758581177;
        nArray[83] = 753790401;
        nArray[84] = 1612718144;
        nArray[85] = 536673507;
        nArray[86] = -927878791;
        nArray[87] = -312779850;
        nArray[88] = -1100322092;
        nArray[89] = 1187761037;
        nArray[90] = -641810841;
        nArray[91] = 1262041458;
        nArray[92] = -565556588;
        nArray[93] = -733197160;
        nArray[94] = -396863312;
        nArray[95] = 1255133061;
        nArray[96] = 1808847035;
        nArray[97] = 720367557;
        nArray[98] = -441800113;
        nArray[99] = 385612781;
        nArray[100] = -985447546;
        nArray[101] = -682799718;
        nArray[102] = 0x55333366;
        nArray[103] = -1803188975;
        nArray[104] = -817543798;
        nArray[105] = 284817897;
        nArray[106] = 100794884;
        nArray[107] = -2122350594;
        nArray[108] = -263171936;
        nArray[109] = 1144798328;
        nArray[110] = -1163944155;
        nArray[111] = -475486133;
        nArray[112] = -212774494;
        nArray[113] = -22830243;
        nArray[114] = -1069531008;
        nArray[115] = -1970303227;
        nArray[116] = -1382903233;
        nArray[117] = -1130521311;
        nArray[118] = 1211644016;
        nArray[119] = 83228145;
        nArray[120] = -541279133;
        nArray[121] = -1044990345;
        nArray[122] = 1977277103;
        nArray[123] = 1663115586;
        nArray[124] = 806359072;
        nArray[125] = 452984805;
        nArray[126] = 250868733;
        nArray[127] = 1842533055;
        nArray[128] = 1288555905;
        nArray[129] = 336333848;
        nArray[130] = 890442534;
        nArray[131] = 804056259;
        nArray[132] = -513843266;
        nArray[133] = -1567123659;
        nArray[134] = -867941240;
        nArray[135] = 957814574;
        nArray[136] = 1472513171;
        nArray[137] = -223893675;
        nArray[138] = -2105639172;
        nArray[139] = 1195195770;
        nArray[140] = -1402706744;
        nArray[141] = -413311558;
        nArray[142] = 723065138;
        nArray[143] = -1787595802;
        nArray[144] = -1604296512;
        nArray[145] = -1736343271;
        nArray[146] = -783331426;
        nArray[147] = 2145180835;
        nArray[148] = 0x66222244;
        nArray[149] = 2116692564;
        nArray[150] = -1416589253;
        nArray[151] = -2088204277;
        nArray[152] = -901364084;
        nArray[153] = 703524551;
        nArray[154] = -742868885;
        nArray[155] = 1007948840;
        nArray[156] = 2044649127;
        nArray[157] = -497131844;
        nArray[158] = 487262998;
        nArray[159] = 1994120109;
        nArray[160] = 1004593371;
        nArray[161] = 1446130276;
        nArray[162] = 1312438900;
        nArray[163] = 503974420;
        nArray[164] = -615954030;
        nArray[165] = 168166924;
        nArray[166] = 1814307912;
        nArray[167] = -463709000;
        nArray[168] = 1573044895;
        nArray[169] = 1859376061;
        nArray[170] = -273896381;
        nArray[171] = -1503501628;
        nArray[172] = -1466855111;
        nArray[173] = -1533700815;
        nArray[174] = 937747667;
        nArray[175] = -1954973198;
        nArray[176] = 854058965;
        nArray[177] = 1137232011;
        nArray[178] = 1496790894;
        nArray[179] = -1217565222;
        nArray[180] = -1936880383;
        nArray[181] = 1691735473;
        nArray[182] = -766620004;
        nArray[183] = -525751991;
        nArray[184] = -1267962664;
        nArray[185] = -95005012;
        nArray[186] = 133494003;
        nArray[187] = 636152527;
        nArray[188] = -1352309302;
        nArray[189] = -1904575756;
        nArray[190] = -374428089;
        nArray[191] = 0x18080810;
        nArray[192] = -709182865;
        nArray[193] = -2005370640;
        nArray[194] = 1864705354;
        nArray[195] = 1915629148;
        nArray[196] = 605822008;
        nArray[197] = -240736681;
        nArray[198] = -944458637;
        nArray[199] = 1371981463;
        nArray[200] = 602466507;
        nArray[201] = 2094914977;
        nArray[202] = -1670089496;
        nArray[203] = 555687742;
        nArray[204] = -582268010;
        nArray[205] = -591544991;
        nArray[206] = -2037675251;
        nArray[207] = -2054518257;
        nArray[208] = -1871679264;
        nArray[209] = 1111375484;
        nArray[210] = -994724495;
        nArray[211] = -1436129588;
        nArray[212] = -666351472;
        nArray[213] = 84083462;
        nArray[214] = 32962295;
        nArray[215] = 302911004;
        nArray[216] = -1553899070;
        nArray[217] = 1597322602;
        nArray[218] = -111716434;
        nArray[219] = -793134743;
        nArray[220] = -1853454825;
        nArray[221] = 1489093017;
        nArray[222] = 656219450;
        nArray[223] = -1180787161;
        nArray[224] = 954327513;
        nArray[225] = 335083755;
        nArray[226] = -1281845205;
        nArray[227] = 0x33111122;
        nArray[228] = -1150719534;
        nArray[229] = 1893325225;
        nArray[230] = -1987146233;
        nArray[231] = -1483434957;
        nArray[232] = -1231316179;
        nArray[233] = 572399164;
        nArray[234] = -1836611819;
        nArray[235] = 552200649;
        nArray[236] = 1238290055;
        nArray[237] = -11184726;
        nArray[238] = 2015897680;
        nArray[239] = 2061492133;
        nArray[240] = -1886614525;
        nArray[241] = -123625127;
        nArray[242] = -2138470135;
        nArray[243] = 386731290;
        nArray[244] = -624967835;
        nArray[245] = 837215959;
        nArray[246] = -968736124;
        nArray[247] = -1201116976;
        nArray[248] = -1019133566;
        nArray[249] = -1332111063;
        nArray[250] = 1999449434;
        nArray[251] = 286199582;
        nArray[252] = -877612933;
        nArray[253] = -61582168;
        nArray[254] = -692339859;
        nArray[255] = 974525996;
        T0 = nArray;
        int[] nArray2 = new int[256];
        nArray2[0] = 1353184337;
        nArray2[1] = 1399144830;
        nArray2[2] = -1012656358;
        nArray2[3] = -1772214470;
        nArray2[4] = -882136261;
        nArray2[5] = -247096033;
        nArray2[6] = -1420232020;
        nArray2[7] = -1828461749;
        nArray2[8] = 1442459680;
        nArray2[9] = -160598355;
        nArray2[10] = -1854485368;
        nArray2[11] = 625738485;
        nArray2[12] = -52959921;
        nArray2[13] = -674551099;
        nArray2[14] = -2143013594;
        nArray2[15] = -1885117771;
        nArray2[16] = 1230680542;
        nArray2[17] = 1729870373;
        nArray2[18] = -1743852987;
        nArray2[19] = -507445667;
        nArray2[20] = 41234371;
        nArray2[21] = 317738113;
        nArray2[22] = -1550367091;
        nArray2[23] = -956705941;
        nArray2[24] = -413167869;
        nArray2[25] = -1784901099;
        nArray2[26] = -344298049;
        nArray2[27] = -631680363;
        nArray2[28] = 763608788;
        nArray2[29] = -752782248;
        nArray2[30] = 694804553;
        nArray2[31] = 1154009486;
        nArray2[32] = 1787413109;
        nArray2[33] = 2021232372;
        nArray2[34] = 1799248025;
        nArray2[35] = -579749593;
        nArray2[36] = -1236278850;
        nArray2[37] = 397248752;
        nArray2[38] = 1722556617;
        nArray2[39] = -1271214467;
        nArray2[40] = 407560035;
        nArray2[41] = -2110711067;
        nArray2[42] = 1613975959;
        nArray2[43] = 1165972322;
        nArray2[44] = -529046351;
        nArray2[45] = -2068943941;
        nArray2[46] = 480281086;
        nArray2[47] = -1809118983;
        nArray2[48] = 1483229296;
        nArray2[49] = 436028815;
        nArray2[50] = -2022908268;
        nArray2[51] = -1208452270;
        nArray2[52] = 601060267;
        nArray2[53] = -503166094;
        nArray2[54] = 1468997603;
        nArray2[55] = 715871590;
        nArray2[56] = 120122290;
        nArray2[57] = 63092015;
        nArray2[58] = -1703164538;
        nArray2[59] = -1526188077;
        nArray2[60] = -226023376;
        nArray2[61] = -1297760477;
        nArray2[62] = -1167457534;
        nArray2[63] = 1552029421;
        nArray2[64] = 723308426;
        nArray2[65] = -1833666137;
        nArray2[66] = -252573709;
        nArray2[67] = -1578997426;
        nArray2[68] = -839591323;
        nArray2[69] = -708967162;
        nArray2[70] = 526529745;
        nArray2[71] = -1963022652;
        nArray2[72] = -1655493068;
        nArray2[73] = -1604979806;
        nArray2[74] = 853641733;
        nArray2[75] = 1978398372;
        nArray2[76] = 971801355;
        nArray2[77] = -1427152832;
        nArray2[78] = 111112542;
        nArray2[79] = 1360031421;
        nArray2[80] = -108388034;
        nArray2[81] = 1023860118;
        nArray2[82] = -1375387939;
        nArray2[83] = 1186850381;
        nArray2[84] = -1249028975;
        nArray2[85] = 90031217;
        nArray2[86] = 1876166148;
        nArray2[87] = -15380384;
        nArray2[88] = 620468249;
        nArray2[89] = -1746289194;
        nArray2[90] = -868007799;
        nArray2[91] = 2006899047;
        nArray2[92] = -1119688528;
        nArray2[93] = -2004121337;
        nArray2[94] = 945494503;
        nArray2[95] = -605108103;
        nArray2[96] = 1191869601;
        nArray2[97] = -384875908;
        nArray2[98] = -920746760;
        nArray2[100] = -2088337399;
        nArray2[101] = 1223502642;
        nArray2[102] = -1401941730;
        nArray2[103] = 1316117100;
        nArray2[104] = -67170563;
        nArray2[105] = 1446544655;
        nArray2[106] = 517320253;
        nArray2[107] = 658058550;
        nArray2[108] = 1691946762;
        nArray2[109] = 564550760;
        nArray2[110] = -783000677;
        nArray2[111] = 976107044;
        nArray2[112] = -1318647284;
        nArray2[113] = 266819475;
        nArray2[114] = -761860428;
        nArray2[115] = -1634624741;
        nArray2[116] = 1338359936;
        nArray2[117] = -1574904735;
        nArray2[118] = 1766553434;
        nArray2[119] = 370807324;
        nArray2[120] = 179999714;
        nArray2[121] = -450191168;
        nArray2[122] = 1138762300;
        nArray2[123] = 488053522;
        nArray2[124] = 185403662;
        nArray2[125] = -1379431438;
        nArray2[126] = -1180125651;
        nArray2[127] = -928440812;
        nArray2[128] = -2061897385;
        nArray2[129] = 1275557295;
        nArray2[130] = -1143105042;
        nArray2[131] = -44007517;
        nArray2[132] = -1624899081;
        nArray2[133] = -1124765092;
        nArray2[134] = -985962940;
        nArray2[135] = 880737115;
        nArray2[136] = 1982415755;
        nArray2[137] = -590994485;
        nArray2[138] = 1761406390;
        nArray2[139] = 1676797112;
        nArray2[140] = -891538985;
        nArray2[141] = 277177154;
        nArray2[142] = 1076008723;
        nArray2[143] = 538035844;
        nArray2[144] = 2099530373;
        nArray2[145] = -130171950;
        nArray2[146] = 288553390;
        nArray2[147] = 1839278535;
        nArray2[148] = 1261411869;
        nArray2[149] = -214912292;
        nArray2[150] = -330136051;
        nArray2[151] = -790380169;
        nArray2[152] = 1813426987;
        nArray2[153] = -1715900247;
        nArray2[154] = -95906799;
        nArray2[155] = 577038663;
        nArray2[156] = -997393240;
        nArray2[157] = 440397984;
        nArray2[158] = -668172970;
        nArray2[159] = -275762398;
        nArray2[160] = -951170681;
        nArray2[161] = -1043253031;
        nArray2[162] = -22885748;
        nArray2[163] = 906744984;
        nArray2[164] = -813566554;
        nArray2[165] = 685669029;
        nArray2[166] = 646887386;
        nArray2[167] = -1530942145;
        nArray2[168] = -459458004;
        nArray2[169] = 227702864;
        nArray2[170] = -1681105046;
        nArray2[171] = 1648787028;
        nArray2[172] = -1038905866;
        nArray2[173] = -390539120;
        nArray2[174] = 1593260334;
        nArray2[175] = -173030526;
        nArray2[176] = -1098883681;
        nArray2[177] = 2090061929;
        nArray2[178] = -1456614033;
        nArray2[179] = -1290656305;
        nArray2[180] = 999926984;
        nArray2[181] = -1484974064;
        nArray2[182] = 1852021992;
        nArray2[183] = 2075868123;
        nArray2[184] = 158869197;
        nArray2[185] = -199730834;
        nArray2[186] = 28809964;
        nArray2[187] = -1466282109;
        nArray2[188] = 1701746150;
        nArray2[189] = 2129067946;
        nArray2[190] = 147831841;
        nArray2[191] = -420997649;
        nArray2[192] = -644094022;
        nArray2[193] = -835293366;
        nArray2[194] = -737566742;
        nArray2[195] = -696471511;
        nArray2[196] = -1347247055;
        nArray2[197] = 824393514;
        nArray2[198] = 815048134;
        nArray2[199] = -1067015627;
        nArray2[200] = 935087732;
        nArray2[201] = -1496677636;
        nArray2[202] = -1328508704;
        nArray2[203] = 366520115;
        nArray2[204] = 1251476721;
        nArray2[205] = -136647615;
        nArray2[206] = 240176511;
        nArray2[207] = 804688151;
        nArray2[208] = -1915335306;
        nArray2[209] = 1303441219;
        nArray2[210] = 1414376140;
        nArray2[211] = -553347356;
        nArray2[212] = -474623586;
        nArray2[213] = 461924940;
        nArray2[214] = -1205916479;
        nArray2[215] = 2136040774;
        nArray2[216] = 82468509;
        nArray2[217] = 1563790337;
        nArray2[218] = 1937016826;
        nArray2[219] = 776014843;
        nArray2[220] = 1511876531;
        nArray2[221] = 1389550482;
        nArray2[222] = 861278441;
        nArray2[223] = 323475053;
        nArray2[224] = -1939744870;
        nArray2[225] = 2047648055;
        nArray2[226] = -1911228327;
        nArray2[227] = -1992551445;
        nArray2[228] = -299390514;
        nArray2[229] = 902390199;
        nArray2[230] = -303751967;
        nArray2[231] = 1018251130;
        nArray2[232] = 1507840668;
        nArray2[233] = 1064563285;
        nArray2[234] = 2043548696;
        nArray2[235] = -1086863501;
        nArray2[236] = -355600557;
        nArray2[237] = 1537932639;
        nArray2[238] = 342834655;
        nArray2[239] = -2032450440;
        nArray2[240] = -2114736182;
        nArray2[241] = 1053059257;
        nArray2[242] = 741614648;
        nArray2[243] = 1598071746;
        nArray2[244] = 1925389590;
        nArray2[245] = 203809468;
        nArray2[246] = -1958134744;
        nArray2[247] = 1100287487;
        nArray2[248] = 1895934009;
        nArray2[249] = -558691320;
        nArray2[250] = -1662733096;
        nArray2[251] = -1866377628;
        nArray2[252] = 1636092795;
        nArray2[253] = 1890988757;
        nArray2[254] = 1952214088;
        nArray2[255] = 1113045200;
        Tinv0 = nArray2;
    }

    private static int FFmulX(int n) {
        return (n & 0x7F7F7F7F) << 1 ^ ((n & 0x80808080) >>> 7) * 27;
    }

    private static int FFmulX2(int n) {
        int n2 = (n & 0x3F3F3F3F) << 2;
        int n3 = n & 0xC0C0C0C0;
        n3 ^= n3 >>> 1;
        return n2 ^ n3 >>> 2 ^ n3 >>> 5;
    }

    private void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2, int[][] nArray) {
        int n3;
        int n4;
        int n5;
        int n6 = Pack.littleEndianToInt(byArray, n);
        int n7 = Pack.littleEndianToInt(byArray, n + 4);
        int n8 = Pack.littleEndianToInt(byArray, n + 8);
        int n9 = Pack.littleEndianToInt(byArray, n + 12);
        int n10 = n6 ^ nArray[this.ROUNDS][0];
        int n11 = n7 ^ nArray[this.ROUNDS][1];
        int n12 = n8 ^ nArray[this.ROUNDS][2];
        int n13 = this.ROUNDS - 1;
        int n14 = n9 ^ nArray[this.ROUNDS][3];
        while (n13 > 1) {
            n5 = Tinv0[n10 & 0xFF] ^ AESEngine.shift(Tinv0[n14 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n12 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n11 >> 24 & 0xFF], 8) ^ nArray[n13][0];
            n4 = Tinv0[n11 & 0xFF] ^ AESEngine.shift(Tinv0[n10 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n14 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n12 >> 24 & 0xFF], 8) ^ nArray[n13][1];
            n3 = Tinv0[n12 & 0xFF] ^ AESEngine.shift(Tinv0[n11 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n10 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n14 >> 24 & 0xFF], 8) ^ nArray[n13][2];
            n14 = Tinv0[n14 & 0xFF] ^ AESEngine.shift(Tinv0[n12 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n11 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n10 >> 24 & 0xFF], 8) ^ nArray[n13--][3];
            n10 = Tinv0[n5 & 0xFF] ^ AESEngine.shift(Tinv0[n14 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n3 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n4 >> 24 & 0xFF], 8) ^ nArray[n13][0];
            n11 = Tinv0[n4 & 0xFF] ^ AESEngine.shift(Tinv0[n5 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n14 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n3 >> 24 & 0xFF], 8) ^ nArray[n13][1];
            n12 = Tinv0[n3 & 0xFF] ^ AESEngine.shift(Tinv0[n4 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n5 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n14 >> 24 & 0xFF], 8) ^ nArray[n13][2];
            n14 = Tinv0[n14 & 0xFF] ^ AESEngine.shift(Tinv0[n3 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n4 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n5 >> 24 & 0xFF], 8) ^ nArray[n13--][3];
        }
        n5 = Tinv0[n10 & 0xFF] ^ AESEngine.shift(Tinv0[n14 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n12 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n11 >> 24 & 0xFF], 8) ^ nArray[n13][0];
        n4 = Tinv0[n11 & 0xFF] ^ AESEngine.shift(Tinv0[n10 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n14 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n12 >> 24 & 0xFF], 8) ^ nArray[n13][1];
        n3 = Tinv0[n12 & 0xFF] ^ AESEngine.shift(Tinv0[n11 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n10 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n14 >> 24 & 0xFF], 8) ^ nArray[n13][2];
        n14 = Tinv0[n14 & 0xFF] ^ AESEngine.shift(Tinv0[n12 >> 8 & 0xFF], 24) ^ AESEngine.shift(Tinv0[n11 >> 16 & 0xFF], 16) ^ AESEngine.shift(Tinv0[n10 >> 24 & 0xFF], 8) ^ nArray[n13][3];
        n6 = Si[n5 & 0xFF] & 0xFF ^ (this.s[n14 >> 8 & 0xFF] & 0xFF) << 8 ^ (this.s[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ Si[n4 >> 24 & 0xFF] << 24 ^ nArray[0][0];
        n7 = this.s[n4 & 0xFF] & 0xFF ^ (this.s[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n14 >> 16 & 0xFF] & 0xFF) << 16 ^ this.s[n3 >> 24 & 0xFF] << 24 ^ nArray[0][1];
        n8 = this.s[n3 & 0xFF] & 0xFF ^ (Si[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (Si[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ this.s[n14 >> 24 & 0xFF] << 24 ^ nArray[0][2];
        n9 = Si[n14 & 0xFF] & 0xFF ^ (this.s[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (this.s[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ this.s[n5 >> 24 & 0xFF] << 24 ^ nArray[0][3];
        Pack.intToLittleEndian(n6, byArray2, n2);
        Pack.intToLittleEndian(n7, byArray2, n2 + 4);
        Pack.intToLittleEndian(n8, byArray2, n2 + 8);
        Pack.intToLittleEndian(n9, byArray2, n2 + 12);
    }

    private void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2, int[][] nArray) {
        int n3;
        int n4;
        int n5;
        int n6 = Pack.littleEndianToInt(byArray, n);
        int n7 = Pack.littleEndianToInt(byArray, n + 4);
        int n8 = Pack.littleEndianToInt(byArray, n + 8);
        int n9 = Pack.littleEndianToInt(byArray, n + 12);
        int n10 = n6 ^ nArray[0][0];
        int n11 = n7 ^ nArray[0][1];
        int n12 = n8 ^ nArray[0][2];
        int n13 = 1;
        int n14 = n9 ^ nArray[0][3];
        while (n13 < this.ROUNDS - 1) {
            n5 = T0[n10 & 0xFF] ^ AESEngine.shift(T0[n11 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n12 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n14 >> 24 & 0xFF], 8) ^ nArray[n13][0];
            n4 = T0[n11 & 0xFF] ^ AESEngine.shift(T0[n12 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n14 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n10 >> 24 & 0xFF], 8) ^ nArray[n13][1];
            n3 = T0[n12 & 0xFF] ^ AESEngine.shift(T0[n14 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n10 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n11 >> 24 & 0xFF], 8) ^ nArray[n13][2];
            n14 = T0[n14 & 0xFF] ^ AESEngine.shift(T0[n10 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n11 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n12 >> 24 & 0xFF], 8) ^ nArray[n13++][3];
            n10 = T0[n5 & 0xFF] ^ AESEngine.shift(T0[n4 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n3 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n14 >> 24 & 0xFF], 8) ^ nArray[n13][0];
            n11 = T0[n4 & 0xFF] ^ AESEngine.shift(T0[n3 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n14 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n5 >> 24 & 0xFF], 8) ^ nArray[n13][1];
            n12 = T0[n3 & 0xFF] ^ AESEngine.shift(T0[n14 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n5 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n4 >> 24 & 0xFF], 8) ^ nArray[n13][2];
            n14 = T0[n14 & 0xFF] ^ AESEngine.shift(T0[n5 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n4 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n3 >> 24 & 0xFF], 8) ^ nArray[n13++][3];
        }
        n5 = T0[n10 & 0xFF] ^ AESEngine.shift(T0[n11 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n12 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n14 >> 24 & 0xFF], 8) ^ nArray[n13][0];
        n4 = T0[n11 & 0xFF] ^ AESEngine.shift(T0[n12 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n14 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n10 >> 24 & 0xFF], 8) ^ nArray[n13][1];
        n3 = T0[n12 & 0xFF] ^ AESEngine.shift(T0[n14 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n10 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n11 >> 24 & 0xFF], 8) ^ nArray[n13][2];
        n14 = T0[n14 & 0xFF] ^ AESEngine.shift(T0[n10 >> 8 & 0xFF], 24) ^ AESEngine.shift(T0[n11 >> 16 & 0xFF], 16) ^ AESEngine.shift(T0[n12 >> 24 & 0xFF], 8) ^ nArray[n13++][3];
        n6 = S[n5 & 0xFF] & 0xFF ^ (S[n4 >> 8 & 0xFF] & 0xFF) << 8 ^ (this.s[n3 >> 16 & 0xFF] & 0xFF) << 16 ^ this.s[n14 >> 24 & 0xFF] << 24 ^ nArray[n13][0];
        n7 = this.s[n4 & 0xFF] & 0xFF ^ (S[n3 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n14 >> 16 & 0xFF] & 0xFF) << 16 ^ this.s[n5 >> 24 & 0xFF] << 24 ^ nArray[n13][1];
        n8 = this.s[n3 & 0xFF] & 0xFF ^ (S[n14 >> 8 & 0xFF] & 0xFF) << 8 ^ (S[n5 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n4 >> 24 & 0xFF] << 24 ^ nArray[n13][2];
        n9 = this.s[n14 & 0xFF] & 0xFF ^ (this.s[n5 >> 8 & 0xFF] & 0xFF) << 8 ^ (this.s[n4 >> 16 & 0xFF] & 0xFF) << 16 ^ S[n3 >> 24 & 0xFF] << 24 ^ nArray[n13][3];
        Pack.intToLittleEndian(n6, byArray2, n2);
        Pack.intToLittleEndian(n7, byArray2, n2 + 4);
        Pack.intToLittleEndian(n8, byArray2, n2 + 8);
        Pack.intToLittleEndian(n9, byArray2, n2 + 12);
    }

    private int[][] generateWorkingKey(byte[] byArray, boolean bl) {
        int n;
        int n2;
        int n3 = byArray.length;
        if (n3 < 16 || n3 > 32 || (n3 & 7) != 0) {
            throw new IllegalArgumentException("Key length not 128/192/256 bits.");
        }
        int n4 = n3 >>> 2;
        this.ROUNDS = n4 + 6;
        int[][] nArray = new int[this.ROUNDS + 1][4];
        block0 : switch (n4) {
            case 4: {
                int n5;
                int n6;
                int n7;
                nArray[0][0] = n2 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n7 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n6 = Pack.littleEndianToInt(byArray, 12);
                int n8 = 1;
                while (n8 <= 10) {
                    n5 = AESEngine.subWord(AESEngine.shift(n6, 8)) ^ rcon[n8 - 1];
                    nArray[n8][0] = n2 ^= n5;
                    nArray[n8][1] = n ^= n2;
                    nArray[n8][2] = n7 ^= n;
                    nArray[n8][3] = n6 ^= n7;
                    ++n8;
                }
                break;
            }
            case 6: {
                int n9;
                int n6;
                int n7;
                nArray[0][0] = n2 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n7 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n6 = Pack.littleEndianToInt(byArray, 12);
                int n8 = Pack.littleEndianToInt(byArray, 16);
                int n5 = Pack.littleEndianToInt(byArray, 20);
                int n10 = 1;
                int n11 = 1;
                while (true) {
                    nArray[n10][0] = n8;
                    nArray[n10][1] = n5;
                    n9 = AESEngine.subWord(AESEngine.shift(n5, 8)) ^ n11;
                    n11 <<= 1;
                    nArray[n10][2] = n2 ^= n9;
                    nArray[n10][3] = n ^= n2;
                    nArray[n10 + 1][0] = n7 ^= n;
                    nArray[n10 + 1][1] = n6 ^= n7;
                    nArray[n10 + 1][2] = n8 ^= n6;
                    nArray[n10 + 1][3] = n5 ^= n8;
                    n9 = AESEngine.subWord(AESEngine.shift(n5, 8)) ^ n11;
                    n11 <<= 1;
                    nArray[n10 + 2][0] = n2 ^= n9;
                    nArray[n10 + 2][1] = n ^= n2;
                    nArray[n10 + 2][2] = n7 ^= n;
                    nArray[n10 + 2][3] = n6 ^= n7;
                    if ((n10 += 3) >= 13) break block0;
                    n5 ^= (n8 ^= n6);
                }
            }
            case 8: {
                int n11;
                int n10;
                int n5;
                int n8;
                int n6;
                int n7;
                nArray[0][0] = n2 = Pack.littleEndianToInt(byArray, 0);
                nArray[0][1] = n = Pack.littleEndianToInt(byArray, 4);
                nArray[0][2] = n7 = Pack.littleEndianToInt(byArray, 8);
                nArray[0][3] = n6 = Pack.littleEndianToInt(byArray, 12);
                nArray[1][0] = n8 = Pack.littleEndianToInt(byArray, 16);
                nArray[1][1] = n5 = Pack.littleEndianToInt(byArray, 20);
                nArray[1][2] = n10 = Pack.littleEndianToInt(byArray, 24);
                nArray[1][3] = n11 = Pack.littleEndianToInt(byArray, 28);
                int n9 = 2;
                int n12 = 1;
                while (true) {
                    int n13 = AESEngine.subWord(AESEngine.shift(n11, 8)) ^ n12;
                    n12 <<= 1;
                    nArray[n9][0] = n2 ^= n13;
                    nArray[n9][1] = n ^= n2;
                    nArray[n9][2] = n7 ^= n;
                    nArray[n9][3] = n6 ^= n7;
                    if (++n9 >= 15) break block0;
                    n13 = AESEngine.subWord(n6);
                    nArray[n9][0] = n8 ^= n13;
                    nArray[n9][1] = n5 ^= n8;
                    nArray[n9][2] = n10 ^= n5;
                    nArray[n9][3] = n11 ^= n10;
                    ++n9;
                }
            }
            default: {
                throw new IllegalStateException("Should never get here");
            }
        }
        if (!bl) {
            n2 = 1;
            while (n2 < this.ROUNDS) {
                n = 0;
                while (n < 4) {
                    nArray[n2][n] = AESEngine.inv_mcol(nArray[n2][n]);
                    ++n;
                }
                ++n2;
            }
        }
        return nArray;
    }

    public String getAlgorithmName() {
        return "AES";
    }

    public int getBlockSize() {
        return 16;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof KeyParameter) {
            this.WorkingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey(), bl);
            this.forEncryption = bl;
            this.s = bl ? Arrays.clone(S) : Arrays.clone(Si);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to AES init - " + cipherParameters.getClass().getName());
    }

    private static int inv_mcol(int n) {
        int n2 = n;
        int n3 = n2 ^ AESEngine.shift(n2, 8);
        n2 ^= AESEngine.FFmulX(n3);
        n3 ^= AESEngine.FFmulX2(n2);
        return n2 ^= n3 ^ AESEngine.shift(n3, 16);
    }

    public BlockCipher newInstance() {
        return new AESEngine();
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.WorkingKey == null) {
            throw new IllegalStateException("AES engine not initialised");
        }
        if (n > byArray.length - 16) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 > byArray2.length - 16) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.forEncryption) {
            this.encryptBlock(byArray, n, byArray2, n2, this.WorkingKey);
        } else {
            this.decryptBlock(byArray, n, byArray2, n2, this.WorkingKey);
        }
        return 16;
    }

    public void reset() {
    }

    private static int shift(int n, int n2) {
        return n >>> n2 | n << -n2;
    }

    private static int subWord(int n) {
        return S[n & 0xFF] & 0xFF | (S[n >> 8 & 0xFF] & 0xFF) << 8 | (S[n >> 16 & 0xFF] & 0xFF) << 16 | S[n >> 24 & 0xFF] << 24;
    }
}

