/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.engines.AESWrapPadEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.util.test.TestFailedException;
import org.bouncycastle.util.test.TestResult;

public class AESWrapTest
extends SimpleTest {
    public String getName() {
        return "AESWrap";
    }

    private void heapIssueTest() {
        byte[] byArray = Hex.decode("d305ef52a6b9e72c810b821261d2d678");
        byte[] byArray2 = Hex.decode("d2b2906d209a46261d8f6794eca3179d");
        AESWrapPadEngine aESWrapPadEngine = new AESWrapPadEngine();
        aESWrapPadEngine.init(false, new KeyParameter(byArray));
        try {
            byte[] byArray3 = aESWrapPadEngine.unwrap(byArray2, 0, byArray2.length);
            this.fail("incorrect pad not detected");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
    }

    public static void main(String[] stringArray) {
        AESWrapTest aESWrapTest = new AESWrapTest();
        TestResult testResult = aESWrapTest.perform();
        System.out.println(testResult);
    }

    public void performTest() throws Exception {
        byte[] byArray = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] byArray2 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] byArray3 = Hex.decode("1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5");
        this.wrapTest(1, byArray, byArray2, byArray3);
        byte[] byArray4 = Hex.decode("000102030405060708090a0b0c0d0e0f1011121314151617");
        byte[] byArray5 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] byArray6 = Hex.decode("96778b25ae6ca435f92b5b97c050aed2468ab8a17ad84e5d");
        this.wrapTest(2, byArray4, byArray5, byArray6);
        byte[] byArray7 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        byte[] byArray8 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] byArray9 = Hex.decode("64e8c3f9ce0f5ba263e9777905818a2a93c8191e7d6e8ae7");
        this.wrapTest(3, byArray7, byArray8, byArray9);
        byte[] byArray10 = Hex.decode("000102030405060708090a0b0c0d0e0f1011121314151617");
        byte[] byArray11 = Hex.decode("00112233445566778899aabbccddeeff0001020304050607");
        byte[] byArray12 = Hex.decode("031d33264e15d33268f24ec260743edce1c6c7ddee725a936ba814915c6762d2");
        this.wrapTest(4, byArray10, byArray11, byArray12);
        byte[] byArray13 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        byte[] byArray14 = Hex.decode("00112233445566778899aabbccddeeff0001020304050607");
        byte[] byArray15 = Hex.decode("a8f9bc1612c68b3ff6e6f4fbe30e71e4769c8b80a32cb8958cd5d17d6b254da1");
        this.wrapTest(5, byArray13, byArray14, byArray15);
        byte[] byArray16 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        byte[] byArray17 = Hex.decode("00112233445566778899aabbccddeeff000102030405060708090a0b0c0d0e0f");
        byte[] byArray18 = Hex.decode("28c9f404c4b810f4cbccb35cfb87f8263f5786e2d80ed326cbc7f0e71a99f43bfb988b9b7a02dd21");
        this.wrapTest(6, byArray16, byArray17, byArray18);
        byte[] byArray19 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f");
        byte[] byArray20 = Hex.decode("00112233445566778899aabbccddeeff000102030405060708090a0b0c0d0e0f");
        byte[] byArray21 = Hex.decode("cba01acbdb4c7c39fa59babb383c485f318837208731a81c735b5be6ba710375a1159e26a9b57228");
        this.wrapTest(7, byArray19, byArray20, byArray21, true);
        AESWrapEngine aESWrapEngine = new AESWrapEngine();
        KeyParameter keyParameter = new KeyParameter(new byte[16]);
        byte[] byArray22 = new byte[16];
        try {
            aESWrapEngine.init(true, keyParameter);
            aESWrapEngine.unwrap(byArray22, 0, byArray22.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            this.fail("unexpected exception: " + invalidCipherTextException, invalidCipherTextException);
        }
        try {
            aESWrapEngine.init(false, keyParameter);
            aESWrapEngine.wrap(byArray22, 0, byArray22.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            aESWrapEngine.init(false, keyParameter);
            aESWrapEngine.unwrap(byArray22, 0, byArray22.length / 2);
            this.fail("failed unwrap short test.");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {}
        try {
            aESWrapEngine.init(true, keyParameter);
            aESWrapEngine.wrap(byArray22, 0, 15);
            this.fail("ailed wrap length test.");
        }
        catch (DataLengthException dataLengthException) {}
        this.heapIssueTest();
    }

    private void wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.wrapTest(n, byArray, byArray2, byArray3, false);
    }

    private void wrapTest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        byte[] byArray4;
        byte[] byArray5;
        AESWrapEngine aESWrapEngine = new AESWrapEngine(bl);
        aESWrapEngine.init(true, new KeyParameter(byArray));
        try {
            byArray5 = aESWrapEngine.wrap(byArray2, 0, byArray2.length);
            if (!Arrays.areEqual(byArray5, byArray3)) {
                this.fail("failed wrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray5)));
            }
        }
        catch (TestFailedException testFailedException) {
            throw testFailedException;
        }
        catch (Exception exception) {
            this.fail("failed wrap test exception " + exception.toString());
        }
        aESWrapEngine.init(false, new KeyParameter(byArray));
        try {
            byArray5 = aESWrapEngine.unwrap(byArray3, 0, byArray3.length);
            if (!Arrays.areEqual(byArray5, byArray2)) {
                this.fail("failed unwrap test " + n + " expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray5)));
            }
        }
        catch (TestFailedException testFailedException) {
            throw testFailedException;
        }
        catch (Exception exception) {
            this.fail("failed unwrap test exception.", exception);
        }
        byArray5 = new byte[5 + byArray2.length];
        System.arraycopy(byArray2, 0, byArray5, 5, byArray2.length);
        aESWrapEngine.init(true, new KeyParameter(byArray));
        try {
            byArray4 = aESWrapEngine.wrap(byArray5, 5, byArray2.length);
            if (!Arrays.areEqual(byArray4, byArray3)) {
                this.fail("failed wrap test " + n + " expected " + new String(Hex.encode(byArray3)) + " got " + new String(Hex.encode(byArray4)));
            }
        }
        catch (Exception exception) {
            this.fail("failed wrap test exception " + exception.toString());
        }
        aESWrapEngine.init(false, new KeyParameter(byArray));
        byArray4 = new byte[6 + byArray3.length];
        System.arraycopy(byArray3, 0, byArray4, 6, byArray3.length);
        try {
            byArray5 = aESWrapEngine.unwrap(byArray4, 6, byArray3.length);
            if (!Arrays.areEqual(byArray5, byArray2)) {
                this.fail("failed unwrap test " + n + " expected " + new String(Hex.encode(byArray2)) + " got " + new String(Hex.encode(byArray5)));
            }
        }
        catch (Exception exception) {
            this.fail("failed unwrap test exception.", exception);
        }
    }
}

