/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.engines.ARIAEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ARIATest
extends SimpleTest {
    private static SecureRandom R = new SecureRandom();
    private static final String[][] TEST_VECTORS_RFC5794 = new String[][]{{"128-Bit Key", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "d718fbd6ab644c739da95f3be6451778"}, {"192-Bit Key", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "26449c1805dbe7aa25a468ce263a9e79"}, {"256-Bit Key", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "f92bd7c79fb72e2f2b8f80c1972d24fc"}};

    private void checkRandomRoundtrips() {
        ARIAEngine aRIAEngine = new ARIAEngine();
        ARIAEngine aRIAEngine2 = new ARIAEngine();
        byte[] byArray = new byte[aRIAEngine.getBlockSize()];
        byte[] byArray2 = new byte[aRIAEngine.getBlockSize()];
        byte[] byArray3 = new byte[aRIAEngine.getBlockSize()];
        int n = 16;
        while (n <= 32) {
            byte[] byArray4 = new byte[n];
            R.nextBytes(byArray4);
            KeyParameter keyParameter = new KeyParameter(byArray4);
            aRIAEngine.init(true, keyParameter);
            aRIAEngine2.init(false, keyParameter);
            R.nextBytes(byArray);
            int n2 = 0;
            while (n2 < 100) {
                aRIAEngine.processBlock(byArray, 0, byArray2, 0);
                aRIAEngine2.processBlock(byArray2, 0, byArray3, 0);
                this.isTrue(Arrays.areEqual(byArray, byArray3));
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                ++n2;
            }
            n += 8;
        }
    }

    private void checkTestVector_RFC5794(String[] stringArray) {
        String string = "'" + stringArray[0] + "'";
        ARIAEngine aRIAEngine = new ARIAEngine();
        int n = aRIAEngine.getBlockSize();
        this.isTrue("Wrong block size returned from getBlockSize() for " + string, n == 16);
        KeyParameter keyParameter = new KeyParameter(Hex.decode(stringArray[1]));
        byte[] byArray = Hex.decode(stringArray[2]);
        byte[] byArray2 = Hex.decode(stringArray[3]);
        this.isTrue("Unexpected plaintext length for " + string, n == byArray.length);
        this.isTrue("Unexpected ciphertext length for " + string, n == byArray2.length);
        aRIAEngine.init(true, keyParameter);
        byte[] byArray3 = new byte[n];
        int n2 = aRIAEngine.processBlock(byArray, 0, byArray3, 0);
        this.isTrue("Wrong length returned from processBlock() (encryption) for " + string, n == n2);
        this.isTrue("Incorrect ciphertext computed for " + string, Arrays.areEqual(byArray2, byArray3));
        aRIAEngine.init(false, keyParameter);
        n2 = aRIAEngine.processBlock(byArray2, 0, byArray3, 0);
        this.isTrue("Wrong length returned from processBlock() (decryption) for " + string, n == n2);
        this.isTrue("Incorrect plaintext computed for " + string, Arrays.areEqual(byArray, byArray3));
    }

    private void checkTestVectors_RFC5794() {
        int n = 0;
        while (n < TEST_VECTORS_RFC5794.length) {
            this.checkTestVector_RFC5794(TEST_VECTORS_RFC5794[n]);
            ++n;
        }
    }

    public String getName() {
        return "ARIA";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ARIATest());
    }

    public void performTest() throws Exception {
        this.checkTestVectors_RFC5794();
        int n = 0;
        while (n < 100) {
            this.checkRandomRoundtrips();
            ++n;
        }
        new MyARIAEngine().checkImplementation();
    }

    private class MyARIAEngine
    extends ARIAEngine {
        MyARIAEngine() {
        }

        public void checkImplementation() {
            this.checkInvolution();
            this.checkSBoxes();
        }

        private void checkInvolution() {
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[16];
            int n = 0;
            while (n < 100) {
                R.nextBytes(byArray);
                System.arraycopy(byArray, 0, byArray2, 0, 16);
                ARIAEngine.A(byArray2);
                ARIAEngine.A(byArray2);
                ARIATest.this.isTrue(Arrays.areEqual(byArray, byArray2));
                ++n;
            }
        }

        private void checkSBoxes() {
            int n = 0;
            while (n < 256) {
                byte by = (byte)n;
                ARIATest.this.isTrue(by == ARIAEngine.SB1(ARIAEngine.SB3(by)));
                ARIATest.this.isTrue(by == ARIAEngine.SB3(ARIAEngine.SB1(by)));
                ARIATest.this.isTrue(by == ARIAEngine.SB2(ARIAEngine.SB4(by)));
                ARIATest.this.isTrue(by == ARIAEngine.SB4(ARIAEngine.SB2(by)));
                ++n;
            }
        }
    }
}

