/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.OCBBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.AEADTestUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Times;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class OCBTest
extends SimpleTest {
    private static final String KEY_128 = "000102030405060708090A0B0C0D0E0F";
    private static final String KEY_96 = "0F0E0D0C0B0A09080706050403020100";
    private static final String[][] TEST_VECTORS_128 = new String[][]{{"BBAA99887766554433221100", "", "", "785407BFFFC8AD9EDCC5520AC9111EE6"}, {"BBAA99887766554433221101", "0001020304050607", "0001020304050607", "6820B3657B6F615A5725BDA0D3B4EB3A257C9AF1F8F03009"}, {"BBAA99887766554433221102", "0001020304050607", "", "81017F8203F081277152FADE694A0A00"}, {"BBAA99887766554433221103", "", "0001020304050607", "45DD69F8F5AAE72414054CD1F35D82760B2CD00D2F99BFA9"}, {"BBAA99887766554433221104", "000102030405060708090A0B0C0D0E0F", "000102030405060708090A0B0C0D0E0F", "571D535B60B277188BE5147170A9A22C3AD7A4FF3835B8C5701C1CCEC8FC3358"}, {"BBAA99887766554433221105", "000102030405060708090A0B0C0D0E0F", "", "8CF761B6902EF764462AD86498CA6B97"}, {"BBAA99887766554433221106", "", "000102030405060708090A0B0C0D0E0F", "5CE88EC2E0692706A915C00AEB8B2396F40E1C743F52436BDF06D8FA1ECA343D"}, {"BBAA99887766554433221107", "000102030405060708090A0B0C0D0E0F1011121314151617", "000102030405060708090A0B0C0D0E0F1011121314151617", "1CA2207308C87C010756104D8840CE1952F09673A448A122C92C62241051F57356D7F3C90BB0E07F"}, {"BBAA99887766554433221108", "000102030405060708090A0B0C0D0E0F1011121314151617", "", "6DC225A071FC1B9F7C69F93B0F1E10DE"}, {"BBAA99887766554433221109", "", "000102030405060708090A0B0C0D0E0F1011121314151617", "221BD0DE7FA6FE993ECCD769460A0AF2D6CDED0C395B1C3CE725F32494B9F914D85C0B1EB38357FF"}, {"BBAA9988776655443322110A", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "BD6F6C496201C69296C11EFD138A467ABD3C707924B964DEAFFC40319AF5A48540FBBA186C5553C68AD9F592A79A4240"}, {"BBAA9988776655443322110B", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "", "FE80690BEE8A485D11F32965BC9D2A32"}, {"BBAA9988776655443322110C", "", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "2942BFC773BDA23CABC6ACFD9BFD5835BD300F0973792EF46040C53F1432BCDFB5E1DDE3BC18A5F840B52E653444D5DF"}, {"BBAA9988776655443322110D", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F2021222324252627", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F2021222324252627", "D5CA91748410C1751FF8A2F618255B68A0A12E093FF454606E59F9C1D0DDC54B65E8628E568BAD7AED07BA06A4A69483A7035490C5769E60"}, {"BBAA9988776655443322110E", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F2021222324252627", "", "C5CD9D1850C141E358649994EE701B68"}, {"BBAA9988776655443322110F", "", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F2021222324252627", "4412923493C57D5DE0D700F753CCE0D1D2D95060122E9F15A5DDBFC5787E50B5CC55EE507BCB084E479AD363AC366B95A98CA5F3000B1479"}};
    private static final String[][] TEST_VECTORS_96 = new String[][]{{"BBAA9988776655443322110D", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F2021222324252627", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F2021222324252627", "1792A4E31E0755FB03E31B22116E6C2DDF9EFD6E33D536F1A0124B0A55BAE884ED93481529C76B6AD0C515F4D1CDD4FDAC4F02AA"}};

    private void checkTestCase(AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, String string, int n, byte[] byArray, byte[] byArray2) throws InvalidCipherTextException {
        byte[] byArray3 = Arrays.copyOfRange(byArray2, byArray2.length - n, byArray2.length);
        byte[] byArray4 = new byte[aEADBlockCipher.getOutputSize(byArray.length)];
        int n2 = aEADBlockCipher.processBytes(byArray, 0, byArray.length, byArray4, 0);
        if (byArray4.length != (n2 += aEADBlockCipher.doFinal(byArray4, n2))) {
            this.fail("encryption reported incorrect length: " + string);
        }
        if (!this.areEqual(byArray2, byArray4)) {
            this.fail("incorrect encrypt in: " + string);
        }
        if (!this.areEqual(byArray3, aEADBlockCipher.getMac())) {
            this.fail("getMac() not the same as the appended tag: " + string);
        }
        byte[] byArray5 = new byte[aEADBlockCipher2.getOutputSize(byArray2.length)];
        int n3 = aEADBlockCipher2.processBytes(byArray2, 0, byArray2.length, byArray5, 0);
        if (byArray5.length != (n3 += aEADBlockCipher2.doFinal(byArray5, n3))) {
            this.fail("decryption reported incorrect length: " + string);
        }
        if (!this.areEqual(byArray, byArray5)) {
            this.fail("incorrect decrypt in: " + string);
        }
        if (!this.areEqual(byArray3, aEADBlockCipher2.getMac())) {
            this.fail("getMac() not the same as the appended tag: " + string);
        }
    }

    private byte[] createNonce(int n) {
        byte[] byArray = new byte[12];
        byArray[10] = (byte)(n >>> 8);
        byArray[11] = (byte)n;
        return byArray;
    }

    private AEADBlockCipher createOCBCipher() {
        return new OCBBlockCipher(this.createUnderlyingCipher(), this.createUnderlyingCipher());
    }

    private BlockCipher createUnderlyingCipher() {
        return new AESEngine();
    }

    public String getName() {
        return "OCB";
    }

    private AEADBlockCipher initOCBCipher(boolean bl, AEADParameters aEADParameters) {
        AEADBlockCipher aEADBlockCipher = this.createOCBCipher();
        aEADBlockCipher.init(bl, aEADParameters);
        return aEADBlockCipher;
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new OCBTest());
    }

    private static int nextInt(SecureRandom secureRandom, int n) {
        int n2;
        int n3;
        if ((n & -n) == n) {
            return (int)((long)n * (long)(secureRandom.nextInt() >>> 1) >> 31);
        }
        while ((n3 = secureRandom.nextInt() >>> 1) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    private void outputSizeTests() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[15];
        byte[] byArray3 = null;
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray), 128, byArray2, byArray3);
        AEADBlockCipher aEADBlockCipher = this.initOCBCipher(true, aEADParameters);
        if (aEADBlockCipher.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes encryption");
        }
        if (aEADBlockCipher.getOutputSize(0) != 16) {
            this.fail("incorrect getOutputSize for initial 0 bytes encryption");
        }
        aEADBlockCipher.init(false, aEADParameters);
        if (aEADBlockCipher.getUpdateOutputSize(0) != 0) {
            this.fail("incorrect getUpdateOutputSize for initial 0 bytes decryption");
        }
        if (aEADBlockCipher.getOutputSize(0) != 0) {
            this.fail("fragile getOutputSize for initial 0 bytes decryption");
        }
        if (aEADBlockCipher.getOutputSize(16) != 0) {
            this.fail("incorrect getOutputSize for initial MAC-size bytes decryption");
        }
    }

    public void performTest() throws Exception {
        byte[] byArray = Hex.decode(KEY_128);
        int n = 0;
        while (n < TEST_VECTORS_128.length) {
            this.runTestCase("Test Case " + n, TEST_VECTORS_128[n], 128, byArray);
            ++n;
        }
        byte[] byArray2 = Hex.decode(KEY_96);
        int n2 = 0;
        while (n2 < TEST_VECTORS_96.length) {
            this.runTestCase("Test Case " + n2, TEST_VECTORS_96[n2], 96, byArray2);
            ++n2;
        }
        this.runLongerTestCase(128, 128, "67E944D23256C5E0B6C61FA22FDF1EA2");
        this.runLongerTestCase(192, 128, "F673F2C3E7174AAE7BAE986CA9F29E17");
        this.runLongerTestCase(256, 128, "D90EB8E9C977C88B79DD793D7FFA161C");
        this.runLongerTestCase(128, 96, "77A3D8E73589158D25D01209");
        this.runLongerTestCase(192, 96, "05D56EAD2752C86BE6932C5E");
        this.runLongerTestCase(256, 96, "5458359AC23B0CBA9E6330DD");
        this.runLongerTestCase(128, 64, "192C9B7BD90BA06A");
        this.runLongerTestCase(192, 64, "0066BC6E0EF34E24");
        this.runLongerTestCase(256, 64, "7D4EA5D445501CBE");
        this.randomTests();
        this.outputSizeTests();
        this.testExceptions();
    }

    private void randomTest(SecureRandom secureRandom) throws InvalidCipherTextException {
        byte[] byArray;
        int n = 16 + 8 * (Math.abs(secureRandom.nextInt()) % 3);
        byte[] byArray2 = new byte[n];
        secureRandom.nextBytes(byArray2);
        int n2 = secureRandom.nextInt() >>> 16;
        byte[] byArray3 = new byte[n2];
        secureRandom.nextBytes(byArray3);
        int n3 = secureRandom.nextInt() >>> 24;
        byte[] byArray4 = new byte[n3];
        secureRandom.nextBytes(byArray4);
        int n4 = secureRandom.nextInt() >>> 24;
        byte[] byArray5 = new byte[n4];
        secureRandom.nextBytes(byArray5);
        int n5 = 1 + OCBTest.nextInt(secureRandom, 15);
        byte[] byArray6 = new byte[n5];
        secureRandom.nextBytes(byArray6);
        AEADParameters aEADParameters = new AEADParameters(new KeyParameter(byArray2), 128, byArray6, byArray4);
        AEADBlockCipher aEADBlockCipher = this.initOCBCipher(true, aEADParameters);
        byte[] byArray7 = new byte[aEADBlockCipher.getOutputSize(byArray3.length)];
        int n6 = aEADBlockCipher.getUpdateOutputSize(byArray3.length);
        int n7 = OCBTest.nextInt(secureRandom, byArray5.length + 1);
        aEADBlockCipher.processAADBytes(byArray5, 0, n7);
        int n8 = aEADBlockCipher.processBytes(byArray3, 0, byArray3.length, byArray7, 0);
        aEADBlockCipher.processAADBytes(byArray5, n7, byArray5.length - n7);
        if (n6 != n8) {
            this.fail("encryption reported incorrect update length in randomised test");
        }
        if (byArray7.length != (n8 += aEADBlockCipher.doFinal(byArray7, n8))) {
            this.fail("encryption reported incorrect length in randomised test");
        }
        byte[] byArray8 = aEADBlockCipher.getMac();
        byte[] byArray9 = new byte[byArray7.length - byArray3.length];
        System.arraycopy(byArray7, byArray3.length, byArray9, 0, byArray9.length);
        if (!this.areEqual(byArray8, byArray9)) {
            this.fail("stream contained wrong mac in randomised test");
        }
        aEADBlockCipher.init(false, aEADParameters);
        byte[] byArray10 = new byte[aEADBlockCipher.getOutputSize(byArray7.length)];
        n6 = aEADBlockCipher.getUpdateOutputSize(byArray7.length);
        n7 = OCBTest.nextInt(secureRandom, byArray5.length + 1);
        aEADBlockCipher.processAADBytes(byArray5, 0, n7);
        n8 = aEADBlockCipher.processBytes(byArray7, 0, byArray7.length, byArray10, 0);
        aEADBlockCipher.processAADBytes(byArray5, n7, byArray5.length - n7);
        if (n6 != n8) {
            this.fail("decryption reported incorrect update length in randomised test");
        }
        n8 += aEADBlockCipher.doFinal(byArray10, n8);
        if (!this.areEqual(byArray3, byArray10)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(byArray8, byArray = aEADBlockCipher.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
        aEADBlockCipher.init(false, AEADTestUtil.reuseKey(aEADParameters));
        byArray10 = new byte[aEADBlockCipher.getOutputSize(byArray7.length)];
        n7 = OCBTest.nextInt(secureRandom, byArray5.length + 1);
        aEADBlockCipher.processAADBytes(byArray5, 0, n7);
        n8 = aEADBlockCipher.processBytes(byArray7, 0, byArray7.length, byArray10, 0);
        aEADBlockCipher.processAADBytes(byArray5, n7, byArray5.length - n7);
        n8 += aEADBlockCipher.doFinal(byArray10, n8);
        if (!this.areEqual(byArray3, byArray10)) {
            this.fail("incorrect decrypt in randomised test");
        }
        if (!this.areEqual(byArray8, byArray = aEADBlockCipher.getMac())) {
            this.fail("decryption produced different mac from encryption");
        }
    }

    private void randomTests() throws InvalidCipherTextException {
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.setSeed(Times.nanoTime());
        int n = 0;
        while (n < 10) {
            this.randomTest(secureRandom);
            ++n;
        }
    }

    private void runLongerTestCase(int n, int n2, String string) throws InvalidCipherTextException {
        byte[] byArray = Hex.decode(string);
        byte[] byArray2 = new byte[n / 8];
        byArray2[byArray2.length - 1] = (byte)n2;
        KeyParameter keyParameter = new KeyParameter(byArray2);
        AEADBlockCipher aEADBlockCipher = this.initOCBCipher(true, new AEADParameters(keyParameter, n2, this.createNonce(385)));
        AEADBlockCipher aEADBlockCipher2 = this.createOCBCipher();
        long l = 0L;
        byte[] byArray3 = new byte[128];
        int n3 = 0;
        int n4 = 0;
        while (n4 < 128) {
            aEADBlockCipher2.init(true, new AEADParameters(keyParameter, n2, this.createNonce(++n3)));
            l += (long)this.updateCiphers(aEADBlockCipher, aEADBlockCipher2, byArray3, n4, true, true);
            aEADBlockCipher2.init(true, new AEADParameters(keyParameter, n2, this.createNonce(++n3)));
            l += (long)this.updateCiphers(aEADBlockCipher, aEADBlockCipher2, byArray3, n4, false, true);
            aEADBlockCipher2.init(true, new AEADParameters(keyParameter, n2, this.createNonce(++n3)));
            l += (long)this.updateCiphers(aEADBlockCipher, aEADBlockCipher2, byArray3, n4, true, false);
            ++n4;
        }
        long l2 = 16256 + 48 * n2;
        if (l != l2) {
            this.fail("test generated the wrong amount of input: " + l);
        }
        byte[] byArray4 = new byte[aEADBlockCipher.getOutputSize(0)];
        aEADBlockCipher.doFinal(byArray4, 0);
        if (!this.areEqual(byArray, byArray4)) {
            this.fail("incorrect encrypt in long-form test");
        }
    }

    private void runTestCase(String string, String[] stringArray, int n, byte[] byArray) throws InvalidCipherTextException {
        int n2 = 0;
        byte[] byArray2 = Hex.decode(stringArray[n2++]);
        byte[] byArray3 = Hex.decode(stringArray[n2++]);
        byte[] byArray4 = Hex.decode(stringArray[n2++]);
        byte[] byArray5 = Hex.decode(stringArray[n2++]);
        int n3 = n / 8;
        KeyParameter keyParameter = new KeyParameter(byArray);
        AEADParameters aEADParameters = new AEADParameters(keyParameter, n, byArray2, byArray3);
        AEADBlockCipher aEADBlockCipher = this.initOCBCipher(true, aEADParameters);
        AEADBlockCipher aEADBlockCipher2 = this.initOCBCipher(false, aEADParameters);
        this.checkTestCase(aEADBlockCipher, aEADBlockCipher2, string, n3, byArray4, byArray5);
        this.checkTestCase(aEADBlockCipher, aEADBlockCipher2, String.valueOf(string) + " (reused)", n3, byArray4, byArray5);
        AEADParameters aEADParameters2 = AEADTestUtil.reuseKey(aEADParameters);
        aEADBlockCipher.init(true, aEADParameters2);
        aEADBlockCipher2.init(false, aEADParameters2);
        this.checkTestCase(aEADBlockCipher, aEADBlockCipher2, String.valueOf(string) + " (key reuse)", n3, byArray4, byArray5);
    }

    private void testExceptions() throws InvalidCipherTextException {
        AEADBlockCipher aEADBlockCipher = this.createOCBCipher();
        try {
            aEADBlockCipher = new OCBBlockCipher(new DESEngine(), new DESEngine());
            this.fail("incorrect block size not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            aEADBlockCipher.init(false, new KeyParameter(new byte[16]));
            this.fail("illegal argument not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        AEADTestUtil.testReset(this, this.createOCBCipher(), this.createOCBCipher(), new AEADParameters(new KeyParameter(new byte[16]), 128, new byte[15]));
        AEADTestUtil.testTampering(this, aEADBlockCipher, new AEADParameters(new KeyParameter(new byte[16]), 128, new byte[15]));
        AEADTestUtil.testOutputSizes(this, this.createOCBCipher(), new AEADParameters(new KeyParameter(new byte[16]), 128, new byte[15]));
        AEADTestUtil.testBufferSizeChecks(this, this.createOCBCipher(), new AEADParameters(new KeyParameter(new byte[16]), 128, new byte[15]));
    }

    private int updateCiphers(AEADBlockCipher aEADBlockCipher, AEADBlockCipher aEADBlockCipher2, byte[] byArray, int n, boolean bl, boolean bl2) throws InvalidCipherTextException {
        int n2 = bl2 ? n : 0;
        int n3 = aEADBlockCipher2.getOutputSize(n2);
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        if (bl) {
            aEADBlockCipher2.processAADBytes(byArray, 0, n);
        }
        if (bl2) {
            n4 += aEADBlockCipher2.processBytes(byArray, 0, n, byArray2, n4);
        }
        n4 += aEADBlockCipher2.doFinal(byArray2, n4);
        aEADBlockCipher.processAADBytes(byArray2, 0, n4);
        return n4;
    }
}

