/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.TBCPadding;
import org.bouncycastle.crypto.paddings.X923Padding;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class PaddingTest
extends SimpleTest {
    private void blockCheck(PaddedBufferedBlockCipher paddedBufferedBlockCipher, BlockCipherPadding blockCipherPadding, KeyParameter keyParameter, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 8];
        byte[] byArray3 = new byte[byArray.length];
        try {
            paddedBufferedBlockCipher.init(true, keyParameter);
            int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray2, 0);
            n += paddedBufferedBlockCipher.doFinal(byArray2, n);
            paddedBufferedBlockCipher.init(false, keyParameter);
            int n2 = paddedBufferedBlockCipher.processBytes(byArray2, 0, n, byArray3, 0);
            n2 += paddedBufferedBlockCipher.doFinal(byArray3, n2);
            if (!this.areEqual(byArray, byArray3)) {
                this.fail("failed to decrypt - i = " + byArray.length + ", padding = " + blockCipherPadding.getPaddingName());
            }
        }
        catch (Exception exception) {
            this.fail("Exception - " + exception.toString(), exception);
        }
    }

    public String getName() {
        return "PaddingTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new PaddingTest());
    }

    public void performTest() {
        SecureRandom secureRandom;
        block2: {
            secureRandom = new SecureRandom(new byte[20]);
            secureRandom.setSeed(System.currentTimeMillis());
            this.testPadding(new PKCS7Padding(), secureRandom, Hex.decode("ffffff0505050505"), Hex.decode("0000000004040404"));
            PKCS7Padding pKCS7Padding = new PKCS7Padding();
            try {
                pKCS7Padding.padCount(new byte[8]);
                this.fail("invalid padding not detected");
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                if ("pad block corrupted".equals(invalidCipherTextException.getMessage())) break block2;
                this.fail("wrong exception for corrupt padding: " + invalidCipherTextException);
            }
        }
        this.testPadding(new ISO10126d2Padding(), secureRandom, null, null);
        this.testPadding(new X923Padding(), secureRandom, null, null);
        this.testPadding(new TBCPadding(), secureRandom, Hex.decode("ffffff0000000000"), Hex.decode("00000000ffffffff"));
        this.testPadding(new ZeroBytePadding(), secureRandom, Hex.decode("ffffff0000000000"), null);
        this.testPadding(new ISO7816d4Padding(), secureRandom, Hex.decode("ffffff8000000000"), Hex.decode("0000000080000000"));
        this.testOutputSizes();
    }

    private void testOutputSizes() {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new DESEngine(), new PKCS7Padding());
        KeyParameter keyParameter = new KeyParameter(Hex.decode("0011223344556677"));
        int n = 0;
        while (n < paddedBufferedBlockCipher.getBlockSize() * 2) {
            paddedBufferedBlockCipher.init(true, keyParameter);
            if (paddedBufferedBlockCipher.getUpdateOutputSize(n) < 0) {
                this.fail("Padded cipher encrypt negative update output size for input size " + n);
            }
            if (paddedBufferedBlockCipher.getOutputSize(n) < 0) {
                this.fail("Padded cipher encrypt negative output size for input size " + n);
            }
            paddedBufferedBlockCipher.init(false, keyParameter);
            if (paddedBufferedBlockCipher.getUpdateOutputSize(n) < 0) {
                this.fail("Padded cipher decrypt negative update output size for input size " + n);
            }
            if (paddedBufferedBlockCipher.getOutputSize(n) < 0) {
                this.fail("Padded cipher decrypt negative output size for input size " + n);
            }
            ++n;
        }
    }

    public void testPadding(BlockCipherPadding blockCipherPadding, SecureRandom secureRandom, byte[] byArray, byte[] byArray2) {
        PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher(new DESEngine(), blockCipherPadding);
        KeyParameter keyParameter = new KeyParameter(Hex.decode("0011223344556677"));
        byte[] byArray3 = new byte[8];
        byArray3[0] = -1;
        byArray3[1] = -1;
        byArray3[2] = -1;
        byte[] byArray4 = byArray3;
        if (byArray != null) {
            blockCipherPadding.addPadding(byArray4, 3);
            if (!this.areEqual(byArray4, byArray)) {
                this.fail("failed ff test for " + blockCipherPadding.getPaddingName());
            }
        }
        if (byArray2 != null) {
            byArray4 = new byte[8];
            blockCipherPadding.addPadding(byArray4, 4);
            if (!this.areEqual(byArray4, byArray2)) {
                this.fail("failed zero test for " + blockCipherPadding.getPaddingName());
            }
        }
        int n = 1;
        while (n != 200) {
            byArray4 = new byte[n];
            secureRandom.nextBytes(byArray4);
            this.blockCheck(paddedBufferedBlockCipher, blockCipherPadding, keyParameter, byArray4);
            ++n;
        }
    }
}

