/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SHA512tDigest;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTest;

public class RSADigestSignerTest
extends SimpleTest {
    private void checkDigest(RSAKeyParameters rSAKeyParameters, RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters, Digest digest, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws Exception {
        byte[] byArray = new byte[]{1, 6, 3, 32, 7, 43, 2, 5, 7, 78, 4, 23};
        RSADigestSigner rSADigestSigner = new RSADigestSigner(digest);
        rSADigestSigner.init(true, rSAPrivateCrtKeyParameters);
        rSADigestSigner.update(byArray, 0, byArray.length);
        byte[] byArray2 = rSADigestSigner.generateSignature();
        rSADigestSigner = new RSADigestSigner(digest, aSN1ObjectIdentifier);
        rSADigestSigner.init(false, rSAKeyParameters);
        rSADigestSigner.update(byArray, 0, byArray.length);
        if (!rSADigestSigner.verifySignature(byArray2)) {
            this.fail("RSA Digest Signer failed.");
        }
    }

    private void checkNullDigest(RSAKeyParameters rSAKeyParameters, RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters, Digest digest, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws Exception {
        byte[] byArray = new byte[]{1, 6, 3, 32, 7, 43, 2, 5, 7, 78, 4, 23};
        RSADigestSigner rSADigestSigner = new RSADigestSigner(new NullDigest());
        byte[] byArray2 = new byte[digest.getDigestSize()];
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, 0);
        DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE), byArray2);
        byte[] byArray3 = digestInfo.getEncoded();
        rSADigestSigner.init(true, rSAPrivateCrtKeyParameters);
        rSADigestSigner.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = rSADigestSigner.generateSignature();
        rSADigestSigner = new RSADigestSigner(digest, aSN1ObjectIdentifier);
        rSADigestSigner.init(false, rSAKeyParameters);
        rSADigestSigner.update(byArray, 0, byArray.length);
        if (!rSADigestSigner.verifySignature(byArray4)) {
            this.fail("NONE - RSA Digest Signer failed.");
        }
        rSADigestSigner = new RSADigestSigner(new NullDigest());
        rSADigestSigner.init(false, rSAKeyParameters);
        rSADigestSigner.update(byArray3, 0, byArray3.length);
        if (!rSADigestSigner.verifySignature(byArray4)) {
            this.fail("NONE - RSA Digest Signer failed.");
        }
    }

    public String getName() {
        return "RSADigestSigner";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new RSADigestSignerTest());
    }

    public void performTest() throws Exception {
        BigInteger bigInteger = new BigInteger(Base64.decode("AIASoe2PQb1IP7bTyC9usjHP7FvnUMVpKW49iuFtrw/dMpYlsMMoIU2jupfifDpdFxIktSB4P+6Ymg5WjvHKTIrvQ7SR4zV4jaPTu56Ys0pZ9EDA6gb3HLjtU+8Bb1mfWM+yjKxcPDuFjwEtjGlPHg1Vq+CA9HNcMSKNn2+tW6qt"));
        BigInteger bigInteger2 = new BigInteger(Base64.decode("EQ=="));
        BigInteger bigInteger3 = new BigInteger(Base64.decode("AIASoe2PQb1IP7bTyC9usjHP7FvnUMVpKW49iuFtrw/dMpYlsMMoIU2jupfifDpdFxIktSB4P+6Ymg5WjvHKTIrvQ7SR4zV4jaPTu56Ys0pZ9EDA6gb3HLjtU+8Bb1mfWM+yjKxcPDuFjwEtjGlPHg1Vq+CA9HNcMSKNn2+tW6qt"));
        BigInteger bigInteger4 = new BigInteger(Base64.decode("JXzfzG5v+HtLJIZqYMUefJfFLu8DPuJGaLD6lI3cZ0babWZ/oPGoJa5iHpX4Ul/7l3s1PFsuy1GhzCdOdlfRcQ=="));
        BigInteger bigInteger5 = new BigInteger(Base64.decode("YNdJhw3cn0gBoVmMIFRZzflPDNthBiWy/dUMSRfJCxoZjSnr1gysZHK01HteV1YYNGcwPdr3j4FbOfri5c6DUQ=="));
        BigInteger bigInteger6 = new BigInteger(Base64.decode("DxFAOhDajr00rBjqX+7nyZ/9sHWRCCp9WEN5wCsFiWVRPtdB+NeLcou7mWXwf1Y+8xNgmmh//fPV45G2dsyBeZbXeJwB7bzx9NMEAfedchyOwjR8PYdjK3NpTLKtZlEJ6Jkh4QihrXpZMO4fKZWUm9bid3+lmiq43FwW+Hof8/E="));
        BigInteger bigInteger7 = new BigInteger(Base64.decode("AJ9StyTVW+AL/1s7RBtFwZGFBgd3zctBqzzwKPda6LbtIFDznmwDCqAlIQH9X14X7UPLokCDhuAa76OnDXb1OiE="));
        BigInteger bigInteger8 = new BigInteger(Base64.decode("AM3JfD79dNJ5A3beScSzPtWxx/tSLi0QHFtkuhtSizeXdkv5FSba7lVzwEOGKHmW829bRoNxThDy4ds1IihW1w0="));
        BigInteger bigInteger9 = new BigInteger(Base64.decode("Lt0g7wrsNsQxuDdB8q/rH8fSFeBXMGLtCIqfOec1j7FEIuYA/ACiRDgXkHa0WgN7nLXSjHoy630wC5Toq8vvUg=="));
        RSAKeyParameters rSAKeyParameters = new RSAKeyParameters(false, bigInteger, bigInteger2);
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(bigInteger3, bigInteger2, bigInteger6, bigInteger7, bigInteger8, bigInteger4, bigInteger5, bigInteger9);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA1Digest(), X509ObjectIdentifiers.id_SHA1);
        this.checkNullDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA1Digest(), X509ObjectIdentifiers.id_SHA1);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA224Digest(), NISTObjectIdentifiers.id_sha224);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA256Digest(), NISTObjectIdentifiers.id_sha256);
        this.checkNullDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA256Digest(), NISTObjectIdentifiers.id_sha256);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA384Digest(), NISTObjectIdentifiers.id_sha384);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA512Digest(), NISTObjectIdentifiers.id_sha512);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA512tDigest(224), NISTObjectIdentifiers.id_sha512_224);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA512tDigest(256), NISTObjectIdentifiers.id_sha512_256);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA3Digest(224), NISTObjectIdentifiers.id_sha3_224);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA3Digest(256), NISTObjectIdentifiers.id_sha3_256);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA3Digest(384), NISTObjectIdentifiers.id_sha3_384);
        this.checkDigest(rSAKeyParameters, rSAPrivateCrtKeyParameters, new SHA3Digest(512), NISTObjectIdentifiers.id_sha3_512);
        RSADigestSigner rSADigestSigner = new RSADigestSigner(new NullDigest());
        rSADigestSigner.init(true, rSAPrivateCrtKeyParameters);
        rSADigestSigner.update(new byte[16], 0, 16);
        try {
            rSADigestSigner.generateSignature();
            this.fail("no exception");
        }
        catch (CryptoException cryptoException) {
            this.isTrue(cryptoException.getMessage().startsWith("unable to encode signature: malformed DigestInfo"));
        }
    }
}

