/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ResetTest
extends SimpleTest {
    private static final byte[] input = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
    private static final byte[] output = Hex.decode("3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53");

    private void basicTrial(BufferedBlockCipher bufferedBlockCipher, KeyParameter keyParameter) throws InvalidCipherTextException {
        bufferedBlockCipher.init(true, keyParameter);
        byte[] byArray = new byte[input.length];
        int n = bufferedBlockCipher.processBytes(input, 0, input.length, byArray, 0);
        bufferedBlockCipher.doFinal(byArray, n);
        if (!this.areEqual(byArray, output)) {
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(byArray)));
        }
    }

    public String getName() {
        return "Reset";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ResetTest());
    }

    public void performTest() throws Exception {
        BufferedBlockCipher bufferedBlockCipher = new BufferedBlockCipher(new DESEngine());
        KeyParameter keyParameter = new KeyParameter(Hex.decode("0123456789abcdef"));
        this.basicTrial(bufferedBlockCipher, keyParameter);
        bufferedBlockCipher.init(false, keyParameter);
        byte[] byArray = new byte[input.length];
        int n = bufferedBlockCipher.processBytes(output, 0, output.length - 1, byArray, 0);
        try {
            bufferedBlockCipher.doFinal(byArray, n);
            this.fail("no DataLengthException - short input");
        }
        catch (DataLengthException dataLengthException) {}
        n = bufferedBlockCipher.processBytes(output, 0, output.length, byArray, 0);
        bufferedBlockCipher.doFinal(byArray, n);
        if (!this.areEqual(input, byArray)) {
            this.fail("failed reversal one got " + new String(Hex.encode(byArray)));
        }
        n = bufferedBlockCipher.processBytes(output, 0, output.length - 1, byArray, 0);
        try {
            bufferedBlockCipher.doFinal(byArray, n);
            this.fail("no DataLengthException - short output");
        }
        catch (DataLengthException dataLengthException) {}
        n = bufferedBlockCipher.processBytes(output, 0, output.length, byArray, 0);
        bufferedBlockCipher.doFinal(byArray, n);
        if (!this.areEqual(input, byArray)) {
            this.fail("failed reversal two got " + new String(Hex.encode(byArray)));
        }
    }
}

