/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.macs.VMPCMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class VMPCMacTest
extends SimpleTest {
    static byte[] output1 = Hex.decode("9BDA16E2AD0E284774A3ACBC8835A8326C11FAAD");

    public String getName() {
        return "VMPC-MAC";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new VMPCMacTest());
    }

    public void performTest() throws Exception {
        KeyParameter keyParameter = new KeyParameter(Hex.decode("9661410AB797D8A9EB767C21172DF6C7"));
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, Hex.decode("4B5C2F003E67F39557A8D26F3DA2B155"));
        byte[] byArray = new byte[512];
        int n = 117;
        int n2 = 0;
        while (n2 < 256) {
            byArray[n + n2] = (byte)n2;
            ++n2;
        }
        VMPCMac vMPCMac = new VMPCMac();
        vMPCMac.init(parametersWithIV);
        vMPCMac.update(byArray, n, 256);
        byte[] byArray2 = new byte[20];
        vMPCMac.doFinal(byArray2, 0);
        if (!Arrays.areEqual(byArray2, output1)) {
            this.fail("Fail", new String(Hex.encode(output1)), new String(Hex.encode(byArray2)));
        }
    }
}

