/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.util.DerUtil;

public class DEROtherInfo {
    private DERSequence sequence;

    private DEROtherInfo(DERSequence dERSequence) {
        this.sequence = dERSequence;
    }

    /* synthetic */ DEROtherInfo(1 var1_1, DERSequence dERSequence) {
        this(dERSequence);
    }

    public byte[] getEncoded() throws IOException {
        return this.sequence.getEncoded();
    }

    public static final class Builder {
        private final AlgorithmIdentifier algorithmID;
        private final ASN1OctetString partyUVInfo;
        private final ASN1OctetString partyVInfo;
        private ASN1TaggedObject suppPubInfo;
        private ASN1TaggedObject suppPrivInfo;

        public Builder(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2) {
            this.algorithmID = algorithmIdentifier;
            this.partyUVInfo = DerUtil.getOctetString(byArray);
            this.partyVInfo = DerUtil.getOctetString(byArray2);
        }

        public DEROtherInfo build() {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add(this.algorithmID);
            aSN1EncodableVector.add(this.partyUVInfo);
            aSN1EncodableVector.add(this.partyVInfo);
            if (this.suppPubInfo != null) {
                aSN1EncodableVector.add(this.suppPubInfo);
            }
            if (this.suppPrivInfo != null) {
                aSN1EncodableVector.add(this.suppPrivInfo);
            }
            class Org_bouncycastle_crypto_util_DEROtherInfo$1 {
                /* synthetic */ Org_bouncycastle_crypto_util_DEROtherInfo$1() {
                }
            }
            return new DEROtherInfo(null, new DERSequence(aSN1EncodableVector));
        }

        public Builder withSuppPrivInfo(byte[] byArray) {
            this.suppPrivInfo = new DERTaggedObject(false, 1, (ASN1Encodable)DerUtil.getOctetString(byArray));
            return this;
        }

        public Builder withSuppPubInfo(byte[] byArray) {
            this.suppPubInfo = new DERTaggedObject(false, 0, (ASN1Encodable)DerUtil.getOctetString(byArray));
            return this;
        }
    }
}

