/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.Arrays;

public class KTSParameterSpec
implements AlgorithmParameterSpec {
    private String wrappingKeyAlgorithm;
    private int keySizeInBits;
    private AlgorithmParameterSpec parameterSpec;
    private AlgorithmIdentifier kdfAlgorithm;
    private byte[] otherInfo;

    private KTSParameterSpec(String string, int n, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.wrappingKeyAlgorithm = string;
        this.keySizeInBits = n;
        this.parameterSpec = algorithmParameterSpec;
        this.kdfAlgorithm = algorithmIdentifier;
        this.otherInfo = byArray;
    }

    /* synthetic */ KTSParameterSpec(1 var1_1, String string, int n, AlgorithmParameterSpec algorithmParameterSpec, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this(string, n, algorithmParameterSpec, algorithmIdentifier, byArray);
    }

    public AlgorithmIdentifier getKdfAlgorithm() {
        return this.kdfAlgorithm;
    }

    public String getKeyAlgorithmName() {
        return this.wrappingKeyAlgorithm;
    }

    public int getKeySize() {
        return this.keySizeInBits;
    }

    public byte[] getOtherInfo() {
        return Arrays.clone(this.otherInfo);
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public static final class Builder {
        private final String algorithmName;
        private int keySizeInBits;
        private AlgorithmParameterSpec parameterSpec;
        private AlgorithmIdentifier kdfAlgorithm;
        private byte[] otherInfo;

        public Builder(String string, int n) {
            this(string, n, null);
        }

        public Builder(String string, int n, byte[] byArray) {
            this.algorithmName = string;
            this.keySizeInBits = n;
            this.kdfAlgorithm = new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf3, new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256));
            this.otherInfo = byArray == null ? new byte[]{} : Arrays.clone(byArray);
        }

        public KTSParameterSpec build() {
            class Org_bouncycastle_jcajce_spec_KTSParameterSpec$1 {
                /* synthetic */ Org_bouncycastle_jcajce_spec_KTSParameterSpec$1() {
                }
            }
            return new KTSParameterSpec(null, this.algorithmName, this.keySizeInBits, this.parameterSpec, this.kdfAlgorithm, this.otherInfo);
        }

        public Builder withKdfAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
            this.kdfAlgorithm = algorithmIdentifier;
            return this;
        }

        public Builder withParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            this.parameterSpec = algorithmParameterSpec;
            return this;
        }
    }
}

