/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.ECPointMap;
import org.bouncycastle.math.ec.PreCompCallback;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.WNafPreCompInfo;

public abstract class WNafUtil {
    public static final String PRECOMP_NAME = "bc_wnaf";
    private static final int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};
    private static final int MAX_WIDTH = 16;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final ECPoint[] EMPTY_POINTS = new ECPoint[0];

    static /* synthetic */ ECPoint[] access$0() {
        return EMPTY_POINTS;
    }

    static /* synthetic */ ECPoint[] access$1(ECPoint[] eCPointArray, int n) {
        return WNafUtil.resizeTable(eCPointArray, n);
    }

    public static void configureBasepoint(ECPoint eCPoint) {
        ECCurve eCCurve = eCPoint.getCurve();
        if (eCCurve == null) {
            return;
        }
        BigInteger bigInteger = eCCurve.getOrder();
        int n = bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
        final int n2 = Math.min(16, WNafUtil.getWindowSize(n) + 3);
        eCCurve.precompute(eCPoint, PRECOMP_NAME, new PreCompCallback(){

            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo;
                WNafPreCompInfo wNafPreCompInfo2 = wNafPreCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
                if (wNafPreCompInfo != null && wNafPreCompInfo.getConfWidth() == n2) {
                    wNafPreCompInfo.setPromotionCountdown(0);
                    return wNafPreCompInfo;
                }
                WNafPreCompInfo wNafPreCompInfo3 = new WNafPreCompInfo();
                wNafPreCompInfo3.setPromotionCountdown(0);
                wNafPreCompInfo3.setConfWidth(n2);
                if (wNafPreCompInfo != null) {
                    wNafPreCompInfo3.setPreComp(wNafPreCompInfo.getPreComp());
                    wNafPreCompInfo3.setPreCompNeg(wNafPreCompInfo.getPreCompNeg());
                    wNafPreCompInfo3.setTwice(wNafPreCompInfo.getTwice());
                    wNafPreCompInfo3.setWidth(wNafPreCompInfo.getWidth());
                }
                return wNafPreCompInfo3;
            }
        });
    }

    public static int[] generateCompactNaf(BigInteger bigInteger) {
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_INTS;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n = bigInteger2.bitLength();
        int[] nArray = new int[n >> 1];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 < n2) {
            if (!bigInteger3.testBit(n5)) {
                ++n4;
            } else {
                int n6 = bigInteger.testBit(n5) ? -1 : 1;
                nArray[n3++] = n6 << 16 | n4;
                n4 = 1;
                ++n5;
            }
            ++n5;
        }
        nArray[n3++] = 0x10000 | n4;
        if (nArray.length > n3) {
            nArray = WNafUtil.trim(nArray, n3);
        }
        return nArray;
    }

    public static int[] generateCompactWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateCompactNaf(bigInteger);
        }
        if (n < 2 || n > 16) {
            throw new IllegalArgumentException("'width' must be in the range [2, 16]");
        }
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_INTS;
        }
        int[] nArray = new int[bigInteger.bitLength() / n + 1];
        int n2 = 1 << n;
        int n3 = n2 - 1;
        int n4 = n2 >>> 1;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n6) == bl) {
                ++n6;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n6);
            int n7 = bigInteger.intValue() & n3;
            if (bl) {
                ++n7;
            }
            boolean bl2 = bl = (n7 & n4) != 0;
            if (bl) {
                n7 -= n2;
            }
            int n8 = n5 > 0 ? n6 - 1 : n6;
            nArray[n5++] = n7 << 16 | n8;
            n6 = n;
        }
        if (nArray.length > n5) {
            nArray = WNafUtil.trim(nArray, n5);
        }
        return nArray;
    }

    public static byte[] generateJSF(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = Math.max(bigInteger.bitLength(), bigInteger2.bitLength()) + 1;
        byte[] byArray = new byte[n];
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 | n4 || bigInteger3.bitLength() > n5 || bigInteger4.bitLength() > n5) {
            int n6;
            int n7 = (bigInteger3.intValue() >>> n5) + n3 & 7;
            int n8 = (bigInteger4.intValue() >>> n5) + n4 & 7;
            int n9 = n7 & 1;
            if (n9 != 0 && n7 + (n9 -= n7 & 2) == 4 && (n8 & 3) == 2) {
                n9 = -n9;
            }
            if ((n6 = n8 & 1) != 0 && n8 + (n6 -= n8 & 2) == 4 && (n7 & 3) == 2) {
                n6 = -n6;
            }
            if (n3 << 1 == 1 + n9) {
                n3 ^= 1;
            }
            if (n4 << 1 == 1 + n6) {
                n4 ^= 1;
            }
            if (++n5 == 30) {
                n5 = 0;
                bigInteger3 = bigInteger3.shiftRight(30);
                bigInteger4 = bigInteger4.shiftRight(30);
            }
            byArray[n2++] = (byte)(n9 << 4 | n6 & 0xF);
        }
        if (byArray.length > n2) {
            byArray = WNafUtil.trim(byArray, n2);
        }
        return byArray;
    }

    public static byte[] generateNaf(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n = bigInteger2.bitLength() - 1;
        byte[] byArray = new byte[n];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        int n2 = 1;
        while (n2 < n) {
            if (bigInteger3.testBit(n2)) {
                byArray[n2 - 1] = (byte)(bigInteger.testBit(n2) ? -1 : 1);
                ++n2;
            }
            ++n2;
        }
        byArray[n - 1] = 1;
        return byArray;
    }

    public static byte[] generateWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateNaf(bigInteger);
        }
        if (n < 2 || n > 8) {
            throw new IllegalArgumentException("'width' must be in the range [2, 8]");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[bigInteger.bitLength() + 1];
        int n2 = 1 << n;
        int n3 = n2 - 1;
        int n4 = n2 >>> 1;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        while (n6 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n6) == bl) {
                ++n6;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n6);
            int n7 = bigInteger.intValue() & n3;
            if (bl) {
                ++n7;
            }
            boolean bl2 = bl = (n7 & n4) != 0;
            if (bl) {
                n7 -= n2;
            }
            n5 += n5 > 0 ? n6 - 1 : n6;
            byArray[n5++] = (byte)n7;
            n6 = n;
        }
        if (byArray.length > n5) {
            byArray = WNafUtil.trim(byArray, n5);
        }
        return byArray;
    }

    public static int getNafWeight(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return 0;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        return bigInteger3.bitCount();
    }

    public static WNafPreCompInfo getWNafPreCompInfo(ECPoint eCPoint) {
        return WNafUtil.getWNafPreCompInfo(eCPoint.getCurve().getPreCompInfo(eCPoint, PRECOMP_NAME));
    }

    public static WNafPreCompInfo getWNafPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
    }

    public static int getWindowSize(int n) {
        return WNafUtil.getWindowSize(n, DEFAULT_WINDOW_SIZE_CUTOFFS, 16);
    }

    public static int getWindowSize(int n, int n2) {
        return WNafUtil.getWindowSize(n, DEFAULT_WINDOW_SIZE_CUTOFFS, n2);
    }

    public static int getWindowSize(int n, int[] nArray) {
        return WNafUtil.getWindowSize(n, nArray, 16);
    }

    public static int getWindowSize(int n, int[] nArray, int n2) {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n < nArray[n3]) break;
            ++n3;
        }
        return Math.max(2, Math.min(n2, n3 + 2));
    }

    public static WNafPreCompInfo precompute(final ECPoint eCPoint, final int n, final boolean bl) {
        final ECCurve eCCurve = eCPoint.getCurve();
        return (WNafPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, new PreCompCallback(){

            private boolean checkExisting(WNafPreCompInfo wNafPreCompInfo, int n3, int n2, boolean bl2) {
                return wNafPreCompInfo != null && wNafPreCompInfo.getWidth() >= Math.max(wNafPreCompInfo.getConfWidth(), n3) && this.checkTable(wNafPreCompInfo.getPreComp(), n2) && (!bl2 || this.checkTable(wNafPreCompInfo.getPreCompNeg(), n2));
            }

            private boolean checkTable(ECPoint[] eCPointArray, int n2) {
                return eCPointArray != null && eCPointArray.length >= n2;
            }

            /*
             * Unable to fully structure code
             */
            public PreCompInfo precompute(PreCompInfo var1_1) {
                block15: {
                    block18: {
                        block17: {
                            block16: {
                                var2_2 = var1_1 instanceof WNafPreCompInfo != false ? (WNafPreCompInfo)var1_1 : null;
                                if (this.checkExisting(var2_2, var3_3 = Math.max(2, Math.min(16, n)), var4_4 = 1 << var3_3 - 2, bl)) {
                                    var2_2.decrementPromotionCountdown();
                                    return var2_2;
                                }
                                var5_5 = new WNafPreCompInfo();
                                var6_6 = null;
                                var7_7 = null;
                                var8_8 = null;
                                if (var2_2 != null) {
                                    var9_9 = var2_2.decrementPromotionCountdown();
                                    var5_5.setPromotionCountdown(var9_9);
                                    var10_10 = var2_2.getConfWidth();
                                    var5_5.setConfWidth(var10_10);
                                    var6_6 = var2_2.getPreComp();
                                    var7_7 = var2_2.getPreCompNeg();
                                    var8_8 = var2_2.getTwice();
                                }
                                var3_3 = Math.min(16, Math.max(var5_5.getConfWidth(), var3_3));
                                var4_4 = 1 << var3_3 - 2;
                                var9_9 = 0;
                                if (var6_6 == null) {
                                    var6_6 = WNafUtil.access$0();
                                } else {
                                    var9_9 = var6_6.length;
                                }
                                if (var9_9 >= var4_4) break block15;
                                var6_6 = WNafUtil.access$1(var6_6, var4_4);
                                if (var4_4 != 1) break block16;
                                var6_6[0] = eCPoint.normalize();
                                break block15;
                            }
                            var10_10 = var9_9;
                            if (var10_10 == 0) {
                                var6_6[0] = eCPoint;
                                var10_10 = 1;
                            }
                            var11_11 = null;
                            if (var4_4 != 2) break block17;
                            var6_6[1] = eCPoint.threeTimes();
                            break block18;
                        }
                        var12_12 = var8_8;
                        var13_13 = var6_6[var10_10 - 1];
                        if (var12_12 != null || (var8_8 = (var12_12 = var6_6[0].twice())).isInfinity() || !ECAlgorithms.isFpCurve(eCCurve) || eCCurve.getFieldSize() < 64) ** GOTO lbl57
                        switch (eCCurve.getCoordinateSystem()) {
                            case 2: 
                            case 3: 
                            case 4: {
                                var11_11 = var8_8.getZCoord(0);
                                var12_12 = eCCurve.createPoint(var8_8.getXCoord().toBigInteger(), var8_8.getYCoord().toBigInteger());
                                var14_14 = var11_11.square();
                                var15_15 = var14_14.multiply(var11_11);
                                var13_13 = var13_13.scaleX(var14_14).scaleY(var15_15);
                                if (var9_9 == 0) {
                                    var6_6[0] = var13_13;
                                }
                                ** GOTO lbl57
                            }
                            default: {
                                if (var10_10 < var4_4) ** continue;
                            }
                        }
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            var6_6[var10_10++] = var13_13 = var13_13.add(var12_12);
lbl57:
                            // 3 sources

                            if (var10_10 < var4_4) ** GOTO lbl-1000
                            break;
                        }
                    }
                    eCCurve.normalizeAll(var6_6, var9_9, var4_4 - var9_9, var11_11);
                }
                if (bl) {
                    if (var7_7 == null) {
                        var10_10 = 0;
                        var7_7 = new ECPoint[var4_4];
                    } else {
                        var10_10 = var7_7.length;
                        if (var10_10 < var4_4) {
                            var7_7 = WNafUtil.access$1(var7_7, var4_4);
                        }
                    }
                    while (var10_10 < var4_4) {
                        var7_7[var10_10] = var6_6[var10_10].negate();
                        ++var10_10;
                    }
                }
                var5_5.setPreComp(var6_6);
                var5_5.setPreCompNeg(var7_7);
                var5_5.setTwice(var8_8);
                var5_5.setWidth(var3_3);
                return var5_5;
            }
        });
    }

    public static WNafPreCompInfo precomputeWithPointMap(ECPoint eCPoint, final ECPointMap eCPointMap, final WNafPreCompInfo wNafPreCompInfo, final boolean bl) {
        ECCurve eCCurve = eCPoint.getCurve();
        return (WNafPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, new PreCompCallback(){

            private boolean checkExisting(WNafPreCompInfo wNafPreCompInfo2, int n, int n2, boolean bl2) {
                return wNafPreCompInfo2 != null && wNafPreCompInfo2.getWidth() >= n && this.checkTable(wNafPreCompInfo2.getPreComp(), n2) && (!bl2 || this.checkTable(wNafPreCompInfo2.getPreCompNeg(), n2));
            }

            private boolean checkTable(ECPoint[] eCPointArray, int n) {
                return eCPointArray != null && eCPointArray.length >= n;
            }

            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                Object object;
                int n;
                int n2;
                WNafPreCompInfo wNafPreCompInfo3 = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
                if (this.checkExisting(wNafPreCompInfo3, n2 = wNafPreCompInfo.getWidth(), n = wNafPreCompInfo.getPreComp().length, bl)) {
                    wNafPreCompInfo3.decrementPromotionCountdown();
                    return wNafPreCompInfo3;
                }
                WNafPreCompInfo wNafPreCompInfo2 = new WNafPreCompInfo();
                wNafPreCompInfo2.setPromotionCountdown(wNafPreCompInfo.getPromotionCountdown());
                ECPoint eCPoint = wNafPreCompInfo.getTwice();
                if (eCPoint != null) {
                    object = eCPointMap.map(eCPoint);
                    wNafPreCompInfo2.setTwice((ECPoint)object);
                }
                object = wNafPreCompInfo.getPreComp();
                ECPoint[] eCPointArray = new ECPoint[((ECPoint[])object).length];
                int n3 = 0;
                while (n3 < ((ECPoint[])object).length) {
                    eCPointArray[n3] = eCPointMap.map(object[n3]);
                    ++n3;
                }
                wNafPreCompInfo2.setPreComp(eCPointArray);
                wNafPreCompInfo2.setWidth(n2);
                if (bl) {
                    ECPoint[] eCPointArray2 = new ECPoint[eCPointArray.length];
                    int n4 = 0;
                    while (n4 < eCPointArray2.length) {
                        eCPointArray2[n4] = eCPointArray[n4].negate();
                        ++n4;
                    }
                    wNafPreCompInfo2.setPreCompNeg(eCPointArray2);
                }
                return wNafPreCompInfo2;
            }
        });
    }

    private static ECPoint[] resizeTable(ECPoint[] eCPointArray, int n) {
        ECPoint[] eCPointArray2 = new ECPoint[n];
        System.arraycopy(eCPointArray, 0, eCPointArray2, 0, eCPointArray.length);
        return eCPointArray2;
    }

    private static byte[] trim(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static int[] trim(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }
}

