/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.djb;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.math.ec.AbstractECLookupTable;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.djb.Curve25519Field;
import org.bouncycastle.math.ec.custom.djb.Curve25519FieldElement;
import org.bouncycastle.math.ec.custom.djb.Curve25519Point;
import org.bouncycastle.math.raw.Nat256;
import org.bouncycastle.util.encoders.Hex;

public class Curve25519
extends ECCurve.AbstractFp {
    public static final BigInteger q = Curve25519FieldElement.Q;
    private static final BigInteger C_a = new BigInteger(1, Hex.decodeStrict("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144"));
    private static final BigInteger C_b = new BigInteger(1, Hex.decodeStrict("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864"));
    private static final int CURVE25519_DEFAULT_COORDS = 4;
    private static final ECFieldElement[] CURVE25519_AFFINE_ZS = new ECFieldElement[]{new Curve25519FieldElement(ECConstants.ONE), new Curve25519FieldElement(C_a)};
    protected Curve25519Point infinity = new Curve25519Point(this, null, null);

    public Curve25519() {
        super(q);
        this.a = this.fromBigInteger(C_a);
        this.b = this.fromBigInteger(C_b);
        this.order = new BigInteger(1, Hex.decodeStrict("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"));
        this.cofactor = BigInteger.valueOf(8L);
        this.coord = 4;
    }

    protected ECCurve cloneCurve() {
        return new Curve25519();
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n, final int n2) {
        final int n3 = 8;
        final int[] nArray = new int[n2 * 8 * 2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            ECPoint eCPoint = eCPointArray[n + n5];
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n4);
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n4 += 8);
            n4 += 8;
            ++n5;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                return this.createRawPoint(new Curve25519FieldElement(nArray3), new Curve25519FieldElement(nArray2), CURVE25519_AFFINE_ZS);
            }

            public int getSize() {
                return n2;
            }

            public ECPoint lookup(int n) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = 0;
                int n32 = 0;
                while (n32 < n2) {
                    int n4 = (n32 ^ n) - 1 >> 31;
                    int n5 = 0;
                    while (n5 < n3) {
                        int n6 = n5;
                        nArray3[n6] = nArray3[n6] ^ nArray[n22 + n5] & n4;
                        int n7 = n5;
                        nArray2[n7] = nArray2[n7] ^ nArray[n22 + n3 + n5] & n4;
                        ++n5;
                    }
                    n22 += n3 * 2;
                    ++n32;
                }
                return this.createPoint(nArray3, nArray2);
            }

            public ECPoint lookupVar(int n) {
                int[] nArray3 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n22 = n * n3 * 2;
                int n32 = 0;
                while (n32 < n3) {
                    nArray3[n32] = nArray[n22 + n32];
                    nArray2[n32] = nArray[n22 + n3 + n32];
                    ++n32;
                }
                return this.createPoint(nArray3, nArray2);
            }
        };
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new Curve25519FieldElement(bigInteger);
    }

    public int getFieldSize() {
        return q.bitLength();
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public BigInteger getQ() {
        return q;
    }

    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Curve25519Field.random(secureRandom, nArray);
        return new Curve25519FieldElement(nArray);
    }

    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Curve25519Field.randomMult(secureRandom, nArray);
        return new Curve25519FieldElement(nArray);
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 4: {
                return true;
            }
        }
        return false;
    }
}

