/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.cmce;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.pqc.crypto.cmce.CMCEEngine;

public class CMCEParameters
implements CipherParameters {
    private static int[] poly3488;
    private static int[] poly4608;
    private static int[] poly6688;
    private static int[] poly6960;
    private static int[] poly8192;
    public static final CMCEParameters mceliece348864r3;
    public static final CMCEParameters mceliece348864fr3;
    public static final CMCEParameters mceliece460896r3;
    public static final CMCEParameters mceliece460896fr3;
    public static final CMCEParameters mceliece6688128r3;
    public static final CMCEParameters mceliece6688128fr3;
    public static final CMCEParameters mceliece6960119r3;
    public static final CMCEParameters mceliece6960119fr3;
    public static final CMCEParameters mceliece8192128r3;
    public static final CMCEParameters mceliece8192128fr3;
    private final String name;
    private final int m;
    private final int n;
    private final int t;
    private final int[] poly;
    private final boolean usePivots;
    private final int defaultKeySize;
    private final CMCEEngine engine;

    static {
        int[] nArray = new int[3];
        nArray[0] = 3;
        nArray[1] = 1;
        poly3488 = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 10;
        nArray2[1] = 9;
        nArray2[2] = 6;
        poly4608 = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 7;
        nArray3[1] = 2;
        nArray3[2] = 1;
        poly6688 = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 8;
        poly6960 = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 7;
        nArray5[1] = 2;
        nArray5[2] = 1;
        poly8192 = nArray5;
        mceliece348864r3 = new CMCEParameters("mceliece348864", 12, 3488, 64, poly3488, false, 128);
        mceliece348864fr3 = new CMCEParameters("mceliece348864f", 12, 3488, 64, poly3488, true, 128);
        mceliece460896r3 = new CMCEParameters("mceliece460896", 13, 4608, 96, poly4608, false, 192);
        mceliece460896fr3 = new CMCEParameters("mceliece460896f", 13, 4608, 96, poly4608, true, 192);
        mceliece6688128r3 = new CMCEParameters("mceliece6688128", 13, 6688, 128, poly6688, false, 256);
        mceliece6688128fr3 = new CMCEParameters("mceliece6688128f", 13, 6688, 128, poly6688, true, 256);
        mceliece6960119r3 = new CMCEParameters("mceliece6960119", 13, 6960, 119, poly6960, false, 256);
        mceliece6960119fr3 = new CMCEParameters("mceliece6960119f", 13, 6960, 119, poly6960, true, 256);
        mceliece8192128r3 = new CMCEParameters("mceliece8192128", 13, 8192, 128, poly8192, false, 256);
        mceliece8192128fr3 = new CMCEParameters("mceliece8192128f", 13, 8192, 128, poly8192, true, 256);
    }

    private CMCEParameters(String string, int n, int n2, int n3, int[] nArray, boolean bl, int n4) {
        this.name = string;
        this.m = n;
        this.n = n2;
        this.t = n3;
        this.poly = nArray;
        this.usePivots = bl;
        this.defaultKeySize = n4;
        this.engine = new CMCEEngine(n, n2, n3, nArray, bl, n4);
    }

    public int getDefaultKeySize() {
        return this.defaultKeySize;
    }

    CMCEEngine getEngine() {
        return this.engine;
    }

    public int getM() {
        return this.m;
    }

    public int getMu() {
        return this.usePivots ? 32 : 0;
    }

    public int getN() {
        return this.n;
    }

    public String getName() {
        return this.name;
    }

    public int getNu() {
        return this.usePivots ? 64 : 0;
    }

    public int getT() {
        return this.t;
    }
}

