/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.util.DEROtherInfo;
import org.bouncycastle.pqc.crypto.ExchangePair;
import org.bouncycastle.pqc.crypto.newhope.NHAgreement;
import org.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import org.bouncycastle.pqc.crypto.newhope.NHKeyPairGenerator;
import org.bouncycastle.pqc.crypto.newhope.NHOtherInfoGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class NewHopeTest
extends SimpleTest {
    private static final int ROUNDS = 1000;

    public String getName() {
        return "NewHope";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new NewHopeTest());
    }

    public void performTest() throws Exception {
        this.testKeyExchange();
        this.testInterop();
        this.testPrivInfoGeneration();
        this.testReuse();
    }

    private void testInterop() {
    }

    private void testKeyExchange() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        SecureRandom secureRandom2 = new SecureRandom();
        int n = 0;
        while (n < 1000) {
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(new KeyGenerationParameters(secureRandom, 2048));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = nHKeyPairGenerator.generateKeyPair();
            NHExchangePairGenerator nHExchangePairGenerator = new NHExchangePairGenerator(secureRandom2);
            ExchangePair exchangePair = nHExchangePairGenerator.generateExchange(asymmetricCipherKeyPair.getPublic());
            NHAgreement nHAgreement = new NHAgreement();
            nHAgreement.init(asymmetricCipherKeyPair.getPrivate());
            byte[] byArray = nHAgreement.calculateAgreement(exchangePair.getPublicKey());
            this.isTrue("value mismatch", Arrays.areEqual(byArray, exchangePair.getSharedValue()));
            ++n;
        }
    }

    private void testPrivInfoGeneration() throws IOException {
        SecureRandom secureRandom = new SecureRandom();
        NHOtherInfoGenerator.PartyU partyU = new NHOtherInfoGenerator.PartyU(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode("beef"), Hex.decode("cafe"), secureRandom);
        byte[] byArray = partyU.getSuppPrivInfoPartA();
        NHOtherInfoGenerator.PartyV partyV = new NHOtherInfoGenerator.PartyV(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode("beef"), Hex.decode("cafe"), secureRandom);
        byte[] byArray2 = partyV.getSuppPrivInfoPartB(byArray);
        DEROtherInfo dEROtherInfo = partyU.generate(byArray2);
        DEROtherInfo dEROtherInfo2 = partyV.generate();
        this.areEqual(dEROtherInfo.getEncoded(), dEROtherInfo2.getEncoded());
    }

    private void testReuse() throws IOException {
        SecureRandom secureRandom = new SecureRandom();
        NHOtherInfoGenerator.PartyU partyU = new NHOtherInfoGenerator.PartyU(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode("beef"), Hex.decode("cafe"), secureRandom);
        byte[] byArray = partyU.getSuppPrivInfoPartA();
        NHOtherInfoGenerator.PartyV partyV = new NHOtherInfoGenerator.PartyV(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1), Hex.decode("beef"), Hex.decode("cafe"), secureRandom);
        byte[] byArray2 = partyV.getSuppPrivInfoPartB(byArray);
        DEROtherInfo dEROtherInfo = partyU.generate(byArray2);
        DEROtherInfo dEROtherInfo2 = partyV.generate();
        this.areEqual(dEROtherInfo.getEncoded(), dEROtherInfo2.getEncoded());
        try {
            partyV.generate();
            this.fail("no exception");
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("builder already used", illegalStateException.getMessage());
        }
        try {
            partyU.generate(byArray2);
            this.fail("no exception");
        }
        catch (IllegalStateException illegalStateException) {
            this.isEquals("builder already used", illegalStateException.getMessage());
        }
    }
}

