/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

public final class ByteUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] concatenate(byte[][] byArray) {
        int n = byArray[0].length;
        byte[] byArray2 = new byte[byArray.length * n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            System.arraycopy(byArray[n3], 0, byArray2, n2, n);
            n2 += n;
            ++n3;
        }
        return byArray2;
    }

    public static int deepHashCode(byte[] byArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = 31 * n + byArray[n2];
            ++n2;
        }
        return n;
    }

    public static int deepHashCode(byte[][] byArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = 31 * n + ByteUtils.deepHashCode(byArray[n2]);
            ++n2;
        }
        return n;
    }

    public static int deepHashCode(byte[][][] byArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = 31 * n + ByteUtils.deepHashCode(byArray[n2]);
            ++n2;
        }
        return n;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2 == null;
        }
        if (byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        int n = byArray.length - 1;
        while (n >= 0) {
            bl &= byArray[n] == byArray2[n];
            --n;
        }
        return bl;
    }

    public static boolean equals(byte[][] byArray, byte[][] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        int n = byArray.length - 1;
        while (n >= 0) {
            bl &= ByteUtils.equals(byArray[n], byArray2[n]);
            --n;
        }
        return bl;
    }

    public static boolean equals(byte[][][] byArray, byte[][][] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        int n = byArray.length - 1;
        while (n >= 0) {
            if (byArray[n].length != byArray2[n].length) {
                return false;
            }
            int n2 = byArray[n].length - 1;
            while (n2 >= 0) {
                bl &= ByteUtils.equals(byArray[n][n2], byArray2[n][n2]);
                --n2;
            }
            --n;
        }
        return bl;
    }

    public static byte[] fromHexString(String string) {
        char[] cArray = string.toUpperCase().toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9' || cArray[n2] >= 'A' && cArray[n2] <= 'F') {
                ++n;
            }
            ++n2;
        }
        byte[] byArray = new byte[n + 1 >> 1];
        int n3 = n & 1;
        int n4 = 0;
        while (n4 < cArray.length) {
            block8: {
                block7: {
                    block6: {
                        if (cArray[n4] < '0' || cArray[n4] > '9') break block6;
                        int n5 = n3 >> 1;
                        byArray[n5] = (byte)(byArray[n5] << 4);
                        int n6 = n3 >> 1;
                        byArray[n6] = (byte)(byArray[n6] | cArray[n4] - 48);
                        break block7;
                    }
                    if (cArray[n4] < 'A' || cArray[n4] > 'F') break block8;
                    int n7 = n3 >> 1;
                    byArray[n7] = (byte)(byArray[n7] << 4);
                    int n8 = n3 >> 1;
                    byArray[n8] = (byte)(byArray[n8] | cArray[n4] - 65 + 10);
                }
                ++n3;
            }
            ++n4;
        }
        return byArray;
    }

    public static byte[][] split(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        if (n > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[][] byArray2 = new byte[][]{new byte[n], new byte[byArray.length - n]};
        System.arraycopy(byArray, 0, byArray2[0], 0, n);
        System.arraycopy(byArray, n, byArray2[1], 0, byArray.length - n);
        return byArray2;
    }

    public static byte[] subArray(byte[] byArray, int n) {
        return ByteUtils.subArray(byArray, n, byArray.length);
    }

    public static byte[] subArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, n2 - n);
        return byArray2;
    }

    public static String toBinaryString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            int n2 = 0;
            while (n2 < 8) {
                int n3 = by >>> n2 & 1;
                string = String.valueOf(string) + n3;
                ++n2;
            }
            if (n != byArray.length - 1) {
                string = String.valueOf(string) + " ";
            }
            ++n;
        }
        return string;
    }

    public static char[] toCharArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            cArray[n] = (char)byArray[n];
            ++n;
        }
        return cArray;
    }

    public static String toHexString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            string = String.valueOf(string) + HEX_CHARS[byArray[n] >>> 4 & 0xF];
            string = String.valueOf(string) + HEX_CHARS[byArray[n] & 0xF];
            ++n;
        }
        return string;
    }

    public static String toHexString(byte[] byArray, String string, String string2) {
        String string3 = new String(string);
        int n = 0;
        while (n < byArray.length) {
            string3 = String.valueOf(string3) + HEX_CHARS[byArray[n] >>> 4 & 0xF];
            string3 = String.valueOf(string3) + HEX_CHARS[byArray[n] & 0xF];
            if (n < byArray.length - 1) {
                string3 = String.valueOf(string3) + string2;
            }
            ++n;
        }
        return string3;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        int n = byArray.length - 1;
        while (n >= 0) {
            byArray3[n] = (byte)(byArray[n] ^ byArray2[n]);
            --n;
        }
        return byArray3;
    }
}

