/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.mail.internet.SharedInputStream;

public class SharedFileInputStream
extends FilterInputStream
implements SharedInputStream {
    private final SharedFileInputStream _parent;
    private final File _file;
    private final long _start;
    private final long _length;
    private long _position;
    private long _markedPosition;
    private List _subStreams = new LinkedList();

    public SharedFileInputStream(String string) throws IOException {
        this(new File(string));
    }

    public SharedFileInputStream(File file) throws IOException {
        this(file, 0L, file.length());
    }

    private SharedFileInputStream(File file, long l, long l2) throws IOException {
        super(new BufferedInputStream(new FileInputStream(file)));
        this._parent = null;
        this._file = file;
        this._start = l;
        this._length = l2;
        this.in.skip(l);
    }

    private SharedFileInputStream(SharedFileInputStream sharedFileInputStream, long l, long l2) throws IOException {
        super(new BufferedInputStream(new FileInputStream(sharedFileInputStream._file)));
        this._parent = sharedFileInputStream;
        this._file = sharedFileInputStream._file;
        this._start = l;
        this._length = l2;
        this.in.skip(l);
    }

    public long getPosition() {
        return this._position;
    }

    public InputStream newStream(long l, long l2) {
        try {
            SharedFileInputStream sharedFileInputStream = l2 < 0L ? (this._length > 0L ? new SharedFileInputStream(this, this._start + l, this._length - l) : (this._length == 0L ? new SharedFileInputStream(this, this._start + l, 0L) : new SharedFileInputStream(this, this._start + l, -1L))) : new SharedFileInputStream(this, this._start + l, l2 - l);
            this._subStreams.add(sharedFileInputStream);
            return sharedFileInputStream;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to create shared stream: " + iOException);
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = 0;
        if (var3_3 != 0) ** GOTO lbl7
        return 0;
        while ((var5_5 = this.read()) >= 0) {
            var1_1[var2_2 + var4_4] = (byte)var5_5;
            ++var4_4;
lbl7:
            // 2 sources

            if (var4_4 < var3_3) continue;
        }
        if (var4_4 == 0) {
            return -1;
        }
        return var4_4;
    }

    public int read() throws IOException {
        if (this._position == this._length) {
            return -1;
        }
        ++this._position;
        return this.in.read();
    }

    public boolean markSupported() {
        return true;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 != l) {
            if (this.read() < 0) break;
            ++l2;
        }
        return l2;
    }

    public void mark(int n) {
        this._markedPosition = this._position;
        this.in.mark(n);
    }

    public void reset() throws IOException {
        this._position = this._markedPosition;
        this.in.reset();
    }

    public SharedFileInputStream getRoot() {
        if (this._parent != null) {
            return this._parent.getRoot();
        }
        return this;
    }

    public void dispose() throws IOException {
        Iterator iterator = this._subStreams.iterator();
        while (iterator.hasNext()) {
            try {
                ((SharedFileInputStream)iterator.next()).dispose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.in.close();
    }
}

