/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1NumericString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(class$org$bouncycastle$asn1$ASN1NumericString != null ? class$org$bouncycastle$asn1$ASN1NumericString : (class$org$bouncycastle$asn1$ASN1NumericString = ASN1NumericString.class$("org.bouncycastle.asn1.ASN1NumericString")), 18){

        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1NumericString.createPrimitive(dEROctetString.getOctets());
        }
    };
    final byte[] contents;
    static /* synthetic */ Class class$org$bouncycastle$asn1$ASN1NumericString;

    ASN1NumericString(String string, boolean bl) {
        if (bl && !ASN1NumericString.isNumericString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.contents = Strings.toByteArray(string);
    }

    ASN1NumericString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1NumericString)) {
            return false;
        }
        ASN1NumericString aSN1NumericString = (ASN1NumericString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1NumericString.contents);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ASN1NumericString createPrimitive(byte[] byArray) {
        return new DERNumericString(byArray, false);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 18, this.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    public static ASN1NumericString getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1NumericString) {
            return (ASN1NumericString)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1NumericString) {
            return (ASN1NumericString)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1NumericString)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1NumericString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1NumericString)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    public final byte[] getOctets() {
        return Arrays.clone(this.contents);
    }

    public final String getString() {
        return Strings.fromByteArray(this.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public static boolean isNumericString(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            char c = string.charAt(n);
            if (c > '\u007f') {
                return false;
            }
            if ((c < '0' || c > '9') && c != ' ') {
                return false;
            }
            --n;
        }
        return true;
    }

    static boolean isNumericString(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            switch (byArray[n]) {
                default: {
                    return false;
                }
                case 32: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        return this.getString();
    }
}

