/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class DERUTF8StringTest
implements Test {
    private static final char[] glyph1_utf16 = new char[]{'\ud801', '\udc00'};
    private static final byte[] glyph1_utf8 = new byte[]{-16, -112, -112, -128};
    private static final char[] glyph2_utf16 = new char[]{'\u6771'};
    private static final byte[] glyph2_utf8 = new byte[]{-26, -99, -79};
    private static final char[] glyph3_utf16 = new char[]{'\u00df'};
    private static final byte[] glyph3_utf8 = new byte[]{-61, -97};
    private static final char[] glyph4_utf16 = new char[]{'A'};
    private static final byte[] glyph4_utf8 = new byte[]{65};
    private static final byte[][] glyphs_utf8 = new byte[][]{glyph1_utf8, glyph2_utf8, glyph3_utf8, glyph4_utf8};
    private static final char[][] glyphs_utf16 = new char[][]{glyph1_utf16, glyph2_utf16, glyph3_utf16, glyph4_utf16};

    public String getName() {
        return "DERUTF8String";
    }

    public static void main(String[] stringArray) {
        DERUTF8StringTest dERUTF8StringTest = new DERUTF8StringTest();
        TestResult testResult = dERUTF8StringTest.perform();
        System.out.println(testResult);
    }

    public TestResult perform() {
        try {
            int n = 0;
            while (n < glyphs_utf16.length) {
                String string = new String(glyphs_utf16[n]);
                byte[] byArray = new DERUTF8String(string).getEncoded();
                byte[] byArray2 = new byte[byArray.length - 2];
                System.arraycopy(byArray, 2, byArray2, 0, byArray.length - 2);
                byte[] byArray3 = new DERUTF8String(Strings.fromUTF8ByteArray(new DEROctetString(byArray2).getOctets())).getEncoded();
                if (!Arrays.areEqual(byArray, byArray3)) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed UTF-8 encoding and decoding");
                }
                if (!Arrays.areEqual(byArray2, glyphs_utf8[n])) {
                    return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed UTF-8 encoding and decoding");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, String.valueOf(this.getName()) + ": failed with Exception " + exception.getMessage());
        }
        return new SimpleTestResult(true, String.valueOf(this.getName()) + ": Okay");
    }
}

