/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLApplicationSpecific;
import org.bouncycastle.asn1.DLBitString;
import org.bouncycastle.asn1.DLExternal;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.util.test.SimpleTest;

public class DLExternalTest
extends SimpleTest {
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERUTF8String;
    static /* synthetic */ Class class$org$bouncycastle$asn1$ASN1Integer;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLSet;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLApplicationSpecific;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLSequence;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERPrintableString;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLTaggedObject;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DEROctetString;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DERIA5String;
    static /* synthetic */ Class class$org$bouncycastle$asn1$DLExternal;

    private void checkRealDataExample(int n, DLExternal dLExternal) throws IOException {
        ASN1Primitive aSN1Primitive;
        ASN1TaggedObject aSN1TaggedObject;
        ASN1Primitive aSN1Primitive2;
        this.isEquals("check direct reference", "2.1.1", String.valueOf(dLExternal.getDirectReference()));
        this.isEquals("check indirect reference", "9", String.valueOf(dLExternal.getIndirectReference()));
        this.isEquals("check data value decriptor", "example data representing the User Data of an OSI.6 ConnectP containing an MSBind with username and password", String.valueOf(dLExternal.getDataValueDescriptor()));
        this.isEquals("check encoding", n, dLExternal.getEncoding());
        ASN1Primitive aSN1Primitive3 = dLExternal.getExternalContent();
        this.isTrue("check existence of content", aSN1Primitive3 != null);
        switch (n) {
            case 1: {
                this.isTrue("check type is an OCTET STRING: " + aSN1Primitive3.getClass(), aSN1Primitive3 instanceof ASN1OctetString);
                aSN1Primitive2 = (ASN1OctetString)aSN1Primitive3;
                aSN1TaggedObject = ASN1TaggedObject.getInstance(((ASN1OctetString)aSN1Primitive2).getOctets());
                break;
            }
            case 2: {
                this.isTrue("check type is a BIT STRING: " + aSN1Primitive3.getClass(), aSN1Primitive3 instanceof ASN1BitString);
                aSN1Primitive = (ASN1BitString)aSN1Primitive3;
                aSN1TaggedObject = ASN1TaggedObject.getInstance(((ASN1BitString)aSN1Primitive).getBytes());
                break;
            }
            default: {
                this.isTrue("check type is a tagged object: " + aSN1Primitive3.getClass(), aSN1Primitive3 instanceof ASN1TaggedObject);
                aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive3;
            }
        }
        this.isTrue("check tag", aSN1TaggedObject.hasContextTag(16));
        this.isEquals("check explicit", true, aSN1TaggedObject.isExplicit());
        this.isEquals("check tagged object is a DLSet: " + aSN1TaggedObject.getBaseUniversal(true, 17).getClass(), (class$org$bouncycastle$asn1$DLSet != null ? class$org$bouncycastle$asn1$DLSet : (class$org$bouncycastle$asn1$DLSet = DLExternalTest.class$("org.bouncycastle.asn1.DLSet"))).getName(), aSN1TaggedObject.getBaseUniversal(true, 17).getClass().getName());
        aSN1Primitive2 = (DLSet)aSN1TaggedObject.getBaseUniversal(true, 17);
        this.isEquals("check number of elements", 2L, ((ASN1Set)aSN1Primitive2).size());
        this.isEquals("check first element in set: " + ((ASN1Set)aSN1Primitive2).getObjectAt(0).getClass(), (class$org$bouncycastle$asn1$DLApplicationSpecific != null ? class$org$bouncycastle$asn1$DLApplicationSpecific : (class$org$bouncycastle$asn1$DLApplicationSpecific = DLExternalTest.class$("org.bouncycastle.asn1.DLApplicationSpecific"))).getName(), ((ASN1Set)aSN1Primitive2).getObjectAt(0).getClass().getName());
        aSN1Primitive = (DLApplicationSpecific)((ASN1Set)aSN1Primitive2).getObjectAt(0);
        this.isEquals("check tag number", 0L, ((ASN1ApplicationSpecific)aSN1Primitive).getApplicationTag());
        this.isEquals("check application object: " + ((ASN1ApplicationSpecific)aSN1Primitive).getEnclosedObject().getClass(), (class$org$bouncycastle$asn1$DLSequence != null ? class$org$bouncycastle$asn1$DLSequence : (class$org$bouncycastle$asn1$DLSequence = DLExternalTest.class$("org.bouncycastle.asn1.DLSequence"))).getName(), ((ASN1ApplicationSpecific)aSN1Primitive).getEnclosedObject().getClass().getName());
        DLSequence dLSequence = (DLSequence)((ASN1ApplicationSpecific)aSN1Primitive).getEnclosedObject();
        this.isEquals("check number of elements", 4L, dLSequence.size());
        this.isEquals("check first element in set: " + dLSequence.getObjectAt(0).getClass(), (class$org$bouncycastle$asn1$DLApplicationSpecific != null ? class$org$bouncycastle$asn1$DLApplicationSpecific : (class$org$bouncycastle$asn1$DLApplicationSpecific = DLExternalTest.class$("org.bouncycastle.asn1.DLApplicationSpecific"))).getName(), dLSequence.getObjectAt(0).getClass().getName());
        DLApplicationSpecific dLApplicationSpecific = (DLApplicationSpecific)dLSequence.getObjectAt(0);
        this.isEquals("check application number", 0L, dLApplicationSpecific.getApplicationTag());
        this.isEquals("check application object: " + dLApplicationSpecific.getEnclosedObject().getClass(), (class$org$bouncycastle$asn1$DERPrintableString != null ? class$org$bouncycastle$asn1$DERPrintableString : (class$org$bouncycastle$asn1$DERPrintableString = DLExternalTest.class$("org.bouncycastle.asn1.DERPrintableString"))).getName(), dLApplicationSpecific.getEnclosedObject().getClass().getName());
        this.isEquals("check C", "de", ((DERPrintableString)dLApplicationSpecific.getEnclosedObject()).getString());
        this.isEquals("check second element in set: " + dLSequence.getObjectAt(1).getClass(), (class$org$bouncycastle$asn1$DLApplicationSpecific != null ? class$org$bouncycastle$asn1$DLApplicationSpecific : (class$org$bouncycastle$asn1$DLApplicationSpecific = DLExternalTest.class$("org.bouncycastle.asn1.DLApplicationSpecific"))).getName(), dLSequence.getObjectAt(1).getClass().getName());
        dLApplicationSpecific = (DLApplicationSpecific)dLSequence.getObjectAt(1);
        this.isEquals("check application number", 2L, dLApplicationSpecific.getApplicationTag());
        this.isEquals("check application object: " + dLApplicationSpecific.getEnclosedObject().getClass(), (class$org$bouncycastle$asn1$DERPrintableString != null ? class$org$bouncycastle$asn1$DERPrintableString : (class$org$bouncycastle$asn1$DERPrintableString = DLExternalTest.class$("org.bouncycastle.asn1.DERPrintableString"))).getName(), dLApplicationSpecific.getEnclosedObject().getClass().getName());
        this.isEquals("check A", "viaT", ((DERPrintableString)dLApplicationSpecific.getEnclosedObject()).getString());
        this.isEquals("check third element in set: " + dLSequence.getObjectAt(2).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject != null ? class$org$bouncycastle$asn1$DLTaggedObject : (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject"))).getName(), dLSequence.getObjectAt(2).getClass().getName());
        DLTaggedObject dLTaggedObject = (DLTaggedObject)dLSequence.getObjectAt(2);
        this.isTrue("check tag", dLTaggedObject.hasContextTag(3));
        this.isEquals("check implicit", false, dLTaggedObject.isExplicit());
        this.isEquals("check tagged object: " + dLTaggedObject.getBaseUniversal(false, 4).getClass(), (class$org$bouncycastle$asn1$DEROctetString != null ? class$org$bouncycastle$asn1$DEROctetString : (class$org$bouncycastle$asn1$DEROctetString = DLExternalTest.class$("org.bouncycastle.asn1.DEROctetString"))).getName(), dLTaggedObject.getBaseUniversal(false, 4).getClass().getName());
        this.isEquals("check O", "Organization", new String(((DEROctetString)dLTaggedObject.getBaseUniversal(false, 4)).getOctets(), "8859_1"));
        this.isEquals("check fourth element in set: " + dLSequence.getObjectAt(3).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject != null ? class$org$bouncycastle$asn1$DLTaggedObject : (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject"))).getName(), dLSequence.getObjectAt(3).getClass().getName());
        dLTaggedObject = (DLTaggedObject)dLSequence.getObjectAt(3);
        this.isTrue("check tag", dLTaggedObject.hasContextTag(5));
        this.isEquals("check explicit", true, dLTaggedObject.isExplicit());
        this.isEquals("check tagged object: " + dLTaggedObject.getExplicitBaseTagged().getClass(), (class$org$bouncycastle$asn1$DLTaggedObject != null ? class$org$bouncycastle$asn1$DLTaggedObject : (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject"))).getName(), dLTaggedObject.getExplicitBaseTagged().getClass().getName());
        dLTaggedObject = (DLTaggedObject)dLTaggedObject.getExplicitBaseTagged();
        this.isTrue("check tag", dLTaggedObject.hasContextTag(0));
        this.isEquals("check implicit", false, dLTaggedObject.isExplicit());
        this.isEquals("check tagged object: " + dLTaggedObject.getBaseUniversal(false, 4).getClass(), (class$org$bouncycastle$asn1$DEROctetString != null ? class$org$bouncycastle$asn1$DEROctetString : (class$org$bouncycastle$asn1$DEROctetString = DLExternalTest.class$("org.bouncycastle.asn1.DEROctetString"))).getName(), dLTaggedObject.getBaseUniversal(false, 4).getClass().getName());
        this.isEquals("check CN", "Common Name", new String(((DEROctetString)dLTaggedObject.getBaseUniversal(false, 4)).getOctets(), "8859_1"));
        this.isEquals("check second element in set: " + ((ASN1Set)aSN1Primitive2).getObjectAt(1).getClass(), (class$org$bouncycastle$asn1$DLTaggedObject != null ? class$org$bouncycastle$asn1$DLTaggedObject : (class$org$bouncycastle$asn1$DLTaggedObject = DLExternalTest.class$("org.bouncycastle.asn1.DLTaggedObject"))).getName(), ((ASN1Set)aSN1Primitive2).getObjectAt(1).getClass().getName());
        DLTaggedObject dLTaggedObject2 = (DLTaggedObject)((ASN1Set)aSN1Primitive2).getObjectAt(1);
        this.isTrue("check tag", dLTaggedObject2.hasContextTag(2));
        this.isEquals("check explicit", true, dLTaggedObject2.isExplicit());
        this.isEquals("check tagged object: " + dLTaggedObject2.getBaseUniversal(true, 22).getClass(), (class$org$bouncycastle$asn1$DERIA5String != null ? class$org$bouncycastle$asn1$DERIA5String : (class$org$bouncycastle$asn1$DERIA5String = DLExternalTest.class$("org.bouncycastle.asn1.DERIA5String"))).getName(), dLTaggedObject2.getBaseUniversal(true, 22).getClass().getName());
        this.isEquals("check password", "SomePassword", ((ASN1IA5String)dLTaggedObject2.getBaseUniversal(true, 22)).getString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private ASN1EncodableVector createRealDataExample(int n) throws IOException {
        DLTaggedObject dLTaggedObject;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1ObjectIdentifier("2.1.1"));
        aSN1EncodableVector.add(new ASN1Integer(9L));
        aSN1EncodableVector.add(new DERUTF8String("example data representing the User Data of an OSI.6 ConnectP containing an MSBind with username and password"));
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new DLApplicationSpecific(0, new DERPrintableString("de")));
        aSN1EncodableVector2.add(new DLApplicationSpecific(2, new DERPrintableString("viaT")));
        aSN1EncodableVector2.add(new DLTaggedObject(false, 3, (ASN1Encodable)new DEROctetString("Organization".getBytes("8859_1"))));
        aSN1EncodableVector2.add(new DLTaggedObject(true, 5, (ASN1Encodable)new DLTaggedObject(false, 0, (ASN1Encodable)new DEROctetString("Common Name".getBytes("8859_1")))));
        DLApplicationSpecific dLApplicationSpecific = new DLApplicationSpecific(0, new DLSequence(aSN1EncodableVector2));
        DLTaggedObject dLTaggedObject2 = new DLTaggedObject(true, 2, (ASN1Encodable)new DERIA5String("SomePassword"));
        ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
        aSN1EncodableVector3.add(dLApplicationSpecific);
        aSN1EncodableVector3.add(dLTaggedObject2);
        DLSet dLSet = new DLSet(aSN1EncodableVector3);
        ASN1Primitive aSN1Primitive = dLTaggedObject = new DLTaggedObject(true, 16, (ASN1Encodable)dLSet);
        switch (n) {
            case 1: {
                aSN1Primitive = new DEROctetString(aSN1Primitive.getEncoded("DL"));
                break;
            }
            case 2: {
                aSN1Primitive = new DLBitString(aSN1Primitive.getEncoded("DL"));
                break;
            }
        }
        aSN1EncodableVector.add(new DLTaggedObject(n == 0, n, (ASN1Encodable)aSN1Primitive));
        return aSN1EncodableVector;
    }

    public String getName() {
        return "DLExternal";
    }

    private void implTestReadEncoded(int n) throws Exception {
        DLExternal dLExternal = new DLExternal(this.createRealDataExample(n));
        ASN1InputStream aSN1InputStream = new ASN1InputStream(dLExternal.getEncoded());
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        this.isTrue("check ais returned an object", aSN1Primitive != null);
        this.isEquals("check returned type: " + aSN1Primitive.getClass(), (class$org$bouncycastle$asn1$DLExternal != null ? class$org$bouncycastle$asn1$DLExternal : (class$org$bouncycastle$asn1$DLExternal = DLExternalTest.class$("org.bouncycastle.asn1.DLExternal"))).getName(), aSN1Primitive.getClass().getName());
        this.checkRealDataExample(n, (DLExternal)aSN1Primitive);
        aSN1InputStream.close();
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new DLExternalTest());
    }

    public void performTest() throws Exception {
        this.testInstantiationByVector();
        this.testReadEncoded();
    }

    public void testInstantiationByVector() throws Exception {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            new DLExternal(new DLSequence(aSN1EncodableVector));
            this.fail("exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("check message", "too few objects in input sequence", illegalArgumentException.getMessage());
        }
        aSN1EncodableVector.add(new DERUTF8String("something completely different"));
        try {
            new DLExternal(new DLSequence(aSN1EncodableVector));
            this.fail("exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isEquals("check message", "too few objects in input sequence", illegalArgumentException.getMessage());
        }
        aSN1EncodableVector.add(new DLTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer(1234567890L)));
        DLExternal dLExternal = new DLExternal(new DLSequence(aSN1EncodableVector));
        this.isEquals("check direct reference", null, dLExternal.getDirectReference());
        this.isEquals("check indirect reference", null, dLExternal.getIndirectReference());
        this.isTrue("check data value descriptor", dLExternal.getDataValueDescriptor() != null);
        String string = dLExternal.getDataValueDescriptor().getClass().getName();
        this.isEquals("check type of value descriptor: " + string, (class$org$bouncycastle$asn1$DERUTF8String != null ? class$org$bouncycastle$asn1$DERUTF8String : (class$org$bouncycastle$asn1$DERUTF8String = DLExternalTest.class$("org.bouncycastle.asn1.DERUTF8String"))).getName(), string);
        this.isEquals("check value", "something completely different", ((ASN1UTF8String)dLExternal.getDataValueDescriptor()).getString());
        this.isEquals("check encoding", 0L, dLExternal.getEncoding());
        this.isTrue("check existence of external content", dLExternal.getExternalContent() != null);
        String string2 = dLExternal.getExternalContent().getClass().getName();
        this.isEquals("check type of external content: " + string2, (class$org$bouncycastle$asn1$ASN1Integer != null ? class$org$bouncycastle$asn1$ASN1Integer : (class$org$bouncycastle$asn1$ASN1Integer = DLExternalTest.class$("org.bouncycastle.asn1.ASN1Integer"))).getName(), string2);
        this.isEquals("check value of external content", "1234567890", ((ASN1Integer)dLExternal.getExternalContent()).getValue().toString());
        aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(9L));
        aSN1EncodableVector.add(new DERUTF8String("something completely different"));
        aSN1EncodableVector.add(new DLTaggedObject(true, 0, (ASN1Encodable)new ASN1Integer(1234567890L)));
        dLExternal = new DLExternal(aSN1EncodableVector);
        this.isEquals("check direct reference", null, dLExternal.getDirectReference());
        this.isTrue("check existence of indirect reference", dLExternal.getIndirectReference() != null);
        this.isEquals("check indirect reference", "9", dLExternal.getIndirectReference().getValue().toString());
        this.isTrue("check existence of data value descriptor", dLExternal.getDataValueDescriptor() != null);
        string = dLExternal.getDataValueDescriptor().getClass().getName();
        this.isEquals("check type of value descriptor: " + string, (class$org$bouncycastle$asn1$DERUTF8String != null ? class$org$bouncycastle$asn1$DERUTF8String : (class$org$bouncycastle$asn1$DERUTF8String = DLExternalTest.class$("org.bouncycastle.asn1.DERUTF8String"))).getName(), string);
        this.isEquals("check value", "something completely different", ((ASN1UTF8String)dLExternal.getDataValueDescriptor()).getString());
        this.isEquals("check encoding", 0L, dLExternal.getEncoding());
        this.isTrue("check existence of external content", dLExternal.getExternalContent() != null);
        string2 = dLExternal.getExternalContent().getClass().getName();
        this.isEquals("check type of external content: " + string2, (class$org$bouncycastle$asn1$ASN1Integer != null ? class$org$bouncycastle$asn1$ASN1Integer : (class$org$bouncycastle$asn1$ASN1Integer = DLExternalTest.class$("org.bouncycastle.asn1.ASN1Integer"))).getName(), string2);
        this.isEquals("check value of external content", "1234567890", ((ASN1Integer)dLExternal.getExternalContent()).getValue().toString());
        dLExternal = new DLExternal(this.createRealDataExample(0));
        this.checkRealDataExample(0, dLExternal);
        dLExternal = new DLExternal(this.createRealDataExample(1));
        this.checkRealDataExample(1, dLExternal);
        dLExternal = new DLExternal(this.createRealDataExample(2));
        this.checkRealDataExample(2, dLExternal);
    }

    public void testReadEncoded() throws Exception {
        this.implTestReadEncoded(0);
        this.implTestReadEncoded(1);
        this.implTestReadEncoded(2);
    }
}

