/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class TagTest
extends SimpleTest {
    byte[] longTagged = Base64.decode("ZSRzIp8gEEZFRENCQTk4NzY1NDMyMTCfIQwyMDA2MDQwMTEyMzSUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFZS6QAkRFkQlURUNITklLRVKSBQECAwQFkxAREhMUFRYXGBkalAggBREVcwOJAgBxFxgZGpQIIAUXGBkalAggBWUukAJERZEJVEVDSE5JS0VSkgUBAgMEBZMQERITFBUWFxgZGpQIIAURFXMDiQIAcRcYGRqUCCAFFxgZGpQIIAVlLpACREWRCVRFQ0hOSUtFUpIFAQIDBAWTEBESExQVFhcYGRqUCCAFERVzA4kCAHEXGBkalAggBRcYGRqUCCAFFxgZGpQIIAUXGBkalAg=");
    byte[] longAppSpecificTag = Hex.decode("5F610101");
    byte[] taggedInteger = Hex.decode("BF2203020101");

    public String getName() {
        return "Tag";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new TagTest());
    }

    public void performTest() throws IOException {
        ASN1Sequence aSN1Sequence;
        ASN1TaggedObject aSN1TaggedObject;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(this.longTagged);
        ASN1TaggedObject aSN1TaggedObject2 = (ASN1TaggedObject)aSN1InputStream.readObject();
        if (!aSN1TaggedObject2.hasTag(64, 5)) {
            this.fail("unexpected tag value found - not 5");
        }
        if (!(aSN1TaggedObject2 = aSN1TaggedObject2.getExplicitBaseTagged()).hasTag(64, 19)) {
            this.fail("unexpected tag value found - not 19");
        }
        if (!(aSN1TaggedObject = (ASN1TaggedObject)(aSN1Sequence = (ASN1Sequence)aSN1TaggedObject2.getBaseUniversal(false, 16)).getObjectAt(0)).hasContextTag(32)) {
            this.fail("unexpected tag value found - not 32");
        }
        if (!(aSN1TaggedObject = (ASN1TaggedObject)ASN1Primitive.fromByteArray(aSN1TaggedObject.getEncoded())).hasContextTag(32)) {
            this.fail("unexpected tag value found on recode - not 32");
        }
        if (!(aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(1)).hasContextTag(33)) {
            this.fail("unexpected tag value found - not 33");
        }
        if (!(aSN1TaggedObject = (ASN1TaggedObject)ASN1Primitive.fromByteArray(aSN1TaggedObject.getEncoded())).hasContextTag(33)) {
            this.fail("unexpected tag value found on recode - not 33");
        }
        if (!(aSN1TaggedObject2 = (ASN1TaggedObject)(aSN1InputStream = new ASN1InputStream(this.longAppSpecificTag)).readObject()).hasTag(64, 97)) {
            this.fail("incorrect tag number read");
        }
        if (!(aSN1TaggedObject2 = (ASN1TaggedObject)ASN1Primitive.fromByteArray(aSN1TaggedObject2.getEncoded())).hasTag(64, 97)) {
            this.fail("incorrect tag number read on recode");
        }
        SecureRandom secureRandom = new SecureRandom();
        int n = 0;
        while (n < 100) {
            int n2 = secureRandom.nextInt() >>> 1 + (secureRandom.nextInt() >>> 1) % 26;
            aSN1TaggedObject2 = new DERTaggedObject(false, 64, n2, (ASN1Encodable)new DEROctetString(new byte[]{1}));
            if (!(aSN1TaggedObject2 = (ASN1TaggedObject)ASN1Primitive.fromByteArray(aSN1TaggedObject2.getEncoded())).hasTag(64, n2)) {
                this.fail("incorrect tag number read on recode (random test value: " + n2 + ")");
            }
            ++n;
        }
        aSN1TaggedObject = new DERTaggedObject(false, 34, (ASN1Encodable)new DERTaggedObject(true, 1000, (ASN1Encodable)new ASN1Integer(1L)));
        if (!this.areEqual(this.taggedInteger, aSN1TaggedObject.getEncoded())) {
            this.fail("incorrect encoding for implicit explicit tagged integer");
        }
    }
}

