/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Blake2sDigest
implements ExtendedDigest {
    private static final int[] blake2s_IV = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final byte[][] blake2s_sigma;
    private static final int ROUNDS = 10;
    private static final int BLOCK_LENGTH_BYTES = 64;
    private int digestLength = 32;
    private int keyLength = 0;
    private byte[] salt = null;
    private byte[] personalization = null;
    private byte[] key = null;
    private int fanout = 1;
    private int depth = 1;
    private int leafLength = 0;
    private long nodeOffset = 0L;
    private int nodeDepth = 0;
    private int innerHashLength = 0;
    private byte[] buffer = null;
    private int bufferPos = 0;
    private int[] internalState = new int[16];
    private int[] chainValue = null;
    private int t0 = 0;
    private int t1 = 0;
    private int f0 = 0;

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = 10;
        byArray[11] = 11;
        byArray[12] = 12;
        byArray[13] = 13;
        byArray[14] = 14;
        byArray[15] = 15;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 14;
        byArray2[1] = 10;
        byArray2[2] = 4;
        byArray2[3] = 8;
        byArray2[4] = 9;
        byArray2[5] = 15;
        byArray2[6] = 13;
        byArray2[7] = 6;
        byArray2[8] = 1;
        byArray2[9] = 12;
        byArray2[11] = 2;
        byArray2[12] = 11;
        byArray2[13] = 7;
        byArray2[14] = 5;
        byArray2[15] = 3;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[0] = 11;
        byArray3[1] = 8;
        byArray3[2] = 12;
        byArray3[4] = 5;
        byArray3[5] = 2;
        byArray3[6] = 15;
        byArray3[7] = 13;
        byArray3[8] = 10;
        byArray3[9] = 14;
        byArray3[10] = 3;
        byArray3[11] = 6;
        byArray3[12] = 7;
        byArray3[13] = 1;
        byArray3[14] = 9;
        byArray3[15] = 4;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[16];
        byArray4[0] = 7;
        byArray4[1] = 9;
        byArray4[2] = 3;
        byArray4[3] = 1;
        byArray4[4] = 13;
        byArray4[5] = 12;
        byArray4[6] = 11;
        byArray4[7] = 14;
        byArray4[8] = 2;
        byArray4[9] = 6;
        byArray4[10] = 5;
        byArray4[11] = 10;
        byArray4[12] = 4;
        byArray4[14] = 15;
        byArray4[15] = 8;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[16];
        byArray5[0] = 9;
        byArray5[2] = 5;
        byArray5[3] = 7;
        byArray5[4] = 2;
        byArray5[5] = 4;
        byArray5[6] = 10;
        byArray5[7] = 15;
        byArray5[8] = 14;
        byArray5[9] = 1;
        byArray5[10] = 11;
        byArray5[11] = 12;
        byArray5[12] = 6;
        byArray5[13] = 8;
        byArray5[14] = 3;
        byArray5[15] = 13;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[16];
        byArray6[0] = 2;
        byArray6[1] = 12;
        byArray6[2] = 6;
        byArray6[3] = 10;
        byArray6[5] = 11;
        byArray6[6] = 8;
        byArray6[7] = 3;
        byArray6[8] = 4;
        byArray6[9] = 13;
        byArray6[10] = 7;
        byArray6[11] = 5;
        byArray6[12] = 15;
        byArray6[13] = 14;
        byArray6[14] = 1;
        byArray6[15] = 9;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[16];
        byArray7[0] = 12;
        byArray7[1] = 5;
        byArray7[2] = 1;
        byArray7[3] = 15;
        byArray7[4] = 14;
        byArray7[5] = 13;
        byArray7[6] = 4;
        byArray7[7] = 10;
        byArray7[9] = 7;
        byArray7[10] = 6;
        byArray7[11] = 3;
        byArray7[12] = 9;
        byArray7[13] = 2;
        byArray7[14] = 8;
        byArray7[15] = 11;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[16];
        byArray8[0] = 13;
        byArray8[1] = 11;
        byArray8[2] = 7;
        byArray8[3] = 14;
        byArray8[4] = 12;
        byArray8[5] = 1;
        byArray8[6] = 3;
        byArray8[7] = 9;
        byArray8[8] = 5;
        byArray8[10] = 15;
        byArray8[11] = 4;
        byArray8[12] = 8;
        byArray8[13] = 6;
        byArray8[14] = 2;
        byArray8[15] = 10;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[16];
        byArray9[0] = 6;
        byArray9[1] = 15;
        byArray9[2] = 14;
        byArray9[3] = 9;
        byArray9[4] = 11;
        byArray9[5] = 3;
        byArray9[7] = 8;
        byArray9[8] = 12;
        byArray9[9] = 2;
        byArray9[10] = 13;
        byArray9[11] = 7;
        byArray9[12] = 1;
        byArray9[13] = 4;
        byArray9[14] = 10;
        byArray9[15] = 5;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[16];
        byArray10[0] = 10;
        byArray10[1] = 2;
        byArray10[2] = 8;
        byArray10[3] = 4;
        byArray10[4] = 7;
        byArray10[5] = 6;
        byArray10[6] = 1;
        byArray10[7] = 5;
        byArray10[8] = 15;
        byArray10[9] = 11;
        byArray10[10] = 9;
        byArray10[11] = 14;
        byArray10[12] = 3;
        byArray10[13] = 12;
        byArray10[14] = 13;
        byArrayArray[9] = byArray10;
        blake2s_sigma = byArrayArray;
    }

    public Blake2sDigest() {
        this(256);
    }

    public Blake2sDigest(int n) {
        if (n < 8 || n > 256 || n % 8 != 0) {
            throw new IllegalArgumentException("BLAKE2s digest bit length must be a multiple of 8 and not greater than 256");
        }
        this.digestLength = n / 8;
        this.init(null, null, null);
    }

    Blake2sDigest(int n, int n2, long l) {
        this.digestLength = n;
        this.nodeOffset = l;
        this.fanout = 0;
        this.depth = 0;
        this.leafLength = n2;
        this.innerHashLength = n2;
        this.nodeDepth = 0;
        this.init(null, null, null);
    }

    Blake2sDigest(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, long l) {
        this.digestLength = n;
        this.nodeOffset = l;
        this.init(byArray2, byArray3, byArray);
    }

    public Blake2sDigest(Blake2sDigest blake2sDigest) {
        this.bufferPos = blake2sDigest.bufferPos;
        this.buffer = Arrays.clone(blake2sDigest.buffer);
        this.keyLength = blake2sDigest.keyLength;
        this.key = Arrays.clone(blake2sDigest.key);
        this.digestLength = blake2sDigest.digestLength;
        this.internalState = Arrays.clone(this.internalState);
        this.chainValue = Arrays.clone(blake2sDigest.chainValue);
        this.t0 = blake2sDigest.t0;
        this.t1 = blake2sDigest.t1;
        this.f0 = blake2sDigest.f0;
        this.salt = Arrays.clone(blake2sDigest.salt);
        this.personalization = Arrays.clone(blake2sDigest.personalization);
        this.fanout = blake2sDigest.fanout;
        this.depth = blake2sDigest.depth;
        this.leafLength = blake2sDigest.leafLength;
        this.nodeOffset = blake2sDigest.nodeOffset;
        this.nodeDepth = blake2sDigest.nodeDepth;
        this.innerHashLength = blake2sDigest.innerHashLength;
    }

    public Blake2sDigest(byte[] byArray) {
        this.init(null, null, byArray);
    }

    public Blake2sDigest(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) {
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Invalid digest length (required: 1 - 32)");
        }
        this.digestLength = n;
        this.init(byArray2, byArray3, byArray);
    }

    private void G(int n, int n2, int n3, int n4, int n5, int n6) {
        this.internalState[n3] = this.internalState[n3] + this.internalState[n4] + n;
        this.internalState[n6] = this.rotr32(this.internalState[n6] ^ this.internalState[n3], 16);
        this.internalState[n5] = this.internalState[n5] + this.internalState[n6];
        this.internalState[n4] = this.rotr32(this.internalState[n4] ^ this.internalState[n5], 12);
        this.internalState[n3] = this.internalState[n3] + this.internalState[n4] + n2;
        this.internalState[n6] = this.rotr32(this.internalState[n6] ^ this.internalState[n3], 8);
        this.internalState[n5] = this.internalState[n5] + this.internalState[n6];
        this.internalState[n4] = this.rotr32(this.internalState[n4] ^ this.internalState[n5], 7);
    }

    public void clearKey() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            Arrays.fill(this.buffer, (byte)0);
        }
    }

    public void clearSalt() {
        if (this.salt != null) {
            Arrays.fill(this.salt, (byte)0);
        }
    }

    private void compress(byte[] byArray, int n) {
        this.initializeInternalState();
        int[] nArray = new int[16];
        int n2 = 0;
        while (n2 < 16) {
            nArray[n2] = Pack.littleEndianToInt(byArray, n + n2 * 4);
            ++n2;
        }
        int n3 = 0;
        while (n3 < 10) {
            this.G(nArray[blake2s_sigma[n3][0]], nArray[blake2s_sigma[n3][1]], 0, 4, 8, 12);
            this.G(nArray[blake2s_sigma[n3][2]], nArray[blake2s_sigma[n3][3]], 1, 5, 9, 13);
            this.G(nArray[blake2s_sigma[n3][4]], nArray[blake2s_sigma[n3][5]], 2, 6, 10, 14);
            this.G(nArray[blake2s_sigma[n3][6]], nArray[blake2s_sigma[n3][7]], 3, 7, 11, 15);
            this.G(nArray[blake2s_sigma[n3][8]], nArray[blake2s_sigma[n3][9]], 0, 5, 10, 15);
            this.G(nArray[blake2s_sigma[n3][10]], nArray[blake2s_sigma[n3][11]], 1, 6, 11, 12);
            this.G(nArray[blake2s_sigma[n3][12]], nArray[blake2s_sigma[n3][13]], 2, 7, 8, 13);
            this.G(nArray[blake2s_sigma[n3][14]], nArray[blake2s_sigma[n3][15]], 3, 4, 9, 14);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.chainValue.length) {
            this.chainValue[n4] = this.chainValue[n4] ^ this.internalState[n4] ^ this.internalState[n4 + 8];
            ++n4;
        }
    }

    public int doFinal(byte[] byArray, int n) {
        this.f0 = -1;
        this.t0 += this.bufferPos;
        if (this.t0 < 0 && this.bufferPos > -this.t0) {
            ++this.t1;
        }
        this.compress(this.buffer, 0);
        Arrays.fill(this.buffer, (byte)0);
        Arrays.fill(this.internalState, 0);
        int n2 = 0;
        while (n2 < this.chainValue.length && n2 * 4 < this.digestLength) {
            byte[] byArray2 = Pack.intToLittleEndian(this.chainValue[n2]);
            if (n2 * 4 < this.digestLength - 4) {
                System.arraycopy(byArray2, 0, byArray, n + n2 * 4, 4);
            } else {
                System.arraycopy(byArray2, 0, byArray, n + n2 * 4, this.digestLength - n2 * 4);
            }
            ++n2;
        }
        Arrays.fill(this.chainValue, 0);
        this.reset();
        return this.digestLength;
    }

    public String getAlgorithmName() {
        return "BLAKE2s";
    }

    public int getByteLength() {
        return 64;
    }

    public int getDigestSize() {
        return this.digestLength;
    }

    private void init(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.buffer = new byte[64];
        if (byArray3 != null && byArray3.length > 0) {
            if (byArray3.length > 32) {
                throw new IllegalArgumentException("Keys > 32 bytes are not supported");
            }
            this.key = new byte[byArray3.length];
            System.arraycopy(byArray3, 0, this.key, 0, byArray3.length);
            this.keyLength = byArray3.length;
            System.arraycopy(byArray3, 0, this.buffer, 0, byArray3.length);
            this.bufferPos = 64;
        }
        if (this.chainValue == null) {
            this.chainValue = new int[8];
            this.chainValue[0] = blake2s_IV[0] ^ (this.digestLength | this.keyLength << 8 | (this.fanout << 16 | this.depth << 24));
            this.chainValue[1] = blake2s_IV[1] ^ this.leafLength;
            int n = (int)(this.nodeOffset >> 32);
            int n2 = (int)this.nodeOffset;
            this.chainValue[2] = blake2s_IV[2] ^ n2;
            this.chainValue[3] = blake2s_IV[3] ^ (n | this.nodeDepth << 16 | this.innerHashLength << 24);
            this.chainValue[4] = blake2s_IV[4];
            this.chainValue[5] = blake2s_IV[5];
            if (byArray != null) {
                if (byArray.length != 8) {
                    throw new IllegalArgumentException("Salt length must be exactly 8 bytes");
                }
                this.salt = new byte[8];
                System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
                this.chainValue[4] = this.chainValue[4] ^ Pack.littleEndianToInt(byArray, 0);
                this.chainValue[5] = this.chainValue[5] ^ Pack.littleEndianToInt(byArray, 4);
            }
            this.chainValue[6] = blake2s_IV[6];
            this.chainValue[7] = blake2s_IV[7];
            if (byArray2 != null) {
                if (byArray2.length != 8) {
                    throw new IllegalArgumentException("Personalization length must be exactly 8 bytes");
                }
                this.personalization = new byte[8];
                System.arraycopy(byArray2, 0, this.personalization, 0, byArray2.length);
                this.chainValue[6] = this.chainValue[6] ^ Pack.littleEndianToInt(byArray2, 0);
                this.chainValue[7] = this.chainValue[7] ^ Pack.littleEndianToInt(byArray2, 4);
            }
        }
    }

    private void initializeInternalState() {
        System.arraycopy(this.chainValue, 0, this.internalState, 0, this.chainValue.length);
        System.arraycopy(blake2s_IV, 0, this.internalState, this.chainValue.length, 4);
        this.internalState[12] = this.t0 ^ blake2s_IV[4];
        this.internalState[13] = this.t1 ^ blake2s_IV[5];
        this.internalState[14] = this.f0 ^ blake2s_IV[6];
        this.internalState[15] = blake2s_IV[7];
    }

    public void reset() {
        this.bufferPos = 0;
        this.f0 = 0;
        this.t0 = 0;
        this.t1 = 0;
        this.chainValue = null;
        Arrays.fill(this.buffer, (byte)0);
        if (this.key != null) {
            System.arraycopy(this.key, 0, this.buffer, 0, this.key.length);
            this.bufferPos = 64;
        }
        this.init(this.salt, this.personalization, this.key);
    }

    private int rotr32(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    public void update(byte by) {
        int n = 64 - this.bufferPos;
        if (n == 0) {
            this.t0 += 64;
            if (this.t0 == 0) {
                ++this.t1;
            }
            this.compress(this.buffer, 0);
            Arrays.fill(this.buffer, (byte)0);
            this.buffer[0] = by;
            this.bufferPos = 1;
        } else {
            this.buffer[this.bufferPos] = by;
            ++this.bufferPos;
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return;
        }
        int n3 = 0;
        if (this.bufferPos != 0) {
            n3 = 64 - this.bufferPos;
            if (n3 < n2) {
                System.arraycopy(byArray, n, this.buffer, this.bufferPos, n3);
                this.t0 += 64;
                if (this.t0 == 0) {
                    ++this.t1;
                }
                this.compress(this.buffer, 0);
                this.bufferPos = 0;
                Arrays.fill(this.buffer, (byte)0);
            } else {
                System.arraycopy(byArray, n, this.buffer, this.bufferPos, n2);
                this.bufferPos += n2;
                return;
            }
        }
        int n4 = n + n2 - 64;
        int n5 = n + n3;
        while (n5 < n4) {
            this.t0 += 64;
            if (this.t0 == 0) {
                ++this.t1;
            }
            this.compress(byArray, n5);
            n5 += 64;
        }
        System.arraycopy(byArray, n5, this.buffer, 0, n + n2 - n5);
        this.bufferPos += n + n2 - n5;
    }
}

