/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.params.NaccacheSternKeyGenerationParameters;
import org.bouncycastle.crypto.params.NaccacheSternKeyParameters;
import org.bouncycastle.crypto.params.NaccacheSternPrivateKeyParameters;
import org.bouncycastle.util.BigIntegers;

public class NaccacheSternKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static int[] smallPrimes = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557};
    private NaccacheSternKeyGenerationParameters param;
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private static Vector findFirstPrimes(int n) {
        Vector<BigInteger> vector = new Vector<BigInteger>(n);
        int n2 = 0;
        while (n2 != n) {
            vector.addElement(BigInteger.valueOf(smallPrimes[n2]));
            ++n2;
        }
        return vector;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        int n = this.param.getStrength();
        SecureRandom secureRandom = this.param.getRandom();
        int n2 = this.param.getCertainty();
        boolean bl = this.param.isDebug();
        if (bl) {
            System.out.println("Fetching first " + this.param.getCntSmallPrimes() + " primes.");
        }
        Vector vector = NaccacheSternKeyPairGenerator.findFirstPrimes(this.param.getCntSmallPrimes());
        vector = NaccacheSternKeyPairGenerator.permuteList(vector, secureRandom);
        BigInteger bigInteger6 = ONE;
        BigInteger bigInteger7 = ONE;
        int n3 = 0;
        while (n3 < vector.size() / 2) {
            bigInteger6 = bigInteger6.multiply((BigInteger)vector.elementAt(n3));
            ++n3;
        }
        int n4 = vector.size() / 2;
        while (n4 < vector.size()) {
            bigInteger7 = bigInteger7.multiply((BigInteger)vector.elementAt(n4));
            ++n4;
        }
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7);
        int n5 = n - bigInteger8.bitLength() - 48;
        BigInteger bigInteger9 = NaccacheSternKeyPairGenerator.generatePrime(n5 / 2 + 1, n2, secureRandom);
        BigInteger bigInteger10 = NaccacheSternKeyPairGenerator.generatePrime(n5 / 2 + 1, n2, secureRandom);
        long l = 0L;
        if (bl) {
            System.out.println("generating p and q");
        }
        BigInteger bigInteger11 = bigInteger9.multiply(bigInteger6).shiftLeft(1);
        BigInteger bigInteger12 = bigInteger10.multiply(bigInteger7).shiftLeft(1);
        while (true) {
            ++l;
            bigInteger5 = NaccacheSternKeyPairGenerator.generatePrime(24, n2, secureRandom);
            bigInteger4 = bigInteger5.multiply(bigInteger11).add(ONE);
            if (!bigInteger4.isProbablePrime(n2)) continue;
            while (bigInteger5.equals(bigInteger3 = NaccacheSternKeyPairGenerator.generatePrime(24, n2, secureRandom)) || !(bigInteger2 = bigInteger3.multiply(bigInteger12).add(ONE)).isProbablePrime(n2)) {
            }
            if (!bigInteger8.gcd(bigInteger5.multiply(bigInteger3)).equals(ONE)) continue;
            if (bigInteger4.multiply(bigInteger2).bitLength() >= n) break;
            if (!bl) continue;
            System.out.println("key size too small. Should be " + n + " but is actually " + bigInteger4.multiply(bigInteger2).bitLength());
        }
        if (bl) {
            System.out.println("needed " + l + " tries to generate p and q.");
        }
        BigInteger bigInteger13 = bigInteger4.multiply(bigInteger2);
        BigInteger bigInteger14 = bigInteger4.subtract(ONE).multiply(bigInteger2.subtract(ONE));
        l = 0L;
        if (bl) {
            System.out.println("generating g");
        }
        while (true) {
            Vector<BigInteger> vector2 = new Vector<BigInteger>();
            int n6 = 0;
            while (n6 != vector.size()) {
                BigInteger bigInteger15 = (BigInteger)vector.elementAt(n6);
                BigInteger bigInteger16 = bigInteger14.divide(bigInteger15);
                do {
                    ++l;
                } while ((bigInteger = BigIntegers.createRandomPrime(n, n2, secureRandom)).modPow(bigInteger16, bigInteger13).equals(ONE));
                vector2.addElement(bigInteger);
                ++n6;
            }
            bigInteger = ONE;
            int n7 = 0;
            while (n7 < vector.size()) {
                bigInteger = bigInteger.multiply(((BigInteger)vector2.elementAt(n7)).modPow(bigInteger8.divide((BigInteger)vector.elementAt(n7)), bigInteger13)).mod(bigInteger13);
                ++n7;
            }
            boolean bl2 = false;
            int n8 = 0;
            while (n8 < vector.size()) {
                if (bigInteger.modPow(bigInteger14.divide((BigInteger)vector.elementAt(n8)), bigInteger13).equals(ONE)) {
                    if (bl) {
                        System.out.println("g has order phi(n)/" + vector.elementAt(n8) + "\n g: " + bigInteger);
                    }
                    bl2 = true;
                    break;
                }
                ++n8;
            }
            if (bl2) continue;
            if (bigInteger.modPow(bigInteger14.divide(BigInteger.valueOf(4L)), bigInteger13).equals(ONE)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/4\n g:" + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger14.divide(bigInteger5), bigInteger13).equals(ONE)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/p'\n g: " + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger14.divide(bigInteger3), bigInteger13).equals(ONE)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/q'\n g: " + bigInteger);
                continue;
            }
            if (bigInteger.modPow(bigInteger14.divide(bigInteger9), bigInteger13).equals(ONE)) {
                if (!bl) continue;
                System.out.println("g has order phi(n)/a\n g: " + bigInteger);
                continue;
            }
            if (!bigInteger.modPow(bigInteger14.divide(bigInteger10), bigInteger13).equals(ONE)) break;
            if (!bl) continue;
            System.out.println("g has order phi(n)/b\n g: " + bigInteger);
        }
        if (bl) {
            System.out.println("needed " + l + " tries to generate g");
            System.out.println();
            System.out.println("found new NaccacheStern cipher variables:");
            System.out.println("smallPrimes: " + vector);
            System.out.println("sigma:...... " + bigInteger8 + " (" + bigInteger8.bitLength() + " bits)");
            System.out.println("a:.......... " + bigInteger9);
            System.out.println("b:.......... " + bigInteger10);
            System.out.println("p':......... " + bigInteger5);
            System.out.println("q':......... " + bigInteger3);
            System.out.println("p:.......... " + bigInteger4);
            System.out.println("q:.......... " + bigInteger2);
            System.out.println("n:.......... " + bigInteger13);
            System.out.println("phi(n):..... " + bigInteger14);
            System.out.println("g:.......... " + bigInteger);
            System.out.println();
        }
        return new AsymmetricCipherKeyPair(new NaccacheSternKeyParameters(false, bigInteger, bigInteger13, bigInteger8.bitLength()), new NaccacheSternPrivateKeyParameters(bigInteger, bigInteger13, bigInteger8.bitLength(), vector, bigInteger14));
    }

    private static BigInteger generatePrime(int n, int n2, SecureRandom secureRandom) {
        BigInteger bigInteger = BigIntegers.createRandomPrime(n, n2, secureRandom);
        while (bigInteger.bitLength() != n) {
            bigInteger = BigIntegers.createRandomPrime(n, n2, secureRandom);
        }
        return bigInteger;
    }

    private static int getInt(SecureRandom secureRandom, int n) {
        int n2;
        int n3;
        if ((n & -n) == n) {
            return (int)((long)n * (long)(secureRandom.nextInt() & Integer.MAX_VALUE) >> 31);
        }
        while ((n3 = secureRandom.nextInt() & Integer.MAX_VALUE) - (n2 = n3 % n) + (n - 1) < 0) {
        }
        return n2;
    }

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (NaccacheSternKeyGenerationParameters)keyGenerationParameters;
    }

    private static Vector permuteList(Vector vector, SecureRandom secureRandom) {
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            vector3.addElement(vector.elementAt(n));
            ++n;
        }
        vector2.addElement(vector3.elementAt(0));
        vector3.removeElementAt(0);
        while (vector3.size() != 0) {
            vector2.insertElementAt(vector3.elementAt(0), NaccacheSternKeyPairGenerator.getInt(secureRandom, vector2.size() + 1));
            vector3.removeElementAt(0);
        }
        return vector2;
    }
}

