/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Pack;

public class Tables4kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[256][2];
        } else if (GCMUtil.areEqual(this.H, byArray) != 0) {
            return;
        }
        this.H = new byte[16];
        GCMUtil.copy(byArray, this.H);
        GCMUtil.asLongs(this.H, this.T[1]);
        GCMUtil.multiplyP7(this.T[1], this.T[1]);
        int n = 2;
        while (n < 256) {
            GCMUtil.divideP(this.T[n >> 1], this.T[n]);
            GCMUtil.xor(this.T[n], this.T[1], this.T[n + 1]);
            n += 2;
        }
    }

    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[byArray[15] & 0xFF];
        long l = lArray[0];
        long l2 = lArray[1];
        int n = 14;
        while (n >= 0) {
            lArray = this.T[byArray[n] & 0xFF];
            long l3 = l2 << 56;
            l2 = lArray[1] ^ (l2 >>> 8 | l << 56);
            l = lArray[0] ^ l >>> 8 ^ l3 ^ l3 >>> 1 ^ l3 >>> 2 ^ l3 >>> 7;
            --n;
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

