/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.prng.DigestRandomGenerator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class DigestRandomNumberTest
extends SimpleTest {
    private static final byte[] ZERO_SEED = new byte[8];
    private static final byte[] TEST_SEED = Hex.decode("81dcfafc885914057876");
    private static final byte[] expected0SHA1 = Hex.decode("95bca677b3d4ff793213c00892d2356ec729ee02");
    private static final byte[] noCycle0SHA1 = Hex.decode("d57ccd0eb12c3938d59226412bc1268037b6b846");
    private static final byte[] expected0SHA256 = Hex.decode("587e2dfd597d086e47ddcd343eac983a5c913bef8c6a1a560a5c1bc3a74b0991");
    private static final byte[] noCycle0SHA256 = Hex.decode("e5776c4483486ba7be081f4e1b9dafbab25c8fae290fd5474c1ceda2c16f9509");
    private static final byte[] expected100SHA1 = Hex.decode("b9d924092546e0876cafd4937d7364ebf9efa4be");
    private static final byte[] expected100SHA256 = Hex.decode("fbc4aa54b948b99de104c44563a552899d718bb75d1941cc62a2444b0506abaf");
    private static final byte[] expectedTestSHA1 = Hex.decode("e9ecef9f5306daf1ac51a89a211a64cb24415649");
    private static final byte[] expectedTestSHA256 = Hex.decode("bdab3ca831b472a2fa09bd1bade541ef16c96640a91fcec553679a136061de98");
    private static final byte[] sha1Xors = Hex.decode("7edcc1216934f3891b03ffa65821611a3e2b1f79");
    private static final byte[] sha256Xors = Hex.decode("5ec48189cc0aa71e79c707bc3c33ffd47bbba368a83d6cfebf3cd3969d7f3eed");

    private void doCountTest(Digest digest, byte[] byArray, byte[] byArray2) {
        int n;
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(digest);
        byte[] byArray3 = new byte[digest.getDigestSize()];
        int[] nArray = new int[digest.getDigestSize()];
        byte[] byArray4 = new byte[digest.getDigestSize()];
        byte[] byArray5 = new byte[digest.getDigestSize()];
        byte[] byArray6 = new byte[digest.getDigestSize()];
        digestRandomGenerator.addSeedMaterial(byArray);
        int n2 = 0;
        while (n2 != 1000000) {
            digestRandomGenerator.nextBytes(byArray3);
            n = 0;
            while (n != byArray3.length) {
                int n3 = n;
                nArray[n3] = nArray[n3] + (byArray3[n] & 0xFF);
                int n4 = n;
                byArray4[n4] = (byte)(byArray4[n4] & byArray3[n]);
                int n5 = n;
                byArray5[n5] = (byte)(byArray5[n5] ^ byArray3[n]);
                int n6 = n;
                byArray6[n6] = (byte)(byArray6[n6] | byArray3[n]);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n != byArray3.length) {
            if (nArray[n] / 1000000 != 127) {
                this.fail("average test failed for " + digest.getAlgorithmName());
            }
            if (byArray4[n] != 0) {
                this.fail("and test failed for " + digest.getAlgorithmName());
            }
            if ((byArray6[n] & 0xFF) != 255) {
                this.fail("or test failed for " + digest.getAlgorithmName());
            }
            if (byArray5[n] != byArray2[n]) {
                this.fail("xor test failed for " + digest.getAlgorithmName());
            }
            ++n;
        }
    }

    private void doExpectedTest(Digest digest, int n, byte[] byArray) {
        this.doExpectedTest(digest, n, byArray, null);
    }

    private void doExpectedTest(Digest digest, int n, byte[] byArray, byte[] byArray2) {
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(digest);
        byte[] byArray3 = new byte[digest.getDigestSize()];
        digestRandomGenerator.addSeedMaterial(n);
        int n2 = 0;
        while (n2 != 1024) {
            digestRandomGenerator.nextBytes(byArray3);
            ++n2;
        }
        if (byArray2 != null && Arrays.areEqual(byArray2, byArray3)) {
            this.fail("seed not being cycled!");
        }
        if (!Arrays.areEqual(byArray, byArray3)) {
            this.fail("expected output doesn't match");
        }
    }

    private void doExpectedTest(Digest digest, byte[] byArray, byte[] byArray2) {
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(digest);
        byte[] byArray3 = new byte[digest.getDigestSize()];
        digestRandomGenerator.addSeedMaterial(byArray);
        int n = 0;
        while (n != 1024) {
            digestRandomGenerator.nextBytes(byArray3);
            ++n;
        }
        if (!Arrays.areEqual(byArray2, byArray3)) {
            this.fail("expected output doesn't match");
        }
    }

    public String getName() {
        return "DigestRandomNumber";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new DigestRandomNumberTest());
    }

    public void performTest() throws Exception {
        this.doExpectedTest(new SHA1Digest(), 0, expected0SHA1, noCycle0SHA1);
        this.doExpectedTest(new SHA256Digest(), 0, expected0SHA256, noCycle0SHA256);
        this.doExpectedTest((Digest)new SHA1Digest(), 100, expected100SHA1);
        this.doExpectedTest((Digest)new SHA256Digest(), 100, expected100SHA256);
        this.doExpectedTest((Digest)new SHA1Digest(), ZERO_SEED, expected0SHA1);
        this.doExpectedTest((Digest)new SHA256Digest(), ZERO_SEED, expected0SHA256);
        this.doExpectedTest((Digest)new SHA1Digest(), TEST_SEED, expectedTestSHA1);
        this.doExpectedTest((Digest)new SHA256Digest(), TEST_SEED, expectedTestSHA256);
        this.doCountTest(new SHA1Digest(), TEST_SEED, sha1Xors);
        this.doCountTest(new SHA256Digest(), TEST_SEED, sha256Xors);
    }
}

