/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.kems.ECIESKeyEncapsulation;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.test.SimpleTest;

public class ECIESKeyEncapsulationTest
extends SimpleTest {
    public String getName() {
        return "ECIESKeyEncapsulation";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new ECIESKeyEncapsulationTest());
    }

    public void performTest() throws Exception {
        X9ECParameters x9ECParameters = SECNamedCurves.getByName("secp224r1");
        ECDomainParameters eCDomainParameters = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(eCDomainParameters, new SecureRandom()));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = eCKeyPairGenerator.generateKeyPair();
        KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(new SHA1Digest());
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[57];
        ECIESKeyEncapsulation eCIESKeyEncapsulation = new ECIESKeyEncapsulation(kDF2BytesGenerator, secureRandom);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPublic());
        KeyParameter keyParameter = (KeyParameter)eCIESKeyEncapsulation.encrypt(byArray, 128);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPrivate());
        KeyParameter keyParameter2 = (KeyParameter)eCIESKeyEncapsulation.decrypt(byArray, 128);
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed basic test");
        }
        eCIESKeyEncapsulation = new ECIESKeyEncapsulation(kDF2BytesGenerator, secureRandom, true, false, false);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPublic());
        keyParameter = (KeyParameter)eCIESKeyEncapsulation.encrypt(byArray, 128);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPrivate());
        keyParameter2 = (KeyParameter)eCIESKeyEncapsulation.decrypt(byArray, 128);
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed cofactor test");
        }
        eCIESKeyEncapsulation = new ECIESKeyEncapsulation(kDF2BytesGenerator, secureRandom, false, true, false);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPublic());
        keyParameter = (KeyParameter)eCIESKeyEncapsulation.encrypt(byArray, 128);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPrivate());
        keyParameter2 = (KeyParameter)eCIESKeyEncapsulation.decrypt(byArray, 128);
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed old cofactor test");
        }
        eCIESKeyEncapsulation = new ECIESKeyEncapsulation(kDF2BytesGenerator, secureRandom, false, false, true);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPublic());
        keyParameter = (KeyParameter)eCIESKeyEncapsulation.encrypt(byArray, 128);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPrivate());
        keyParameter2 = (KeyParameter)eCIESKeyEncapsulation.decrypt(byArray, 128);
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed single hash test");
        }
        eCIESKeyEncapsulation = new ECIESKeyEncapsulation(kDF2BytesGenerator, secureRandom, true, false, true);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPublic());
        keyParameter = (KeyParameter)eCIESKeyEncapsulation.encrypt(byArray, 128);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPrivate());
        keyParameter2 = (KeyParameter)eCIESKeyEncapsulation.decrypt(byArray, 128);
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed cofactor and single hash test");
        }
        eCIESKeyEncapsulation = new ECIESKeyEncapsulation(kDF2BytesGenerator, secureRandom, false, true, true);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPublic());
        keyParameter = (KeyParameter)eCIESKeyEncapsulation.encrypt(byArray, 128);
        eCIESKeyEncapsulation.init(asymmetricCipherKeyPair.getPrivate());
        keyParameter2 = (KeyParameter)eCIESKeyEncapsulation.decrypt(byArray, 128);
        if (!this.areEqual(keyParameter.getKey(), keyParameter2.getKey())) {
            this.fail("failed old cofactor and single hash test");
        }
    }
}

