/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.agreement.kdf.GSKKDFParameters;
import org.bouncycastle.crypto.agreement.kdf.GSKKFDGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class GSKKDFTest
extends SimpleTest {
    public String getName() {
        return "GSKKDFTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new GSKKDFTest());
    }

    public void performTest() throws Exception {
        GSKKFDGenerator gSKKFDGenerator = new GSKKFDGenerator(new SHA256Digest());
        byte[] byArray = new byte[16];
        gSKKFDGenerator.init(new GSKKDFParameters(Hex.decode("0102030405060708090a"), 1, Hex.decode("27252622")));
        gSKKFDGenerator.generateBytes(byArray, 0, byArray.length);
        this.areEqual(Hex.decode("bd9ff24b9cc4d91b70af951989b4d719"), byArray);
        gSKKFDGenerator.generateBytes(byArray, 0, byArray.length);
        this.areEqual(Hex.decode("d5934f681ad1e860981eb1792af68e20"), byArray);
        gSKKFDGenerator = new GSKKFDGenerator(new SHA256Digest());
        gSKKFDGenerator.init(new GSKKDFParameters(Hex.decode("0102030405060708090a"), 2, Hex.decode("27252622")));
        gSKKFDGenerator.generateBytes(byArray, 0, byArray.length);
        this.areEqual(Hex.decode("d5934f681ad1e860981eb1792af68e20"), byArray);
        gSKKFDGenerator.init(new GSKKDFParameters(Hex.decode("0102030405060708090a"), 1));
        gSKKFDGenerator.generateBytes(byArray, 0, byArray.length);
        this.areEqual(Hex.decode("3c6e999b2cb08d8d8dd261cd23f15ed6"), byArray);
        gSKKFDGenerator.generateBytes(byArray, 0, byArray.length);
        this.areEqual(Hex.decode("019ce1fcf81b94602f2f8678be905e0e"), byArray);
        try {
            gSKKFDGenerator.generateBytes(byArray, 1, byArray.length);
        }
        catch (DataLengthException dataLengthException) {
            this.isEquals("output buffer too small", dataLengthException.getMessage());
        }
    }
}

