/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.Grainv1Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Grainv1Test
extends SimpleTest {
    String keyStream1 = "dee931cf1662a72f77d0";
    String keyStream2 = "7f362bd3f7abae203664";
    String keyStream4 = "017D13ECB20AE0C9ACF784CB06525F72CE6D52BEBB948F124668C3506455902449EEA505C19F3EE4D052C3D19DA9C4D1B92DBC7F07AFEA6A3D845DE60D8471FD";

    private void Grainv1Test1(CipherParameters cipherParameters) {
        Grainv1Engine grainv1Engine = new Grainv1Engine();
        byte[] byArray = new byte[10];
        byte[] byArray2 = new byte[10];
        grainv1Engine.init(true, cipherParameters);
        grainv1Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, byArray2);
        }
        grainv1Engine.reset();
        grainv1Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, byArray2);
        }
    }

    private void Grainv1Test2(CipherParameters cipherParameters) {
        Grainv1Engine grainv1Engine = new Grainv1Engine();
        byte[] byArray = new byte[10];
        byte[] byArray2 = new byte[10];
        grainv1Engine.init(true, cipherParameters);
        grainv1Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, byArray2);
        }
        grainv1Engine.reset();
        grainv1Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, byArray2);
        }
    }

    private void Grainv1Test3(CipherParameters cipherParameters) {
        Grainv1Engine grainv1Engine = new Grainv1Engine();
        byte[] byArray = "Encrypt me!".getBytes();
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[byArray.length];
        grainv1Engine.init(true, cipherParameters);
        grainv1Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        grainv1Engine.reset();
        grainv1Engine.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
        if (!this.areEqual(byArray, byArray3)) {
            this.mismatch("Test 3", new String(Hex.encode(byArray)), byArray3);
        }
    }

    private void Grainv1Test4(CipherParameters cipherParameters) {
        Grainv1Engine grainv1Engine = new Grainv1Engine();
        byte[] byArray = new byte[this.keyStream4.length() / 2];
        byte[] byArray2 = new byte[byArray.length];
        grainv1Engine.init(true, cipherParameters);
        grainv1Engine.processBytes(byArray, 0, byArray.length, byArray2, 0);
        if (!this.areEqual(byArray2, Hex.decode(this.keyStream4))) {
            this.mismatch("Keystream 4", this.keyStream4, byArray2);
        }
    }

    public String getName() {
        return "Grain v1";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new Grainv1Test());
    }

    private void mismatch(String string, String string2, byte[] byArray) {
        this.fail("mismatch on " + string, string2, new String(Hex.encode(byArray)));
    }

    public void performTest() {
        this.Grainv1Test1(new ParametersWithIV(new KeyParameter(Hex.decode("00000000000000000000")), Hex.decode("0000000000000000")));
        this.Grainv1Test2(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef1234")), Hex.decode("0123456789abcdef")));
        this.Grainv1Test3(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef1234")), Hex.decode("0123456789abcdef")));
        this.Grainv1Test4(new ParametersWithIV(new KeyParameter(Hex.decode("0F62B5085BAE0154A7FA")), Hex.decode("288FF65DC42B92F9")));
    }
}

