/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.HC128Engine;
import org.bouncycastle.crypto.engines.HC256Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class HCFamilyVecTest
extends SimpleTest {
    private String dellChar(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n != string.length()) {
            if (string.charAt(n) != c) {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return "HC-128 and HC-256 (ecrypt)";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new HCFamilyVecTest());
    }

    public void performTest() throws Exception {
        this.runTests(new HC128Engine(), "ecrypt_HC-128.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_128K_128IV.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_256K_128IV.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_128K_256IV.txt");
        this.runTests(new HC256Engine(), "ecrypt_HC-256_256K_256IV.txt");
    }

    private static String readBlock(PeekableLineReader peekableLineReader) throws IOException {
        String string;
        String string2 = peekableLineReader.readLine().trim();
        String string3 = string2.substring(string2.lastIndexOf(32) + 1);
        while ((string = peekableLineReader.peekLine().trim()).length() >= 1 && string.indexOf(61) < 0) {
            string3 = String.valueOf(string3) + peekableLineReader.readLine().trim();
        }
        return string3;
    }

    private void runAllVectors(StreamCipher streamCipher, String string, PeekableLineReader peekableLineReader) throws IOException {
        String string2;
        while ((string2 = peekableLineReader.readLine()) != null) {
            if (!(string2 = string2.trim()).startsWith("Set ")) continue;
            this.runVector(streamCipher, string, peekableLineReader, this.dellChar(string2, ':'));
        }
    }

    private void runTests(StreamCipher streamCipher, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream(string));
        PeekableLineReader peekableLineReader = new PeekableLineReader(inputStreamReader);
        this.runAllVectors(streamCipher, string, peekableLineReader);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void runVector(StreamCipher var1_1, String var2_2, PeekableLineReader var3_3, String var4_4) throws IOException {
        var5_5 = HCFamilyVecTest.readBlock(var3_3);
        var6_6 = HCFamilyVecTest.readBlock(var3_3);
        var7_7 /* !! */  = new KeyParameter(Hex.decode(var5_5));
        var7_7 /* !! */  = new ParametersWithIV(var7_7 /* !! */ , Hex.decode(var6_6));
        var1_1.init(true, var7_7 /* !! */ );
        var8_8 = new byte[64];
        var9_9 = new byte[64];
        var10_10 = new byte[64];
        var11_11 = 0;
        while (true) {
            var12_12 = var3_3.peekLine().trim();
            var13_13 = var12_12.indexOf(61);
            var14_14 = var12_12.substring(0, var13_13 - 1);
            var15_15 = HCFamilyVecTest.readBlock(var3_3);
            var16_16 = Hex.decode(var15_15);
            if (var14_14.equals("xor-digest")) {
                if (Arrays.areEqual(var16_16, var10_10)) break;
                this.fail("Failed in " + var2_2 + " for test vector: " + var4_4 + " at " + var14_14);
                break;
            }
            var17_17 = var14_14.indexOf(91);
            var18_18 = var14_14.indexOf("..");
            var19_19 = var14_14.indexOf(93);
            var20_20 = Integer.parseInt(var14_14.substring(var17_17 + 1, var18_18));
            var21_21 = Integer.parseInt(var14_14.substring(var18_18 + 2, var19_19));
            if (var20_20 % 64 == 0 && var21_21 - var20_20 == 63) ** GOTO lbl31
            throw new IllegalStateException(String.valueOf(var4_4) + ": " + var14_14 + " not on 64 byte boundaries");
lbl-1000:
            // 1 sources

            {
                var1_1.processBytes(var8_8, 0, var8_8.length, var9_9, 0);
                HCFamilyVecTest.xor(var10_10, var9_9);
                var11_11 += 64;
lbl31:
                // 2 sources

                ** while (var11_11 < var21_21)
            }
lbl32:
            // 1 sources

            if (Arrays.areEqual(var16_16, var9_9)) continue;
            this.fail("Failed in " + var2_2 + " for test vector: " + var4_4 + " at " + var14_14);
        }
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n]);
            ++n;
        }
    }

    private static class PeekableLineReader
    extends BufferedReader {
        private String peek = super.readLine();

        public PeekableLineReader(Reader reader) throws IOException {
            super(reader);
        }

        public String peekLine() {
            return this.peek;
        }

        public String readLine() throws IOException {
            String string = this.peek;
            this.peek = super.readLine();
            return string;
        }
    }
}

