/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Commitment;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.commitments.GeneralHashCommitter;
import org.bouncycastle.crypto.commitments.HashCommitter;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class HashCommitmentTest
extends SimpleTest {
    public String getName() {
        return "HashCommitmentTest";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new HashCommitmentTest());
    }

    public void performBasicTest() throws Exception {
        block7: {
            Commitment commitment;
            HashCommitter hashCommitter;
            block6: {
                byte[] byArray = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
                hashCommitter = new HashCommitter(new SHA256Digest(), new SecureRandom());
                hashCommitter = new HashCommitter(new SHA256Digest(), new SecureRandom());
                commitment = hashCommitter.commit(byArray);
                if (!hashCommitter.isRevealed(commitment, byArray)) {
                    this.fail("commitment failed to validate");
                }
                if ((hashCommitter = new HashCommitter(new SHA1Digest(), new SecureRandom())).isRevealed(commitment, byArray)) {
                    this.fail("commitment validated!!");
                }
                try {
                    hashCommitter.isRevealed(commitment, new byte[byArray.length + 1]);
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("Message and witness secret lengths do not match.")) break block6;
                    this.fail("exception thrown but wrong message");
                }
            }
            try {
                commitment = hashCommitter.commit(new byte[33]);
            }
            catch (DataLengthException dataLengthException) {
                if (dataLengthException.getMessage().equals("Message to be committed to too large for digest.")) break block7;
                this.fail("exception thrown but wrong message");
            }
        }
    }

    public void performGeneralTest() throws Exception {
        block8: {
            Commitment commitment;
            GeneralHashCommitter generalHashCommitter;
            block7: {
                byte[] byArray = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
                generalHashCommitter = new GeneralHashCommitter(new SHA256Digest(), new SecureRandom());
                generalHashCommitter = new GeneralHashCommitter(new SHA256Digest(), new SecureRandom());
                commitment = generalHashCommitter.commit(byArray);
                if (!generalHashCommitter.isRevealed(commitment, byArray)) {
                    this.fail("general commitment failed to validate");
                }
                if ((generalHashCommitter = new GeneralHashCommitter(new SHA1Digest(), new SecureRandom())).isRevealed(commitment, byArray)) {
                    this.fail("general commitment validated!!");
                }
                commitment = generalHashCommitter.commit(byArray);
                byte[] byArray2 = commitment.getSecret();
                byte[] byArray3 = Arrays.copyOfRange(byArray2, 0, byArray2.length - 1);
                byte[] byArray4 = new byte[byArray.length + 1];
                byArray4[0] = byArray2[byArray2.length - 1];
                System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
                commitment = new Commitment(byArray3, commitment.getCommitment());
                if (generalHashCommitter.isRevealed(commitment, byArray4)) {
                    this.fail("general commitment validated!!");
                }
                try {
                    generalHashCommitter.isRevealed(commitment, new byte[byArray.length + 1]);
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("Message and witness secret lengths do not match.")) break block7;
                    this.fail("exception thrown but wrong message");
                }
            }
            try {
                commitment = generalHashCommitter.commit(new byte[33]);
            }
            catch (DataLengthException dataLengthException) {
                if (dataLengthException.getMessage().equals("Message to be committed to too large for digest.")) break block8;
                this.fail("exception thrown but wrong message");
            }
        }
    }

    public void performTest() throws Exception {
        this.performBasicTest();
        this.performGeneralTest();
    }
}

