/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import java.util.ArrayList;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class OpenBSDBCryptTest
extends SimpleTest {
    private static final String[][] bcryptTest1 = new String[][]{{"$2a$05$CCCCCCCCCCCCCCCCCCCCC.E5YPO9kmyuRGyh0XouQYb4YMJKvyOeW", "U*U"}, {"$2a$05$CCCCCCCCCCCCCCCCCCCCC.VGOzA784oUp/Z0DY336zx7pLYAy0lwK", "U*U*"}, {"$2a$05$XXXXXXXXXXXXXXXXXXXXXOAcXxm9kjPGEMsLznoKqmqw7tc8WCx4a", "U*U*U"}, {"$2a$05$CCCCCCCCCCCCCCCCCCCCC.7uG0VCzI2bS7j6ymqJi9CdcdxiRTWNy", ""}, {"$2a$05$abcdefghijklmnopqrstuu5s2v8.iXieOjg/.AySBTTZIIVFJeBui", "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789chars after 72 are ignored"}};
    private static final String[] bcryptTest2 = new String[]{"$2a$05$bvIG6Nmid91Mu9RcmmWZfO5HJIMCT8riNW0hEp8f6/FuA2/mHZFpe", "password"};
    private static final String[] bcryptTest2b = new String[]{"$2a$10$.TtQJ4Jr6isd4Hp.mVfZeuh6Gws4rOQ/vdBczhDx.19NFK0Y84Dle", "\u03c0\u03c0\u03c0\u03c0\u03c0\u03c0\u03c0\u03c0"};
    private static final String[][] bcryptTest3 = new String[][]{{"", "$2a$06$DCq7YPn5Rq63x1Lad4cll.", "$2a$06$DCq7YPn5Rq63x1Lad4cll.TV4S6ytwfsfvkgY8jIucDrjc8deX1s."}, {"", "$2a$08$HqWuK6/Ng6sg9gQzbLrgb.", "$2a$08$HqWuK6/Ng6sg9gQzbLrgb.Tl.ZHfXLhvt/SgVyWhQqgqcZ7ZuUtye"}, {"", "$2a$10$k1wbIrmNyFAPwPVPSVa/ze", "$2a$10$k1wbIrmNyFAPwPVPSVa/zecw2BCEnBwVS2GbrmgzxFUOqW9dk4TCW"}, {"", "$2a$12$k42ZFHFWqBp3vWli.nIn8u", "$2a$12$k42ZFHFWqBp3vWli.nIn8uYyIkbvYRvodzbfbK18SSsY.CsIQPlxO"}, {"a", "$2a$06$m0CrhHm10qJ3lXRY.5zDGO", "$2a$06$m0CrhHm10qJ3lXRY.5zDGO3rS2KdeeWLuGmsfGlMfOxih58VYVfxe"}, {"a", "$2a$08$cfcvVd2aQ8CMvoMpP2EBfe", "$2a$08$cfcvVd2aQ8CMvoMpP2EBfeodLEkkFJ9umNEfPD18.hUF62qqlC/V."}, {"a", "$2a$10$k87L/MF28Q673VKh8/cPi.", "$2a$10$k87L/MF28Q673VKh8/cPi.SUl7MU/rWuSiIDDFayrKk/1tBsSQu4u"}, {"a", "$2a$12$8NJH3LsPrANStV6XtBakCe", "$2a$12$8NJH3LsPrANStV6XtBakCez0cKHXVxmvxIlcz785vxAIZrihHZpeS"}, {"abc", "$2a$06$If6bvum7DFjUnE9p2uDeDu", "$2a$06$If6bvum7DFjUnE9p2uDeDu0YHzrHM6tf.iqN8.yx.jNN1ILEf7h0i"}, {"abc", "$2a$08$Ro0CUfOqk6cXEKf3dyaM7O", "$2a$08$Ro0CUfOqk6cXEKf3dyaM7OhSCvnwM9s4wIX9JeLapehKK5YdLxKcm"}, {"abc", "$2a$10$WvvTPHKwdBJ3uk0Z37EMR.", "$2a$10$WvvTPHKwdBJ3uk0Z37EMR.hLA2W6N9AEBhEgrAOljy2Ae5MtaSIUi"}, {"abc", "$2a$12$EXRkfkdmXn2gzds2SSitu.", "$2a$12$EXRkfkdmXn2gzds2SSitu.MW9.gAVqa9eLS1//RYtYCmB1eLHg.9q"}, {"abcdefghijklmnopqrstuvwxyz", "$2a$06$.rCVZVOThsIa97pEDOxvGu", "$2a$06$.rCVZVOThsIa97pEDOxvGuRRgzG64bvtJ0938xuqzv18d3ZpQhstC"}, {"abcdefghijklmnopqrstuvwxyz", "$2a$08$aTsUwsyowQuzRrDqFflhge", "$2a$08$aTsUwsyowQuzRrDqFflhgekJ8d9/7Z3GV3UcgvzQW3J5zMyrTvlz."}, {"abcdefghijklmnopqrstuvwxyz", "$2a$10$fVH8e28OQRj9tqiDXs1e1u", "$2a$10$fVH8e28OQRj9tqiDXs1e1uxpsjN0c7II7YPKXua2NAKYvM6iQk7dq"}, {"abcdefghijklmnopqrstuvwxyz", "$2a$12$D4G5f18o7aMMfwasBL7Gpu", "$2a$12$D4G5f18o7aMMfwasBL7GpuQWuP3pkrZrOAnqP.bmezbMng.QwJ/pG"}, {"~!@#$%^&*()      ~!@#$%^&*()PNBFRD", "$2a$06$fPIsBO8qRqkjj273rfaOI.", "$2a$06$fPIsBO8qRqkjj273rfaOI.HtSV9jLDpTbZn782DC6/t7qT67P6FfO"}, {"~!@#$%^&*()      ~!@#$%^&*()PNBFRD", "$2a$08$Eq2r4G/76Wv39MzSX262hu", "$2a$08$Eq2r4G/76Wv39MzSX262huzPz612MZiYHVUJe/OcOql2jo4.9UxTW"}, {"~!@#$%^&*()      ~!@#$%^&*()PNBFRD", "$2a$10$LgfYWkbzEvQ4JakH7rOvHe", "$2a$10$LgfYWkbzEvQ4JakH7rOvHe0y8pHKF9OaFgwUZ2q7W2FFZmZzJYlfS"}, {"~!@#$%^&*()      ~!@#$%^&*()PNBFRD", "$2a$12$WApznUOJfkEGSmYRfnkrPO", "$2a$12$WApznUOJfkEGSmYRfnkrPOr466oFDCaj4b6HY3EXGvfxm43seyhgC"}};
    private static final String[][] bcryptTest4 = new String[][]{{"n6Hyjr\u007fYTo/r4lgjvM7L<`iM", "$2a$07$XPrYfnqc5ankSHnRfmPVu.A0trKq3VdczdbJjKaWIksKF.GfFCxv."}, {"~s0quB/K8zRtRT:QtZr`s|^O", "$2a$07$5zzz8omiaStXwOetWwlmuePPRwUt0jhNBPYGGgAMcUDvqsGVqv9Cy"}, {"r>8y3uE}6<7nI34?Q2rR0JEw", "$2a$07$k5AH9bO9aplPYdZMZ155qOcY1FewMXcupWewW6fViUtsVQ2Umg6LS"}, {">l_7}xxH3|Cr{dCR[HTUN@k~", "$2a$05$24xz81ZZsMUMm940bbWMCeHsO.s6A3MG0JZzm4y3.Ti6P96bz6RN6"}, {"D`lCFYTe9_8IW6nEB:oPjEk/S", "$2a$05$bA1xkp4NqFvDmtQJtDO9CugW0INxQLpMZha8AaHmBj9Zg9HlfQtBa"}, {"UBGYU6|a|RpA:bp[;}p.ZY4f1", "$2a$08$gu4KBnkla.bEqHiwaJ8.z.0ixfzE1Q0/iPfmpfRmUA.NUhUdZboxa"}, {"O9X[kP6{63F\u007f3rXKtN>n?zh2_", "$2a$04$yRZW9xEsqN9DL19jveqFyO1bljZ0r5KNCYqQzMqYpDB7XHWqDWNGC"}, {":Sa:Bkne\u007fpsG}\\5dOj>kh0KAk", "$2a$04$KhDTFUlakUsPNuLQSgyr7.xQZxkTSIvo0nFw0XyjvrH6n5kZkYDLG"}, {"2_9J6k:\u007f{z?SSjCzL/GT/5CMgc", "$2a$05$eN1jCXDxN9HmuIARJlwH4ewsEyYbAmq7Cw99gEHqGRXtWyrRNLScy"}, {"2KNy`Kodau14?s8XVru<IIw0eDw|.64MM^Wtv;3sfZt~3`2QN6/U]0\u007f^1HtETqWHt<lMfD-LX::zo7AcNLQ.Q.@.g5kX`j7hRi", "$2a$04$xUNE1aUuNlpNwSOuz1VpjuBgW95ImLccIquQxyGLeinucvokg2Ale"}, {"0yWE>E;h/kdC\u007fR\u007fd@T]fQiv`Vz]KC0zaIAIeyY4zcooQ0^DfP{hHsw9?atO}Cxb\u007fkbnK-LxUe;|FiBEluVqO@ysHhXQDdXPt0p", "$2a$07$pNHi/IxrSUohtsD5/eIv4O324ZPGfJE7mUAaNpIPkpyxjW9kqIk76"}, {"ilWj~2mLBa1Pq`sxrW8fNNq:XF0@KP5RLW9u?[E_wwkROmCSWudYoS5I2HGI-1-?Pd0zVxTIeNbF;nLDUGtce{8dHmx90:;N<8", "$2a$07$ePVgkQl8QKSG2Xv6o0bnOe4SZp4ejag5CP44tjxfmY17F5VzRgwF6"}, {"dj~Os\u007fXmQGj6FXnPGgwg9]G@75~L@G[|e<hgh2vaNqIyYZPh@M;I1DTgZS/~Q:i[6d]oei:\u007fhBw4}{}y7k9K^4So\u007fN}wb8mrg[", "$2a$04$BZT7YoAYAgtNkD0/BOl.jOi0dDni7WtmB8.wAebHeHkOs.TpRgml."}, {"7;PjW]RYJoZXf.r2M^Mm1jVIe0wJ=Kd\u007fd2iUBuu1v3HGI1-S[TB6yg{0~:nbpeA08dysS5d}@Oxbrpj[~i-60mpq1WZqQmSVpnR", "$2a$07$fa9NDzoPKiSWC67cP/tj2OqE0PqvGwzRoJiCKj.czyqKyvpdtVpKe"}, {"8nv;PAN~-FQ]Emh@.TKG=^.t8R0EQC0T?x9|9g4xzxYmSbB\u007fO1qDx8kv-ehh0IBv>3KWhz.Z~jUF0tt8[5U@8;5:=[v6p\u007ff.IEJ", "$2a$08$eXo9KDc1BZyybBgMurpcD.GA1/ch3XhgBnIH10Xvjc2ogZaGg3t/m"}};
    private static final String[][] twoYVec = new String[][]{{"a", "$2y$12$DB3BUbYa/SsEL7kCOVji0OauTkPkB5Y1OeyfxJHM7jvMrbml5sgD2"}, {"abc", "$2y$12$p.xODEbFcXUlHGbNxWZqAe6AA5FWupqXmN9tZea2ACDhwIx4EA2a6"}, {"hello world", "$2y$12$wfkxITYXjNLVpEi9nOjz7uXMhCXKSTY7O2y7X4bwY89aGSvRziguq"}, {"ABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXY", "$2y$12$QwAt5kuG68nW7v.87q0QPuwdki3romFc/RU/RV3Qqk4FPw6WdbQzu"}};
    private static final String[][] twoBVec = new String[][]{{"a", "$2b$12$DB3BUbYa/SsEL7kCOVji0OauTkPkB5Y1OeyfxJHM7jvMrbml5sgD2"}, {"abc", "$2b$12$p.xODEbFcXUlHGbNxWZqAe6AA5FWupqXmN9tZea2ACDhwIx4EA2a6"}, {"hello world", "$2b$12$wfkxITYXjNLVpEi9nOjz7uXMhCXKSTY7O2y7X4bwY89aGSvRziguq"}, {"ABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXY", "$2b$12$QwAt5kuG68nW7v.87q0QPuwdki3romFc/RU/RV3Qqk4FPw6WdbQzu"}};
    private static final String[][] twoVec = new String[][]{{"a", "$2$12$DB3BUbYa/SsEL7kCOVji0OauTkPkB5Y1OeyfxJHM7jvMrbml5sgD2"}, {"abc", "$2$12$p.xODEbFcXUlHGbNxWZqAe6AA5FWupqXmN9tZea2ACDhwIx4EA2a6"}, {"hello world", "$2$12$wfkxITYXjNLVpEi9nOjz7uXMhCXKSTY7O2y7X4bwY89aGSvRziguq"}, {"ABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXY", "$2$12$QwAt5kuG68nW7v.87q0QPuwdki3romFc/RU/RV3Qqk4FPw6WdbQzu"}};
    private static final String[][] twoXVec = new String[][]{{"a", "$2x$12$DB3BUbYa/SsEL7kCOVji0OauTkPkB5Y1OeyfxJHM7jvMrbml5sgD2"}, {"abc", "$2x$12$p.xODEbFcXUlHGbNxWZqAe6AA5FWupqXmN9tZea2ACDhwIx4EA2a6"}, {"hello world", "$2x$12$wfkxITYXjNLVpEi9nOjz7uXMhCXKSTY7O2y7X4bwY89aGSvRziguq"}, {"ABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXYABCDEFGHIJKLMNOPQRSTUVWXY", "$2x$12$QwAt5kuG68nW7v.87q0QPuwdki3romFc/RU/RV3Qqk4FPw6WdbQzu"}};

    public String getName() {
        return "OpenBSDBCrypt";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new OpenBSDBCryptTest());
    }

    private void oldPrefixTest(String[][] stringArray) {
        String string;
        String string2;
        int n = 0;
        while (n < stringArray.length) {
            string2 = stringArray[n][1];
            string = stringArray[n][0];
            if (!OpenBSDBCrypt.checkPassword(string2, string.toCharArray())) {
                this.fail("twoBVec mismatch: [" + n + "] " + string);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            string2 = stringArray[n2][1];
            string = stringArray[n2][0];
            if (!OpenBSDBCrypt.checkPassword(string2, Strings.toUTF8ByteArray(string))) {
                this.fail("twoBVec mismatch: [" + n2 + "] " + string);
            }
            ++n2;
        }
    }

    public void performTest() throws Exception {
        Object object;
        Object object2;
        Object object3;
        this.testPermutations();
        byte[] byArray = new byte[16];
        int n = 0;
        while (n < bcryptTest1.length) {
            String[] stringArray = bcryptTest1[n];
            object3 = stringArray[1].toCharArray();
            object2 = OpenBSDBCrypt.generate(object3, byArray, 4);
            object = OpenBSDBCrypt.generate(Strings.toByteArray(object3), byArray, 4);
            this.isEquals(object2, object);
            ++n;
        }
        int n2 = 0;
        while (n2 < bcryptTest1.length) {
            object3 = bcryptTest1[n2];
            object2 = object3[0];
            object = object3[1];
            if (!OpenBSDBCrypt.checkPassword((String)object2, object.toCharArray())) {
                this.fail("test1 mismatch: [" + n2 + "] " + (String)object);
            }
            ++n2;
        }
        object3 = bcryptTest2[0];
        object2 = bcryptTest2[1];
        if (!OpenBSDBCrypt.checkPassword((String)object3, ((String)object2).toCharArray())) {
            this.fail("bcryptTest2 mismatch: " + (String)object2);
        }
        if (!OpenBSDBCrypt.checkPassword((String)(object3 = (Object)bcryptTest2b[0]), ((String)(object2 = bcryptTest2b[1])).toCharArray())) {
            this.fail("bcryptTest2b mismatch: " + (String)object2);
        }
        int n3 = 0;
        while (n3 < bcryptTest3.length) {
            String[] stringArray = bcryptTest3[n3];
            object3 = stringArray[2];
            object2 = stringArray[0];
            if (!OpenBSDBCrypt.checkPassword((String)object3, ((String)object2).toCharArray())) {
                this.fail("test3 mismatch: [" + n3 + "] " + (String)object2);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < bcryptTest4.length) {
            String[] stringArray = bcryptTest4[n4];
            object3 = stringArray[1];
            object2 = stringArray[0];
            if (!OpenBSDBCrypt.checkPassword((String)object3, ((String)object2).toCharArray())) {
                this.fail("test4 mismatch: [" + n4 + "] " + (String)object2);
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < twoYVec.length) {
            object3 = twoYVec[n5][1];
            object2 = twoYVec[n5][0];
            if (!OpenBSDBCrypt.checkPassword((String)object3, ((String)object2).toCharArray())) {
                this.fail("twoYVec mismatch: [" + n5 + "] " + (String)object2);
            }
            ++n5;
        }
        this.oldPrefixTest(twoBVec);
        this.oldPrefixTest(twoXVec);
        this.oldPrefixTest(twoVec);
        int n6 = 4;
        SecureRandom secureRandom = new SecureRandom();
        byArray = new byte[16];
        int n7 = 0;
        while (n7 < 1000) {
            secureRandom.nextBytes(byArray);
            String string = OpenBSDBCrypt.generate("test-token".toCharArray(), byArray, n6);
            this.isTrue(OpenBSDBCrypt.checkPassword(string, "test-token".toCharArray()));
            this.isTrue(OpenBSDBCrypt.checkPassword(string, "wrong-token".toCharArray()) ^ true);
            ++n7;
        }
    }

    private void permute(ArrayList arrayList, byte[] byArray, int n, int n2) {
        if (n == n2) {
            arrayList.add(Arrays.clone(byArray));
        } else {
            int n3 = n;
            while (n3 <= n2) {
                this.swap(byArray, n, n3);
                this.permute(arrayList, byArray, n + 1, n2);
                this.swap(byArray, n, n3);
                ++n3;
            }
        }
    }

    private void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    public void testPermutations() throws Exception {
        byte[] byArray = Strings.toByteArray("aabcc");
        byte[] byArray2 = null;
        byte[][] byArray3 = new byte[][]{new byte[16], new byte[16], new byte[16]};
        int n = 0;
        while (n < 16) {
            byArray3[1][n] = (byte)n;
            byArray3[2][n] = (byte)(16 - n);
            ++n;
        }
        int n2 = byArray.length - 1;
        while (n2 < byArray.length + 2) {
            byArray2 = new byte[n2];
            int n3 = 0;
            while (n3 < byArray.length) {
                int n4 = 0;
                while (n4 < byArray2.length) {
                    byArray2[n4] = byArray[(n3 + n4) % byArray.length];
                    ++n4;
                }
                ArrayList arrayList = new ArrayList();
                this.permute(arrayList, byArray2, 0, byArray2.length - 1);
                int n5 = 0;
                while (n5 != arrayList.size()) {
                    byte[] byArray4 = (byte[])arrayList.get(n5);
                    int n6 = 0;
                    while (n6 != byArray3.length) {
                        byte[] byArray5 = byArray3[n6];
                        String string = OpenBSDBCrypt.generate(byArray, byArray5, 4);
                        String string2 = OpenBSDBCrypt.generate(byArray4, byArray5, 4);
                        boolean bl = Arrays.areEqual(byArray, byArray4);
                        this.isTrue("expected same result", bl == string.equals(string2));
                        this.isTrue("candidate valid with self", OpenBSDBCrypt.checkPassword(string2, byArray4));
                        boolean bl2 = OpenBSDBCrypt.checkPassword(string, byArray4);
                        this.isTrue("candidate valid with root", bl == bl2);
                        ++n6;
                    }
                    ++n5;
                }
                ++n3;
            }
            ++n2;
        }
    }
}

