/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.macs.SipHash128;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.RNGUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SipHash128Test
extends SimpleTest {
    private static final int UPDATE_BYTES = 0;
    private static final int UPDATE_FULL = 1;
    private static final int UPDATE_MIX = 2;

    public String getName() {
        return "SipHash128";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SipHash128Test());
    }

    public void performTest() throws Exception {
        this.performTest_2_4();
        this.performTest_4_8();
    }

    private void performTest(int n, int n2, int[][] nArray) throws Exception {
        int n3;
        Object object;
        int n4 = nArray.length;
        int n5 = nArray[0].length;
        byte[][] byArray = new byte[n4][];
        int n6 = 0;
        while (n6 < n4) {
            byArray[n6] = new byte[n5];
            int n7 = 0;
            while (n7 < n5) {
                byArray[n6][n7] = (byte)nArray[n6][n7];
                ++n7;
            }
            ++n6;
        }
        byte[] byArray2 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        int n8 = 0;
        while (n8 < n4) {
            object = new byte[n8];
            n3 = 0;
            while (n3 < ((byte[])object).length) {
                object[n3] = (byte)n3;
                ++n3;
            }
            this.runMAC(n, n2, byArray[n8], byArray2, (byte[])object);
            ++n8;
        }
        object = new SecureRandom();
        n3 = 0;
        while (n3 < 100) {
            this.randomTest(n, n2, (SecureRandom)object);
            ++n3;
        }
    }

    private void performTest_2_4() throws Exception {
        int[][] nArrayArray = new int[64][];
        nArrayArray[0] = new int[]{163, 129, 127, 4, 186, 37, 168, 230, 109, 246, 114, 20, 199, 85, 2, 147};
        nArrayArray[1] = new int[]{218, 135, 193, 216, 107, 153, 175, 68, 52, 118, 89, 17, 155, 34, 252, 69};
        nArrayArray[2] = new int[]{129, 119, 34, 141, 164, 164, 93, 199, 252, 163, 139, 222, 246, 10, 255, 228};
        nArrayArray[3] = new int[]{156, 112, 182, 12, 82, 103, 169, 78, 95, 51, 182, 176, 41, 133, 237, 81};
        nArrayArray[4] = new int[]{248, 129, 100, 193, 45, 156, 143, 175, 125, 15, 110, 124, 123, 205, 85, 121};
        nArrayArray[5] = new int[]{19, 104, 135, 89, 128, 119, 111, 136, 84, 82, 122, 7, 105, 14, 150, 39};
        nArrayArray[6] = new int[]{20, 238, 202, 51, 139, 32, 134, 19, 72, 94, 160, 48, 143, 215, 161, 94};
        nArrayArray[7] = new int[]{161, 241, 235, 190, 216, 219, 193, 83, 192, 184, 74, 166, 31, 240, 130, 57};
        nArrayArray[8] = new int[]{59, 98, 169, 186, 98, 88, 245, 97, 15, 131, 226, 100, 243, 20, 151, 180};
        nArrayArray[9] = new int[]{38, 68, 153, 6, 10, 217, 186, 171, 196, 127, 139, 2, 187, 109, 113, 237};
        int[] nArray = new int[16];
        nArray[1] = 17;
        nArray[2] = 13;
        nArray[3] = 195;
        nArray[4] = 120;
        nArray[5] = 20;
        nArray[6] = 105;
        nArray[7] = 86;
        nArray[8] = 201;
        nArray[9] = 84;
        nArray[10] = 71;
        nArray[11] = 211;
        nArray[12] = 243;
        nArray[13] = 208;
        nArray[14] = 251;
        nArray[15] = 186;
        nArrayArray[10] = nArray;
        nArrayArray[11] = new int[]{1, 81, 197, 104, 56, 107, 102, 119, 162, 180, 220, 111, 129, 229, 220, 24};
        nArrayArray[12] = new int[]{214, 38, 178, 102, 144, 94, 243, 88, 130, 99, 77, 246, 133, 50, 193, 37};
        nArrayArray[13] = new int[]{152, 105, 226, 71, 233, 192, 139, 16, 208, 41, 147, 79, 196, 185, 82, 247};
        nArrayArray[14] = new int[]{49, 252, 239, 172, 102, 215, 222, 156, 126, 199, 72, 95, 228, 73, 73, 2};
        nArrayArray[15] = new int[]{84, 147, 233, 153, 51, 176, 168, 17, 126, 8, 236, 15, 151, 207, 195, 217};
        nArrayArray[16] = new int[]{110, 226, 164, 202, 103, 176, 84, 187, 253, 51, 21, 191, 133, 35, 5, 119};
        nArrayArray[17] = new int[]{71, 61, 6, 232, 115, 141, 184, 152, 84, 192, 102, 196, 122, 228, 119, 64};
        nArrayArray[18] = new int[]{164, 38, 229, 228, 35, 191, 72, 133, 41, 77, 164, 129, 254, 174, 247, 35};
        nArrayArray[19] = new int[]{120, 1, 119, 49, 207, 101, 250, 176, 116, 213, 32, 137, 82, 81, 46, 177};
        nArrayArray[20] = new int[]{158, 37, 252, 131, 63, 34, 144, 115, 62, 147, 68, 165, 232, 56, 57, 235};
        nArrayArray[21] = new int[]{86, 142, 73, 90, 190, 82, 90, 33, 138, 34, 20, 205, 62, 7, 29, 18};
        nArrayArray[22] = new int[]{74, 41, 181, 69, 82, 209, 107, 154, 70, 156, 16, 82, 142, 255, 10, 174};
        nArrayArray[23] = new int[]{201, 209, 132, 221, 213, 169, 245, 224, 207, 140, 226, 154, 154, 191, 105, 28};
        nArrayArray[24] = new int[]{45, 180, 121, 174, 120, 189, 80, 216, 136, 42, 138, 23, 138, 97, 50, 173};
        nArrayArray[25] = new int[]{142, 206, 95, 4, 45, 94, 68, 123, 80, 81, 185, 234, 203, 141, 143, 111};
        nArrayArray[26] = new int[]{156, 11, 83, 180, 179, 195, 7, 232, 126, 174, 224, 134, 120, 20, 31, 102};
        nArrayArray[27] = new int[]{171, 242, 72, 175, 105, 166, 234, 228, 191, 211, 235, 47, 18, 158, 235, 148};
        nArrayArray[28] = new int[]{6, 100, 218, 22, 104, 87, 75, 136, 185, 53, 243, 2, 115, 88, 174, 244};
        nArrayArray[29] = new int[]{170, 75, 157, 196, 191, 51, 125, 233, 12, 212, 253, 60, 70, 124, 106, 183};
        nArrayArray[30] = new int[]{234, 92, 127, 71, 31, 175, 107, 222, 43, 26, 215, 212, 104, 109, 34, 135};
        nArrayArray[31] = new int[]{41, 57, 176, 24, 50, 35, 250, 252, 23, 35, 222, 79, 82, 196, 61, 53};
        nArrayArray[32] = new int[]{124, 57, 86, 202, 94, 234, 252, 62, 54, 62, 157, 85, 101, 70, 235, 104};
        nArrayArray[33] = new int[]{119, 198, 7, 113, 70, 240, 28, 50, 182, 182, 157, 95, 78, 169, 255, 207};
        nArrayArray[34] = new int[]{55, 166, 152, 108, 184, 132, 126, 223, 9, 37, 240, 241, 48, 155, 84, 222};
        nArrayArray[35] = new int[]{167, 5, 240, 230, 157, 169, 168, 249, 7, 36, 26, 46, 146, 60, 140, 200};
        nArrayArray[36] = new int[]{61, 196, 125, 31, 41, 196, 72, 70, 30, 158, 118, 237, 144, 79, 103, 17};
        nArrayArray[37] = new int[]{13, 98, 191, 1, 230, 252, 14, 26, 13, 60, 71, 81, 197, 211, 105, 43};
        nArrayArray[38] = new int[]{140, 3, 70, 139, 202, 124, 102, 158, 228, 253, 94, 8, 75, 190, 231, 181};
        nArrayArray[39] = new int[]{82, 138, 91, 185, 59, 175, 44, 156, 68, 115, 204, 229, 208, 210, 43, 217};
        nArrayArray[40] = new int[]{223, 106, 48, 30, 149, 201, 93, 173, 151, 174, 12, 200, 198, 145, 59, 216};
        nArrayArray[41] = new int[]{128, 17, 137, 144, 44, 133, 127, 57, 231, 53, 145, 40, 94, 112, 182, 219};
        nArrayArray[42] = new int[]{230, 23, 52, 106, 201, 194, 49, 187, 54, 80, 174, 52, 204, 202, 12, 91};
        nArrayArray[43] = new int[]{39, 217, 52, 55, 239, 183, 33, 170, 64, 24, 33, 220, 236, 90, 223, 137};
        nArrayArray[44] = new int[]{137, 35, 125, 157, 237, 156, 94, 120, 216, 177, 201, 177, 102, 204, 115, 66};
        nArrayArray[45] = new int[]{74, 109, 128, 145, 191, 94, 125, 101, 17, 137, 250, 148, 162, 80, 177, 76};
        nArrayArray[46] = new int[]{14, 51, 249, 96, 85, 231, 174, 137, 63, 252, 14, 61, 207, 73, 41, 2};
        nArrayArray[47] = new int[]{230, 28, 67, 43, 114, 11, 25, 209, 142, 200, 216, 75, 220, 99, 21, 27};
        nArrayArray[48] = new int[]{247, 229, 174, 245, 73, 247, 130, 207, 55, 144, 85, 166, 8, 38, 155, 22};
        nArrayArray[49] = new int[]{67, 141, 3, 15, 208, 183, 165, 79, 168, 55, 242, 173, 32, 26, 100, 3};
        nArrayArray[50] = new int[]{165, 144, 211, 238, 79, 191, 4, 227, 36, 126, 13, 39, 242, 134, 66, 63};
        nArrayArray[51] = new int[]{95, 226, 193, 161, 114, 254, 147, 196, 177, 92, 211, 124, 174, 249, 245, 56};
        nArrayArray[52] = new int[]{44, 151, 50, 92, 189, 6, 179, 110, 178, 19, 61, 208, 139, 58, 1, 124};
        int[] nArray2 = new int[16];
        nArray2[0] = 146;
        nArray2[1] = 200;
        nArray2[2] = 20;
        nArray2[3] = 34;
        nArray2[4] = 122;
        nArray2[5] = 107;
        nArray2[6] = 202;
        nArray2[7] = 148;
        nArray2[8] = 159;
        nArray2[9] = 240;
        nArray2[10] = 101;
        nArray2[11] = 159;
        nArray2[13] = 42;
        nArray2[14] = 211;
        nArray2[15] = 158;
        nArrayArray[53] = nArray2;
        nArrayArray[54] = new int[]{220, 232, 80, 17, 11, 216, 50, 140, 251, 213, 8, 65, 214, 145, 29, 135};
        nArrayArray[55] = new int[]{103, 241, 73, 132, 199, 218, 121, 18, 72, 227, 43, 181, 146, 37, 131, 218};
        nArrayArray[56] = new int[]{25, 56, 242, 207, 114, 213, 78, 233, 126, 148, 22, 111, 169, 29, 42, 54};
        nArrayArray[57] = new int[]{116, 72, 30, 150, 70, 237, 73, 254, 15, 98, 36, 48, 22, 4, 105, 142};
        int[] nArray3 = new int[16];
        nArray3[0] = 87;
        nArray3[1] = 252;
        nArray3[2] = 165;
        nArray3[3] = 222;
        nArray3[4] = 152;
        nArray3[5] = 169;
        nArray3[6] = 214;
        nArray3[7] = 216;
        nArray3[9] = 100;
        nArray3[10] = 56;
        nArray3[11] = 208;
        nArray3[12] = 88;
        nArray3[13] = 61;
        nArray3[14] = 138;
        nArray3[15] = 29;
        nArrayArray[58] = nArray3;
        nArrayArray[59] = new int[]{159, 236, 222, 28, 239, 220, 28, 190, 212, 118, 54, 116, 217, 87, 83, 89};
        int[] nArray4 = new int[16];
        nArray4[0] = 227;
        nArray4[1] = 4;
        nArray4[2] = 12;
        nArray4[4] = 235;
        nArray4[5] = 40;
        nArray4[6] = 241;
        nArray4[7] = 83;
        nArray4[8] = 102;
        nArray4[9] = 202;
        nArray4[10] = 115;
        nArray4[11] = 203;
        nArray4[12] = 216;
        nArray4[13] = 114;
        nArray4[14] = 231;
        nArray4[15] = 64;
        nArrayArray[60] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[0] = 118;
        nArray5[1] = 151;
        nArray5[3] = 154;
        nArray5[4] = 106;
        nArray5[5] = 131;
        nArray5[6] = 29;
        nArray5[7] = 254;
        nArray5[8] = 204;
        nArray5[9] = 169;
        nArray5[10] = 28;
        nArray5[11] = 89;
        nArray5[12] = 147;
        nArray5[13] = 103;
        nArray5[14] = 15;
        nArray5[15] = 122;
        nArrayArray[61] = nArray5;
        nArrayArray[62] = new int[]{88, 83, 84, 35, 33, 245, 103, 160, 5, 213, 71, 164, 240, 71, 89, 189};
        nArrayArray[63] = new int[]{81, 80, 209, 119, 47, 80, 131, 74, 80, 62, 6, 154, 151, 63, 189, 124};
        int[][] nArrayArray2 = nArrayArray;
        this.performTest(2, 4, nArrayArray2);
    }

    private void performTest_4_8() throws Exception {
        int[][] nArrayArray = new int[64][];
        nArrayArray[0] = new int[]{31, 100, 206, 88, 109, 169, 4, 233, 207, 236, 232, 84, 131, 167, 10, 108};
        nArrayArray[1] = new int[]{71, 52, 93, 168, 239, 76, 121, 71, 106, 242, 124, 167, 145, 199, 162, 128};
        nArrayArray[2] = new int[]{225, 73, 95, 163, 150, 202, 45, 198, 34, 115, 129, 95, 24, 130, 33, 164};
        nArrayArray[3] = new int[]{199, 162, 115, 132, 74, 197, 78, 131, 90, 156, 182, 127, 129, 5, 118, 2};
        nArrayArray[4] = new int[]{84, 31, 82, 187, 244, 62, 206, 78, 42, 149, 200, 224, 31, 101, 109, 239};
        nArrayArray[5] = new int[]{23, 151, 59, 212, 13, 243, 72, 21, 36, 79, 153, 12, 191, 18, 190, 93};
        nArrayArray[6] = new int[]{107, 11, 54, 13, 86, 50, 128, 205, 177, 125, 86, 201, 8, 225, 245, 255};
        int[] nArray = new int[16];
        nArray[0] = 237;
        nArray[2] = 225;
        nArray[3] = 59;
        nArray[4] = 24;
        nArray[5] = 75;
        nArray[6] = 241;
        nArray[7] = 194;
        nArray[8] = 114;
        nArray[9] = 107;
        nArray[10] = 139;
        nArray[11] = 84;
        nArray[12] = 255;
        nArray[13] = 210;
        nArray[14] = 238;
        nArray[15] = 224;
        nArrayArray[7] = nArray;
        nArrayArray[8] = new int[]{167, 217, 70, 19, 143, 249, 237, 245, 54, 74, 90, 35, 175, 202, 224, 99};
        nArrayArray[9] = new int[]{158, 115, 20, 183, 84, 92, 236, 163, 139, 154, 85, 73, 228, 251, 11, 232};
        nArrayArray[10] = new int[]{88, 108, 98, 198, 132, 137, 209, 104, 174, 230, 91, 136, 154, 185, 18, 117};
        nArrayArray[11] = new int[]{230, 113, 82, 166, 76, 163, 209, 71, 196, 171, 132, 30, 47, 46, 122, 153};
        nArrayArray[12] = new int[]{127, 28, 122, 234, 144, 141, 229, 46, 62, 158, 8, 131, 238, 168, 22, 175};
        nArrayArray[13] = new int[]{222, 130, 122, 191, 146, 183, 51, 146, 63, 53, 51, 13, 181, 239, 74, 52};
        nArrayArray[14] = new int[]{89, 117, 99, 100, 15, 55, 154, 197, 55, 103, 142, 226, 53, 76, 125, 249};
        nArrayArray[15] = new int[]{40, 77, 3, 48, 58, 69, 58, 89, 61, 120, 247, 250, 220, 144, 98, 203};
        nArrayArray[16] = new int[]{145, 74, 199, 162, 89, 127, 99, 183, 192, 253, 229, 171, 141, 78, 173, 156};
        nArrayArray[17] = new int[]{13, 81, 21, 164, 75, 164, 85, 238, 58, 69, 59, 149, 206, 135, 195, 203};
        nArrayArray[18] = new int[]{84, 155, 147, 157, 11, 241, 216, 148, 131, 55, 136, 90, 132, 206, 121, 20};
        nArrayArray[19] = new int[]{108, 23, 151, 105, 205, 52, 138, 235, 210, 251, 19, 87, 140, 114, 180, 108};
        int[] nArray2 = new int[16];
        nArray2[0] = 170;
        nArray2[1] = 208;
        nArray2[2] = 54;
        nArray2[3] = 193;
        nArray2[4] = 56;
        nArray2[5] = 201;
        nArray2[6] = 87;
        nArray2[7] = 224;
        nArray2[8] = 104;
        nArray2[9] = 42;
        nArray2[11] = 238;
        nArray2[12] = 47;
        nArray2[13] = 134;
        nArray2[14] = 64;
        nArray2[15] = 139;
        nArrayArray[20] = nArray2;
        nArrayArray[21] = new int[]{33, 177, 238, 196, 47, 182, 112, 191, 238, 144, 68, 255, 78, 215, 58, 38};
        nArrayArray[22] = new int[]{5, 147, 161, 214, 41, 151, 237, 55, 70, 83, 201, 23, 70, 63, 20, 235};
        nArrayArray[23] = new int[]{17, 61, 49, 98, 119, 25, 249, 30, 160, 241, 255, 198, 134, 87, 226, 78};
        nArrayArray[24] = new int[]{179, 57, 76, 247, 45, 224, 106, 221, 14, 115, 20, 240, 194, 82, 196, 214};
        nArrayArray[25] = new int[]{146, 42, 152, 218, 157, 53, 195, 65, 226, 69, 107, 228, 205, 99, 137, 210};
        nArrayArray[26] = new int[]{89, 107, 98, 48, 247, 87, 179, 74, 162, 220, 234, 80, 203, 178, 141, 77};
        nArrayArray[27] = new int[]{194, 78, 228, 151, 213, 91, 126, 128, 6, 132, 223, 117, 101, 89, 238, 72};
        nArrayArray[28] = new int[]{94, 156, 182, 161, 54, 104, 30, 212, 94, 43, 157, 228, 220, 1, 129, 119};
        nArrayArray[29] = new int[]{191, 250, 57, 202, 134, 86, 211, 4, 121, 51, 237, 254, 157, 129, 120, 178};
        nArrayArray[30] = new int[]{24, 34, 148, 24, 161, 208, 121, 90, 53, 122, 128, 58, 129, 52, 174, 163};
        nArrayArray[31] = new int[]{74, 62, 150, 255, 83, 71, 78, 46, 115, 123, 105, 87, 26, 119, 176, 110};
        nArrayArray[32] = new int[]{254, 213, 240, 249, 208, 55, 114, 132, 46, 47, 87, 47, 99, 241, 148, 80};
        nArrayArray[33] = new int[]{57, 51, 88, 134, 193, 249, 66, 99, 196, 12, 102, 41, 198, 188, 68, 111};
        nArrayArray[34] = new int[]{238, 165, 249, 59, 179, 135, 16, 176, 139, 44, 70, 151, 25, 139, 191, 159};
        nArrayArray[35] = new int[]{128, 110, 199, 182, 112, 79, 114, 14, 55, 67, 18, 6, 97, 102, 212, 58};
        nArrayArray[36] = new int[]{110, 105, 237, 157, 240, 201, 57, 180, 157, 175, 238, 174, 96, 71, 178, 162};
        nArrayArray[37] = new int[]{147, 199, 123, 242, 152, 182, 249, 199, 148, 162, 48, 23, 127, 47, 215, 56};
        nArrayArray[38] = new int[]{255, 173, 156, 217, 140, 42, 168, 117, 218, 255, 58, 42, 76, 230, 12, 230};
        nArrayArray[39] = new int[]{77, 153, 47, 253, 249, 74, 147, 205, 205, 100, 239, 118, 87, 245, 16, 227};
        nArrayArray[40] = new int[]{50, 112, 98, 78, 36, 224, 161, 30, 161, 134, 224, 150, 190, 27, 206, 155};
        nArrayArray[41] = new int[]{49, 232, 187, 224, 203, 78, 255, 81, 31, 255, 199, 196, 9, 52, 49, 119};
        nArrayArray[42] = new int[]{203, 225, 125, 5, 135, 154, 217, 7, 100, 138, 18, 160, 112, 22, 171, 91};
        nArrayArray[43] = new int[]{136, 72, 212, 67, 112, 233, 139, 226, 213, 210, 139, 70, 54, 106, 10, 252};
        nArrayArray[44] = new int[]{183, 255, 209, 178, 66, 16, 118, 169, 12, 181, 207, 101, 84, 9, 94, 12};
        nArrayArray[45] = new int[]{106, 107, 102, 108, 213, 35, 168, 246, 187, 216, 132, 254, 31, 209, 5, 12};
        nArrayArray[46] = new int[]{168, 254, 138, 131, 80, 251, 245, 200, 5, 241, 140, 189, 48, 19, 98, 36};
        nArrayArray[47] = new int[]{204, 231, 17, 122, 238, 130, 54, 242, 235, 58, 150, 148, 213, 126, 98, 181};
        nArrayArray[48] = new int[]{58, 37, 240, 228, 252, 40, 183, 12, 107, 48, 144, 186, 254, 246, 159, 4};
        nArrayArray[49] = new int[]{63, 5, 230, 38, 116, 159, 196, 139, 129, 6, 248, 228, 68, 49, 221, 74};
        nArrayArray[50] = new int[]{118, 104, 121, 249, 118, 114, 22, 92, 10, 255, 213, 250, 220, 119, 52, 91};
        nArrayArray[51] = new int[]{67, 113, 160, 90, 182, 108, 89, 139, 201, 194, 132, 148, 161, 221, 47, 14};
        nArrayArray[52] = new int[]{101, 248, 91, 211, 162, 165, 241, 186, 31, 34, 182, 239, 214, 224, 2, 102};
        nArrayArray[53] = new int[]{118, 207, 97, 218, 229, 75, 34, 239, 202, 106, 159, 34, 138, 175, 102, 17};
        nArrayArray[54] = new int[]{108, 220, 194, 227, 159, 219, 162, 159, 136, 83, 144, 171, 157, 164, 132, 218};
        nArrayArray[55] = new int[]{225, 238, 172, 234, 204, 59, 103, 178, 216, 228, 226, 97, 123, 47, 170, 90};
        nArrayArray[56] = new int[]{11, 210, 159, 111, 76, 225, 15, 23, 120, 214, 176, 46, 213, 171, 90, 109};
        nArrayArray[57] = new int[]{173, 24, 159, 21, 106, 82, 38, 124, 224, 135, 69, 131, 91, 101, 166, 7};
        nArrayArray[58] = new int[]{15, 107, 153, 113, 114, 37, 102, 212, 61, 236, 107, 153, 227, 28, 33, 143};
        nArrayArray[59] = new int[]{161, 164, 200, 250, 79, 61, 244, 102, 211, 243, 156, 111, 61, 158, 26, 116};
        nArrayArray[60] = new int[]{59, 26, 61, 184, 140, 240, 194, 31, 193, 166, 216, 167, 45, 158, 249, 29};
        int[] nArray3 = new int[16];
        nArray3[0] = 209;
        nArray3[1] = 72;
        nArray3[2] = 104;
        nArray3[3] = 2;
        nArray3[4] = 239;
        nArray3[5] = 192;
        nArray3[7] = 40;
        nArray3[8] = 86;
        nArray3[9] = 195;
        nArray3[10] = 99;
        nArray3[11] = 90;
        nArray3[12] = 138;
        nArray3[13] = 105;
        nArray3[14] = 46;
        nArray3[15] = 229;
        nArrayArray[61] = nArray3;
        nArrayArray[62] = new int[]{238, 161, 95, 143, 124, 174, 25, 153, 253, 86, 73, 49, 194, 44, 28, 60};
        nArrayArray[63] = new int[]{99, 245, 174, 99, 40, 196, 219, 147, 32, 121, 97, 238, 144, 107, 212, 165};
        int[][] nArrayArray2 = nArrayArray;
        this.performTest(4, 8, nArrayArray2);
    }

    private void randomTest(int n, int n2, SecureRandom secureRandom) {
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        int n3 = 1 + RNGUtils.nextInt(secureRandom, 1024);
        byte[] byArray2 = new byte[n3];
        secureRandom.nextBytes(byArray2);
        SipHash128 sipHash128 = new SipHash128(n, n2);
        sipHash128.init(new KeyParameter(byArray));
        this.updateMAC(sipHash128, byArray2, 0);
        byte[] byArray3 = new byte[16];
        sipHash128.doFinal(byArray3, 0);
        this.updateMAC(sipHash128, byArray2, 1);
        byte[] byArray4 = new byte[16];
        sipHash128.doFinal(byArray4, 0);
        this.updateMAC(sipHash128, byArray2, 2);
        byte[] byArray5 = new byte[16];
        sipHash128.doFinal(byArray5, 0);
        if (!Arrays.areEqual(byArray3, byArray4) || !Arrays.areEqual(byArray3, byArray5)) {
            this.fail("Inconsistent results in random test");
        }
    }

    private void runMAC(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        this.runMAC(n, n2, byArray, byArray2, byArray3, 0);
        this.runMAC(n, n2, byArray, byArray2, byArray3, 1);
        this.runMAC(n, n2, byArray, byArray2, byArray3, 2);
    }

    private void runMAC(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) throws Exception {
        SipHash128 sipHash128 = new SipHash128(n, n2);
        sipHash128.init(new KeyParameter(byArray2));
        this.updateMAC(sipHash128, byArray3, n3);
        byte[] byArray4 = new byte[sipHash128.getMacSize()];
        int n4 = sipHash128.doFinal(byArray4, 0);
        if (n4 != byArray4.length) {
            this.fail("Result length does not equal getMacSize() for doFinal(byte[],int)");
        }
        if (!this.areEqual(byArray, byArray4)) {
            this.fail("Result does not match expected value for doFinal(byte[],int)");
        }
    }

    private void updateMAC(SipHash128 sipHash128, byte[] byArray, int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < byArray.length) {
                    sipHash128.update(byArray[n2]);
                    ++n2;
                }
                break;
            }
            case 1: {
                sipHash128.update(byArray, 0, byArray.length);
                break;
            }
            case 2: {
                int n3 = Math.max(1, byArray.length / 3);
                int n4 = 0;
                while (n4 < byArray.length) {
                    sipHash128.update(byArray[n4++]);
                    int n5 = Math.min(byArray.length - n4, n3);
                    sipHash128.update(byArray, n4, n5);
                    n4 += n5;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

