/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.macs.SipHash;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.test.RNGUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class SipHashTest
extends SimpleTest {
    private static final int UPDATE_BYTES = 0;
    private static final int UPDATE_FULL = 1;
    private static final int UPDATE_MIX = 2;

    public String getName() {
        return "SipHash";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new SipHashTest());
    }

    public void performTest() throws Exception {
        this.performTest_2_4();
        this.performTest_4_8();
    }

    private void performTest(int n, int n2, int[][] nArray) throws Exception {
        int n3;
        Object object;
        int n4 = nArray.length;
        int n5 = nArray[0].length;
        byte[][] byArray = new byte[n4][];
        int n6 = 0;
        while (n6 < n4) {
            byArray[n6] = new byte[n5];
            int n7 = 0;
            while (n7 < n5) {
                byArray[n6][n7] = (byte)nArray[n6][n7];
                ++n7;
            }
            ++n6;
        }
        byte[] byArray2 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        int n8 = 0;
        while (n8 < n4) {
            object = new byte[n8];
            n3 = 0;
            while (n3 < ((byte[])object).length) {
                object[n3] = (byte)n3;
                ++n3;
            }
            this.runMAC(n, n2, byArray[n8], byArray2, (byte[])object);
            ++n8;
        }
        object = new SecureRandom();
        n3 = 0;
        while (n3 < 100) {
            this.randomTest(n, n2, (SecureRandom)object);
            ++n3;
        }
    }

    private void performTest_2_4() throws Exception {
        byte[] byArray = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] byArray2 = Hex.decode("000102030405060708090a0b0c0d0e");
        byte[] byArray3 = Hex.decode("e545be4961ca29a1");
        this.runMAC(2, 4, byArray3, byArray, byArray2);
        int[][] nArrayArray = new int[64][];
        nArrayArray[0] = new int[]{49, 14, 14, 221, 71, 219, 111, 114};
        nArrayArray[1] = new int[]{253, 103, 220, 147, 197, 57, 248, 116};
        nArrayArray[2] = new int[]{90, 79, 169, 217, 9, 128, 108, 13};
        nArrayArray[3] = new int[]{45, 126, 251, 215, 150, 102, 103, 133};
        nArrayArray[4] = new int[]{183, 135, 113, 39, 224, 148, 39, 207};
        nArrayArray[5] = new int[]{141, 166, 153, 205, 100, 85, 118, 24};
        nArrayArray[6] = new int[]{206, 227, 254, 88, 110, 70, 201, 203};
        int[] nArray = new int[8];
        nArray[0] = 55;
        nArray[1] = 209;
        nArray[2] = 1;
        nArray[3] = 139;
        nArray[4] = 245;
        nArray[6] = 2;
        nArray[7] = 171;
        nArrayArray[7] = nArray;
        nArrayArray[8] = new int[]{98, 36, 147, 154, 121, 245, 245, 147};
        int[] nArray2 = new int[8];
        nArray2[0] = 176;
        nArray2[1] = 228;
        nArray2[2] = 169;
        nArray2[3] = 11;
        nArray2[4] = 223;
        nArray2[5] = 130;
        nArray2[7] = 158;
        nArrayArray[9] = nArray2;
        nArrayArray[10] = new int[]{243, 185, 221, 148, 197, 187, 93, 122};
        nArrayArray[11] = new int[]{167, 173, 107, 34, 70, 47, 179, 244};
        nArrayArray[12] = new int[]{251, 229, 14, 134, 188, 143, 30, 117};
        nArrayArray[13] = new int[]{144, 61, 132, 192, 39, 86, 234, 20};
        nArrayArray[14] = new int[]{238, 242, 122, 142, 144, 202, 35, 247};
        nArrayArray[15] = new int[]{229, 69, 190, 73, 97, 202, 41, 161};
        nArrayArray[16] = new int[]{219, 155, 194, 87, 127, 204, 42, 63};
        nArrayArray[17] = new int[]{148, 71, 190, 44, 245, 233, 154, 105};
        nArrayArray[18] = new int[]{156, 211, 141, 150, 240, 179, 193, 75};
        nArrayArray[19] = new int[]{189, 97, 121, 167, 29, 201, 109, 187};
        nArrayArray[20] = new int[]{152, 238, 162, 26, 242, 92, 214, 190};
        nArrayArray[21] = new int[]{199, 103, 59, 46, 176, 203, 242, 208};
        nArrayArray[22] = new int[]{136, 62, 163, 227, 149, 103, 83, 147};
        nArrayArray[23] = new int[]{200, 206, 92, 205, 140, 3, 12, 168};
        nArrayArray[24] = new int[]{148, 175, 73, 246, 198, 80, 173, 184};
        nArrayArray[25] = new int[]{234, 184, 133, 138, 222, 146, 225, 188};
        nArrayArray[26] = new int[]{243, 21, 187, 91, 184, 53, 216, 23};
        nArrayArray[27] = new int[]{173, 207, 107, 7, 99, 97, 46, 47};
        nArrayArray[28] = new int[]{165, 201, 29, 167, 172, 170, 77, 222};
        nArrayArray[29] = new int[]{113, 101, 149, 135, 102, 80, 162, 166};
        nArrayArray[30] = new int[]{40, 239, 73, 92, 83, 163, 135, 173};
        nArrayArray[31] = new int[]{66, 195, 65, 216, 250, 146, 216, 50};
        nArrayArray[32] = new int[]{206, 124, 242, 114, 47, 81, 39, 113};
        nArrayArray[33] = new int[]{227, 120, 89, 249, 70, 35, 243, 167};
        nArrayArray[34] = new int[]{56, 18, 5, 187, 26, 176, 224, 18};
        nArrayArray[35] = new int[]{174, 151, 161, 15, 212, 52, 224, 21};
        nArrayArray[36] = new int[]{180, 163, 21, 8, 190, 255, 77, 49};
        nArrayArray[37] = new int[]{129, 57, 98, 41, 240, 144, 121, 2};
        nArrayArray[38] = new int[]{77, 12, 244, 158, 229, 212, 220, 202};
        nArrayArray[39] = new int[]{92, 115, 51, 106, 118, 216, 191, 154};
        nArrayArray[40] = new int[]{208, 167, 4, 83, 107, 169, 62, 14};
        nArrayArray[41] = new int[]{146, 89, 88, 252, 214, 66, 12, 173};
        nArrayArray[42] = new int[]{169, 21, 194, 155, 200, 6, 115, 24};
        nArrayArray[43] = new int[]{149, 43, 121, 243, 188, 10, 166, 212};
        nArrayArray[44] = new int[]{242, 29, 242, 228, 29, 69, 53, 249};
        nArrayArray[45] = new int[]{135, 87, 117, 25, 4, 143, 83, 169};
        nArrayArray[46] = new int[]{16, 165, 108, 245, 223, 205, 154, 219};
        nArrayArray[47] = new int[]{235, 117, 9, 92, 205, 152, 108, 208};
        nArrayArray[48] = new int[]{81, 169, 203, 158, 203, 163, 18, 230};
        nArrayArray[49] = new int[]{150, 175, 173, 252, 44, 230, 102, 199};
        nArrayArray[50] = new int[]{114, 254, 82, 151, 90, 67, 100, 238};
        nArrayArray[51] = new int[]{90, 22, 69, 178, 118, 213, 146, 161};
        nArrayArray[52] = new int[]{178, 116, 203, 142, 191, 135, 135, 10};
        nArrayArray[53] = new int[]{111, 155, 180, 32, 61, 231, 179, 129};
        nArrayArray[54] = new int[]{234, 236, 178, 163, 11, 34, 168, 127};
        nArrayArray[55] = new int[]{153, 36, 164, 60, 193, 49, 87, 36};
        nArrayArray[56] = new int[]{189, 131, 141, 58, 175, 191, 141, 183};
        nArrayArray[57] = new int[]{11, 26, 42, 50, 101, 213, 26, 234};
        nArrayArray[58] = new int[]{19, 80, 121, 163, 35, 28, 230, 96};
        nArrayArray[59] = new int[]{147, 43, 40, 70, 228, 215, 6, 102};
        nArrayArray[60] = new int[]{225, 145, 95, 92, 177, 236, 164, 108};
        nArrayArray[61] = new int[]{243, 37, 150, 92, 161, 109, 98, 159};
        nArrayArray[62] = new int[]{87, 95, 242, 142, 96, 56, 27, 229};
        nArrayArray[63] = new int[]{114, 69, 6, 235, 76, 50, 138, 149};
        int[][] nArrayArray2 = nArrayArray;
        this.performTest(2, 4, nArrayArray2);
    }

    private void performTest_4_8() throws Exception {
        int[][] nArrayArray = new int[64][];
        nArrayArray[0] = new int[]{65, 218, 56, 153, 43, 5, 121, 200};
        nArrayArray[1] = new int[]{81, 184, 149, 82, 249, 20, 89, 200};
        nArrayArray[2] = new int[]{146, 55, 22, 240, 190, 221, 195, 51};
        nArrayArray[3] = new int[]{106, 70, 212, 125, 101, 71, 193, 5};
        nArrayArray[4] = new int[]{194, 56, 89, 43, 74, 193, 250, 72};
        nArrayArray[5] = new int[]{246, 194, 215, 217, 207, 82, 71, 225};
        nArrayArray[6] = new int[]{107, 182, 188, 52, 200, 53, 85, 142};
        nArrayArray[7] = new int[]{71, 215, 63, 113, 90, 190, 253, 78};
        nArrayArray[8] = new int[]{32, 181, 139, 156, 7, 47, 219, 80};
        nArrayArray[9] = new int[]{54, 49, 154, 243, 94, 225, 18, 83};
        nArrayArray[10] = new int[]{72, 169, 208, 219, 10, 141, 132, 143};
        nArrayArray[11] = new int[]{204, 105, 57, 96, 54, 4, 10, 129};
        nArrayArray[12] = new int[]{75, 109, 104, 83, 122, 167, 151, 97};
        nArrayArray[13] = new int[]{41, 55, 150, 233, 242, 201, 80, 105};
        nArrayArray[14] = new int[]{136, 67, 27, 234, 167, 98, 154, 104};
        nArrayArray[15] = new int[]{224, 166, 169, 125, 213, 137, 211, 131};
        nArrayArray[16] = new int[]{85, 156, 245, 83, 128, 178, 172, 112};
        nArrayArray[17] = new int[]{213, 183, 197, 17, 122, 227, 121, 78};
        nArrayArray[18] = new int[]{90, 60, 69, 70, 52, 173, 16, 43};
        nArrayArray[19] = new int[]{192, 164, 128, 175, 163, 90, 61, 188};
        nArrayArray[20] = new int[]{120, 194, 39, 9, 229, 40, 75, 200};
        nArrayArray[21] = new int[]{239, 38, 112, 70, 13, 235, 214, 157};
        nArrayArray[22] = new int[]{217, 118, 239, 134, 169, 208, 132, 216};
        nArrayArray[23] = new int[]{227, 217, 129, 24, 25, 234, 208, 232};
        nArrayArray[24] = new int[]{137, 51, 60, 181, 62, 234, 236, 22};
        nArrayArray[25] = new int[]{49, 21, 108, 95, 100, 115, 73, 198};
        nArrayArray[26] = new int[]{165, 76, 206, 53, 53, 118, 50, 164};
        nArrayArray[27] = new int[]{6, 93, 137, 37, 192, 167, 210, 254};
        nArrayArray[28] = new int[]{43, 187, 170, 130, 34, 26, 58, 139};
        nArrayArray[29] = new int[]{135, 11, 251, 206, 100, 9, 123, 112};
        nArrayArray[30] = new int[]{64, 216, 224, 249, 100, 149, 238, 139};
        nArrayArray[31] = new int[]{121, 252, 167, 244, 11, 250, 223, 18};
        int[] nArray = new int[8];
        nArray[1] = 11;
        nArray[2] = 251;
        nArray[3] = 242;
        nArray[4] = 47;
        nArray[5] = 118;
        nArray[6] = 158;
        nArray[7] = 210;
        nArrayArray[32] = nArray;
        nArrayArray[33] = new int[]{64, 104, 85, 145, 248, 229, 34, 250};
        nArrayArray[34] = new int[]{43, 230, 254, 116, 216, 20, 157, 13};
        nArrayArray[35] = new int[]{186, 126, 47, 14, 11, 117, 96, 237};
        nArrayArray[36] = new int[]{2, 233, 227, 132, 237, 167, 225, 151};
        nArrayArray[37] = new int[]{196, 232, 10, 98, 149, 39, 99, 182};
        nArrayArray[38] = new int[]{131, 39, 237, 198, 93, 92, 109, 211};
        nArrayArray[39] = new int[]{121, 252, 100, 209, 100, 164, 47, 192};
        nArrayArray[40] = new int[]{21, 74, 117, 17, 203, 252, 97, 78};
        nArrayArray[41] = new int[]{139, 20, 141, 124, 236, 160, 230, 111};
        nArrayArray[42] = new int[]{223, 238, 105, 182, 84, 196, 3, 250};
        nArrayArray[43] = new int[]{197, 143, 54, 166, 105, 123, 183, 201};
        nArrayArray[44] = new int[]{166, 197, 190, 156, 5, 198, 49, 33};
        nArrayArray[45] = new int[]{181, 138, 135, 89, 251, 205, 137, 49};
        nArrayArray[46] = new int[]{215, 104, 58, 103, 4, 204, 196, 37};
        nArrayArray[47] = new int[]{203, 106, 230, 225, 229, 162, 68, 141};
        nArrayArray[48] = new int[]{110, 38, 105, 91, 58, 58, 81, 115};
        nArrayArray[49] = new int[]{120, 113, 7, 207, 159, 51, 172, 74};
        nArrayArray[50] = new int[]{22, 117, 144, 218, 217, 123, 116, 132};
        int[] nArray2 = new int[8];
        nArray2[1] = 107;
        nArray2[2] = 104;
        nArray2[3] = 30;
        nArray2[4] = 240;
        nArray2[5] = 107;
        nArray2[6] = 243;
        nArray2[7] = 6;
        nArrayArray[51] = nArray2;
        nArrayArray[52] = new int[]{28, 155, 48, 2, 102, 239, 207, 166};
        nArrayArray[53] = new int[]{40, 141, 47, 136, 209, 176, 179, 75};
        nArrayArray[54] = new int[]{224, 17, 6, 189, 172, 245, 107, 254};
        nArrayArray[55] = new int[]{192, 16, 31, 14, 91, 110, 3, 40};
        nArrayArray[56] = new int[]{195, 167, 145, 69, 91, 27, 28, 10};
        nArrayArray[57] = new int[]{87, 7, 175, 225, 158, 11, 58, 15};
        nArrayArray[58] = new int[]{230, 90, 114, 41, 254, 83, 89, 79};
        int[] nArray3 = new int[8];
        nArray3[1] = 47;
        nArray3[2] = 157;
        nArray3[3] = 185;
        nArray3[4] = 171;
        nArray3[5] = 26;
        nArray3[6] = 175;
        nArray3[7] = 76;
        nArrayArray[59] = nArray3;
        nArrayArray[60] = new int[]{89, 40, 203, 80, 68, 193, 6, 6};
        nArrayArray[61] = new int[]{213, 56, 1, 150, 123, 133, 115, 33};
        nArrayArray[62] = new int[]{5, 219, 54, 79, 26, 9, 153, 204};
        nArrayArray[63] = new int[]{230, 119, 132, 188, 85, 3, 222, 35};
        int[][] nArrayArray2 = nArrayArray;
        this.performTest(4, 8, nArrayArray2);
    }

    private void randomTest(int n, int n2, SecureRandom secureRandom) {
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        int n3 = 1 + RNGUtils.nextInt(secureRandom, 1024);
        byte[] byArray2 = new byte[n3];
        secureRandom.nextBytes(byArray2);
        SipHash sipHash = new SipHash(n, n2);
        sipHash.init(new KeyParameter(byArray));
        this.updateMAC(sipHash, byArray2, 0);
        byte[] byArray3 = new byte[16];
        sipHash.doFinal(byArray3, 0);
        this.updateMAC(sipHash, byArray2, 1);
        byte[] byArray4 = new byte[16];
        sipHash.doFinal(byArray4, 0);
        this.updateMAC(sipHash, byArray2, 2);
        byte[] byArray5 = new byte[16];
        sipHash.doFinal(byArray5, 0);
        if (!Arrays.areEqual(byArray3, byArray4) || !Arrays.areEqual(byArray3, byArray5)) {
            this.fail("Inconsistent results in random test");
        }
    }

    private void runMAC(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        this.runMAC(n, n2, byArray, byArray2, byArray3, 0);
        this.runMAC(n, n2, byArray, byArray2, byArray3, 1);
        this.runMAC(n, n2, byArray, byArray2, byArray3, 2);
    }

    private void runMAC(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) throws Exception {
        long l = Pack.littleEndianToLong(byArray, 0);
        SipHash sipHash = new SipHash(n, n2);
        sipHash.init(new KeyParameter(byArray2));
        this.updateMAC(sipHash, byArray3, n3);
        long l2 = sipHash.doFinal();
        if (l != l2) {
            this.fail("Result does not match expected value for doFinal()");
        }
        this.updateMAC(sipHash, byArray3, n3);
        byte[] byArray4 = new byte[sipHash.getMacSize()];
        int n4 = sipHash.doFinal(byArray4, 0);
        if (n4 != byArray4.length) {
            this.fail("Result length does not equal getMacSize() for doFinal(byte[],int)");
        }
        if (!this.areEqual(byArray, byArray4)) {
            this.fail("Result does not match expected value for doFinal(byte[],int)");
        }
    }

    private void updateMAC(SipHash sipHash, byte[] byArray, int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < byArray.length) {
                    sipHash.update(byArray[n2]);
                    ++n2;
                }
                break;
            }
            case 1: {
                sipHash.update(byArray, 0, byArray.length);
                break;
            }
            case 2: {
                int n3 = Math.max(1, byArray.length / 3);
                int n4 = 0;
                while (n4 < byArray.length) {
                    sipHash.update(byArray[n4++]);
                    int n5 = Math.min(byArray.length - n4, n3);
                    sipHash.update(byArray, n4, n5);
                    n4 += n5;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

