/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.ecgost;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.agreement.ECVKOAgreement;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithUKM;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private String kaAlgorithm;
    private ECDomainParameters parameters;
    private ECVKOAgreement agreement;
    private byte[] result;
    static /* synthetic */ Class class$org$bouncycastle$jce$interfaces$ECPublicKey;
    static /* synthetic */ Class class$org$bouncycastle$jce$interfaces$ECPrivateKey;

    protected KeyAgreementSpi(String string, ECVKOAgreement eCVKOAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.kaAlgorithm = string;
        this.agreement = eCVKOAgreement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] doCalcSecret() {
        return this.result;
    }

    protected void doInitFromKey(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(String.valueOf(this.kaAlgorithm) + " key agreement requires " + KeyAgreementSpi.getSimpleName(class$org$bouncycastle$jce$interfaces$ECPrivateKey != null ? class$org$bouncycastle$jce$interfaces$ECPrivateKey : (class$org$bouncycastle$jce$interfaces$ECPrivateKey = KeyAgreementSpi.class$("org.bouncycastle.jce.interfaces.ECPrivateKey"))) + " for initialisation");
        }
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.parameters = eCPrivateKeyParameters.getParameters();
        this.ukmParameters = algorithmParameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial() : null;
        this.agreement.init(new ParametersWithUKM(eCPrivateKeyParameters, this.ukmParameters));
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException(String.valueOf(this.kaAlgorithm) + " not initialised.");
        }
        if (!bl) {
            throw new IllegalStateException(String.valueOf(this.kaAlgorithm) + " can only be between two parties.");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(String.valueOf(this.kaAlgorithm) + " key agreement requires " + KeyAgreementSpi.getSimpleName(class$org$bouncycastle$jce$interfaces$ECPublicKey != null ? class$org$bouncycastle$jce$interfaces$ECPublicKey : (class$org$bouncycastle$jce$interfaces$ECPublicKey = KeyAgreementSpi.class$("org.bouncycastle.jce.interfaces.ECPublicKey"))) + " for doPhase");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = KeyAgreementSpi.generatePublicKeyParameter((PublicKey)key);
        try {
            this.result = this.agreement.calculateAgreement(asymmetricKeyParameter);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("calculation failed: " + exception.getMessage()){

                public Throwable getCause() {
                    return exception;
                }
            };
        }
        return null;
    }

    static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        return publicKey instanceof BCECPublicKey ? ((BCECGOST3410PublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    private static String getSimpleName(Class clazz) {
        String string = clazz.getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static class ECVKO
    extends KeyAgreementSpi {
        public ECVKO() {
            super("ECGOST3410", new ECVKOAgreement(new GOST3411Digest()), null);
        }
    }
}

