/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.cert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.cert.CertSelector;
import org.bouncycastle.jce.cert.CertUtil;
import org.bouncycastle.util.Integers;

public class X509CertSelector
implements CertSelector {
    private static final Hashtable keyPurposeIdMap = new Hashtable();
    private X509Certificate x509Cert = null;
    private BigInteger serialNumber = null;
    private Object issuerDN = null;
    private X509Name issuerDNX509 = null;
    private Object subjectDN = null;
    private X509Name subjectDNX509 = null;
    private byte[] subjectKeyID = null;
    private byte[] authorityKeyID = null;
    private Date certValid = null;
    private Date privateKeyValid = null;
    private ASN1ObjectIdentifier subjectKeyAlgID = null;
    private PublicKey subjectPublicKey = null;
    private byte[] subjectPublicKeyByte = null;
    private boolean[] keyUsage = null;
    private Set keyPurposeSet = null;
    private boolean matchAllSubjectAltNames = true;
    private Set subjectAltNames = null;
    private Set subjectAltNamesByte = null;
    private int minMaxPathLen = -1;
    private Set policy = null;
    private Set policyOID = null;
    private Set pathToNames = null;
    private Set pathToNamesByte = null;

    static {
        keyPurposeIdMap.put(KeyPurposeId.id_kp_serverAuth.getId(), KeyPurposeId.id_kp_serverAuth);
        keyPurposeIdMap.put(KeyPurposeId.id_kp_clientAuth.getId(), KeyPurposeId.id_kp_clientAuth);
        keyPurposeIdMap.put(KeyPurposeId.id_kp_codeSigning.getId(), KeyPurposeId.id_kp_codeSigning);
        keyPurposeIdMap.put(KeyPurposeId.id_kp_emailProtection.getId(), KeyPurposeId.id_kp_emailProtection);
        keyPurposeIdMap.put(KeyPurposeId.id_kp_ipsecEndSystem.getId(), KeyPurposeId.id_kp_ipsecEndSystem);
        keyPurposeIdMap.put(KeyPurposeId.id_kp_ipsecTunnel.getId(), KeyPurposeId.id_kp_ipsecTunnel);
        keyPurposeIdMap.put(KeyPurposeId.id_kp_ipsecUser.getId(), KeyPurposeId.id_kp_ipsecUser);
        keyPurposeIdMap.put(KeyPurposeId.id_kp_timeStamping.getId(), KeyPurposeId.id_kp_timeStamping);
    }

    public void addPathToName(int n, String string) throws IOException {
        byte[] byArray = CertUtil.parseGeneralName(n, string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Integers.valueOf(n));
        arrayList.add(string);
        this.pathToNames.add(arrayList);
        arrayList.set(1, byArray);
        this.pathToNamesByte.add(arrayList);
        throw new UnsupportedOperationException();
    }

    public void addPathToName(int n, byte[] byArray) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Integers.valueOf(n));
        arrayList.add(byArray.clone());
        this.pathToNames.add(arrayList);
        this.pathToNamesByte.add(arrayList);
    }

    public void addSubjectAlternativeName(int n, String string) throws IOException {
        byte[] byArray = CertUtil.parseGeneralName(n, string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Integers.valueOf(n));
        arrayList.add(string);
        this.subjectAltNames.add(arrayList);
        arrayList.set(1, byArray);
        this.subjectAltNamesByte.add(arrayList);
    }

    public void addSubjectAlternativeName(int n, byte[] byArray) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Integers.valueOf(n));
        arrayList.add(byArray.clone());
        this.subjectAltNames.add(arrayList);
        this.subjectAltNamesByte.add(arrayList);
    }

    public Object clone() {
        try {
            ArrayList<Object> arrayList;
            List list;
            Iterator iterator;
            X509CertSelector x509CertSelector = (X509CertSelector)super.clone();
            if (this.issuerDN instanceof byte[]) {
                x509CertSelector.issuerDN = ((byte[])this.issuerDN).clone();
            }
            if (this.subjectDN instanceof byte[]) {
                x509CertSelector.subjectDN = ((byte[])this.subjectDN).clone();
            }
            if (this.subjectKeyID != null) {
                x509CertSelector.subjectKeyID = (byte[])this.subjectKeyID.clone();
            }
            if (this.authorityKeyID != null) {
                x509CertSelector.authorityKeyID = (byte[])this.authorityKeyID.clone();
            }
            if (this.subjectPublicKeyByte != null) {
                x509CertSelector.subjectPublicKeyByte = (byte[])this.subjectPublicKeyByte.clone();
            }
            if (this.keyUsage != null) {
                x509CertSelector.keyUsage = (boolean[])this.keyUsage.clone();
            }
            if (this.keyPurposeSet != null) {
                x509CertSelector.keyPurposeSet = new HashSet(this.keyPurposeSet);
            }
            if (this.policy != null) {
                x509CertSelector.policy = new HashSet(this.policy);
                x509CertSelector.policyOID = new HashSet();
                iterator = this.policyOID.iterator();
                while (iterator.hasNext()) {
                    x509CertSelector.policyOID.add(new ASN1ObjectIdentifier(((ASN1ObjectIdentifier)iterator.next()).getId()));
                }
            }
            if (this.subjectAltNames != null) {
                x509CertSelector.subjectAltNames = new HashSet(this.getSubjectAlternativeNames());
                iterator = this.subjectAltNamesByte.iterator();
                while (iterator.hasNext()) {
                    list = (List)iterator.next();
                    arrayList = new ArrayList<Object>();
                    arrayList.add(list.get(0));
                    arrayList.add(((byte[])list.get(1)).clone());
                    x509CertSelector.subjectAltNamesByte.add(arrayList);
                }
            }
            if (this.pathToNames != null) {
                x509CertSelector.pathToNames = new HashSet(this.getPathToNames());
                iterator = this.pathToNamesByte.iterator();
                while (iterator.hasNext()) {
                    list = (List)iterator.next();
                    arrayList = new ArrayList();
                    arrayList.add(list.get(0));
                    arrayList.add(((byte[])list.get(1)).clone());
                    x509CertSelector.pathToNamesByte.add(arrayList);
                }
            }
            return x509CertSelector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public byte[] getAuthorityKeyIdentifier() {
        if (this.authorityKeyID != null) {
            return (byte[])this.authorityKeyID.clone();
        }
        return null;
    }

    public int getBasicConstraints() {
        return this.minMaxPathLen;
    }

    public X509Certificate getCertificate() {
        return this.x509Cert;
    }

    public Date getCertificateValid() {
        if (this.certValid != null) {
            return new Date(this.certValid.getTime());
        }
        return null;
    }

    public Set getExtendedKeyUsage() {
        if (this.keyPurposeSet == null || this.keyPurposeSet.isEmpty()) {
            return this.keyPurposeSet;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.keyPurposeSet.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().toString());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public byte[] getIssuerAsBytes() throws IOException {
        if (this.issuerDN instanceof byte[]) {
            return (byte[])((byte[])this.issuerDN).clone();
        }
        if (this.issuerDNX509 != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
            aSN1OutputStream.writeObject(this.issuerDNX509.toASN1Primitive());
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getIssuerAsString() {
        if (this.issuerDN instanceof String) {
            return new String((String)this.issuerDN);
        }
        if (this.issuerDNX509 != null) {
            return this.issuerDNX509.toString();
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllSubjectAltNames;
    }

    public byte[] getNameConstraints() {
        throw new UnsupportedOperationException();
    }

    public Collection getPathToNames() {
        if (this.pathToNames == null) {
            return null;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.pathToNames.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(list.get(0));
            if (list.get(1) instanceof byte[]) {
                arrayList.add(((byte[])list.get(1)).clone());
            } else {
                arrayList.add(list.get(1));
            }
            hashSet.add(arrayList);
        }
        return hashSet;
    }

    public Set getPolicy() {
        if (this.policy == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.policy);
    }

    public Date getPrivateKeyValid() {
        if (this.privateKeyValid != null) {
            return new Date(this.privateKeyValid.getTime());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public Collection getSubjectAlternativeNames() {
        if (this.subjectAltNames != null) {
            return null;
        }
        HashSet hashSet = new HashSet();
        Iterator iterator = this.subjectAltNames.iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(list.get(0));
            if (list.get(1) instanceof byte[]) {
                arrayList.add(((byte[])list.get(1)).clone());
            } else {
                arrayList.add(list.get(1));
            }
            hashSet.add(arrayList);
        }
        return hashSet;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        if (this.subjectDN instanceof byte[]) {
            return (byte[])((byte[])this.subjectDN).clone();
        }
        if (this.subjectDNX509 != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
            aSN1OutputStream.writeObject(this.subjectDNX509.toASN1Primitive());
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getSubjectAsString() {
        if (this.subjectDN instanceof String) {
            return new String((String)this.subjectDN);
        }
        if (this.subjectDNX509 != null) {
            return this.subjectDNX509.toString();
        }
        return null;
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyID != null) {
            return (byte[])this.subjectKeyID.clone();
        }
        return null;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public String getSubjectPublicKeyAlgID() {
        if (this.subjectKeyAlgID != null) {
            return this.subjectKeyAlgID.toString();
        }
        return null;
    }

    public boolean match(Certificate certificate) {
        boolean[] blArray;
        ASN1Primitive aSN1Primitive;
        Object object;
        ASN1InputStream aSN1InputStream;
        Object object2;
        Object object3;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (this.x509Cert != null && !this.x509Cert.equals(x509Certificate)) {
            return false;
        }
        if (this.serialNumber != null && !this.serialNumber.equals(x509Certificate.getSerialNumber())) {
            return false;
        }
        try {
            if (this.issuerDNX509 != null && !this.issuerDNX509.equals(PrincipalUtil.getIssuerX509Principal(x509Certificate), true)) {
                return false;
            }
            if (this.subjectDNX509 != null && !this.subjectDNX509.equals(PrincipalUtil.getSubjectX509Principal(x509Certificate), true)) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (this.subjectKeyID != null) {
            object3 = x509Certificate.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
            if (object3 == null) {
                return false;
            }
            try {
                object2 = new ByteArrayInputStream((byte[])object3);
                aSN1InputStream = new ASN1InputStream((InputStream)object2);
                object = ((ASN1OctetString)aSN1InputStream.readObject()).getOctets();
                if (!Arrays.equals(this.subjectKeyID, (byte[])object)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (this.authorityKeyID != null) {
            object3 = x509Certificate.getExtensionValue(X509Extensions.AuthorityKeyIdentifier.getId());
            if (object3 == null) {
                return false;
            }
            try {
                object2 = new ByteArrayInputStream((byte[])object3);
                aSN1InputStream = new ASN1InputStream((InputStream)object2);
                object = ((ASN1OctetString)aSN1InputStream.readObject()).getOctets();
                if (!Arrays.equals(this.authorityKeyID, (byte[])object)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (this.certValid != null) {
            if (x509Certificate.getNotAfter() != null && this.certValid.after(x509Certificate.getNotAfter())) {
                return false;
            }
            if (x509Certificate.getNotBefore() != null && this.certValid.before(x509Certificate.getNotBefore())) {
                return false;
            }
        }
        if (this.privateKeyValid != null) {
            try {
                object3 = x509Certificate.getExtensionValue(X509Extensions.PrivateKeyUsagePeriod.getId());
                if (object3 != null) {
                    object2 = new ByteArrayInputStream((byte[])object3);
                    aSN1InputStream = new ASN1InputStream((InputStream)object2);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssZ");
                    object2 = new ByteArrayInputStream(((ASN1OctetString)aSN1InputStream.readObject()).getOctets());
                    object = (ASN1Sequence)(aSN1InputStream = new ASN1InputStream((InputStream)object2)).readObject();
                    aSN1Primitive = ASN1GeneralizedTime.getInstance(((ASN1Sequence)object).getObjectAt(0));
                    if (this.privateKeyValid.before(simpleDateFormat.parse(((ASN1GeneralizedTime)aSN1Primitive).getTime()))) {
                        return false;
                    }
                    aSN1Primitive = ASN1GeneralizedTime.getInstance(((ASN1Sequence)object).getObjectAt(1));
                    if (this.privateKeyValid.after(simpleDateFormat.parse(((ASN1GeneralizedTime)aSN1Primitive).getTime()))) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.subjectKeyAlgID != null) {
            try {
                object3 = SubjectPublicKeyInfo.getInstance(x509Certificate.getPublicKey().getEncoded());
                object2 = object3.getAlgorithmId();
                if (!((AlgorithmIdentifier)object2).getAlgorithm().equals(this.subjectKeyAlgID)) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.subjectPublicKeyByte != null && !Arrays.equals(this.subjectPublicKeyByte, x509Certificate.getPublicKey().getEncoded())) {
            return false;
        }
        if (this.subjectPublicKey != null && !this.subjectPublicKey.equals(x509Certificate.getPublicKey())) {
            return false;
        }
        if (this.keyUsage != null && (blArray = x509Certificate.getKeyUsage()) != null) {
            int n = 0;
            while (n < this.keyUsage.length) {
                if (this.keyUsage[n] && (blArray.length <= n || !blArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        if (this.keyPurposeSet != null && !this.keyPurposeSet.isEmpty()) {
            try {
                byte[] byArray = x509Certificate.getExtensionValue(X509Extensions.ExtendedKeyUsage.getId());
                if (byArray != null) {
                    object2 = new ByteArrayInputStream(byArray);
                    aSN1InputStream = new ASN1InputStream((InputStream)object2);
                    object = ExtendedKeyUsage.getInstance(aSN1InputStream.readObject());
                    Iterator iterator = this.keyPurposeSet.iterator();
                    while (iterator.hasNext()) {
                        if (((ExtendedKeyUsage)object).hasKeyPurposeId((KeyPurposeId)iterator.next())) continue;
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.minMaxPathLen != -1) {
            if (this.minMaxPathLen == -2 && x509Certificate.getBasicConstraints() != -1) {
                return false;
            }
            if (this.minMaxPathLen >= 0 && x509Certificate.getBasicConstraints() < this.minMaxPathLen) {
                return false;
            }
        }
        if (this.policyOID != null) {
            try {
                byte[] byArray = x509Certificate.getExtensionValue(X509Extensions.CertificatePolicies.getId());
                if (byArray == null) {
                    return false;
                }
                if (!this.policyOID.isEmpty()) {
                    object2 = new ByteArrayInputStream(byArray);
                    aSN1InputStream = new ASN1InputStream((InputStream)object2);
                    object2 = new ByteArrayInputStream(((ASN1OctetString)aSN1InputStream.readObject()).getOctets());
                    aSN1InputStream = new ASN1InputStream((InputStream)object2);
                    object = ((ASN1Sequence)aSN1InputStream.readObject()).getObjects();
                    boolean bl = false;
                    while (object.hasMoreElements() && !bl) {
                        aSN1Primitive = (ASN1Sequence)object.nextElement();
                        if (!this.policyOID.contains(((ASN1Sequence)aSN1Primitive).getObjectAt(0))) continue;
                        bl = true;
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (this.subjectAltNamesByte != null) {
            try {
                byte[] byArray = x509Certificate.getExtensionValue(X509Extensions.SubjectAlternativeName.getId());
                if (byArray == null) {
                    return false;
                }
                object2 = new ByteArrayInputStream(byArray);
                aSN1InputStream = new ASN1InputStream((InputStream)object2);
                object2 = new ByteArrayInputStream(((ASN1OctetString)aSN1InputStream.readObject()).getOctets());
                aSN1InputStream = new ASN1InputStream((InputStream)object2);
                object = ((ASN1Sequence)aSN1InputStream.readObject()).getObjects();
                boolean bl = false;
                HashSet hashSet = new HashSet(this.subjectAltNamesByte);
                while (object.hasMoreElements() && !bl) {
                    aSN1Primitive = (ASN1TaggedObject)object.nextElement();
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(Integers.valueOf(((ASN1TaggedObject)aSN1Primitive).getTagNo()));
                    ASN1Primitive aSN1Primitive2 = ((ASN1TaggedObject)aSN1Primitive).getObject();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(byteArrayOutputStream, "DER");
                    aSN1OutputStream.writeObject((ASN1Encodable)aSN1Primitive2);
                    aSN1OutputStream.close();
                    arrayList.add(byteArrayOutputStream.toByteArray());
                    if (hashSet.remove(arrayList)) {
                        bl = true;
                    }
                    if (!this.matchAllSubjectAltNames || hashSet.isEmpty()) continue;
                    bl = false;
                }
                if (!bl) {
                    return false;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.authorityKeyID = (byte[])(byArray == null ? null : (byte[])byArray.clone());
    }

    public void setBasicConstraints(int n) {
        if (n < -2) {
            throw new IllegalArgumentException("minMaxPathLen must be >= -2");
        }
        this.minMaxPathLen = n;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.x509Cert = x509Certificate;
    }

    public void setCertificateValid(Date date) {
        this.certValid = date == null ? null : new Date(date.getTime());
    }

    public void setExtendedKeyUsage(Set set) throws IOException {
        if (set == null || set.isEmpty()) {
            this.keyPurposeSet = set;
        } else {
            this.keyPurposeSet = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof String)) continue;
                KeyPurposeId keyPurposeId = (KeyPurposeId)keyPurposeIdMap.get((String)e);
                if (keyPurposeId == null) {
                    throw new IOException("unknown purposeID " + (String)e);
                }
                this.keyPurposeSet.add(keyPurposeId);
            }
        }
    }

    public void setIssuer(String string) throws IOException {
        if (string == null) {
            this.issuerDN = null;
            this.issuerDNX509 = null;
        } else {
            X509Name x509Name;
            try {
                x509Name = new X509Name(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
            this.issuerDNX509 = x509Name;
            this.issuerDN = string;
        }
    }

    public void setIssuer(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.issuerDN = null;
            this.issuerDNX509 = null;
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            if (!(aSN1Primitive instanceof ASN1Sequence)) {
                throw new IOException("parsing error");
            }
            this.issuerDNX509 = new X509Name((ASN1Sequence)aSN1Primitive);
            this.issuerDN = (byte[])byArray.clone();
        }
    }

    public void setKeyUsage(boolean[] blArray) {
        this.keyUsage = (boolean[])(blArray == null ? null : (boolean[])blArray.clone());
    }

    public void setMatchAllSubjectAltNames(boolean bl) {
        this.matchAllSubjectAltNames = bl;
    }

    public void setNameConstraints(byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setPathToNames(Collection collection) throws IOException {
        try {
            if (collection == null || collection.isEmpty()) {
                this.pathToNames = null;
                this.pathToNamesByte = null;
            } else {
                this.pathToNames = new HashSet();
                this.pathToNamesByte = new HashSet();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    int n = (Integer)list.get(0);
                    Object e = list.get(1);
                    if (e instanceof String) {
                        this.addPathToName(n, (String)e);
                        continue;
                    }
                    if (e instanceof byte[]) {
                        this.addPathToName(n, (byte[])e);
                        continue;
                    }
                    throw new IOException("parsing error: unknown data type");
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("parsing exception:\n" + exception.toString());
        }
    }

    public void setPolicy(Set set) throws IOException {
        if (set == null) {
            this.policy = null;
            this.policyOID = null;
        } else {
            this.policyOID = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof String) {
                    CertUtil.parseOID((String)e);
                    this.policyOID.add(new ASN1ObjectIdentifier((String)e));
                    continue;
                }
                throw new IOException("certPolicySet contains null values or non String objects");
            }
            this.policy = new HashSet(set);
        }
    }

    public void setPrivateKeyValid(Date date) {
        this.privateKeyValid = date == null ? null : new Date(date.getTime());
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger;
    }

    public void setSubject(String string) throws IOException {
        if (string == null) {
            this.subjectDN = null;
            this.subjectDNX509 = null;
        } else {
            X509Name x509Name;
            try {
                x509Name = new X509Name(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
            this.subjectDNX509 = x509Name;
            this.subjectDN = string;
        }
    }

    public void setSubject(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectDN = null;
            this.subjectDNX509 = null;
        } else {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            if (!(aSN1Primitive instanceof ASN1Sequence)) {
                throw new IOException("parsing error");
            }
            this.subjectDNX509 = new X509Name((ASN1Sequence)aSN1Primitive);
            this.subjectDN = (byte[])byArray.clone();
        }
    }

    public void setSubjectAlternativeNames(Collection collection) throws IOException {
        try {
            if (collection == null || collection.isEmpty()) {
                this.subjectAltNames = null;
                this.subjectAltNamesByte = null;
            } else {
                this.subjectAltNames = new HashSet();
                this.subjectAltNamesByte = new HashSet();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    List list = (List)iterator.next();
                    int n = (Integer)list.get(0);
                    Object e = list.get(1);
                    if (e instanceof String) {
                        this.addSubjectAlternativeName(n, (String)e);
                        continue;
                    }
                    if (e instanceof byte[]) {
                        this.addSubjectAlternativeName(n, (byte[])e);
                        continue;
                    }
                    throw new IOException("parsing error: unknown data type");
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("parsing exception:\n" + exception.toString());
        }
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyID = (byte[])(byArray == null ? null : (byte[])byArray.clone());
    }

    public void setSubjectPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            this.subjectPublicKey = null;
            this.subjectPublicKeyByte = null;
        } else {
            this.subjectPublicKey = publicKey;
            this.subjectPublicKeyByte = publicKey.getEncoded();
        }
    }

    public void setSubjectPublicKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectPublicKey = null;
            this.subjectPublicKeyByte = null;
        } else {
            this.subjectPublicKey = null;
            this.subjectPublicKeyByte = (byte[])byArray.clone();
        }
    }

    public void setSubjectPublicKeyAlgID(String string) throws IOException {
        if (string != null) {
            CertUtil.parseOID(string);
            this.subjectKeyAlgID = new ASN1ObjectIdentifier(string);
        } else {
            this.subjectKeyAlgID = null;
        }
    }

    public String toString() {
        ASN1Primitive aSN1Primitive;
        ASN1InputStream aSN1InputStream;
        Object object;
        Object object2;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CertSelector: [\n");
        if (this.x509Cert != null) {
            stringBuffer.append("  Certificate: ").append(this.x509Cert).append('\n');
        }
        if (this.serialNumber != null) {
            stringBuffer.append("  Serial Number: ").append(this.serialNumber).append('\n');
        }
        if (this.issuerDN != null) {
            stringBuffer.append("  Issuer: ").append(this.getIssuerAsString()).append('\n');
        }
        if (this.subjectDN != null) {
            stringBuffer.append("  Subject: ").append(this.getSubjectAsString()).append('\n');
        }
        try {
            if (this.subjectKeyID != null) {
                iterator = new ByteArrayInputStream(this.subjectKeyID);
                object2 = new ASN1InputStream((InputStream)((Object)iterator));
                object = ((ASN1InputStream)object2).readObject();
                stringBuffer.append("  Subject Key Identifier: ").append(ASN1Dump.dumpAsString(object)).append('\n');
            }
            if (this.authorityKeyID != null) {
                iterator = new ByteArrayInputStream(this.authorityKeyID);
                object2 = new ASN1InputStream((InputStream)((Object)iterator));
                object = ((ASN1InputStream)object2).readObject();
                stringBuffer.append("  Authority Key Identifier: ").append(ASN1Dump.dumpAsString(object)).append('\n');
            }
        }
        catch (IOException iOException) {
            stringBuffer.append(iOException.getMessage()).append('\n');
        }
        if (this.certValid != null) {
            stringBuffer.append("  Certificate Valid: ").append(this.certValid).append('\n');
        }
        if (this.privateKeyValid != null) {
            stringBuffer.append("  Private Key Valid: ").append(this.privateKeyValid).append('\n');
        }
        if (this.subjectKeyAlgID != null) {
            stringBuffer.append("  Subject Public Key AlgID: ").append(this.subjectKeyAlgID).append('\n');
        }
        if (this.subjectPublicKey != null) {
            stringBuffer.append("  Subject Public Key: ").append(this.subjectPublicKey).append('\n');
        }
        if (this.keyUsage != null) {
            stringBuffer.append("  Key Usage: ").append(this.keyUsage).append('\n');
        }
        if (this.keyPurposeSet != null) {
            stringBuffer.append("  Extended Key Usage: ").append(this.keyPurposeSet).append('\n');
        }
        if (this.policy != null) {
            stringBuffer.append("  Policy: ").append(this.policy).append('\n');
        }
        stringBuffer.append("  matchAllSubjectAltNames flag: ").append(this.matchAllSubjectAltNames).append('\n');
        if (this.subjectAltNamesByte != null) {
            stringBuffer.append("   SubjectAlternativNames: \n[");
            iterator = this.subjectAltNamesByte.iterator();
            try {
                while (iterator.hasNext()) {
                    object2 = (List)iterator.next();
                    object = new ByteArrayInputStream((byte[])object2.get(1));
                    aSN1InputStream = new ASN1InputStream((InputStream)object);
                    aSN1Primitive = aSN1InputStream.readObject();
                    stringBuffer.append("  Type: ").append(object2.get(0)).append(" Data: ").append(ASN1Dump.dumpAsString(aSN1Primitive)).append('\n');
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException.getMessage()).append('\n');
            }
            stringBuffer.append("]\n");
        }
        if (this.pathToNamesByte != null) {
            stringBuffer.append("   PathToNamesNames: \n[");
            iterator = this.pathToNamesByte.iterator();
            try {
                while (iterator.hasNext()) {
                    object2 = (List)iterator.next();
                    object = new ByteArrayInputStream((byte[])object2.get(1));
                    aSN1InputStream = new ASN1InputStream((InputStream)object);
                    aSN1Primitive = aSN1InputStream.readObject();
                    stringBuffer.append("  Type: ").append(object2.get(0)).append(" Data: ").append(ASN1Dump.dumpAsString(aSN1Primitive)).append('\n');
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException.getMessage()).append('\n');
            }
            stringBuffer.append("]\n");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

