/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECLookupTable;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.ECPointMap;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.FixedPointPreCompInfo;
import org.bouncycastle.math.ec.FixedPointUtil;
import org.bouncycastle.math.ec.WNafPreCompInfo;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.math.ec.endo.ECEndomorphism;
import org.bouncycastle.math.ec.endo.EndoUtil;
import org.bouncycastle.math.ec.endo.GLVEndomorphism;
import org.bouncycastle.math.field.FiniteField;
import org.bouncycastle.math.field.PolynomialExtensionField;
import org.bouncycastle.math.raw.Nat;

public class ECAlgorithms {
    public static ECPoint cleanPoint(ECCurve eCCurve, ECPoint eCPoint) {
        ECCurve eCCurve2 = eCPoint.getCurve();
        if (!eCCurve.equals(eCCurve2)) {
            throw new IllegalArgumentException("Point must be on the same curve");
        }
        return eCCurve.decodePoint(eCPoint.getEncoded(false));
    }

    static ECPoint implCheckResult(ECPoint eCPoint) {
        if (!eCPoint.isValidPartial()) {
            throw new IllegalStateException("Invalid result");
        }
        return eCPoint;
    }

    private static ECPoint implShamirsTrickFixedPoint(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        int n;
        ECCurve eCCurve = eCPoint.getCurve();
        int n2 = FixedPointUtil.getCombSize(eCCurve);
        if (bigInteger.bitLength() > n2 || bigInteger2.bitLength() > n2) {
            throw new IllegalStateException("fixed-point comb doesn't support scalars larger than the curve order");
        }
        FixedPointPreCompInfo fixedPointPreCompInfo = FixedPointUtil.precompute(eCPoint);
        FixedPointPreCompInfo fixedPointPreCompInfo2 = FixedPointUtil.precompute(eCPoint2);
        ECLookupTable eCLookupTable = fixedPointPreCompInfo.getLookupTable();
        ECLookupTable eCLookupTable2 = fixedPointPreCompInfo2.getLookupTable();
        int n3 = fixedPointPreCompInfo.getWidth();
        if (n3 != (n = fixedPointPreCompInfo2.getWidth())) {
            FixedPointCombMultiplier fixedPointCombMultiplier = new FixedPointCombMultiplier();
            ECPoint eCPoint3 = fixedPointCombMultiplier.multiply(eCPoint, bigInteger);
            ECPoint eCPoint4 = fixedPointCombMultiplier.multiply(eCPoint2, bigInteger2);
            return eCPoint3.add(eCPoint4);
        }
        int n4 = n3;
        int n5 = (n2 + n4 - 1) / n4;
        ECPoint eCPoint5 = eCCurve.getInfinity();
        int n6 = n5 * n4;
        int[] nArray = Nat.fromBigInteger(n6, bigInteger);
        int[] nArray2 = Nat.fromBigInteger(n6, bigInteger2);
        int n7 = n6 - 1;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = 0;
            int n10 = 0;
            int n11 = n7 - n8;
            while (n11 >= 0) {
                int n12 = nArray[n11 >>> 5] >>> (n11 & 0x1F);
                n9 ^= n12 >>> 1;
                n9 <<= 1;
                n9 ^= n12;
                int n13 = nArray2[n11 >>> 5] >>> (n11 & 0x1F);
                n10 ^= n13 >>> 1;
                n10 <<= 1;
                n10 ^= n13;
                n11 -= n5;
            }
            ECPoint eCPoint6 = eCLookupTable.lookupVar(n9);
            ECPoint eCPoint7 = eCLookupTable2.lookupVar(n10);
            ECPoint eCPoint8 = eCPoint6.add(eCPoint7);
            eCPoint5 = eCPoint5.twicePlus(eCPoint8);
            ++n8;
        }
        return eCPoint5.add(fixedPointPreCompInfo.getOffset()).add(fixedPointPreCompInfo2.getOffset());
    }

    static ECPoint implShamirsTrickJsf(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        ECCurve eCCurve = eCPoint.getCurve();
        ECPoint eCPoint3 = eCCurve.getInfinity();
        ECPoint eCPoint4 = eCPoint.add(eCPoint2);
        ECPoint eCPoint5 = eCPoint.subtract(eCPoint2);
        ECPoint[] eCPointArray = new ECPoint[]{eCPoint2, eCPoint5, eCPoint, eCPoint4};
        eCCurve.normalizeAll(eCPointArray);
        ECPoint[] eCPointArray2 = new ECPoint[]{eCPointArray[3].negate(), eCPointArray[2].negate(), eCPointArray[1].negate(), eCPointArray[0].negate(), eCPoint3, eCPointArray[0], eCPointArray[1], eCPointArray[2], eCPointArray[3]};
        byte[] byArray = WNafUtil.generateJSF(bigInteger, bigInteger2);
        ECPoint eCPoint6 = eCPoint3;
        int n = byArray.length;
        while (--n >= 0) {
            byte by = byArray[n];
            int n2 = by << 24 >> 28;
            int n3 = by << 28 >> 28;
            int n4 = 4 + n2 * 3 + n3;
            eCPoint6 = eCPoint6.twicePlus(eCPointArray2[n4]);
        }
        return eCPoint6;
    }

    static ECPoint implShamirsTrickWNaf(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() < 0;
        boolean bl2 = bigInteger2.signum() < 0;
        BigInteger bigInteger3 = bigInteger.abs();
        BigInteger bigInteger4 = bigInteger2.abs();
        int n = WNafUtil.getWindowSize(bigInteger3.bitLength(), 8);
        int n2 = WNafUtil.getWindowSize(bigInteger4.bitLength(), 8);
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n, true);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precompute(eCPoint2, n2, true);
        ECCurve eCCurve = eCPoint.getCurve();
        int n3 = FixedPointUtil.getCombSize(eCCurve);
        if (!bl && !bl2 && bigInteger.bitLength() <= n3 && bigInteger2.bitLength() <= n3 && wNafPreCompInfo.isPromoted() && wNafPreCompInfo2.isPromoted()) {
            return ECAlgorithms.implShamirsTrickFixedPoint(eCPoint, bigInteger, eCPoint2, bigInteger2);
        }
        int n4 = Math.min(8, wNafPreCompInfo.getWidth());
        int n5 = Math.min(8, wNafPreCompInfo2.getWidth());
        ECPoint[] eCPointArray = bl ? wNafPreCompInfo.getPreCompNeg() : wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray2 = bl2 ? wNafPreCompInfo2.getPreCompNeg() : wNafPreCompInfo2.getPreComp();
        ECPoint[] eCPointArray3 = bl ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
        ECPoint[] eCPointArray4 = bl2 ? wNafPreCompInfo2.getPreComp() : wNafPreCompInfo2.getPreCompNeg();
        byte[] byArray = WNafUtil.generateWindowNaf(n4, bigInteger3);
        byte[] byArray2 = WNafUtil.generateWindowNaf(n5, bigInteger4);
        return ECAlgorithms.implShamirsTrickWNaf(eCPointArray, eCPointArray3, byArray, eCPointArray2, eCPointArray4, byArray2);
    }

    static ECPoint implShamirsTrickWNaf(ECEndomorphism eCEndomorphism, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        boolean bl = bigInteger.signum() < 0;
        boolean bl2 = bigInteger2.signum() < 0;
        bigInteger = bigInteger.abs();
        bigInteger2 = bigInteger2.abs();
        int n = WNafUtil.getWindowSize(Math.max(bigInteger.bitLength(), bigInteger2.bitLength()), 8);
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n, true);
        ECPoint eCPoint2 = EndoUtil.mapPoint(eCEndomorphism, eCPoint);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precomputeWithPointMap(eCPoint2, eCEndomorphism.getPointMap(), wNafPreCompInfo, true);
        int n2 = Math.min(8, wNafPreCompInfo.getWidth());
        int n3 = Math.min(8, wNafPreCompInfo2.getWidth());
        ECPoint[] eCPointArray = bl ? wNafPreCompInfo.getPreCompNeg() : wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray2 = bl2 ? wNafPreCompInfo2.getPreCompNeg() : wNafPreCompInfo2.getPreComp();
        ECPoint[] eCPointArray3 = bl ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
        ECPoint[] eCPointArray4 = bl2 ? wNafPreCompInfo2.getPreComp() : wNafPreCompInfo2.getPreCompNeg();
        byte[] byArray = WNafUtil.generateWindowNaf(n2, bigInteger);
        byte[] byArray2 = WNafUtil.generateWindowNaf(n3, bigInteger2);
        return ECAlgorithms.implShamirsTrickWNaf(eCPointArray, eCPointArray3, byArray, eCPointArray2, eCPointArray4, byArray2);
    }

    private static ECPoint implShamirsTrickWNaf(ECPoint[] eCPointArray, ECPoint[] eCPointArray2, byte[] byArray, ECPoint[] eCPointArray3, ECPoint[] eCPointArray4, byte[] byArray2) {
        ECPoint eCPoint;
        int n = Math.max(byArray.length, byArray2.length);
        ECCurve eCCurve = eCPointArray[0].getCurve();
        ECPoint eCPoint2 = eCPoint = eCCurve.getInfinity();
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            byte by;
            byte by2 = n3 < byArray.length ? byArray[n3] : (byte)0;
            byte by3 = by = n3 < byArray2.length ? byArray2[n3] : (byte)0;
            if ((by2 | by) == 0) {
                ++n2;
            } else {
                ECPoint[] eCPointArray5;
                int n4;
                ECPoint eCPoint3 = eCPoint;
                if (by2 != 0) {
                    n4 = Math.abs(by2);
                    eCPointArray5 = by2 < 0 ? eCPointArray2 : eCPointArray;
                    eCPoint3 = eCPoint3.add(eCPointArray5[n4 >>> 1]);
                }
                if (by != 0) {
                    n4 = Math.abs(by);
                    eCPointArray5 = by < 0 ? eCPointArray4 : eCPointArray3;
                    eCPoint3 = eCPoint3.add(eCPointArray5[n4 >>> 1]);
                }
                if (n2 > 0) {
                    eCPoint2 = eCPoint2.timesPow2(n2);
                    n2 = 0;
                }
                eCPoint2 = eCPoint2.twicePlus(eCPoint3);
            }
            --n3;
        }
        if (n2 > 0) {
            eCPoint2 = eCPoint2.timesPow2(n2);
        }
        return eCPoint2;
    }

    static ECPoint implSumOfMultiplies(ECEndomorphism eCEndomorphism, ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        int n = eCPointArray.length;
        int n2 = n << 1;
        boolean[] blArray = new boolean[n2];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n2];
        byte[][] byArray = new byte[n2][];
        ECPointMap eCPointMap = eCEndomorphism.getPointMap();
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 << 1;
            int n5 = n4 + 1;
            BigInteger bigInteger = bigIntegerArray[n4];
            blArray[n4] = bigInteger.signum() < 0;
            bigInteger = bigInteger.abs();
            BigInteger bigInteger2 = bigIntegerArray[n5];
            blArray[n5] = bigInteger2.signum() < 0;
            bigInteger2 = bigInteger2.abs();
            int n6 = WNafUtil.getWindowSize(Math.max(bigInteger.bitLength(), bigInteger2.bitLength()), 8);
            ECPoint eCPoint = eCPointArray[n3];
            WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n6, true);
            ECPoint eCPoint2 = EndoUtil.mapPoint(eCEndomorphism, eCPoint);
            WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.precomputeWithPointMap(eCPoint2, eCPointMap, wNafPreCompInfo, true);
            int n7 = Math.min(8, wNafPreCompInfo.getWidth());
            int n8 = Math.min(8, wNafPreCompInfo2.getWidth());
            wNafPreCompInfoArray[n4] = wNafPreCompInfo;
            wNafPreCompInfoArray[n5] = wNafPreCompInfo2;
            byArray[n4] = WNafUtil.generateWindowNaf(n7, bigInteger);
            byArray[n5] = WNafUtil.generateWindowNaf(n8, bigInteger2);
            ++n3;
        }
        return ECAlgorithms.implSumOfMultiplies(blArray, wNafPreCompInfoArray, byArray);
    }

    static ECPoint implSumOfMultiplies(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        int n = eCPointArray.length;
        boolean[] blArray = new boolean[n];
        WNafPreCompInfo[] wNafPreCompInfoArray = new WNafPreCompInfo[n];
        byte[][] byArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            BigInteger bigInteger = bigIntegerArray[n2];
            blArray[n2] = bigInteger.signum() < 0;
            bigInteger = bigInteger.abs();
            int n3 = WNafUtil.getWindowSize(bigInteger.bitLength(), 8);
            WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPointArray[n2], n3, true);
            int n4 = Math.min(8, wNafPreCompInfo.getWidth());
            wNafPreCompInfoArray[n2] = wNafPreCompInfo;
            byArray[n2] = WNafUtil.generateWindowNaf(n4, bigInteger);
            ++n2;
        }
        return ECAlgorithms.implSumOfMultiplies(blArray, wNafPreCompInfoArray, byArray);
    }

    private static ECPoint implSumOfMultiplies(boolean[] blArray, WNafPreCompInfo[] wNafPreCompInfoArray, byte[][] byArray) {
        ECPoint eCPoint;
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n = Math.max(n, byArray[n3].length);
            ++n3;
        }
        ECCurve eCCurve = wNafPreCompInfoArray[0].getPreComp()[0].getCurve();
        ECPoint eCPoint2 = eCPoint = eCCurve.getInfinity();
        int n4 = 0;
        int n5 = n - 1;
        while (n5 >= 0) {
            ECPoint eCPoint3 = eCPoint;
            int n6 = 0;
            while (n6 < n2) {
                byte by;
                byte[] byArray2 = byArray[n6];
                byte by2 = by = n5 < byArray2.length ? byArray2[n5] : (byte)0;
                if (by != 0) {
                    int n7 = Math.abs(by);
                    WNafPreCompInfo wNafPreCompInfo = wNafPreCompInfoArray[n6];
                    ECPoint[] eCPointArray = by < 0 == blArray[n6] ? wNafPreCompInfo.getPreComp() : wNafPreCompInfo.getPreCompNeg();
                    eCPoint3 = eCPoint3.add(eCPointArray[n7 >>> 1]);
                }
                ++n6;
            }
            if (eCPoint3 == eCPoint) {
                ++n4;
            } else {
                if (n4 > 0) {
                    eCPoint2 = eCPoint2.timesPow2(n4);
                    n4 = 0;
                }
                eCPoint2 = eCPoint2.twicePlus(eCPoint3);
            }
            --n5;
        }
        if (n4 > 0) {
            eCPoint2 = eCPoint2.timesPow2(n4);
        }
        return eCPoint2;
    }

    static ECPoint implSumOfMultipliesGLV(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray, GLVEndomorphism gLVEndomorphism) {
        Object[] objectArray;
        BigInteger bigInteger = eCPointArray[0].getCurve().getOrder();
        int n = eCPointArray.length;
        BigInteger[] bigIntegerArray2 = new BigInteger[n << 1];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            objectArray = gLVEndomorphism.decomposeScalar(bigIntegerArray[n2].mod(bigInteger));
            bigIntegerArray2[n3++] = objectArray[0];
            bigIntegerArray2[n3++] = objectArray[1];
            ++n2;
        }
        if (gLVEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implSumOfMultiplies(gLVEndomorphism, eCPointArray, bigIntegerArray2);
        }
        objectArray = new ECPoint[n << 1];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n) {
            ECPoint eCPoint = eCPointArray[n4];
            ECPoint eCPoint2 = EndoUtil.mapPoint(gLVEndomorphism, eCPoint);
            objectArray[n5++] = eCPoint;
            objectArray[n5++] = eCPoint2;
            ++n4;
        }
        return ECAlgorithms.implSumOfMultiplies((ECPoint[])objectArray, bigIntegerArray2);
    }

    public static ECPoint importPoint(ECCurve eCCurve, ECPoint eCPoint) {
        ECCurve eCCurve2 = eCPoint.getCurve();
        if (!eCCurve.equals(eCCurve2)) {
            throw new IllegalArgumentException("Point must be on the same curve");
        }
        return eCCurve.importPoint(eCPoint);
    }

    public static boolean isF2mCurve(ECCurve eCCurve) {
        return ECAlgorithms.isF2mField(eCCurve.getField());
    }

    public static boolean isF2mField(FiniteField finiteField) {
        return finiteField.getDimension() > 1 && finiteField.getCharacteristic().equals(ECConstants.TWO) && finiteField instanceof PolynomialExtensionField;
    }

    public static boolean isFpCurve(ECCurve eCCurve) {
        return ECAlgorithms.isFpField(eCCurve.getField());
    }

    public static boolean isFpField(FiniteField finiteField) {
        return finiteField.getDimension() == 1;
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n, int n2) {
        ECAlgorithms.montgomeryTrick(eCFieldElementArray, n, n2, null);
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n, int n2, ECFieldElement eCFieldElement) {
        ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[n2];
        eCFieldElementArray2[0] = eCFieldElementArray[n];
        int n3 = 0;
        while (++n3 < n2) {
            eCFieldElementArray2[n3] = eCFieldElementArray2[n3 - 1].multiply(eCFieldElementArray[n + n3]);
        }
        --n3;
        if (eCFieldElement != null) {
            eCFieldElementArray2[n3] = eCFieldElementArray2[n3].multiply(eCFieldElement);
        }
        ECFieldElement eCFieldElement2 = eCFieldElementArray2[n3].invert();
        while (n3 > 0) {
            int n4 = n + n3--;
            ECFieldElement eCFieldElement3 = eCFieldElementArray[n4];
            eCFieldElementArray[n4] = eCFieldElementArray2[n3].multiply(eCFieldElement2);
            eCFieldElement2 = eCFieldElement2.multiply(eCFieldElement3);
        }
        eCFieldElementArray[n] = eCFieldElement2;
    }

    public static ECPoint referenceMultiply(ECPoint eCPoint, BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.abs();
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n = bigInteger2.bitLength();
        if (n > 0) {
            if (bigInteger2.testBit(0)) {
                eCPoint2 = eCPoint;
            }
            int n2 = 1;
            while (n2 < n) {
                eCPoint = eCPoint.twice();
                if (bigInteger2.testBit(n2)) {
                    eCPoint2 = eCPoint2.add(eCPoint);
                }
                ++n2;
            }
        }
        return bigInteger.signum() < 0 ? eCPoint2.negate() : eCPoint2;
    }

    public static ECPoint shamirsTrick(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        ECCurve eCCurve = eCPoint.getCurve();
        eCPoint2 = ECAlgorithms.importPoint(eCCurve, eCPoint2);
        return ECAlgorithms.implCheckResult(ECAlgorithms.implShamirsTrickJsf(eCPoint, bigInteger, eCPoint2, bigInteger2));
    }

    public static ECPoint sumOfMultiplies(ECPoint[] eCPointArray, BigInteger[] bigIntegerArray) {
        if (eCPointArray == null || bigIntegerArray == null || eCPointArray.length != bigIntegerArray.length || eCPointArray.length < 1) {
            throw new IllegalArgumentException("point and scalar arrays should be non-null, and of equal, non-zero, length");
        }
        int n = eCPointArray.length;
        switch (n) {
            case 1: {
                return eCPointArray[0].multiply(bigIntegerArray[0]);
            }
            case 2: {
                return ECAlgorithms.sumOfTwoMultiplies(eCPointArray[0], bigIntegerArray[0], eCPointArray[1], bigIntegerArray[1]);
            }
        }
        ECPoint eCPoint = eCPointArray[0];
        ECCurve eCCurve = eCPoint.getCurve();
        ECPoint[] eCPointArray2 = new ECPoint[n];
        eCPointArray2[0] = eCPoint;
        int n2 = 1;
        while (n2 < n) {
            eCPointArray2[n2] = ECAlgorithms.importPoint(eCCurve, eCPointArray[n2]);
            ++n2;
        }
        ECEndomorphism eCEndomorphism = eCCurve.getEndomorphism();
        if (eCEndomorphism instanceof GLVEndomorphism) {
            return ECAlgorithms.implCheckResult(ECAlgorithms.implSumOfMultipliesGLV(eCPointArray2, bigIntegerArray, (GLVEndomorphism)eCEndomorphism));
        }
        return ECAlgorithms.implCheckResult(ECAlgorithms.implSumOfMultiplies(eCPointArray2, bigIntegerArray));
    }

    public static ECPoint sumOfTwoMultiplies(ECPoint eCPoint, BigInteger bigInteger, ECPoint eCPoint2, BigInteger bigInteger2) {
        Object object;
        ECCurve eCCurve = eCPoint.getCurve();
        eCPoint2 = ECAlgorithms.importPoint(eCCurve, eCPoint2);
        if (eCCurve instanceof ECCurve.AbstractF2m && ((ECCurve.AbstractF2m)(object = (ECCurve.AbstractF2m)eCCurve)).isKoblitz()) {
            return ECAlgorithms.implCheckResult(eCPoint.multiply(bigInteger).add(eCPoint2.multiply(bigInteger2)));
        }
        object = eCCurve.getEndomorphism();
        if (object instanceof GLVEndomorphism) {
            return ECAlgorithms.implCheckResult(ECAlgorithms.implSumOfMultipliesGLV(new ECPoint[]{eCPoint, eCPoint2}, new BigInteger[]{bigInteger, bigInteger2}, (GLVEndomorphism)object));
        }
        return ECAlgorithms.implCheckResult(ECAlgorithms.implShamirsTrickWNaf(eCPoint, bigInteger, eCPoint2, bigInteger2));
    }

    public static ECPoint validatePoint(ECPoint eCPoint) {
        if (!eCPoint.isValid()) {
            throw new IllegalStateException("Invalid point");
        }
        return eCPoint;
    }
}

