/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sphincsplus;

import org.bouncycastle.pqc.crypto.sphincsplus.ADRS;
import org.bouncycastle.pqc.crypto.sphincsplus.SPHINCSPlusEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

class WotsPlus {
    private final SPHINCSPlusEngine engine;
    private final int w;

    WotsPlus(SPHINCSPlusEngine sPHINCSPlusEngine) {
        this.engine = sPHINCSPlusEngine;
        this.w = this.engine.WOTS_W;
    }

    int[] base_w(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        byte by = 0;
        int n5 = 0;
        int[] nArray = new int[n2];
        int n6 = 0;
        while (n6 < n2) {
            if (n5 == 0) {
                by = byArray[n3];
                ++n3;
                n5 += 8;
            }
            nArray[n4] = by >>> (n5 -= this.engine.WOTS_LOGW) & n - 1;
            ++n4;
            ++n6;
        }
        return nArray;
    }

    byte[] chain(byte[] byArray, int n, int n2, byte[] byArray2, ADRS aDRS) {
        if (n2 == 0) {
            return Arrays.clone(byArray);
        }
        if (n + n2 > this.w - 1) {
            return null;
        }
        byte[] byArray3 = this.chain(byArray, n, n2 - 1, byArray2, aDRS);
        aDRS.setHashAddress(n + n2 - 1);
        byArray3 = this.engine.F(byArray2, aDRS, byArray3);
        return byArray3;
    }

    public byte[] pkFromSig(byte[] byArray, byte[] byArray2, byte[] byArray3, ADRS aDRS) {
        int n = 0;
        ADRS aDRS2 = new ADRS(aDRS);
        int[] nArray = this.base_w(byArray2, this.w, this.engine.WOTS_LEN1);
        int n2 = 0;
        while (n2 < this.engine.WOTS_LEN1) {
            n += this.w - 1 - nArray[n2];
            ++n2;
        }
        int n3 = (this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW + 7) / 8;
        nArray = Arrays.concatenate(nArray, this.base_w(Arrays.copyOfRange(Pack.intToBigEndian(n <<= 8 - this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW % 8), 4 - n3, 4), this.w, this.engine.WOTS_LEN2));
        byte[] byArray4 = new byte[this.engine.N];
        byte[][] byArray5 = new byte[this.engine.WOTS_LEN][];
        int n4 = 0;
        while (n4 < this.engine.WOTS_LEN) {
            aDRS.setChainAddress(n4);
            System.arraycopy(byArray, n4 * this.engine.N, byArray4, 0, this.engine.N);
            byArray5[n4] = this.chain(byArray4, nArray[n4], this.w - 1 - nArray[n4], byArray3, aDRS);
            ++n4;
        }
        aDRS2.setType(1);
        aDRS2.setKeyPairAddress(aDRS.getKeyPairAddress());
        return this.engine.T_l(byArray3, aDRS2, Arrays.concatenate(byArray5));
    }

    byte[] pkGen(byte[] byArray, byte[] byArray2, ADRS aDRS) {
        ADRS aDRS2 = new ADRS(aDRS);
        byte[][] byArray3 = new byte[this.engine.WOTS_LEN][];
        int n = 0;
        while (n < this.engine.WOTS_LEN) {
            ADRS aDRS3 = new ADRS(aDRS);
            aDRS3.setChainAddress(n);
            aDRS3.setHashAddress(0);
            byte[] byArray4 = this.engine.PRF(byArray2, byArray, aDRS3);
            byArray3[n] = this.chain(byArray4, 0, this.w - 1, byArray2, aDRS3);
            ++n;
        }
        aDRS2.setType(1);
        aDRS2.setKeyPairAddress(aDRS.getKeyPairAddress());
        return this.engine.T_l(byArray2, aDRS2, Arrays.concatenate(byArray3));
    }

    public byte[] sign(byte[] byArray, byte[] byArray2, byte[] byArray3, ADRS aDRS) {
        ADRS aDRS2 = new ADRS(aDRS);
        int n = 0;
        int[] nArray = this.base_w(byArray, this.w, this.engine.WOTS_LEN1);
        int n2 = 0;
        while (n2 < this.engine.WOTS_LEN1) {
            n += this.w - 1 - nArray[n2];
            ++n2;
        }
        if (this.engine.WOTS_LOGW % 8 != 0) {
            n <<= 8 - this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW % 8;
        }
        int n3 = (this.engine.WOTS_LEN2 * this.engine.WOTS_LOGW + 7) / 8;
        byte[] byArray4 = Pack.intToBigEndian(n);
        nArray = Arrays.concatenate(nArray, this.base_w(Arrays.copyOfRange(byArray4, n3, byArray4.length), this.w, this.engine.WOTS_LEN2));
        byte[][] byArray5 = new byte[this.engine.WOTS_LEN][];
        int n4 = 0;
        while (n4 < this.engine.WOTS_LEN) {
            aDRS2.setChainAddress(n4);
            aDRS2.setHashAddress(0);
            byte[] byArray6 = this.engine.PRF(byArray3, byArray2, aDRS2);
            byArray5[n4] = this.chain(byArray6, 0, nArray[n4], byArray3, aDRS2);
            ++n4;
        }
        return Arrays.concatenate(byArray5);
    }
}

