/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyPairGenerator;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceKobaraImaiCipher;
import org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.test.SimpleTest;

public class McElieceKobaraImaiCipherTest
extends SimpleTest {
    SecureRandom keyRandom = new SecureRandom();

    private void checkEncoding() throws Exception {
        this.checkEncoding(new McElieceCCA2Parameters("SHA-1"));
        this.checkEncoding(new McElieceCCA2Parameters("SHA-224"));
        this.checkEncoding(new McElieceCCA2Parameters("SHA-256"));
        this.checkEncoding(new McElieceCCA2Parameters("SHA-384"));
        this.checkEncoding(new McElieceCCA2Parameters("SHA-512"));
    }

    private void checkEncoding(McElieceCCA2Parameters mcElieceCCA2Parameters) throws Exception {
        McElieceCCA2KeyPairGenerator mcElieceCCA2KeyPairGenerator = new McElieceCCA2KeyPairGenerator();
        McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(this.keyRandom, mcElieceCCA2Parameters);
        mcElieceCCA2KeyPairGenerator.init(mcElieceCCA2KeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = mcElieceCCA2KeyPairGenerator.generateKeyPair();
        McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters = (McElieceCCA2PrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters = (McElieceCCA2PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters2 = (McElieceCCA2PrivateKeyParameters)PrivateKeyFactory.createKey(PrivateKeyInfoFactory.createPrivateKeyInfo(mcElieceCCA2PrivateKeyParameters));
        McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters2 = (McElieceCCA2PublicKeyParameters)PublicKeyFactory.createKey(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(mcElieceCCA2PublicKeyParameters));
        this.isEquals(PrivateKeyInfoFactory.createPrivateKeyInfo(mcElieceCCA2PrivateKeyParameters), PrivateKeyInfoFactory.createPrivateKeyInfo(mcElieceCCA2PrivateKeyParameters2));
        this.isEquals(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(mcElieceCCA2PublicKeyParameters), SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(mcElieceCCA2PublicKeyParameters2));
        byte[] byArray = Arrays.concatenate(Strings.toByteArray("A not so random string"), new byte[155]);
        McElieceKobaraImaiCipher mcElieceKobaraImaiCipher = new McElieceKobaraImaiCipher();
        mcElieceKobaraImaiCipher.init(true, mcElieceCCA2PublicKeyParameters);
        byte[] byArray2 = mcElieceKobaraImaiCipher.messageEncrypt(byArray);
        mcElieceKobaraImaiCipher.init(false, mcElieceCCA2PrivateKeyParameters2);
        byte[] byArray3 = mcElieceKobaraImaiCipher.messageDecrypt(byArray2);
        this.isTrue(Arrays.areEqual(byArray, byArray3));
        mcElieceKobaraImaiCipher.init(true, mcElieceCCA2PublicKeyParameters2);
        byte[] byArray4 = mcElieceKobaraImaiCipher.messageEncrypt(byArray);
        mcElieceKobaraImaiCipher.init(false, mcElieceCCA2PrivateKeyParameters);
        byte[] byArray5 = mcElieceKobaraImaiCipher.messageDecrypt(byArray4);
        this.isTrue(Arrays.areEqual(byArray, byArray5));
    }

    public String getName() {
        return "McElieceKobaraImai";
    }

    public static void main(String[] stringArray) {
        SimpleTest.runTest(new McElieceKobaraImaiCipherTest());
    }

    public void performTest() throws Exception {
        this.checkEncoding();
        int n = 0;
        int n2 = 10;
        Random random = new Random();
        int n3 = 0;
        while (n3 < n) {
            McElieceCCA2Parameters mcElieceCCA2Parameters = new McElieceCCA2Parameters("SHA-256");
            McElieceCCA2KeyPairGenerator mcElieceCCA2KeyPairGenerator = new McElieceCCA2KeyPairGenerator();
            McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(this.keyRandom, mcElieceCCA2Parameters);
            mcElieceCCA2KeyPairGenerator.init(mcElieceCCA2KeyGenerationParameters);
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = mcElieceCCA2KeyPairGenerator.generateKeyPair();
            ParametersWithRandom parametersWithRandom = new ParametersWithRandom(asymmetricCipherKeyPair.getPublic(), this.keyRandom);
            SHA256Digest sHA256Digest = new SHA256Digest();
            McElieceKobaraImaiCipher mcElieceKobaraImaiCipher = new McElieceKobaraImaiCipher();
            int n4 = 1;
            while (n4 <= n2) {
                System.out.println("############### test: " + n4);
                mcElieceKobaraImaiCipher.init(true, parametersWithRandom);
                int n5 = (random.nextInt() & 0x1F) + 1;
                byte[] byArray = new byte[n5];
                random.nextBytes(byArray);
                sHA256Digest.update(byArray, 0, byArray.length);
                byte[] byArray2 = new byte[sHA256Digest.getDigestSize()];
                sHA256Digest.doFinal(byArray2, 0);
                byte[] byArray3 = mcElieceKobaraImaiCipher.messageEncrypt(byArray2);
                mcElieceKobaraImaiCipher.init(false, asymmetricCipherKeyPair.getPrivate());
                byte[] byArray4 = mcElieceKobaraImaiCipher.messageDecrypt(byArray3);
                boolean bl = true;
                int n6 = 0;
                while (n6 < byArray2.length) {
                    bl = bl && byArray2[n6] == byArray4[n6];
                    ++n6;
                }
                if (!bl) {
                    this.fail("en/decryption fails");
                } else {
                    System.out.println("test okay");
                    System.out.println();
                }
                ++n4;
            }
            ++n3;
        }
    }
}

