/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.test.FixedSecureRandom;

public class NISTSecureRandom
extends SecureRandom {
    private byte[] seed;
    private byte[] personalization;
    private byte[] key;
    private byte[] v;
    int reseed_counuter = 1;

    public NISTSecureRandom(byte[] byArray, byte[] byArray2) {
        this.seed = byArray;
        this.personalization = byArray2;
        this.init(256);
    }

    private void AES256_CTR_DRBG_Update(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n;
        byte[] byArray4 = new byte[48];
        int n2 = 0;
        while (n2 < 3) {
            n = 15;
            while (n >= 0) {
                if ((byArray3[n] & 0xFF) != 255) {
                    int n3 = n;
                    byArray3[n3] = (byte)(byArray3[n3] + 1);
                    break;
                }
                byArray3[n] = 0;
                --n;
            }
            this.AES256_ECB(byArray2, byArray3, byArray4, 16 * n2);
            ++n2;
        }
        if (byArray != null) {
            n = 0;
            while (n < 48) {
                int n4 = n;
                byArray4[n4] = (byte)(byArray4[n4] ^ byArray[n]);
                ++n;
            }
        }
        System.arraycopy(byArray4, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray4, 32, byArray3, 0, byArray3.length);
    }

    private void AES256_ECB(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        try {
            AESEngine aESEngine = new AESEngine();
            aESEngine.init(true, new KeyParameter(byArray));
            int n2 = 0;
            while (n2 != byArray2.length) {
                aESEngine.processBlock(byArray2, n2, byArray3, n + n2);
                n2 += 16;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static FixedSecureRandom getFixed(byte[] byArray, int n) {
        return NISTSecureRandom.getFixed(byArray, null, n, n / 8, n / 8);
    }

    public static FixedSecureRandom getFixed(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        NISTSecureRandom nISTSecureRandom = new NISTSecureRandom(byArray, byArray2);
        nISTSecureRandom.init(n);
        byte[] byArray3 = new byte[n2];
        nISTSecureRandom.nextBytes(byArray3);
        if (n2 != n3) {
            byArray3 = new byte[n3];
        }
        nISTSecureRandom.nextBytes(byArray3);
        return new FixedSecureRandom(byArray3);
    }

    public static FixedSecureRandom getFixedNoDiscard(byte[] byArray, int n) {
        NISTSecureRandom nISTSecureRandom = new NISTSecureRandom(byArray, null);
        nISTSecureRandom.init(n);
        byte[] byArray2 = new byte[n / 8];
        nISTSecureRandom.nextBytes(byArray2);
        return new FixedSecureRandom(byArray2);
    }

    private void init(int n) {
        this.randombytes_init(this.seed, this.personalization, n);
        this.reseed_counuter = 1;
    }

    public void nextBytes(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        int n2 = byArray.length;
        while (n2 > 0) {
            int n3 = 15;
            while (n3 >= 0) {
                if ((this.v[n3] & 0xFF) != 255) {
                    int n4 = n3;
                    this.v[n4] = (byte)(this.v[n4] + 1);
                    break;
                }
                this.v[n3] = 0;
                --n3;
            }
            this.AES256_ECB(this.key, this.v, byArray2, 0);
            if (n2 > 15) {
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                n += 16;
                n2 -= 16;
                continue;
            }
            System.arraycopy(byArray2, 0, byArray, n, n2);
            n2 = 0;
        }
        this.AES256_CTR_DRBG_Update(null, this.key, this.v);
        ++this.reseed_counuter;
    }

    private void randombytes_init(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = new byte[48];
        System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
        if (byArray2 != null) {
            int n2 = 0;
            while (n2 < 48) {
                int n3 = n2;
                byArray3[n3] = (byte)(byArray3[n3] ^ byArray2[n2]);
                ++n2;
            }
        }
        this.key = new byte[32];
        this.v = new byte[16];
        this.AES256_CTR_DRBG_Update(byArray3, this.key, this.v);
        this.reseed_counuter = 1;
    }
}

