/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.Vector;
import org.bouncycastle.util.Arrays;

public class GF2mVector
extends Vector {
    private GF2mField field;
    private int[] vector;

    public GF2mVector(GF2mField gF2mField, byte[] byArray) {
        this.field = new GF2mField(gF2mField);
        int n = 8;
        int n2 = 1;
        while (gF2mField.getDegree() > n) {
            ++n2;
            n += 8;
        }
        if (byArray.length % n2 != 0) {
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
        this.length = byArray.length / n2;
        this.vector = new int[this.length];
        n2 = 0;
        int n3 = 0;
        while (n3 < this.vector.length) {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n3;
                this.vector[n5] = this.vector[n5] | (byArray[n2++] & 0xFF) << n4;
                n4 += 8;
            }
            if (!gF2mField.isElementOfThisField(this.vector[n3])) {
                throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
            }
            ++n3;
        }
    }

    public GF2mVector(GF2mField gF2mField, int[] nArray) {
        this.field = gF2mField;
        this.length = nArray.length;
        int n = nArray.length - 1;
        while (n >= 0) {
            if (!gF2mField.isElementOfThisField(nArray[n])) {
                throw new ArithmeticException("Element array is not specified over the given finite field.");
            }
            --n;
        }
        this.vector = IntUtils.clone(nArray);
    }

    public GF2mVector(GF2mVector gF2mVector) {
        this.field = new GF2mField(gF2mVector.field);
        this.length = gF2mVector.length;
        this.vector = IntUtils.clone(gF2mVector.vector);
    }

    public Vector add(Vector vector) {
        throw new RuntimeException("not implemented");
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2mVector)) {
            return false;
        }
        GF2mVector gF2mVector = (GF2mVector)object;
        if (!this.field.equals(gF2mVector.field)) {
            return false;
        }
        return IntUtils.equals(this.vector, gF2mVector.vector);
    }

    public byte[] getEncoded() {
        int n = 8;
        int n2 = 1;
        while (this.field.getDegree() > n) {
            ++n2;
            n += 8;
        }
        byte[] byArray = new byte[this.vector.length * n2];
        n2 = 0;
        int n3 = 0;
        while (n3 < this.vector.length) {
            int n4 = 0;
            while (n4 < n) {
                byArray[n2++] = (byte)(this.vector[n3] >>> n4);
                n4 += 8;
            }
            ++n3;
        }
        return byArray;
    }

    public GF2mField getField() {
        return this.field;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.vector);
    }

    public int hashCode() {
        int n = this.field.hashCode();
        n = n * 31 + Arrays.hashCode(this.vector);
        return n;
    }

    public boolean isZero() {
        int n = this.vector.length - 1;
        while (n >= 0) {
            if (this.vector[n] != 0) {
                return false;
            }
            --n;
        }
        return true;
    }

    public Vector multiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (this.length != nArray.length) {
            throw new ArithmeticException("permutation size and vector size mismatch");
        }
        int[] nArray2 = new int[this.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.vector[nArray[n]];
            ++n;
        }
        return new GF2mVector(this.field, nArray2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.vector.length) {
            int n2 = 0;
            while (n2 < this.field.getDegree()) {
                int n3 = n2 & 0x1F;
                int n4 = 1 << n3;
                int n5 = this.vector[n] & n4;
                if (n5 != 0) {
                    stringBuffer.append('1');
                } else {
                    stringBuffer.append('0');
                }
                ++n2;
            }
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }
}

