/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2nElement;
import org.bouncycastle.pqc.math.linearalgebra.GF2nONBField;
import org.bouncycastle.pqc.math.linearalgebra.GFElement;
import org.bouncycastle.util.Arrays;

public class GF2nONBElement
extends GF2nElement {
    private static final long[] mBitmask = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    private static final long[] mMaxmask = new long[]{1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
    private static final int[] mIBY64;
    private static final int MAXLONG = 64;
    private int mLength;
    private int mBit;
    private long[] mPol;

    static {
        int[] nArray = new int[384];
        nArray[64] = 1;
        nArray[65] = 1;
        nArray[66] = 1;
        nArray[67] = 1;
        nArray[68] = 1;
        nArray[69] = 1;
        nArray[70] = 1;
        nArray[71] = 1;
        nArray[72] = 1;
        nArray[73] = 1;
        nArray[74] = 1;
        nArray[75] = 1;
        nArray[76] = 1;
        nArray[77] = 1;
        nArray[78] = 1;
        nArray[79] = 1;
        nArray[80] = 1;
        nArray[81] = 1;
        nArray[82] = 1;
        nArray[83] = 1;
        nArray[84] = 1;
        nArray[85] = 1;
        nArray[86] = 1;
        nArray[87] = 1;
        nArray[88] = 1;
        nArray[89] = 1;
        nArray[90] = 1;
        nArray[91] = 1;
        nArray[92] = 1;
        nArray[93] = 1;
        nArray[94] = 1;
        nArray[95] = 1;
        nArray[96] = 1;
        nArray[97] = 1;
        nArray[98] = 1;
        nArray[99] = 1;
        nArray[100] = 1;
        nArray[101] = 1;
        nArray[102] = 1;
        nArray[103] = 1;
        nArray[104] = 1;
        nArray[105] = 1;
        nArray[106] = 1;
        nArray[107] = 1;
        nArray[108] = 1;
        nArray[109] = 1;
        nArray[110] = 1;
        nArray[111] = 1;
        nArray[112] = 1;
        nArray[113] = 1;
        nArray[114] = 1;
        nArray[115] = 1;
        nArray[116] = 1;
        nArray[117] = 1;
        nArray[118] = 1;
        nArray[119] = 1;
        nArray[120] = 1;
        nArray[121] = 1;
        nArray[122] = 1;
        nArray[123] = 1;
        nArray[124] = 1;
        nArray[125] = 1;
        nArray[126] = 1;
        nArray[127] = 1;
        nArray[128] = 2;
        nArray[129] = 2;
        nArray[130] = 2;
        nArray[131] = 2;
        nArray[132] = 2;
        nArray[133] = 2;
        nArray[134] = 2;
        nArray[135] = 2;
        nArray[136] = 2;
        nArray[137] = 2;
        nArray[138] = 2;
        nArray[139] = 2;
        nArray[140] = 2;
        nArray[141] = 2;
        nArray[142] = 2;
        nArray[143] = 2;
        nArray[144] = 2;
        nArray[145] = 2;
        nArray[146] = 2;
        nArray[147] = 2;
        nArray[148] = 2;
        nArray[149] = 2;
        nArray[150] = 2;
        nArray[151] = 2;
        nArray[152] = 2;
        nArray[153] = 2;
        nArray[154] = 2;
        nArray[155] = 2;
        nArray[156] = 2;
        nArray[157] = 2;
        nArray[158] = 2;
        nArray[159] = 2;
        nArray[160] = 2;
        nArray[161] = 2;
        nArray[162] = 2;
        nArray[163] = 2;
        nArray[164] = 2;
        nArray[165] = 2;
        nArray[166] = 2;
        nArray[167] = 2;
        nArray[168] = 2;
        nArray[169] = 2;
        nArray[170] = 2;
        nArray[171] = 2;
        nArray[172] = 2;
        nArray[173] = 2;
        nArray[174] = 2;
        nArray[175] = 2;
        nArray[176] = 2;
        nArray[177] = 2;
        nArray[178] = 2;
        nArray[179] = 2;
        nArray[180] = 2;
        nArray[181] = 2;
        nArray[182] = 2;
        nArray[183] = 2;
        nArray[184] = 2;
        nArray[185] = 2;
        nArray[186] = 2;
        nArray[187] = 2;
        nArray[188] = 2;
        nArray[189] = 2;
        nArray[190] = 2;
        nArray[191] = 2;
        nArray[192] = 3;
        nArray[193] = 3;
        nArray[194] = 3;
        nArray[195] = 3;
        nArray[196] = 3;
        nArray[197] = 3;
        nArray[198] = 3;
        nArray[199] = 3;
        nArray[200] = 3;
        nArray[201] = 3;
        nArray[202] = 3;
        nArray[203] = 3;
        nArray[204] = 3;
        nArray[205] = 3;
        nArray[206] = 3;
        nArray[207] = 3;
        nArray[208] = 3;
        nArray[209] = 3;
        nArray[210] = 3;
        nArray[211] = 3;
        nArray[212] = 3;
        nArray[213] = 3;
        nArray[214] = 3;
        nArray[215] = 3;
        nArray[216] = 3;
        nArray[217] = 3;
        nArray[218] = 3;
        nArray[219] = 3;
        nArray[220] = 3;
        nArray[221] = 3;
        nArray[222] = 3;
        nArray[223] = 3;
        nArray[224] = 3;
        nArray[225] = 3;
        nArray[226] = 3;
        nArray[227] = 3;
        nArray[228] = 3;
        nArray[229] = 3;
        nArray[230] = 3;
        nArray[231] = 3;
        nArray[232] = 3;
        nArray[233] = 3;
        nArray[234] = 3;
        nArray[235] = 3;
        nArray[236] = 3;
        nArray[237] = 3;
        nArray[238] = 3;
        nArray[239] = 3;
        nArray[240] = 3;
        nArray[241] = 3;
        nArray[242] = 3;
        nArray[243] = 3;
        nArray[244] = 3;
        nArray[245] = 3;
        nArray[246] = 3;
        nArray[247] = 3;
        nArray[248] = 3;
        nArray[249] = 3;
        nArray[250] = 3;
        nArray[251] = 3;
        nArray[252] = 3;
        nArray[253] = 3;
        nArray[254] = 3;
        nArray[255] = 3;
        nArray[256] = 4;
        nArray[257] = 4;
        nArray[258] = 4;
        nArray[259] = 4;
        nArray[260] = 4;
        nArray[261] = 4;
        nArray[262] = 4;
        nArray[263] = 4;
        nArray[264] = 4;
        nArray[265] = 4;
        nArray[266] = 4;
        nArray[267] = 4;
        nArray[268] = 4;
        nArray[269] = 4;
        nArray[270] = 4;
        nArray[271] = 4;
        nArray[272] = 4;
        nArray[273] = 4;
        nArray[274] = 4;
        nArray[275] = 4;
        nArray[276] = 4;
        nArray[277] = 4;
        nArray[278] = 4;
        nArray[279] = 4;
        nArray[280] = 4;
        nArray[281] = 4;
        nArray[282] = 4;
        nArray[283] = 4;
        nArray[284] = 4;
        nArray[285] = 4;
        nArray[286] = 4;
        nArray[287] = 4;
        nArray[288] = 4;
        nArray[289] = 4;
        nArray[290] = 4;
        nArray[291] = 4;
        nArray[292] = 4;
        nArray[293] = 4;
        nArray[294] = 4;
        nArray[295] = 4;
        nArray[296] = 4;
        nArray[297] = 4;
        nArray[298] = 4;
        nArray[299] = 4;
        nArray[300] = 4;
        nArray[301] = 4;
        nArray[302] = 4;
        nArray[303] = 4;
        nArray[304] = 4;
        nArray[305] = 4;
        nArray[306] = 4;
        nArray[307] = 4;
        nArray[308] = 4;
        nArray[309] = 4;
        nArray[310] = 4;
        nArray[311] = 4;
        nArray[312] = 4;
        nArray[313] = 4;
        nArray[314] = 4;
        nArray[315] = 4;
        nArray[316] = 4;
        nArray[317] = 4;
        nArray[318] = 4;
        nArray[319] = 4;
        nArray[320] = 5;
        nArray[321] = 5;
        nArray[322] = 5;
        nArray[323] = 5;
        nArray[324] = 5;
        nArray[325] = 5;
        nArray[326] = 5;
        nArray[327] = 5;
        nArray[328] = 5;
        nArray[329] = 5;
        nArray[330] = 5;
        nArray[331] = 5;
        nArray[332] = 5;
        nArray[333] = 5;
        nArray[334] = 5;
        nArray[335] = 5;
        nArray[336] = 5;
        nArray[337] = 5;
        nArray[338] = 5;
        nArray[339] = 5;
        nArray[340] = 5;
        nArray[341] = 5;
        nArray[342] = 5;
        nArray[343] = 5;
        nArray[344] = 5;
        nArray[345] = 5;
        nArray[346] = 5;
        nArray[347] = 5;
        nArray[348] = 5;
        nArray[349] = 5;
        nArray[350] = 5;
        nArray[351] = 5;
        nArray[352] = 5;
        nArray[353] = 5;
        nArray[354] = 5;
        nArray[355] = 5;
        nArray[356] = 5;
        nArray[357] = 5;
        nArray[358] = 5;
        nArray[359] = 5;
        nArray[360] = 5;
        nArray[361] = 5;
        nArray[362] = 5;
        nArray[363] = 5;
        nArray[364] = 5;
        nArray[365] = 5;
        nArray[366] = 5;
        nArray[367] = 5;
        nArray[368] = 5;
        nArray[369] = 5;
        nArray[370] = 5;
        nArray[371] = 5;
        nArray[372] = 5;
        nArray[373] = 5;
        nArray[374] = 5;
        nArray[375] = 5;
        nArray[376] = 5;
        nArray[377] = 5;
        nArray[378] = 5;
        nArray[379] = 5;
        nArray[380] = 5;
        nArray[381] = 5;
        nArray[382] = 5;
        nArray[383] = 5;
        mIBY64 = nArray;
    }

    public GF2nONBElement(GF2nONBElement gF2nONBElement) {
        this.mField = gF2nONBElement.mField;
        this.mDegree = this.mField.getDegree();
        this.mLength = ((GF2nONBField)this.mField).getONBLength();
        this.mBit = ((GF2nONBField)this.mField).getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(gF2nONBElement.getElement());
    }

    public GF2nONBElement(GF2nONBField gF2nONBField, BigInteger bigInteger) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(bigInteger);
    }

    public GF2nONBElement(GF2nONBField gF2nONBField, SecureRandom secureRandom) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        if (this.mLength > 1) {
            int n = 0;
            while (n < this.mLength - 1) {
                this.mPol[n] = secureRandom.nextLong();
                ++n;
            }
            long l = secureRandom.nextLong();
            this.mPol[this.mLength - 1] = l >>> 64 - this.mBit;
        } else {
            this.mPol[0] = secureRandom.nextLong();
            this.mPol[0] = this.mPol[0] >>> 64 - this.mBit;
        }
    }

    public GF2nONBElement(GF2nONBField gF2nONBField, byte[] byArray) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = new long[this.mLength];
        this.assign(byArray);
    }

    private GF2nONBElement(GF2nONBField gF2nONBField, long[] lArray) {
        this.mField = gF2nONBField;
        this.mDegree = this.mField.getDegree();
        this.mLength = gF2nONBField.getONBLength();
        this.mBit = gF2nONBField.getONBBit();
        this.mPol = lArray;
    }

    public static GF2nONBElement ONE(GF2nONBField gF2nONBField) {
        int n = gF2nONBField.getONBLength();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n - 1) {
            lArray[n2] = -1L;
            ++n2;
        }
        lArray[n - 1] = mMaxmask[gF2nONBField.getONBBit() - 1];
        return new GF2nONBElement(gF2nONBField, lArray);
    }

    public static GF2nONBElement ZERO(GF2nONBField gF2nONBField) {
        long[] lArray = new long[gF2nONBField.getONBLength()];
        return new GF2nONBElement(gF2nONBField, lArray);
    }

    public GFElement add(GFElement gFElement) throws RuntimeException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.addToThis(gFElement);
        return gF2nONBElement;
    }

    public void addToThis(GFElement gFElement) throws RuntimeException {
        if (!(gFElement instanceof GF2nONBElement)) {
            throw new RuntimeException();
        }
        if (!this.mField.equals(((GF2nONBElement)gFElement).mField)) {
            throw new RuntimeException();
        }
        int n = 0;
        while (n < this.mLength) {
            int n2 = n;
            this.mPol[n2] = this.mPol[n2] ^ ((GF2nONBElement)gFElement).mPol[n];
            ++n;
        }
    }

    private void assign(BigInteger bigInteger) {
        this.assign(bigInteger.toByteArray());
    }

    private void assign(byte[] byArray) {
        this.mPol = new long[this.mLength];
        int n = 0;
        while (n < byArray.length) {
            int n2 = n >>> 3;
            this.mPol[n2] = this.mPol[n2] | ((long)byArray[byArray.length - 1 - n] & 0xFFL) << ((n & 7) << 3);
            ++n;
        }
    }

    private void assign(long[] lArray) {
        System.arraycopy(lArray, 0, this.mPol, 0, this.mLength);
    }

    void assignOne() {
        int n = 0;
        while (n < this.mLength - 1) {
            this.mPol[n] = -1L;
            ++n;
        }
        this.mPol[this.mLength - 1] = mMaxmask[this.mBit - 1];
    }

    void assignZero() {
        this.mPol = new long[this.mLength];
    }

    public Object clone() {
        return new GF2nONBElement(this);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2nONBElement)) {
            return false;
        }
        GF2nONBElement gF2nONBElement = (GF2nONBElement)object;
        int n = 0;
        while (n < this.mLength) {
            if (this.mPol[n] != gF2nONBElement.mPol[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private long[] getElement() {
        long[] lArray = new long[this.mPol.length];
        System.arraycopy(this.mPol, 0, lArray, 0, this.mPol.length);
        return lArray;
    }

    private long[] getElementReverseOrder() {
        long[] lArray = new long[this.mPol.length];
        int n = 0;
        while (n < this.mDegree) {
            if (this.testBit(this.mDegree - n - 1)) {
                int n2 = n >>> 6;
                lArray[n2] = lArray[n2] | mBitmask[n & 0x3F];
            }
            ++n;
        }
        return lArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mPol);
    }

    public GF2nElement increase() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.increaseThis();
        return gF2nONBElement;
    }

    public void increaseThis() {
        this.addToThis(GF2nONBElement.ONE((GF2nONBField)this.mField));
    }

    public GFElement invert() throws ArithmeticException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.invertThis();
        return gF2nONBElement;
    }

    public void invertThis() throws ArithmeticException {
        if (this.isZero()) {
            throw new ArithmeticException();
        }
        int n = 31;
        boolean bl = false;
        while (!bl && n >= 0) {
            if (((long)(this.mDegree - 1) & mBitmask[n]) != 0L) {
                bl = true;
            }
            --n;
        }
        GF2nElement gF2nElement = GF2nONBElement.ZERO((GF2nONBField)this.mField);
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        int n2 = 1;
        int n3 = ++n - 1;
        while (n3 >= 0) {
            gF2nElement = (GF2nElement)((GF2nElement)gF2nONBElement).clone();
            int n4 = 1;
            while (n4 <= n2) {
                gF2nElement.squareThis();
                ++n4;
            }
            ((GF2nElement)gF2nONBElement).multiplyThisBy(gF2nElement);
            n2 <<= 1;
            if (((long)(this.mDegree - 1) & mBitmask[n3]) != 0L) {
                ((GF2nElement)gF2nONBElement).squareThis();
                ((GF2nElement)gF2nONBElement).multiplyThisBy(this);
                ++n2;
            }
            --n3;
        }
        ((GF2nElement)gF2nONBElement).squareThis();
    }

    public boolean isOne() {
        boolean bl = true;
        int n = 0;
        while (n < this.mLength - 1 && bl) {
            bl = bl && (this.mPol[n] & 0xFFFFFFFFFFFFFFFFL) == -1L;
            ++n;
        }
        if (bl) {
            bl = bl && (this.mPol[this.mLength - 1] & mMaxmask[this.mBit - 1]) == mMaxmask[this.mBit - 1];
        }
        return bl;
    }

    public boolean isZero() {
        boolean bl = true;
        int n = 0;
        while (n < this.mLength && bl) {
            bl = bl && (this.mPol[n] & 0xFFFFFFFFFFFFFFFFL) == 0L;
            ++n;
        }
        return bl;
    }

    public GFElement multiply(GFElement gFElement) throws RuntimeException {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.multiplyThisBy(gFElement);
        return gF2nONBElement;
    }

    public void multiplyThisBy(GFElement gFElement) throws RuntimeException {
        if (!(gFElement instanceof GF2nONBElement)) {
            throw new RuntimeException("The elements have different representation: not yet implemented");
        }
        if (!this.mField.equals(((GF2nONBElement)gFElement).mField)) {
            throw new RuntimeException();
        }
        if (this.equals(gFElement)) {
            this.squareThis();
        } else {
            long[] lArray = this.mPol;
            long[] lArray2 = ((GF2nONBElement)gFElement).mPol;
            long[] lArray3 = new long[this.mLength];
            int[][] nArray = ((GF2nONBField)this.mField).mMult;
            int n = this.mLength - 1;
            int n2 = this.mBit - 1;
            boolean bl = false;
            long l = mBitmask[63];
            long l2 = mBitmask[n2];
            int n3 = 0;
            while (n3 < this.mDegree) {
                boolean bl2;
                int n4;
                int n5;
                bl = false;
                int n6 = 0;
                while (n6 < this.mDegree) {
                    n5 = mIBY64[n6];
                    n4 = n6 & 0x3F;
                    int n7 = mIBY64[nArray[n6][0]];
                    int n8 = nArray[n6][0] & 0x3F;
                    if ((lArray[n5] & mBitmask[n4]) != 0L) {
                        if ((lArray2[n7] & mBitmask[n8]) != 0L) {
                            bl ^= true;
                        }
                        if (nArray[n6][1] != -1 && (lArray2[n7 = mIBY64[nArray[n6][1]]] & mBitmask[n8 = nArray[n6][1] & 0x3F]) != 0L) {
                            bl ^= true;
                        }
                    }
                    ++n6;
                }
                n5 = mIBY64[n3];
                n4 = n3 & 0x3F;
                if (bl) {
                    int n9 = n5;
                    lArray3[n9] = lArray3[n9] ^ mBitmask[n4];
                }
                if (this.mLength > 1) {
                    boolean bl3;
                    bl2 = (lArray[n] & 1L) == 1L;
                    int n10 = n - 1;
                    while (n10 >= 0) {
                        bl3 = (lArray[n10] & 1L) != 0L;
                        lArray[n10] = lArray[n10] >>> 1;
                        if (bl2) {
                            int n11 = n10;
                            lArray[n11] = lArray[n11] ^ l;
                        }
                        bl2 = bl3;
                        --n10;
                    }
                    lArray[n] = lArray[n] >>> 1;
                    if (bl2) {
                        int n12 = n;
                        lArray[n12] = lArray[n12] ^ l2;
                    }
                    bl2 = (lArray2[n] & 1L) == 1L;
                    int n13 = n - 1;
                    while (n13 >= 0) {
                        bl3 = (lArray2[n13] & 1L) != 0L;
                        lArray2[n13] = lArray2[n13] >>> 1;
                        if (bl2) {
                            int n14 = n13;
                            lArray2[n14] = lArray2[n14] ^ l;
                        }
                        bl2 = bl3;
                        --n13;
                    }
                    lArray2[n] = lArray2[n] >>> 1;
                    if (bl2) {
                        int n15 = n;
                        lArray2[n15] = lArray2[n15] ^ l2;
                    }
                } else {
                    bl2 = (lArray[0] & 1L) == 1L;
                    lArray[0] = lArray[0] >>> 1;
                    if (bl2) {
                        lArray[0] = lArray[0] ^ l2;
                    }
                    bl2 = (lArray2[0] & 1L) == 1L;
                    lArray2[0] = lArray2[0] >>> 1;
                    if (bl2) {
                        lArray2[0] = lArray2[0] ^ l2;
                    }
                }
                ++n3;
            }
            this.assign(lArray3);
        }
    }

    void reverseOrder() {
        this.mPol = this.getElementReverseOrder();
    }

    public GF2nElement solveQuadraticEquation() throws RuntimeException {
        if (this.trace() == 1) {
            throw new RuntimeException();
        }
        long l = mBitmask[63];
        long l2 = 0L;
        long l3 = 1L;
        long[] lArray = new long[this.mLength];
        long l4 = 0L;
        int n = 1;
        int n2 = 0;
        while (n2 < this.mLength - 1) {
            n = 1;
            while (n < 64) {
                if (!((mBitmask[n] & this.mPol[n2]) != l2 && (l4 & mBitmask[n - 1]) != l2 || (this.mPol[n2] & mBitmask[n]) == l2 && (l4 & mBitmask[n - 1]) == l2)) {
                    l4 ^= mBitmask[n];
                }
                ++n;
            }
            lArray[n2] = l4;
            l4 = (l & l4) != l2 && (l3 & this.mPol[n2 + 1]) == l3 || (l & l4) == l2 && (l3 & this.mPol[n2 + 1]) == l2 ? l2 : l3;
            ++n2;
        }
        int n3 = this.mDegree & 0x3F;
        long l5 = this.mPol[this.mLength - 1];
        n = 1;
        while (n < n3) {
            if (!((mBitmask[n] & l5) != l2 && (mBitmask[n - 1] & l4) != l2 || (mBitmask[n] & l5) == l2 && (mBitmask[n - 1] & l4) == l2)) {
                l4 ^= mBitmask[n];
            }
            ++n;
        }
        lArray[this.mLength - 1] = l4;
        return new GF2nONBElement((GF2nONBField)this.mField, lArray);
    }

    public GF2nElement square() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.squareThis();
        return gF2nONBElement;
    }

    public GF2nElement squareRoot() {
        GF2nONBElement gF2nONBElement = new GF2nONBElement(this);
        gF2nONBElement.squareRootThis();
        return gF2nONBElement;
    }

    public void squareRootThis() {
        long[] lArray = this.getElement();
        int n = this.mLength - 1;
        int n2 = this.mBit - 1;
        long l = mBitmask[63];
        boolean bl = (lArray[0] & 1L) != 0L;
        int n3 = n;
        while (n3 >= 0) {
            boolean bl2 = (lArray[n3] & 1L) != 0L;
            lArray[n3] = lArray[n3] >>> 1;
            if (bl) {
                if (n3 == n) {
                    int n4 = n3;
                    lArray[n4] = lArray[n4] ^ mBitmask[n2];
                } else {
                    int n5 = n3;
                    lArray[n5] = lArray[n5] ^ l;
                }
            }
            bl = bl2;
            --n3;
        }
        this.assign(lArray);
    }

    public void squareThis() {
        boolean bl;
        long[] lArray = this.getElement();
        int n = this.mLength - 1;
        int n2 = this.mBit - 1;
        long l = mBitmask[63];
        boolean bl2 = (lArray[n] & mBitmask[n2]) != 0L;
        int n3 = 0;
        while (n3 < n) {
            bl = (lArray[n3] & l) != 0L;
            lArray[n3] = lArray[n3] << 1;
            if (bl2) {
                int n4 = n3;
                lArray[n4] = lArray[n4] ^ 1L;
            }
            bl2 = bl;
            ++n3;
        }
        bl = (lArray[n] & mBitmask[n2]) != 0L;
        lArray[n] = lArray[n] << 1;
        if (bl2) {
            int n5 = n;
            lArray[n5] = lArray[n5] ^ 1L;
        }
        if (bl) {
            int n6 = n;
            lArray[n6] = lArray[n6] ^ mBitmask[n2 + 1];
        }
        this.assign(lArray);
    }

    boolean testBit(int n) {
        if (n < 0 || n > this.mDegree) {
            return false;
        }
        long l = this.mPol[n >>> 6] & mBitmask[n & 0x3F];
        return l != 0L;
    }

    public boolean testRightmostBit() {
        return (this.mPol[this.mLength - 1] & mBitmask[this.mBit - 1]) != 0L;
    }

    public byte[] toByteArray() {
        int n = (this.mDegree - 1 >> 3) + 1;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n - n2 - 1] = (byte)((this.mPol[n2 >>> 3] & 255L << ((n2 & 7) << 3)) >>> ((n2 & 7) << 3));
            ++n2;
        }
        return byArray;
    }

    public BigInteger toFlexiBigInt() {
        return new BigInteger(1, this.toByteArray());
    }

    public String toString() {
        return this.toString(16);
    }

    public String toString(int n) {
        String string;
        block5: {
            long[] lArray;
            block4: {
                string = "";
                lArray = this.getElement();
                int n2 = this.mBit;
                if (n != 2) break block4;
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    string = (lArray[lArray.length - 1] & 1L << n3) == 0L ? String.valueOf(string) + "0" : String.valueOf(string) + "1";
                    --n3;
                }
                int n4 = lArray.length - 2;
                while (n4 >= 0) {
                    int n5 = 63;
                    while (n5 >= 0) {
                        string = (lArray[n4] & mBitmask[n5]) == 0L ? String.valueOf(string) + "0" : String.valueOf(string) + "1";
                        --n5;
                    }
                    --n4;
                }
                break block5;
            }
            if (n != 16) break block5;
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            int n6 = lArray.length - 1;
            while (n6 >= 0) {
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 60) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 56) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 52) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 48) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 44) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 40) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 36) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 32) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 28) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 24) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 20) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 16) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 12) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 8) & 0xF];
                string = String.valueOf(string) + cArray[(int)(lArray[n6] >>> 4) & 0xF];
                string = String.valueOf(string) + cArray[(int)lArray[n6] & 0xF];
                string = String.valueOf(string) + " ";
                --n6;
            }
        }
        return string;
    }

    public int trace() {
        int n;
        int n2 = 0;
        int n3 = this.mLength - 1;
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            while (n < 64) {
                if ((this.mPol[n4] & mBitmask[n]) != 0L) {
                    n2 ^= 1;
                }
                ++n;
            }
            ++n4;
        }
        n = this.mBit;
        int n5 = 0;
        while (n5 < n) {
            if ((this.mPol[n3] & mBitmask[n5]) != 0L) {
                n2 ^= 1;
            }
            ++n5;
        }
        return n2;
    }
}

