/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.apache.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.apache.bzip2.BZip2Constants;
import org.bouncycastle.apache.bzip2.CRC;

public class CBZip2OutputStream
extends OutputStream
implements BZip2Constants {
    protected static final int SETMASK = 0x200000;
    protected static final int CLEARMASK = -2097153;
    protected static final int GREATER_ICOST = 15;
    protected static final int LESSER_ICOST = 0;
    protected static final int SMALL_THRESH = 20;
    protected static final int DEPTH_THRESH = 10;
    private boolean finished;
    int count;
    int origPtr;
    int blockSize100k;
    boolean blockRandomised;
    int bsBuff;
    int bsLive;
    CRC mCrc = new CRC();
    private boolean[] inUse = new boolean[256];
    private int nInUse;
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private byte[] blockBytes = null;
    private short[] quadrantShorts = null;
    private int[] zptr = null;
    private int[] szptr;
    private int[] ftab = null;
    private int nMTF;
    private int[] mtfFreq = new int[258];
    private int workFactor;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private int currentByte = -1;
    private int runLength = 0;
    boolean closed = false;
    private int blockCRC;
    private int combinedCRC;
    private final int allowableBlockSize;
    private OutputStream bsStream;
    private int[] incs = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};

    public CBZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public CBZip2OutputStream(OutputStream outputStream, int n) throws IOException {
        outputStream.write(66);
        outputStream.write(90);
        this.bsSetStream(outputStream);
        this.workFactor = 50;
        if (n > 9) {
            n = 9;
        }
        if (n < 1) {
            n = 1;
        }
        this.blockSize100k = n;
        this.allowableBlockSize = 100000 * this.blockSize100k - 20;
        this.allocateCompressStructures();
        this.initialize();
        this.initBlock();
    }

    private void allocateCompressStructures() {
        int n = 100000 * this.blockSize100k;
        this.blockBytes = new byte[n + 1 + 20];
        this.quadrantShorts = new short[n + 1 + 20];
        this.zptr = new int[n];
        this.ftab = new int[65537];
        this.szptr = this.zptr;
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            this.bsStream.write(this.bsBuff >> 24);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
    }

    private void bsPutIntVS(int n, int n2) throws IOException {
        this.bsW(n, n2);
    }

    private void bsPutUChar(int n) throws IOException {
        this.bsW(8, n);
    }

    private void bsPutint(int n) throws IOException {
        this.bsW(8, n >> 24 & 0xFF);
        this.bsW(8, n >> 16 & 0xFF);
        this.bsW(8, n >> 8 & 0xFF);
        this.bsW(8, n & 0xFF);
    }

    private void bsSetStream(OutputStream outputStream) {
        this.bsStream = outputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private void bsW(int n, int n2) throws IOException {
        while (this.bsLive >= 8) {
            this.bsStream.write(this.bsBuff >> 24);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
        this.bsBuff |= n2 << 32 - this.bsLive - n;
        this.bsLive += n;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.closed = true;
        super.close();
        this.bsStream.close();
    }

    private void doReversibleTransformation() {
        this.workLimit = this.workFactor * (this.count - 1);
        this.workDone = 0;
        this.blockRandomised = false;
        this.firstAttempt = true;
        this.mainSort();
        if (this.workDone > this.workLimit && this.firstAttempt) {
            this.randomiseBlock();
            this.workDone = 0;
            this.workLimit = 0;
            this.blockRandomised = true;
            this.firstAttempt = false;
            this.mainSort();
        }
        this.origPtr = -1;
        int n = 0;
        while (n < this.count) {
            if (this.zptr[n] == 0) {
                this.origPtr = n;
                break;
            }
            ++n;
        }
        if (this.origPtr == -1) {
            CBZip2OutputStream.panic();
        }
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.mCrc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        this.doReversibleTransformation();
        this.bsPutUChar(49);
        this.bsPutUChar(65);
        this.bsPutUChar(89);
        this.bsPutUChar(38);
        this.bsPutUChar(83);
        this.bsPutUChar(89);
        this.bsPutint(this.blockCRC);
        this.bsW(1, this.blockRandomised ? 1 : 0);
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUChar(23);
        this.bsPutUChar(114);
        this.bsPutUChar(69);
        this.bsPutUChar(56);
        this.bsPutUChar(80);
        this.bsPutUChar(144);
        this.bsPutint(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.runLength > 0) {
            this.writeRun();
        }
        this.currentByte = -1;
        if (this.count > 0) {
            this.endBlock();
        }
        this.endCompression();
        this.finished = true;
        this.flush();
    }

    public void flush() throws IOException {
        super.flush();
        this.bsStream.flush();
    }

    private boolean fullGtU(int n, int n2) {
        int n3;
        int n4;
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
            return n4 > n3;
        }
        int n5 = this.count;
        do {
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            int n6 = this.quadrantShorts[n] & 0xFFFF;
            int n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if ((n4 = this.blockBytes[++n] & 0xFF) != (n3 = this.blockBytes[++n2] & 0xFF)) {
                return n4 > n3;
            }
            n6 = this.quadrantShorts[n] & 0xFFFF;
            n7 = this.quadrantShorts[n2] & 0xFFFF;
            if (n6 != n7) {
                return n6 > n7;
            }
            if (n >= this.count) {
                n -= this.count;
            }
            if (n2 >= this.count) {
                n2 -= this.count;
            }
            ++this.workDone;
        } while ((n5 -= 4) >= 0);
        return false;
    }

    private void generateMTFValues() {
        char[] cArray = new char[256];
        this.makeMaps();
        int n = this.nInUse + 1;
        int n2 = 0;
        while (n2 <= n) {
            this.mtfFreq[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        n2 = 0;
        while (n2 < this.nInUse) {
            cArray[n2] = (char)n2;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.count) {
            char c = this.unseqToSeq[this.blockBytes[this.zptr[n2]] & 0xFF];
            int n5 = 0;
            char c2 = cArray[n5];
            while (c != c2) {
                char c3 = c2;
                c2 = cArray[++n5];
                cArray[n5] = c3;
            }
            cArray[0] = c2;
            if (n5 == 0) {
                ++n4;
            } else {
                if (n4 > 0) {
                    --n4;
                    while (true) {
                        switch (n4 % 2) {
                            case 0: {
                                this.szptr[n3++] = 0;
                                this.mtfFreq[0] = this.mtfFreq[0] + 1;
                                break;
                            }
                            case 1: {
                                this.szptr[n3++] = 1;
                                this.mtfFreq[1] = this.mtfFreq[1] + 1;
                                break;
                            }
                        }
                        if (n4 < 2) break;
                        n4 = (n4 - 2) / 2;
                    }
                    n4 = 0;
                }
                this.szptr[n3++] = n5 + 1;
                int n6 = n5 + 1;
                this.mtfFreq[n6] = this.mtfFreq[n6] + 1;
            }
            ++n2;
        }
        if (n4 > 0) {
            --n4;
            while (true) {
                switch (n4 % 2) {
                    case 0: {
                        this.szptr[n3++] = 0;
                        this.mtfFreq[0] = this.mtfFreq[0] + 1;
                        break;
                    }
                    case 1: {
                        this.szptr[n3++] = 1;
                        this.mtfFreq[1] = this.mtfFreq[1] + 1;
                        break;
                    }
                }
                if (n4 < 2) break;
                n4 = (n4 - 2) / 2;
            }
        }
        this.szptr[n3++] = n;
        int n7 = n;
        this.mtfFreq[n7] = this.mtfFreq[n7] + 1;
        this.nMTF = n3;
    }

    private void hbAssignCodes(int[] nArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = n;
        while (n5 <= n2) {
            int n6 = 0;
            while (n6 < n3) {
                if ((byArray[n6] & 0xFF) == n5) {
                    nArray[n6] = n4++;
                }
                ++n6;
            }
            n4 <<= 1;
            ++n5;
        }
    }

    protected static void hbMakeCodeLengths(byte[] byArray, int[] nArray, int n, int n2) {
        int[] nArray2 = new int[260];
        int[] nArray3 = new int[516];
        int[] nArray4 = new int[516];
        int n3 = 0;
        while (n3 < n) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
            ++n3;
        }
        block1: while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            n3 = 1;
            while (n3 <= n) {
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                n6 = n8;
                n5 = nArray2[n6];
                while (nArray3[n5] < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
                ++n3;
            }
            if (n8 >= 260) {
                CBZip2OutputStream.panic();
            }
            while (n8 > 1) {
                int n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                n6 = 0;
                n5 = 0;
                int n10 = 0;
                n6 = 1;
                n10 = nArray2[n6];
                while ((n5 = n6 << 1) <= n8) {
                    if (n5 < n8 && nArray3[nArray2[n5 + 1]] < nArray3[nArray2[n5]]) {
                        ++n5;
                    }
                    if (nArray3[n10] < nArray3[nArray2[n5]]) break;
                    nArray2[n6] = nArray2[n5];
                    n6 = n5;
                }
                nArray2[n6] = n10;
                int n11 = nArray2[1];
                nArray2[1] = nArray2[n8];
                --n8;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                n12 = 1;
                n14 = nArray2[n12];
                while ((n13 = n12 << 1) <= n8) {
                    if (n13 < n8 && nArray3[nArray2[n13 + 1]] < nArray3[nArray2[n13]]) {
                        ++n13;
                    }
                    if (nArray3[n14] < nArray3[nArray2[n13]]) break;
                    nArray2[n12] = nArray2[n13];
                    n12 = n13;
                }
                nArray2[n12] = n14;
                nArray4[n9] = nArray4[n11] = ++n7;
                nArray3[n7] = (nArray3[n9] & 0xFFFFFF00) + (nArray3[n11] & 0xFFFFFF00) | 1 + ((nArray3[n9] & 0xFF) > (nArray3[n11] & 0xFF) ? nArray3[n9] & 0xFF : nArray3[n11] & 0xFF);
                nArray4[n7] = -1;
                nArray2[++n8] = n7;
                int n15 = 0;
                int n16 = 0;
                n15 = n8;
                n16 = nArray2[n15];
                while (nArray3[n16] < nArray3[nArray2[n15 >> 1]]) {
                    nArray2[n15] = nArray2[n15 >> 1];
                    n15 >>= 1;
                }
                nArray2[n15] = n16;
            }
            if (n7 >= 516) {
                CBZip2OutputStream.panic();
            }
            boolean bl = false;
            n3 = 1;
            while (n3 <= n) {
                n4 = 0;
                int n17 = n3;
                while (nArray4[n17] >= 0) {
                    n17 = nArray4[n17];
                    ++n4;
                }
                byArray[n3 - 1] = (byte)n4;
                if (n4 > n2) {
                    bl = true;
                }
                ++n3;
            }
            if (!bl) break;
            n3 = 1;
            while (true) {
                if (n3 >= n) continue block1;
                n4 = nArray3[n3] >> 8;
                n4 = 1 + n4 / 2;
                nArray3[n3] = n4 << 8;
                ++n3;
            }
            break;
        }
    }

    private void initBlock() {
        this.mCrc.initialiseCRC();
        this.count = 0;
        int n = 0;
        while (n < 256) {
            this.inUse[n] = false;
            ++n;
        }
    }

    private void initialize() throws IOException {
        this.bsPutUChar(104);
        this.bsPutUChar(48 + this.blockSize100k);
        this.combinedCRC = 0;
    }

    private void mainSort() {
        int[] nArray = new int[256];
        int[] nArray2 = new int[256];
        boolean[] blArray = new boolean[256];
        int n = 0;
        while (n < 20) {
            this.blockBytes[this.count + n + 1] = this.blockBytes[n % this.count + 1];
            ++n;
        }
        n = 0;
        while (n <= this.count + 20) {
            this.quadrantShorts[n] = 0;
            ++n;
        }
        this.blockBytes[0] = this.blockBytes[this.count];
        if (this.count <= 4000) {
            n = 0;
            while (n < this.count) {
                this.zptr[n] = n;
                ++n;
            }
            this.firstAttempt = false;
            this.workLimit = 0;
            this.workDone = 0;
            this.simpleSort(0, this.count - 1, 0);
        } else {
            int n2;
            int n3;
            n = 0;
            while (n <= 255) {
                blArray[n] = false;
                ++n;
            }
            n = 0;
            while (n <= 65536) {
                this.ftab[n] = 0;
                ++n;
            }
            int n4 = this.blockBytes[0] & 0xFF;
            n = 0;
            while (n < this.count) {
                n3 = this.blockBytes[n + 1] & 0xFF;
                int n5 = (n4 << 8) + n3;
                this.ftab[n5] = this.ftab[n5] + 1;
                n4 = n3;
                ++n;
            }
            n = 1;
            while (n <= 65536) {
                int n6 = n;
                this.ftab[n6] = this.ftab[n6] + this.ftab[n - 1];
                ++n;
            }
            n4 = this.blockBytes[1] & 0xFF;
            n = 0;
            while (n < this.count - 1) {
                n3 = this.blockBytes[n + 2] & 0xFF;
                n2 = (n4 << 8) + n3;
                n4 = n3;
                int n7 = n2;
                this.ftab[n7] = this.ftab[n7] - 1;
                this.zptr[this.ftab[n2]] = n++;
            }
            int n8 = n2 = ((this.blockBytes[this.count] & 0xFF) << 8) + (this.blockBytes[1] & 0xFF);
            this.ftab[n8] = this.ftab[n8] - 1;
            this.zptr[this.ftab[n2]] = this.count - 1;
            n = 0;
            while (n <= 255) {
                nArray[n] = n;
                ++n;
            }
            int n9 = 1;
            while ((n9 = 3 * n9 + 1) <= 256) {
            }
            do {
                n = n9 /= 3;
                while (n <= 255) {
                    int n10 = nArray[n];
                    n2 = n;
                    while (this.ftab[nArray[n2 - n9] + 1 << 8] - this.ftab[nArray[n2 - n9] << 8] > this.ftab[n10 + 1 << 8] - this.ftab[n10 << 8]) {
                        nArray[n2] = nArray[n2 - n9];
                        if ((n2 -= n9) <= n9 - 1) break;
                    }
                    nArray[n2] = n10;
                    ++n;
                }
            } while (n9 != 1);
            n = 0;
            while (n <= 255) {
                int n11;
                int n12;
                int n13 = nArray[n];
                n2 = 0;
                while (n2 <= 255) {
                    int n14 = (n13 << 8) + n2;
                    if ((this.ftab[n14] & 0x200000) != 0x200000) {
                        n12 = (this.ftab[n14 + 1] & 0xFFDFFFFF) - 1;
                        n11 = this.ftab[n14] & 0xFFDFFFFF;
                        if (n12 > n11) {
                            this.qSort3(n11, n12, 2);
                            if (this.workDone > this.workLimit && this.firstAttempt) {
                                return;
                            }
                        }
                        int n15 = n14;
                        this.ftab[n15] = this.ftab[n15] | 0x200000;
                    }
                    ++n2;
                }
                blArray[n13] = true;
                if (n < 255) {
                    n11 = this.ftab[n13 << 8] & 0xFFDFFFFF;
                    n12 = (this.ftab[n13 + 1 << 8] & 0xFFDFFFFF) - n11;
                    int n16 = 0;
                    while (n12 >> n16 > 65534) {
                        ++n16;
                    }
                    n2 = 0;
                    while (n2 < n12) {
                        short s;
                        int n17 = this.zptr[n11 + n2] + 1;
                        this.quadrantShorts[n17] = s = (short)(n2 >> n16);
                        if (n17 <= 20) {
                            this.quadrantShorts[n17 + this.count] = s;
                        }
                        ++n2;
                    }
                    if (n12 - 1 >> n16 > 65535) {
                        CBZip2OutputStream.panic();
                    }
                }
                n2 = 0;
                while (n2 <= 255) {
                    nArray2[n2] = this.ftab[(n2 << 8) + n13] & 0xFFDFFFFF;
                    ++n2;
                }
                n2 = this.ftab[n13 << 8] & 0xFFDFFFFF;
                while (n2 < (this.ftab[n13 + 1 << 8] & 0xFFDFFFFF)) {
                    n4 = this.blockBytes[this.zptr[n2]] & 0xFF;
                    if (!blArray[n4]) {
                        this.zptr[nArray2[n4]] = (this.zptr[n2] == 0 ? this.count : this.zptr[n2]) - 1;
                        int n18 = n4;
                        nArray2[n18] = nArray2[n18] + 1;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 <= 255) {
                    int n19 = (n2 << 8) + n13;
                    this.ftab[n19] = this.ftab[n19] | 0x200000;
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void makeMaps() {
        this.nInUse = 0;
        int n = 0;
        while (n < 256) {
            if (this.inUse[n]) {
                this.seqToUnseq[this.nInUse] = (char)n;
                this.unseqToSeq[n] = (char)this.nInUse;
                ++this.nInUse;
            }
            ++n;
        }
    }

    private int med3(int n, int n2, int n3) {
        return n > n2 ? (n3 < n2 ? n2 : (n3 > n ? n : n3)) : (n3 < n ? n : (n3 > n2 ? n2 : n3));
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsPutIntVS(24, this.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private static void panic() {
        throw new IllegalStateException();
    }

    private static void pushStackElem(Vector vector, int n, int n2, int n3, int n4) {
        StackElem stackElem;
        if (n < vector.size()) {
            stackElem = (StackElem)vector.elementAt(n);
        } else {
            stackElem = new StackElem();
            vector.addElement(stackElem);
        }
        stackElem.ll = n2;
        stackElem.hh = n3;
        stackElem.dd = n4;
    }

    private void qSort3(int n, int n2, int n3) {
        Vector vector = new Vector();
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        while (true) {
            int n8;
            int n9;
            int n10;
            if (n6 - n5 < 20 || n7 > 10) {
                this.simpleSort(n5, n6, n7);
                if (n4 < 1 || this.workDone > this.workLimit && this.firstAttempt) {
                    return;
                }
                StackElem stackElem = (StackElem)vector.elementAt(--n4);
                n5 = stackElem.ll;
                n6 = stackElem.hh;
                n7 = stackElem.dd;
                continue;
            }
            int n11 = n7 + 1;
            int n12 = this.med3(this.blockBytes[this.zptr[n5] + n11] & 0xFF, this.blockBytes[this.zptr[n6] + n11] & 0xFF, this.blockBytes[this.zptr[n5 + n6 >>> 1] + n11] & 0xFF);
            int n13 = n10 = n5;
            int n14 = n9 = n6;
            while (true) {
                int n15;
                if (n13 <= n14) {
                    n15 = this.zptr[n13];
                    n8 = (this.blockBytes[n15 + n11] & 0xFF) - n12;
                    if (n8 <= 0) {
                        if (n8 == 0) {
                            this.zptr[n13] = this.zptr[n10];
                            this.zptr[n10++] = n15;
                        }
                        ++n13;
                        continue;
                    }
                }
                while (n13 <= n14) {
                    n15 = this.zptr[n14];
                    n8 = (this.blockBytes[n15 + n11] & 0xFF) - n12;
                    if (n8 < 0) break;
                    if (n8 == 0) {
                        this.zptr[n14] = this.zptr[n9];
                        this.zptr[n9--] = n15;
                    }
                    --n14;
                }
                if (n13 > n14) break;
                n15 = this.zptr[n13];
                this.zptr[n13++] = this.zptr[n14];
                this.zptr[n14--] = n15;
            }
            if (n9 < n10) {
                n7 = n11;
                continue;
            }
            n8 = Math.min(n10 - n5, n13 - n10);
            this.vswap(n5, n13 - n8, n8);
            int n16 = Math.min(n6 - n9, n9 - n14);
            this.vswap(n13, n6 - n16 + 1, n16);
            n8 = n5 + (n13 - n10);
            n16 = n6 - (n9 - n14);
            CBZip2OutputStream.pushStackElem(vector, n4++, n5, n8 - 1, n7);
            CBZip2OutputStream.pushStackElem(vector, n4++, n8, n16, n11);
            n5 = n16 + 1;
        }
    }

    private void randomiseBlock() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 256) {
            this.inUse[n3] = false;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.count) {
            if (n == 0) {
                n = (char)BZip2Constants.rNums[n2];
                if (++n2 == 512) {
                    n2 = 0;
                }
            }
            int n4 = n3 + 1;
            this.blockBytes[n4] = (byte)(this.blockBytes[n4] ^ (--n == 1 ? (byte)1 : 0));
            this.inUse[this.blockBytes[n3 + 1] & 0xFF] = true;
            ++n3;
        }
    }

    private void sendMTFValues() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        short s;
        Object[] objectArray;
        Object object;
        int n6;
        int n7;
        byte[][] byArray = new byte[6][258];
        int n8 = 0;
        int n9 = this.nInUse + 2;
        int n10 = 0;
        while (n10 < 6) {
            byte[] byArray2 = byArray[n10];
            n7 = 0;
            while (n7 < n9) {
                byArray2[n7] = 15;
                ++n7;
            }
            ++n10;
        }
        if (this.nMTF <= 0) {
            CBZip2OutputStream.panic();
        }
        int n11 = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        int n12 = n11;
        int n13 = this.nMTF;
        int n14 = 0;
        while (n12 > 0) {
            int n15 = n13 / n12;
            n6 = n14 - 1;
            int n16 = 0;
            while (n16 < n15 && n6 < n9 - 1) {
                n16 += this.mtfFreq[++n6];
            }
            if (n6 > n14 && n12 != n11 && n12 != 1 && (n11 - n12) % 2 == 1) {
                n16 -= this.mtfFreq[n6];
                --n6;
            }
            object = byArray[n12 - 1];
            n7 = 0;
            while (n7 < n9) {
                object[n7] = n7 >= n14 && n7 <= n6 ? (Object)false : (int[])15;
                ++n7;
            }
            --n12;
            n14 = n6 + 1;
            n13 -= n16;
        }
        object = new int[6][258];
        int[] nArray = new int[6];
        short[] sArray = new short[6];
        byte[] byArray3 = byArray[0];
        byte[] byArray4 = byArray[1];
        byte[] byArray5 = byArray[2];
        byte[] byArray6 = byArray[3];
        byte[] byArray7 = byArray[4];
        byte[] byArray8 = byArray[5];
        int n17 = 0;
        while (n17 < 4) {
            n10 = 0;
            while (n10 < n11) {
                nArray[n10] = 0;
                objectArray = object[n10];
                n7 = 0;
                while (n7 < n9) {
                    objectArray[n7] = 0;
                    ++n7;
                }
                ++n10;
            }
            n8 = 0;
            n14 = 0;
            while (n14 < this.nMTF) {
                n6 = Math.min(n14 + 50 - 1, this.nMTF - 1);
                if (n11 == 6) {
                    short s2 = 0;
                    s = 0;
                    n5 = 0;
                    n4 = 0;
                    short s3 = 0;
                    short s4 = 0;
                    n3 = n14;
                    while (n3 <= n6) {
                        n2 = this.szptr[n3];
                        s2 = (short)(s2 + (byArray3[n2] & 0xFF));
                        s = (short)(s + (byArray4[n2] & 0xFF));
                        n5 = (short)(n5 + (byArray5[n2] & 0xFF));
                        n4 = (short)(n4 + (byArray6[n2] & 0xFF));
                        s3 = (short)(s3 + (byArray7[n2] & 0xFF));
                        s4 = (short)(s4 + (byArray8[n2] & 0xFF));
                        ++n3;
                    }
                    sArray[0] = s2;
                    sArray[1] = s;
                    sArray[2] = n5;
                    sArray[3] = n4;
                    sArray[4] = s3;
                    sArray[5] = s4;
                } else {
                    n10 = 0;
                    while (n10 < n11) {
                        sArray[n10] = 0;
                        ++n10;
                    }
                    n3 = n14;
                    while (n3 <= n6) {
                        int n18 = this.szptr[n3];
                        n10 = 0;
                        while (n10 < n11) {
                            int n15 = n10;
                            sArray[n15] = (short)(sArray[n15] + (byArray[n10][n18] & 0xFF));
                            ++n10;
                        }
                        ++n3;
                    }
                }
                short s5 = 999999999;
                int n20 = -1;
                n10 = 0;
                while (n10 < n11) {
                    if (sArray[n10] < s5) {
                        s5 = sArray[n10];
                        n20 = n10;
                    }
                    ++n10;
                }
                int n16 = n20;
                nArray[n16] = nArray[n16] + 1;
                this.selector[n8] = (char)n20;
                ++n8;
                objectArray = object[n20];
                n3 = n14;
                while (n3 <= n6) {
                    int n18 = this.szptr[n3];
                    objectArray[n18] = objectArray[n18] + 1;
                    ++n3;
                }
                n14 = n6 + 1;
            }
            n10 = 0;
            while (n10 < n11) {
                CBZip2OutputStream.hbMakeCodeLengths(byArray[n10], object[n10], n9, 20);
                ++n10;
            }
            ++n17;
        }
        object = null;
        nArray = null;
        sArray = null;
        if (n11 >= 8) {
            CBZip2OutputStream.panic();
        }
        if (n8 >= 32768 || n8 > 18002) {
            CBZip2OutputStream.panic();
        }
        objectArray = new char[6];
        n3 = 0;
        while (n3 < n11) {
            objectArray[n3] = (char)n3;
            ++n3;
        }
        n3 = 0;
        while (n3 < n8) {
            s = this.selector[n3];
            n = 0;
            n4 = objectArray[n];
            while (s != n4) {
                n5 = n4;
                n4 = objectArray[++n];
                objectArray[n] = n5;
            }
            objectArray[0] = n4;
            this.selectorMtf[n3] = (char)n;
            ++n3;
        }
        int[][] nArray2 = new int[6][258];
        n10 = 0;
        while (n10 < n11) {
            int n23 = 32;
            int n24 = 0;
            byte[] byArray9 = byArray[n10];
            n3 = 0;
            while (n3 < n9) {
                n2 = byArray9[n3] & 0xFF;
                if (n2 > n24) {
                    n24 = n2;
                }
                if (n2 < n23) {
                    n23 = n2;
                }
                ++n3;
            }
            if (n24 > 20) {
                CBZip2OutputStream.panic();
            }
            if (n23 < 1) {
                CBZip2OutputStream.panic();
            }
            this.hbAssignCodes(nArray2[n10], byArray[n10], n23, n24, n9);
            ++n10;
        }
        boolean[] blArray = new boolean[16];
        n3 = 0;
        while (n3 < 16) {
            blArray[n3] = false;
            n2 = n3 * 16;
            n = 0;
            while (n < 16) {
                if (this.inUse[n2 + n]) {
                    blArray[n3] = true;
                    break;
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < 16) {
            this.bsW(1, blArray[n3] ? 1 : 0);
            ++n3;
        }
        n3 = 0;
        while (n3 < 16) {
            if (blArray[n3]) {
                n2 = n3 * 16;
                n = 0;
                while (n < 16) {
                    this.bsW(1, this.inUse[n2 + n] ? 1 : 0);
                    ++n;
                }
            }
            ++n3;
        }
        this.bsW(3, n11);
        this.bsW(15, n8);
        n3 = 0;
        while (n3 < n8) {
            n2 = this.selectorMtf[n3];
            while (n2 >= 24) {
                this.bsW(24, 0xFFFFFF);
                n2 -= 24;
            }
            this.bsW(n2 + 1, (1 << n2 + 1) - 2);
            ++n3;
        }
        n10 = 0;
        while (n10 < n11) {
            byte[] byArray10 = byArray[n10];
            int n25 = byArray10[0] & 0xFF;
            this.bsW(5, n25);
            n3 = 0;
            while (n3 < n9) {
                int n26 = byArray10[n3] & 0xFF;
                while (n25 < n26) {
                    this.bsW(2, 2);
                    ++n25;
                }
                while (n25 > n26) {
                    this.bsW(2, 3);
                    --n25;
                }
                this.bsW(1, 0);
                ++n3;
            }
            ++n10;
        }
        int n27 = 0;
        n14 = 0;
        while (n14 < this.nMTF) {
            n6 = Math.min(n14 + 50 - 1, this.nMTF - 1);
            char c = this.selector[n27];
            byte[] byArray11 = byArray[c];
            int[] nArray3 = nArray2[c];
            n3 = n14;
            while (n3 <= n6) {
                int n28 = this.szptr[n3];
                this.bsW(byArray11[n28] & 0xFF, nArray3[n28]);
                ++n3;
            }
            n14 = n6 + 1;
            ++n27;
        }
        if (n27 != n8) {
            CBZip2OutputStream.panic();
        }
    }

    private void simpleSort(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (n4 < 2) {
            return;
        }
        int n5 = 0;
        while (this.incs[n5] < n4) {
            ++n5;
        }
        --n5;
        while (n5 >= 0) {
            int n6 = this.incs[n5];
            for (int i = n + n6; i <= n2; ++i) {
                int n7 = this.zptr[i];
                int n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) <= n + n6 - 1) break;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) <= n + n6 - 1) break;
                }
                this.zptr[n8] = n7;
                if (++i > n2) break;
                n7 = this.zptr[i];
                n8 = i;
                while (this.fullGtU(this.zptr[n8 - n6] + n3, n7 + n3)) {
                    this.zptr[n8] = this.zptr[n8 - n6];
                    if ((n8 -= n6) <= n + n6 - 1) break;
                }
                this.zptr[n8] = n7;
                if (this.workDone <= this.workLimit || !this.firstAttempt) continue;
                return;
            }
            --n5;
        }
    }

    private void vswap(int n, int n2, int n3) {
        while (--n3 >= 0) {
            int n4 = this.zptr[n];
            int n5 = this.zptr[n2];
            this.zptr[n++] = n5;
            this.zptr[n2++] = n4;
        }
    }

    public void write(int n) throws IOException {
        int n2 = n & 0xFF;
        if (this.currentByte == n2) {
            ++this.runLength;
            if (this.runLength > 254) {
                this.writeRun();
                this.currentByte = -1;
                this.runLength = 0;
            }
        } else if (this.currentByte == -1) {
            this.currentByte = n2;
            ++this.runLength;
        } else {
            this.writeRun();
            this.runLength = 1;
            this.currentByte = n2;
        }
    }

    private void writeRun() throws IOException {
        if (this.count > this.allowableBlockSize) {
            this.endBlock();
            this.initBlock();
        }
        this.inUse[this.currentByte] = true;
        int n = 0;
        while (n < this.runLength) {
            this.mCrc.updateCRC(this.currentByte);
            ++n;
        }
        switch (this.runLength) {
            case 1: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            case 2: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            case 3: {
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                break;
            }
            default: {
                this.inUse[this.runLength - 4] = true;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)this.currentByte;
                this.blockBytes[++this.count] = (byte)(this.runLength - 4);
            }
        }
    }

    private static class StackElem {
        int ll;
        int hh;
        int dd;

        StackElem() {
        }
    }
}

