/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.UserAttributeSubpacket;
import org.bouncycastle.bcpg.UserAttributeSubpacketInputStream;

public class UserAttributePacket
extends ContainedPacket {
    private UserAttributeSubpacket[] subpackets;

    public UserAttributePacket(BCPGInputStream bCPGInputStream) throws IOException {
        UserAttributeSubpacket userAttributeSubpacket;
        UserAttributeSubpacketInputStream userAttributeSubpacketInputStream = new UserAttributeSubpacketInputStream(bCPGInputStream);
        Vector<UserAttributeSubpacket> vector = new Vector<UserAttributeSubpacket>();
        while ((userAttributeSubpacket = userAttributeSubpacketInputStream.readPacket()) != null) {
            vector.addElement(userAttributeSubpacket);
        }
        this.subpackets = new UserAttributeSubpacket[vector.size()];
        int n = 0;
        while (n != this.subpackets.length) {
            this.subpackets[n] = (UserAttributeSubpacket)vector.elementAt(n);
            ++n;
        }
    }

    public UserAttributePacket(UserAttributeSubpacket[] userAttributeSubpacketArray) {
        this.subpackets = userAttributeSubpacketArray;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n != this.subpackets.length) {
            this.subpackets[n].encode(byteArrayOutputStream);
            ++n;
        }
        bCPGOutputStream.writePacket(17, byteArrayOutputStream.toByteArray(), false);
    }

    public UserAttributeSubpacket[] getSubpackets() {
        return this.subpackets;
    }
}

